/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.view.ParagraphView;

public final class TextLayoutCache {
    private static final Logger LOG = Logger.getLogger(TextLayoutCache.class.getName());
    private static final int DEFAULT_CAPACITY = 300;
    private final Map<ParagraphView, Entry> paragraph2entry = new HashMap<ParagraphView, Entry>();
    private Entry head;
    private Entry tail;
    private int capacity = 300;

    void clear() {
        this.paragraph2entry.clear();
        this.tail = null;
        this.head = null;
    }

    int size() {
        return this.paragraph2entry.size();
    }

    void ensureCapacity(int capacity) {
        this.capacity = Math.max(this.capacity, capacity);
    }

    boolean contains(ParagraphView paragraphView) {
        assert (paragraphView != null);
        Entry entry = this.paragraph2entry.get(paragraphView);
        return entry != null;
    }

    void activate(ParagraphView paragraphView) {
        assert (paragraphView != null);
        Entry entry = this.paragraph2entry.get(paragraphView);
        if (entry == null) {
            entry = new Entry(paragraphView);
            this.paragraph2entry.put(paragraphView, entry);
            if (this.paragraph2entry.size() >= this.capacity) {
                Entry tailEntry = this.paragraph2entry.remove(this.tail.paragraphView);
                assert (tailEntry == this.tail);
                this.removeChainEntry(tailEntry);
                tailEntry.release();
            }
            this.addChainEntryFirst(entry);
        }
        if (this.head != entry) {
            this.removeChainEntry(entry);
            this.addChainEntryFirst(entry);
        }
    }

    void remove(ParagraphView paragraphView, boolean clearTextLayouts) {
        Entry entry = this.paragraph2entry.remove(paragraphView);
        if (entry != null) {
            this.removeChainEntry(entry);
            if (clearTextLayouts) {
                entry.release();
            }
        }
    }

    String findIntegrityError() {
        int cnt = 0;
        HashSet<Entry> entries = new HashSet<Entry>(this.paragraph2entry.values());
        Entry entry = this.head;
        while (entry != null) {
            if (!entries.contains(entry)) {
                return "TextLayoutCache: Chain entry[" + cnt + "] not contained in map: " + entry.paragraphView + ", parent=" + entry.paragraphView.getParent();
            }
            if (entry.paragraphView.getParent() == null) {
                return "TextLayoutCache: Null parent for " + entry.paragraphView;
            }
            entry = entry.next;
            ++cnt;
        }
        if (cnt != entries.size()) {
            return "TextLayoutCache: cnt=" + cnt + " != entryCount=" + entries.size();
        }
        return null;
    }

    private void addChainEntryFirst(Entry entry) {
        assert (entry.previous == null && entry.next == null);
        if (this.head == null) {
            assert (this.tail == null);
            this.head = this.tail = entry;
        } else {
            entry.next = this.head;
            this.head.previous = entry;
            this.head = entry;
        }
    }

    private void removeChainEntry(Entry entry) {
        if (entry.previous != null) {
            entry.previous.next = entry.next;
        } else {
            assert (this.head == entry);
            this.head = entry.next;
        }
        if (entry.next != null) {
            entry.next.previous = entry.previous;
        } else {
            assert (this.tail == entry);
            this.tail = entry.previous;
        }
        entry.next = null;
        entry.previous = null;
    }

    private static final class Entry {
        final ParagraphView paragraphView;
        Entry previous;
        Entry next;

        Entry(ParagraphView paragraphView) {
            this.paragraphView = paragraphView;
        }

        void release() {
            this.paragraphView.releaseTextLayouts();
        }
    }
}

