/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphViewChildren;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

public final class ParagraphView
extends EditorView
implements EditorView.Parent {
    private static final Logger LOG = Logger.getLogger(ParagraphView.class.getName());
    private float width;
    private float height;
    private Position startPos;
    private int length;
    ParagraphViewChildren children;

    public ParagraphView(Position startPos) {
        super(null);
        this.startPos = startPos;
    }

    @Override
    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getRawEndOffset() {
        return -1;
    }

    @Override
    public void setRawEndOffset(int rawOffset) {
        throw new IllegalStateException("setRawOffset() must not be called on ParagraphView.");
    }

    float getWidth() {
        return this.width;
    }

    void setWidth(float width) {
        this.width = width;
    }

    void resetWidth() {
        this.width = 0.0f;
        if (this.children != null) {
            this.children.resetWidth();
        }
    }

    float getHeight() {
        return this.height;
    }

    void setHeight(float height) {
        this.height = height;
    }

    @Override
    public float getPreferredSpan(int axis) {
        return axis == 0 ? this.width : this.height;
    }

    @Override
    public final int getViewCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public View getView(int index) {
        return this.children != null ? (EditorView)this.children.get(index) : null;
    }

    public final EditorView getEditorView(int index) {
        return (EditorView)this.children.get(index);
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    void releaseChildren() {
        this.children = null;
    }

    @Override
    public void replace(int index, int length, View[] views) {
        this.replace(index, length, views, 0);
    }

    void replace(int index, int length, View[] views, int offsetDelta) {
        if (this.children == null) {
            assert (length == 0) : "Attempt to remove from null children length=" + length;
            this.children = new ParagraphViewChildren(views.length);
        }
        this.children.replace(this, index, length, views, offsetDelta);
    }

    @Override
    public void preferenceChanged(View childView, boolean widthChange, boolean heightChange) {
        if (childView == null) {
            View parent = this.getParent();
            if (parent != null) {
                parent.preferenceChanged(this, widthChange, heightChange);
            }
        } else if (this.children != null) {
            this.children.preferenceChanged(this, (EditorView)childView, widthChange, heightChange);
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape alloc) {
        this.checkChildrenNotNull();
        return this.children.getChildAllocation(index, alloc);
    }

    @Override
    public int getViewIndex(int offset, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            --offset;
        }
        return this.getViewIndex(offset);
    }

    public int getViewIndex(int offset) {
        this.checkChildrenNotNull();
        return this.children.getViewIndex(this, offset);
    }

    @Override
    public int getViewIndexChecked(double x, double y, Shape alloc) {
        this.checkChildrenNotNull();
        return this.children.getViewIndex(this, x, y, alloc);
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        this.checkChildrenNotNull();
        return this.children.modelToViewChecked(this, offset, alloc, bias);
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        this.checkChildrenNotNull();
        return this.children.viewToModelChecked(this, x, y, alloc, biasReturn);
    }

    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        this.checkChildrenNotNull();
        this.children.paint(this, g, alloc, clipBounds);
    }

    @Override
    public JComponent getToolTip(double x, double y, Shape allocation) {
        this.checkChildrenNotNull();
        return this.children.getToolTip(this, x, y, allocation);
    }

    @Override
    public String getToolTipTextChecked(double x, double y, Shape allocation) {
        this.checkChildrenNotNull();
        return this.children.getToolTipTextChecked(this, x, y, allocation);
    }

    @Override
    public HighlightsSequence getPaintHighlights(EditorView view, int shift) {
        return this.getDocumentView().getPaintHighlights(view, shift);
    }

    @Override
    public void notifyChildWidthChange() {
        View parent = this.getParent();
        if (parent instanceof EditorView.Parent) {
            ((EditorView.Parent)((Object)parent)).notifyChildWidthChange();
        }
    }

    @Override
    public void notifyChildHeightChange() {
        View parent = this.getParent();
        if (parent instanceof EditorView.Parent) {
            ((EditorView.Parent)((Object)parent)).notifyChildHeightChange();
        }
    }

    @Override
    public void notifyRepaint(double x0, double y0, double x1, double y1) {
        View parent = this.getParent();
        if (parent instanceof EditorView.Parent) {
            ((EditorView.Parent)((Object)parent)).notifyRepaint(x0, y0, x1, y1);
        }
    }

    @Override
    public int getViewEndOffset(int rawChildEndOffset) {
        return this.getStartOffset() + this.children.raw2Offset(rawChildEndOffset);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getFontRenderContext() : null;
    }

    @Override
    public void insertUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
    }

    DocumentView getDocumentView() {
        return (DocumentView)this.getParent();
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int retOffset;
        switch (direction) {
            case 3: 
            case 7: {
                retOffset = this.children.getNextVisualPositionX(this, offset, bias, alloc, direction == 3, biasRet);
                break;
            }
            case 1: 
            case 5: {
                DocumentView docView = this.getDocumentView();
                if (docView != null) {
                    retOffset = this.children.getNextVisualPositionY(this, offset, bias, alloc, direction == 5, biasRet, HighlightsViewUtils.getMagicX(docView, this, offset, bias, alloc));
                    break;
                }
                retOffset = offset;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction " + direction);
            }
        }
        return retOffset;
    }

    void releaseTextLayouts() {
        this.children.lowerMeasuredEndIndex(0);
    }

    private void checkChildrenNotNull() {
        if (this.children == null) {
            throw new IllegalStateException("Null children in " + this.getDumpId());
        }
    }

    @Override
    public String findIntegrityError() {
        String err = super.findIntegrityError();
        if (err == null && this.children != null) {
            int childrenLength = this.children.getLength();
            if (this.getLength() != childrenLength) {
                return "length=" + this.getLength() + " != childrenLength=" + childrenLength;
            }
        }
        if (err != null) {
            err = this.getDumpName() + ":" + err;
        }
        return err;
    }

    @Override
    protected StringBuilder appendViewInfo(StringBuilder sb, int indent, String xyInfo, int importantChildIndex) {
        super.appendViewInfo(sb, indent, xyInfo, importantChildIndex);
        sb.append(", WxH:").append(this.getWidth()).append("x").append(this.getHeight());
        if (this.children != null) {
            this.children.appendViewInfo(this, sb);
            if (importantChildIndex != -1) {
                this.children.appendChildrenInfo(this, sb, indent + 8, importantChildIndex);
            }
        } else {
            sb.append(", children=null");
        }
        return sb;
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, "", -1).toString();
    }

    public String toStringDetail() {
        return this.appendViewInfo(new StringBuilder(200), 0, "", -2).toString();
    }

    @Override
    protected String getDumpName() {
        return "PV";
    }
}

