/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Font;
import java.util.Collections;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.highlighting.DirectMergeContainer;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsList;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsReader;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.NewlineView;
import org.netbeans.modules.editor.lib2.view.TabView;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.openide.util.WeakListeners;

public final class HighlightsViewFactory
extends EditorViewFactory
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(HighlightsViewFactory.class.getName());
    private final HighlightingManager highlightingManager = HighlightingManager.getInstance(this.textComponent());
    private HighlightsContainer highlightsContainer;
    private HighlightsContainer paintHighlightsContainer;
    private HighlightsChangeListener weakHL;
    private HighlightsChangeListener paintWeakHL;
    private CharSequence docText;
    private Element lineElementRoot;
    private int lineIndex;
    private int lineEndOffset;
    private int hlLineIndex;
    private HighlightsReader highlightsReader;
    private Font defaultFont;
    private int nextTabOffset;
    private int usageCount = 0;

    public HighlightsViewFactory(View documentView) {
        super(documentView);
        this.highlightingManager.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HighlightsViewFactory.this.notifyStaleCreation();
                HighlightsViewFactory.this.updateHighlightsContainer();
            }
        });
        this.updateHighlightsContainer();
    }

    private void updateHighlightsContainer() {
        if (this.highlightsContainer != null && this.weakHL != null) {
            this.highlightsContainer.removeHighlightsChangeListener(this.weakHL);
            this.paintHighlightsContainer.removeHighlightsChangeListener(this.paintWeakHL);
            this.weakHL = null;
            this.paintWeakHL = null;
        }
        this.highlightsContainer = this.highlightingManager.getBottomHighlights();
        this.weakHL = (HighlightsChangeListener)WeakListeners.create(HighlightsChangeListener.class, (EventListener)this, (Object)this.highlightsContainer);
        this.highlightsContainer.addHighlightsChangeListener(this.weakHL);
        this.paintHighlightsContainer = this.highlightingManager.getTopHighlights();
        this.paintWeakHL = (HighlightsChangeListener)WeakListeners.create(HighlightsChangeListener.class, (EventListener)this, (Object)this.paintHighlightsContainer);
        this.paintHighlightsContainer.addHighlightsChangeListener(this.paintWeakHL);
    }

    @Override
    public void restart(int startOffset, int matchOffset) {
        if (this.usageCount != 0) {
            throw new IllegalStateException("Race condition: usageCount = " + this.usageCount);
        }
        ++this.usageCount;
        this.docText = DocumentUtilities.getText((Document)this.document());
        this.lineElementRoot = this.document().getDefaultRootElement();
        assert (this.lineElementRoot != null) : "lineElementRoot is null.";
        this.lineIndex = this.lineElementRoot.getElementIndex(startOffset);
        this.lineEndOffset = this.lineElementRoot.getElement(this.lineIndex).getEndOffset();
        this.defaultFont = this.textComponent().getFont();
        this.highlightsReader = new HighlightsReader(this.highlightsContainer, startOffset, Integer.MAX_VALUE);
        this.hlLineIndex = this.lineIndex - 1;
    }

    @Override
    public int nextViewStartOffset(int offset) {
        return offset;
    }

    @Override
    public EditorView createView(int startOffset, int limitOffset) {
        assert (startOffset < limitOffset) : "startOffset=" + startOffset + " >= limitOffset=" + limitOffset;
        this.updateLineEndOffset(startOffset);
        this.updateTabsAndHighlights(startOffset);
        HighlightsList hList = this.highlightsReader.highlightsList();
        if (hList.startOffset() < startOffset) {
            hList.skip(startOffset);
        }
        if (startOffset == this.lineEndOffset - 1) {
            AttributeSet attrs = hList.cutSingleChar();
            return new NewlineView(startOffset, attrs);
        }
        if (startOffset == this.nextTabOffset) {
            AttributeSet attrs;
            int tabsEndOffset;
            for (tabsEndOffset = this.nextTabOffset + 1; tabsEndOffset < this.lineEndOffset - 1 && this.docText.charAt(tabsEndOffset) == '\t'; ++tabsEndOffset) {
            }
            if (limitOffset < tabsEndOffset) {
                attrs = hList.cut(limitOffset);
                this.nextTabOffset = limitOffset;
            } else {
                attrs = hList.cut(tabsEndOffset);
                limitOffset = tabsEndOffset;
                this.nextTabOffset = tabsEndOffset;
                while (this.nextTabOffset < this.lineEndOffset - 1 && this.docText.charAt(this.nextTabOffset) != '\t') {
                    ++this.nextTabOffset;
                }
            }
            return new TabView(startOffset, limitOffset - startOffset, attrs);
        }
        limitOffset = Math.min(limitOffset, Math.min(this.nextTabOffset, this.lineEndOffset - 1));
        AttributeSet attrs = hList.cutSameFont(this.defaultFont, limitOffset);
        int length = hList.startOffset() - startOffset;
        return this.createHighlightsView(startOffset, length, attrs);
    }

    @Override
    public int viewEndOffset(int startOffset, int limitOffset) {
        this.updateLineEndOffset(startOffset);
        return Math.min(this.lineEndOffset, limitOffset);
    }

    private EditorView createHighlightsView(int startOffset, int length, AttributeSet attrs) {
        boolean tabs = this.docText.charAt(startOffset) == '\t';
        for (int i = 1; i < length; ++i) {
            if (tabs == (this.docText.charAt(startOffset + i) == '\t')) continue;
            length = i;
            break;
        }
        return tabs ? new TabView(startOffset, length, attrs) : new HighlightsView(startOffset, length, attrs);
    }

    private void updateLineEndOffset(int offset) {
        if (this.usageCount != 1) {
            throw new IllegalStateException("Missing factory restart: usageCount=" + this.usageCount);
        }
        while (offset >= this.lineEndOffset) {
            ++this.lineIndex;
            Element line = this.lineElementRoot.getElement(this.lineIndex);
            this.lineEndOffset = line.getEndOffset();
        }
    }

    private void updateTabsAndHighlights(int offset) {
        if (this.hlLineIndex != this.lineIndex) {
            this.hlLineIndex = this.lineIndex;
            this.nextTabOffset = offset;
            while (this.nextTabOffset < this.lineEndOffset - 1 && this.docText.charAt(this.nextTabOffset) != '\t') {
                ++this.nextTabOffset;
            }
            this.highlightsReader.readUntil(this.lineEndOffset);
        }
    }

    @Override
    public void finishCreation() {
        this.highlightsReader = null;
        this.docText = null;
        this.lineElementRoot = null;
        this.lineIndex = -1;
        this.lineEndOffset = -1;
        --this.usageCount;
    }

    @Override
    public void highlightChanged(HighlightsChangeEvent evt) {
        int startOffset = evt.getStartOffset();
        int endOffset = evt.getEndOffset();
        if (evt.getSource() == this.highlightsContainer) {
            if (this.usageCount != 0) {
                this.notifyStaleCreation();
            }
            int docTextLength = this.document().getLength() + 1;
            assert (startOffset >= 0) : "startOffset=" + startOffset + " < 0";
            assert (endOffset >= 0) : "startOffset=" + endOffset + " < 0";
            startOffset = Math.min(startOffset, docTextLength);
            endOffset = Math.min(endOffset, docTextLength);
            if (ViewHierarchyImpl.CHANGE_LOG.isLoggable(Level.FINE)) {
                HighlightsChangeEvent layerEvent = this.highlightsContainer instanceof DirectMergeContainer ? ((DirectMergeContainer)this.highlightsContainer).layerEvent() : null;
                String layerInfo = layerEvent != null ? " " + this.highlightingManager.findLayer((HighlightsContainer)layerEvent.getSource()) : "";
                ViewUtils.log(ViewHierarchyImpl.CHANGE_LOG, "VIEW-REBUILD-HC:<" + startOffset + "," + endOffset + ">" + layerInfo + "\n");
            }
            if (startOffset <= endOffset) {
                this.fireEvent(Collections.singletonList(HighlightsViewFactory.createChange(startOffset, endOffset)));
            }
        } else {
            assert (evt.getSource() == this.paintHighlightsContainer);
            if (ViewHierarchyImpl.CHANGE_LOG.isLoggable(Level.FINE)) {
                HighlightsChangeEvent layerEvent = this.paintHighlightsContainer instanceof DirectMergeContainer ? ((DirectMergeContainer)this.paintHighlightsContainer).layerEvent() : null;
                String layerInfo = layerEvent != null ? " " + this.highlightingManager.findLayer((HighlightsContainer)layerEvent.getSource()) : "";
                ViewUtils.log(ViewHierarchyImpl.CHANGE_LOG, "REPAINT-HC:<" + startOffset + "," + endOffset + ">" + layerInfo + "\n");
            }
            this.offsetRepaint(startOffset, endOffset);
        }
    }

    public static final class HighlightsFactory
    implements EditorViewFactory.Factory {
        @Override
        public EditorViewFactory createEditorViewFactory(View documentView) {
            return new HighlightsViewFactory(documentView);
        }

        @Override
        public int importance() {
            return 0;
        }
    }
}

