/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewPart;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class HighlightsView
extends EditorView {
    private static final Logger LOG = Logger.getLogger(HighlightsView.class.getName());
    private int rawEndOffset;
    private int length;
    private final AttributeSet attributes;
    private TextLayout textLayout;

    public HighlightsView(int offset, int length, AttributeSet attributes) {
        super(null);
        assert (length > 0) : "length=" + length + " <= 0";
        this.rawEndOffset = offset + length;
        this.length = length;
        this.attributes = attributes;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.checkTextLayoutValid();
        float span = axis == 0 ? Math.abs(TextLayoutUtils.getWidth(this.textLayout)) : TextLayoutUtils.getHeight(this.textLayout);
        return (int)Math.ceil(span);
    }

    @Override
    public int getRawEndOffset() {
        return this.rawEndOffset;
    }

    @Override
    public void setRawEndOffset(int rawOffset) {
        this.rawEndOffset = rawOffset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getStartOffset() {
        return this.getEndOffset() - this.getLength();
    }

    @Override
    public int getEndOffset() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getViewEndOffset(this.rawEndOffset) : this.rawEndOffset;
    }

    @Override
    public Document getDocument() {
        View parent = this.getParent();
        return parent != null ? parent.getDocument() : null;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    TextLayout getTextLayout() {
        return this.textLayout;
    }

    void setTextLayout(TextLayout textLayout) {
        this.textLayout = textLayout;
    }

    TextLayout createPartTextLayout(int shift, int length) {
        this.checkTextLayoutValid();
        DocumentView docView = this.getDocumentView();
        Document doc = docView.getDocument();
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        int startOffset = this.getStartOffset();
        String text = ((Object)docText.subSequence(startOffset + shift, startOffset + shift + length)).toString();
        if (docView.op.isNonPrintableCharactersVisible()) {
            text = text.replace(' ', '\u00b7');
        }
        return docView.op.createTextLayout(text, ViewUtils.getFirstAttributes(this.getAttributes()));
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        this.checkTextLayoutValid();
        int relOffset = Math.max(0, offset - this.getStartOffset());
        Shape ret = HighlightsViewUtils.indexToView(this.textLayout, null, relOffset, bias, this.getLength(), alloc);
        return ret;
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape hViewAlloc, Position.Bias[] biasReturn) {
        this.checkTextLayoutValid();
        int offset = this.getStartOffset() + HighlightsViewUtils.viewToIndex(this.textLayout, x, hViewAlloc, biasReturn);
        return offset;
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        this.checkTextLayoutValid();
        int startOffset = this.getStartOffset();
        return HighlightsViewUtils.getNextVisualPosition(offset, bias, alloc, direction, biasRet, this.textLayout, startOffset, startOffset, this.getLength(), this.getDocumentView());
    }

    @Override
    public void paint(Graphics2D g, Shape hViewAlloc, Rectangle clipBounds) {
        this.checkTextLayoutValid();
        int viewStartOffset = this.getStartOffset();
        DocumentView docView = this.getDocumentView();
        HighlightsViewUtils.paintHiglighted(g, hViewAlloc, clipBounds, docView, this, viewStartOffset, false, this.textLayout, viewStartOffset, 0, this.getLength());
    }

    @Override
    public View breakView(int axis, int offset, float x, float len) {
        this.checkTextLayoutValid();
        View part = HighlightsViewUtils.breakView(axis, offset, x, len, this, 0, this.getLength(), this.textLayout);
        return part != null ? part : this;
    }

    @Override
    public View createFragment(int p0, int p1) {
        this.checkTextLayoutValid();
        int startOffset = this.getStartOffset();
        ViewUtils.checkFragmentBounds(p0, p1, startOffset, this.getLength());
        return new HighlightsViewPart(this, p0 - startOffset, p1 - p0);
    }

    private void checkTextLayoutValid() {
        if (!$assertionsDisabled && this.textLayout == null) {
            DocumentView docView;
            throw new AssertionError((Object)("TextLayout is null in " + this + ((docView = this.getDocumentView()) != null ? "\nDOC-VIEW:\n" + docView.toStringDetailUnlocked() : "")));
        }
    }

    @Override
    protected String getDumpName() {
        return "HV";
    }

    @Override
    protected StringBuilder appendViewInfo(StringBuilder sb, int indent, String xyInfo, int importantChildIndex) {
        super.appendViewInfo(sb, indent, xyInfo, importantChildIndex);
        sb.append(" TL=");
        if (this.textLayout == null) {
            sb.append("<NULL>");
        } else {
            sb.append(TextLayoutUtils.toStringShort(this.textLayout));
        }
        return sb;
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, "", -1).toString();
    }
}

