/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsList;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsReader;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewChildren;
import org.netbeans.modules.editor.lib2.view.ViewGapStorage;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;
import org.netbeans.modules.editor.lib2.view.ViewPaintHighlights;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;

public class DocumentViewChildren
extends ViewChildren<ParagraphView> {
    private static final Logger LOG = Logger.getLogger(DocumentViewChildren.class.getName());
    protected static final double EXTEND_TO_END = 1.073741823E9;
    private static final long serialVersionUID = 0L;
    private ViewPaintHighlights viewPaintHighlights;
    private float childrenWidth;

    DocumentViewChildren(int capacity) {
        super(capacity);
    }

    float width() {
        return this.childrenWidth;
    }

    float height() {
        return (float)this.startVisualOffset(this.size());
    }

    double[] replace(DocumentView docView, int index, int removeCount, View[] addedViews) {
        if (index + removeCount > this.size()) {
            throw new IllegalArgumentException("index=" + index + ", removeCount=" + removeCount + ", viewCount=" + this.size());
        }
        int endAddedIndex = index;
        int removeEndIndex = index + removeCount;
        double startY = this.startVisualOffset(index);
        double origEndY = removeCount == 0 ? startY : this.endVisualOffset(removeEndIndex - 1);
        double endY = startY;
        this.moveVisualGap(removeEndIndex, origEndY);
        if (removeCount != 0) {
            TextLayoutCache tlCache = docView.op.getTextLayoutCache();
            for (int i = removeCount - 1; i >= 0; --i) {
                tlCache.remove((ParagraphView)this.get(index + i), false);
            }
            this.remove(index, removeCount);
        }
        if (addedViews != null && addedViews.length != 0) {
            endAddedIndex = index + addedViews.length;
            this.addArray(index, addedViews);
            for (int i = 0; i < addedViews.length; ++i) {
                ParagraphView view = (ParagraphView)addedViews[i];
                view.setParent(docView);
                view.setRawEndVisualOffset(endY += (double)view.getPreferredSpan(1));
            }
        }
        double deltaY = endY - origEndY;
        this.heightChangeUpdate(endAddedIndex, endY, deltaY);
        if (deltaY != 0.0) {
            docView.op.notifyHeightChange();
        }
        return new double[]{startY, origEndY, deltaY};
    }

    private void heightChangeUpdate(int endIndex, double endY, double deltaY) {
        if (this.gapStorage != null) {
            this.gapStorage.visualGapStart = endY;
            this.gapStorage.visualGapLength -= deltaY;
            this.gapStorage.visualGapIndex = endIndex;
        } else if (deltaY != 0.0) {
            int pCount = this.size();
            if (pCount > 20) {
                this.gapStorage = new ViewGapStorage();
                this.gapStorage.initVisualGap(endIndex, endY);
                deltaY += this.gapStorage.visualGapLength;
            }
            while (endIndex < pCount) {
                EditorView view = (EditorView)this.get(endIndex);
                view.setRawEndVisualOffset(view.getRawEndVisualOffset() + deltaY);
                ++endIndex;
            }
        }
    }

    void checkChildrenSpanChange(DocumentView docView, int index) {
        ParagraphView pView;
        if (docView.op.isChildWidthChange()) {
            docView.op.resetChildWidthChange();
            pView = (ParagraphView)this.get(index);
            float newWidth = pView.getPreferredSpan(0);
            if (newWidth > this.childrenWidth) {
                this.childrenWidth = newWidth;
                docView.op.notifyWidthChange();
            }
        }
        if (docView.op.isChildHeightChange()) {
            docView.op.resetChildHeightChange();
            pView = (ParagraphView)this.get(index);
            double startY = this.startVisualOffset(index);
            double endY = this.endVisualOffset(index);
            float newHeight = pView.getPreferredSpan(1);
            double deltaY = (double)newHeight - (endY - startY);
            if (deltaY != 0.0) {
                this.moveVisualGap(++index, endY);
                pView.setRawEndVisualOffset(endY += deltaY);
                this.heightChangeUpdate(index, endY, deltaY);
                docView.op.notifyHeightChange();
            }
        }
    }

    Shape getChildAllocation(DocumentView docView, int index, Shape docViewAlloc) {
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(docViewAlloc);
        double startY = this.startVisualOffset(index);
        double endY = this.endVisualOffset(index);
        mutableBounds.y += startY;
        mutableBounds.height = endY - startY;
        return mutableBounds;
    }

    int viewIndexFirstByStartOffset(int offset, int low) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        while (low <= high) {
            int mid = low + high >>> 1;
            int midStartOffset = ((ParagraphView)this.get(mid)).getStartOffset();
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0) {
                if ((midStartOffset = ((ParagraphView)this.get(--mid)).getStartOffset()) >= offset) continue;
                ++mid;
                break;
            }
            high = mid;
            break;
        }
        return Math.max(high, 0);
    }

    public int viewIndexAtY(double y, Shape alloc) {
        Rectangle2D allocRect = ViewUtils.shapeAsRect(alloc);
        return this.viewIndexFirstVisual(y -= allocRect.getY(), this.size());
    }

    ParagraphView getParagraphViewChildrenValid(DocumentView docView, int index) {
        ParagraphView pView = (ParagraphView)this.get(index);
        if (pView.children == null) {
            docView.op.ensureChildrenValid(index, index + 1, 0, 5);
            pView = (ParagraphView)this.get(index);
            assert (pView.children != null);
        }
        return pView;
    }

    public Shape modelToViewChecked(DocumentView docView, int offset, Shape docViewAlloc, Position.Bias bias) {
        int pIndex = this.viewIndexFirstByStartOffset(offset, 0);
        Shape ret = docViewAlloc;
        if (pIndex >= 0) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            docView.op.getTextLayoutCache().activate(pView);
            Shape childAlloc = this.getChildAllocation(docView, pIndex, docViewAlloc);
            ret = pView.modelToViewChecked(offset, childAlloc, bias);
            this.checkChildrenSpanChange(docView, pIndex);
        }
        return ret;
    }

    public int viewToModelChecked(DocumentView docView, double x, double y, Shape docViewAlloc, Position.Bias[] biasReturn) {
        int offset;
        int pIndex = this.viewIndexAtY(y, docViewAlloc);
        if (pIndex >= 0) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            docView.op.getTextLayoutCache().activate(pView);
            Shape childAlloc = this.getChildAllocation(docView, pIndex, docViewAlloc);
            offset = pView.viewToModelChecked(x, y, childAlloc, biasReturn);
            this.checkChildrenSpanChange(docView, pIndex);
        } else {
            offset = docView.getStartOffset();
        }
        return offset;
    }

    int getNextVisualPositionY(DocumentView docView, int offset, Position.Bias bias, Shape alloc, boolean southDirection, Position.Bias[] biasRet) {
        double x = HighlightsViewUtils.getMagicX(docView, docView, offset, bias, alloc);
        int viewCount = this.size();
        int increment = southDirection ? 1 : -1;
        int retOffset = -1;
        for (int pIndex = docView.getViewIndex(offset, bias); retOffset == -1 && pIndex >= 0 && pIndex < viewCount; pIndex += increment) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            Shape pAlloc = this.getChildAllocation(docView, pIndex, alloc);
            if (pView.children.ensureIndexMeasured(pView, pView.getViewCount(), ViewUtils.shapeAsRect(pAlloc))) {
                this.checkChildrenSpanChange(docView, pIndex);
                pAlloc = this.getChildAllocation(docView, pIndex, alloc);
            }
            if ((retOffset = pView.children.getNextVisualPositionY(pView, offset, bias, pAlloc, southDirection, biasRet, x)) != -1) continue;
            offset = -1;
        }
        return retOffset;
    }

    int getNextVisualPositionX(DocumentView docView, int offset, Position.Bias bias, Shape alloc, boolean eastDirection, Position.Bias[] biasRet) {
        int viewCount = this.size();
        int increment = eastDirection ? 1 : -1;
        int retOffset = -1;
        for (int pIndex = docView.getViewIndex(offset, bias); retOffset == -1 && pIndex >= 0 && pIndex < viewCount; pIndex += increment) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            Shape pAlloc = this.getChildAllocation(docView, pIndex, alloc);
            if (pView.children.ensureIndexMeasured(pView, pView.getViewCount(), ViewUtils.shapeAsRect(pAlloc))) {
                this.checkChildrenSpanChange(docView, pIndex);
                pAlloc = this.getChildAllocation(docView, pIndex, alloc);
            }
            if ((retOffset = pView.children.getNextVisualPositionX(pView, offset, bias, pAlloc, eastDirection, biasRet)) != -1) continue;
            offset = -1;
        }
        return retOffset;
    }

    public String getToolTipTextChecked(DocumentView docView, double x, double y, Shape docViewAlloc) {
        int pIndex = this.viewIndexAtY(y, docViewAlloc);
        String toolTipText = null;
        if (pIndex >= 0) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            docView.op.getTextLayoutCache().activate(pView);
            Shape childAlloc = this.getChildAllocation(docView, pIndex, docViewAlloc);
            toolTipText = pView.getToolTipTextChecked(x, y, childAlloc);
            this.checkChildrenSpanChange(docView, pIndex);
        }
        return toolTipText;
    }

    public JComponent getToolTip(DocumentView docView, double x, double y, Shape docViewAlloc) {
        int pIndex = this.viewIndexAtY(y, docViewAlloc);
        JComponent toolTip = null;
        if (pIndex >= 0) {
            ParagraphView pView = this.getParagraphViewChildrenValid(docView, pIndex);
            docView.op.getTextLayoutCache().activate(pView);
            Shape childAlloc = this.getChildAllocation(docView, pIndex, docViewAlloc);
            toolTip = pView.getToolTip(x, y, childAlloc);
            this.checkChildrenSpanChange(docView, pIndex);
        }
        return toolTip;
    }

    protected void paint(DocumentView docView, Graphics2D g, Shape docViewAlloc, Rectangle clipBounds) {
        if (this.size() > 0) {
            int phEndOffset;
            int endIndex;
            int startIndex;
            double startY = clipBounds.y;
            double endY = clipBounds.getMaxY();
            if (ViewHierarchyImpl.PAINT_LOG.isLoggable(Level.FINE)) {
                ViewHierarchyImpl.PAINT_LOG.fine("\nDocumentViewChildren.paint(): START clipBounds: " + clipBounds + "\n");
            }
            do {
                startIndex = this.viewIndexAtY(startY, docViewAlloc);
                endIndex = this.viewIndexAtY(endY, docViewAlloc) + 1;
                if (!ViewHierarchyImpl.PAINT_LOG.isLoggable(Level.FINE)) continue;
                ViewHierarchyImpl.PAINT_LOG.fine("  paint:docView:[" + startIndex + "," + endIndex + "] for y:<" + startY + "," + endY + ">\n");
            } while (docView.op.ensureChildrenValid(startIndex, endIndex, 10, 10));
            TextLayoutCache tlCache = docView.op.getTextLayoutCache();
            tlCache.ensureCapacity(endIndex - startIndex);
            endIndex = this.size();
            for (int i = startIndex; i < endIndex; ++i) {
                ParagraphView pView = (ParagraphView)this.get(i);
                if (pView.children == null) {
                    int extraEndIndex = Math.min(i + 20, this.size());
                    docView.op.ensureChildrenValid(i, extraEndIndex, 0, 0);
                    tlCache.ensureCapacity(extraEndIndex - startIndex);
                    endIndex = this.size();
                    pView = (ParagraphView)this.get(i);
                }
                tlCache.activate(pView);
                Shape childAlloc = this.getChildAllocation(docView, i, docViewAlloc);
                Rectangle2D childRect = ViewUtils.shapeAsRect(childAlloc);
                if (pView.children.ensureYMeasured(pView, endY, childRect)) {
                    this.checkChildrenSpanChange(docView, i);
                }
                if (!(childRect.getMaxY() >= endY)) continue;
                endIndex = i + 1;
                break;
            }
            boolean logPaintTime = ViewHierarchyImpl.PAINT_LOG.isLoggable(Level.FINE);
            long nanoTime = 0L;
            if (logPaintTime) {
                nanoTime = System.nanoTime();
            }
            int startOffset = ((ParagraphView)this.get(startIndex)).getStartOffset();
            int endOffset = ((ParagraphView)this.get(endIndex - 1)).getEndOffset();
            HighlightsList paintHighlights = null;
            int maxPHReads = 10;
            do {
                HighlightsContainer phContainer = HighlightingManager.getInstance(docView.getTextComponent()).getTopHighlights();
                final boolean[] phStale = new boolean[1];
                HighlightsChangeListener hChangeListener = new HighlightsChangeListener(){

                    @Override
                    public void highlightChanged(HighlightsChangeEvent event) {
                        phStale[0] = true;
                    }
                };
                phContainer.addHighlightsChangeListener(hChangeListener);
                HighlightsReader reader = new HighlightsReader(phContainer, startOffset, endOffset);
                reader.readUntil(endOffset);
                paintHighlights = reader.highlightsList();
                if (!phStale[0]) break;
                phStale[0] = false;
                phContainer.removeHighlightsChangeListener(hChangeListener);
            } while (--maxPHReads >= 0);
            assert ((phEndOffset = paintHighlights.endOffset()) == endOffset) : "phEndOffset=" + phEndOffset + " != endOffset";
            this.viewPaintHighlights = new ViewPaintHighlights(paintHighlights);
            for (int i = startIndex; i < endIndex; ++i) {
                ParagraphView pView = (ParagraphView)this.get(i);
                Shape childAlloc = this.getChildAllocation(docView, i, docViewAlloc);
                if (ViewHierarchyImpl.PAINT_LOG.isLoggable(Level.FINER)) {
                    ViewHierarchyImpl.PAINT_LOG.finer("    pView[" + i + "]: pAlloc=" + ViewUtils.toString(childAlloc) + "\n");
                }
                pView.paint(g, childAlloc, clipBounds);
            }
            this.viewPaintHighlights = null;
            if (logPaintTime) {
                nanoTime = System.nanoTime() - nanoTime;
                ViewHierarchyImpl.PAINT_LOG.fine("Painted " + (endIndex - startIndex) + " lines <" + startIndex + "," + endIndex + "> in " + (double)nanoTime / 1000000.0 + " ms\n");
            }
        }
    }

    ViewPaintHighlights getPaintHighlights(EditorView view, int shift) {
        assert (this.viewPaintHighlights != null) : "ViewPaintHighlights is null. Not in paint()?";
        this.viewPaintHighlights.reset(view, shift);
        return this.viewPaintHighlights;
    }

    void recomputeChildrenWidths() {
        int viewCount = this.size();
        for (int i = 0; i < viewCount; ++i) {
            ParagraphView pView = (ParagraphView)this.get(i);
            pView.resetWidth();
        }
    }

    public StringBuilder appendChildrenInfo(DocumentView docView, StringBuilder sb, int indent, int importantIndex) {
        return this.appendChildrenInfo(sb, indent, importantIndex);
    }

    @Override
    protected String getXYInfo(int index) {
        return new StringBuilder(10).append(" y=").append(this.startVisualOffset(index)).toString();
    }
}

