/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentViewChildren;
import org.netbeans.modules.editor.lib2.view.DocumentViewOp;
import org.netbeans.modules.editor.lib2.view.EditorTabExpander;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.HighlightsViewFactory;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyChange;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

public final class DocumentView
extends EditorView
implements EditorView.Parent {
    private static final Logger LOG = Logger.getLogger(DocumentView.class.getName());
    static final boolean LOG_SOURCE_TEXT = Boolean.getBoolean("org.netbeans.editor.log.source.text");
    private static final String MUTEX_CLIENT_PROPERTY = "foldHierarchyMutex";
    static final String START_POSITION_PROPERTY = "document-view-start-position";
    static final String END_POSITION_PROPERTY = "document-view-end-position";
    static final String ACCURATE_SPAN_PROPERTY = "document-view-accurate-span";
    static final String TEXT_ZOOM_PROPERTY = "text-zoom";
    DocumentViewOp op;
    private PriorityMutex pMutex;
    DocumentViewChildren children;
    private JTextComponent textComponent;
    private Position startPos;
    private Position endPos;
    private Rectangle2D.Float allocation = new Rectangle2D.Float();
    private final TabExpander tabExpander;
    private ViewHierarchyChange change;

    public static DocumentView get(JTextComponent component) {
        View view;
        View rootView;
        TextUI textUI = component.getUI();
        if (textUI != null && (rootView = textUI.getRootView(component)) != null && rootView.getViewCount() > 0 && (view = rootView.getView(0)) instanceof DocumentView) {
            return (DocumentView)view;
        }
        return null;
    }

    static DocumentView get(View view) {
        while (view != null && !(view instanceof DocumentView)) {
            view = view.getParent();
        }
        return (DocumentView)view;
    }

    public DocumentView(Element elem) {
        super(elem);
        assert (elem != null) : "Expecting non-null element";
        this.op = new DocumentViewOp(this);
        this.tabExpander = new EditorTabExpander(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(Runnable r) {
        if (this.lock()) {
            try {
                r.run();
            }
            finally {
                this.unlock();
            }
        } else {
            r.run();
        }
    }

    public void runReadLockTransaction(final Runnable r) {
        this.getDocument().render(new Runnable(){

            @Override
            public void run() {
                DocumentView.this.runTransaction(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPreferredSpan(int axis) {
        if (this.lock()) {
            try {
                float span;
                this.checkDocumentLockedIfLogging();
                this.op.checkViewsInited();
                this.op.checkRealSpanChange();
                if (!this.op.isChildrenValid()) {
                    float f = 1.0f;
                    return f;
                }
                if (axis == 0) {
                    span = this.allocation.width;
                } else {
                    Container parent;
                    span = this.allocation.height;
                    if (this.textComponent != null && (parent = this.textComponent.getParent()) instanceof JViewport) {
                        JViewport viewport = (JViewport)parent;
                        int viewportHeight = viewport.getExtentSize().height;
                        span += (float)(viewportHeight / 3);
                    }
                }
                float f = span;
                return f;
            }
            finally {
                this.unlock();
            }
        }
        return 1.0f;
    }

    boolean lock() {
        if (this.pMutex != null) {
            this.pMutex.lock();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        try {
            this.op.unlockCheck();
            this.checkFireEvent();
        }
        finally {
            this.pMutex.unlock();
        }
    }

    @Override
    public Document getDocument() {
        return this.getElement().getDocument();
    }

    @Override
    public int getStartOffset() {
        return this.startPos == null ? super.getStartOffset() : this.startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        if (this.endPos == null) {
            return super.getEndOffset();
        }
        int viewCount = this.getViewCount();
        return viewCount > 0 ? this.getView(viewCount - 1).getEndOffset() : this.getStartOffset();
    }

    @Override
    public int getViewCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public View getView(int index) {
        this.checkDocumentLockedIfLogging();
        this.checkMutexAcquiredIfLogging();
        return this.children != null ? (ParagraphView)this.children.get(index) : null;
    }

    public ParagraphView getParagraphView(int index) {
        return (ParagraphView)this.children.get(index);
    }

    @Override
    public Shape getChildAllocation(int index, Shape alloc) {
        return this.children.getChildAllocation(this, index, alloc);
    }

    @Override
    public int getViewIndex(int offset, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            --offset;
        }
        return this.getViewIndex(offset);
    }

    public int getViewIndex(int offset) {
        return this.children.viewIndexFirstByStartOffset(offset, 0);
    }

    public double getY(int pViewIndex) {
        return this.children.startVisualOffset(pViewIndex);
    }

    @Override
    public int getViewEndOffset(int rawChildEndOffset) {
        throw new IllegalStateException("Raw end offsets storage not maintained for DocumentView.");
    }

    @Override
    public void replace(int index, int length, View[] views) {
        this.replaceViews(index, length, views);
    }

    ViewHierarchyChange validChange() {
        if (this.change == null) {
            this.change = new ViewHierarchyChange();
        }
        return this.change;
    }

    void checkFireEvent() {
        if (this.change != null) {
            this.op.viewHierarchyImpl().fireChange(this.change);
            this.change = null;
        }
    }

    public TabExpander getTabExpander() {
        return this.tabExpander;
    }

    double[] replaceViews(int index, int length, View[] views) {
        if (this.children == null) {
            this.children = new DocumentViewChildren(views.length);
        }
        return this.children.replace(this, index, length, views);
    }

    boolean hasExtraStartBound() {
        return this.startPos != null;
    }

    Position getStartPosition() {
        return this.startPos;
    }

    void setStartPosition(Position startPosition) {
        this.startPos = startPosition;
    }

    boolean hasExtraEndBound() {
        return this.endPos != null;
    }

    public int getEndBoundOffset() {
        return this.endPos != null ? this.endPos.getOffset() : this.getDocument().getLength() + 1;
    }

    boolean hasExtraBounds() {
        return this.hasExtraStartBound() || this.hasExtraEndBound();
    }

    @Override
    public int getRawEndOffset() {
        return -1;
    }

    @Override
    public void setRawEndOffset(int rawOffset) {
        throw new IllegalStateException("Unexpected");
    }

    @Override
    public void setSize(float width, float height) {
    }

    public Rectangle2D getAllocation() {
        return this.allocation;
    }

    public Rectangle2D.Double getAllocationMutable() {
        return new Rectangle2D.Double(0.0, 0.0, this.allocation.getWidth(), this.allocation.getHeight());
    }

    @Override
    public HighlightsSequence getPaintHighlights(EditorView view, int shift) {
        return this.children.getPaintHighlights(view, shift);
    }

    @Override
    public void notifyChildWidthChange() {
        this.op.notifyChildWidthChange();
    }

    @Override
    public void notifyChildHeightChange() {
        this.op.notifyChildHeightChange();
    }

    @Override
    public void preferenceChanged(View childView, boolean widthChange, boolean heightChange) {
        if (childView == null) {
            if (widthChange) {
                this.op.notifyWidthChange();
            }
            if (heightChange) {
                this.op.notifyHeightChange();
            }
        } else if (this.children != null) {
            int index = this.getViewIndex(childView.getStartOffset());
            if (widthChange) {
                this.notifyChildWidthChange();
            }
            if (heightChange) {
                this.notifyChildHeightChange();
            }
            this.children.checkChildrenSpanChange(this, index);
            Shape childAlloc = this.getChildAllocation(index, this.getAllocation());
            this.op.notifyRepaint(this.op.extendToVisibleWidth(ViewUtils.shape2Bounds(childAlloc)));
        }
    }

    void superPreferenceChanged(boolean widthChange, boolean heightChange) {
        super.preferenceChanged(this, widthChange, heightChange);
    }

    boolean assignChildrenWidth() {
        float newWidth = this.children.width();
        if (newWidth != this.allocation.width) {
            this.allocation.width = newWidth;
            return true;
        }
        return false;
    }

    boolean assignChildrenHeight() {
        float newHeight = this.children.height();
        if (newHeight != this.allocation.height) {
            this.allocation.height = newHeight;
            return true;
        }
        return false;
    }

    void recomputeChildrenWidths() {
        if (this.children != null) {
            if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINE)) {
                ViewHierarchyImpl.SPAN_LOG.fine("Component width differs => children.recomputeChildrenWidths()\n");
            }
            this.children.recomputeChildrenWidths();
        }
    }

    @Override
    public void notifyRepaint(double x0, double y0, double x1, double y1) {
        this.op.notifyRepaint(x0, y0, x1, y1);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.op.getFontRenderContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offsetRepaint(int startOffset, int endOffset) {
        if (this.lock()) {
            try {
                this.checkDocumentLockedIfLogging();
                if (ViewHierarchyImpl.REPAINT_LOG.isLoggable(Level.FINE)) {
                    ViewHierarchyImpl.REPAINT_LOG.fine("OFFSET-REPAINT: <" + startOffset + "," + endOffset + ">\n");
                }
                if (this.op.isActive() && startOffset < endOffset && this.getViewCount() > 0) {
                    Rectangle2D repaintRect;
                    Rectangle2D.Double docViewRect = this.getAllocationMutable();
                    int pViewIndex = this.getViewIndex(startOffset);
                    ParagraphView pView = this.getParagraphView(pViewIndex);
                    if (endOffset <= pView.getEndOffset()) {
                        Shape pViewAlloc = this.getChildAllocation(pViewIndex, docViewRect);
                        if (pView.children != null) {
                            Shape s = pView.modelToViewChecked(startOffset, Position.Bias.Forward, endOffset, Position.Bias.Forward, pViewAlloc);
                            repaintRect = ViewUtils.shapeAsRect(s);
                            this.children.checkChildrenSpanChange(this, pViewIndex);
                        } else {
                            repaintRect = this.op.extendToVisibleWidth(ViewUtils.shape2Bounds(pViewAlloc));
                        }
                    } else {
                        docViewRect.y = this.getY(pViewIndex);
                        int endIndex = this.getViewIndex(endOffset) + 1;
                        docViewRect.height = this.getY(endIndex) - docViewRect.y;
                        this.op.extendToVisibleWidth(docViewRect);
                        repaintRect = docViewRect;
                    }
                    if (repaintRect != null) {
                        this.op.notifyRepaint(repaintRect);
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(View parent) {
        if (parent != null) {
            Container container = parent.getContainer();
            assert (container != null) : "Container is null";
            assert (container instanceof JTextComponent) : "Container not JTextComponent";
            JTextComponent tc = (JTextComponent)container;
            this.pMutex = (PriorityMutex)tc.getClientProperty(MUTEX_CLIENT_PROPERTY);
            if (this.pMutex == null) {
                this.pMutex = new PriorityMutex();
                tc.putClientProperty(MUTEX_CLIENT_PROPERTY, this.pMutex);
            }
            if (this.lock()) {
                try {
                    super.setParent(parent);
                    this.textComponent = tc;
                    this.op.parentViewSet();
                    this.updateStartEndPos();
                }
                finally {
                    this.unlock();
                }
            }
        } else {
            this.runReadLockTransaction(new Runnable(){

                @Override
                public void run() {
                    if (DocumentView.this.textComponent != null) {
                        DocumentView.this.op.parentCleared();
                        DocumentView.this.textComponent = null;
                    }
                    DocumentView.super.setParent(null);
                }
            });
        }
    }

    void updateStartEndPos() {
        this.startPos = (Position)this.textComponent.getClientProperty(START_POSITION_PROPERTY);
        this.endPos = (Position)this.textComponent.getClientProperty(END_POSITION_PROPERTY);
        int startOffset = 0;
        if (this.startPos != null && (startOffset = this.startPos.getOffset()) == 0) {
            this.startPos = null;
        }
        if (this.endPos != null && (this.endPos.getOffset() == this.getDocument().getEndPosition().getOffset() || this.endPos.getOffset() < startOffset)) {
            this.endPos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipTextChecked(double x, double y, Shape alloc) {
        if (this.lock()) {
            try {
                this.checkDocumentLockedIfLogging();
                this.op.checkViewsInited();
                if (this.op.isActive()) {
                    String string = this.children.getToolTipTextChecked(this, x, y, alloc);
                    return string;
                }
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getToolTip(double x, double y, Shape alloc) {
        if (this.lock()) {
            try {
                this.checkDocumentLockedIfLogging();
                this.op.checkViewsInited();
                if (this.op.isActive()) {
                    JComponent jComponent = this.children.getToolTip(this, x, y, alloc);
                    return jComponent;
                }
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        if (this.lock()) {
            try {
                this.checkDocumentLockedIfLogging();
                this.op.checkViewsInited();
                if (this.op.isActive()) {
                    if (g != null && this.op.renderingHints != null) {
                        g.setRenderingHints(this.op.renderingHints);
                    }
                    this.children.paint(this, g, alloc, clipBounds);
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        if (this.lock()) {
            try {
                Shape shape = this.modelToViewUnlocked(offset, alloc, bias);
                return shape;
            }
            finally {
                this.unlock();
            }
        }
        return null;
    }

    public Shape modelToViewUnlocked(int offset, Shape alloc, Position.Bias bias) {
        int index;
        Rectangle2D.Double rect = ViewUtils.shape2Bounds(alloc);
        Shape retShape = null;
        this.checkDocumentLockedIfLogging();
        this.op.checkViewsInited();
        if (this.op.isActive()) {
            retShape = this.children.modelToViewChecked(this, offset, alloc, bias);
        } else if (this.children != null && (index = this.getViewIndex(offset)) >= 0) {
            rect.y = this.getY(index);
        }
        if (retShape == null) {
            float defaultRowHeight = this.op.getDefaultRowHeight();
            if (defaultRowHeight > 0.0f) {
                rect.height = defaultRowHeight;
            }
            retShape = rect;
        }
        if (ViewHierarchyImpl.OP_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.OP_LOG, "modelToView(" + offset + ")=" + retShape + "\n");
        }
        return retShape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double modelToY(int offset) {
        double retY = 0.0;
        if (this.lock()) {
            try {
                this.checkDocumentLockedIfLogging();
                this.op.checkViewsInited();
                if (this.op.isActive()) {
                    retY = this.modelToYUnlocked(offset);
                }
            }
            finally {
                this.unlock();
            }
        }
        if (ViewHierarchyImpl.OP_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.OP_LOG, "modelToY(" + offset + ")=" + retY + "\n");
        }
        return retY;
    }

    public double modelToYUnlocked(int offset) {
        int index = this.getViewIndex(offset);
        return this.getY(index);
    }

    public double[] modelToYUnlocked(int[] offsets) {
        double[] retYs = new double[offsets.length];
        if (offsets.length > 0) {
            int lastOffset = 0;
            int lastIndex = 0;
            double lastY = 0.0;
            for (int i = 0; i < offsets.length; ++i) {
                double y;
                int offset = offsets[i];
                if (offset == lastOffset) {
                    y = lastY;
                } else {
                    int startIndex = offset > lastOffset ? lastIndex : 0;
                    int index = this.children.viewIndexFirstByStartOffset(offset, startIndex);
                    y = this.getY(index);
                }
                retYs[i] = y;
            }
        }
        return retYs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        if (this.lock()) {
            try {
                int n = this.viewToModelUnlocked(x, y, alloc, biasReturn);
                return n;
            }
            finally {
                this.unlock();
            }
        }
        return 0;
    }

    public int viewToModelUnlocked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int retOffset = 0;
        this.checkDocumentLockedIfLogging();
        this.op.checkViewsInited();
        if (this.op.isActive()) {
            retOffset = this.children.viewToModelChecked(this, x, y, alloc, biasReturn);
        }
        if (ViewHierarchyImpl.OP_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.OP_LOG, "viewToModel: [x,y]=" + x + "," + y + " => " + retOffset + "\n");
        }
        return retOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        block17: {
            retOffset = offset;
            if (this.lock()) {
                try {
                    this.checkDocumentLockedIfLogging();
                    this.op.checkViewsInited();
                    if (!this.op.isActive()) break block17;
                    switch (direction) {
                        case 3: {
                            if (offset == -1) {
                                retOffset = this.getEndOffset() - 1;
                                ** break;
lbl12:
                                // 1 sources

                                break;
                            }
                        }
                        case 7: {
                            if (offset == -1) {
                                retOffset = this.getStartOffset();
                                ** break;
lbl17:
                                // 1 sources

                            } else {
                                retOffset = this.children.getNextVisualPositionX(this, offset, bias, alloc, direction == 3, biasRet);
                                ** break;
                            }
lbl20:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            if (offset == -1) {
                                retOffset = this.getEndOffset() - 1;
                                ** break;
lbl25:
                                // 1 sources

                                break;
                            }
                        }
                        case 5: {
                            if (offset == -1) {
                                retOffset = this.getStartOffset();
                                ** break;
lbl30:
                                // 1 sources

                            } else {
                                retOffset = this.children.getNextVisualPositionY(this, offset, bias, alloc, direction == 5, biasRet);
                                ** break;
                            }
lbl33:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad direction " + direction);
                        }
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }
        if (ViewHierarchyImpl.OP_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.OP_LOG, "nextVisualPosition(" + offset + "," + ViewUtils.toStringDirection(direction) + ")=" + retOffset + "\n");
        }
        return retOffset;
    }

    public void updateLengthyAtomicEdit(int delta) {
        this.op.updateLengthyAtomicEdit(delta);
    }

    @Override
    public void insertUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    void checkDocumentLockedIfLogging() {
        if (ViewHierarchyImpl.CHECK_LOG.isLoggable(Level.FINE)) {
            this.checkDocumentLocked();
        }
    }

    void checkDocumentLocked() {
        if (!DocumentUtilities.isReadLocked((Document)this.getDocument())) {
            ViewHierarchyImpl.CHECK_LOG.log(Level.INFO, "Document not locked", new Exception("Document not locked"));
        }
    }

    void checkMutexAcquiredIfLogging() {
        if (ViewHierarchyImpl.CHECK_LOG.isLoggable(Level.FINE)) {
            this.checkLocked();
        }
    }

    void checkLocked() {
        Thread mutexThread;
        PriorityMutex mutex = this.pMutex;
        if (mutex != null && (mutexThread = mutex.getLockThread()) != Thread.currentThread()) {
            String msg = mutexThread == null ? "Mutex not acquired" : "Mutex already acquired for different thread: " + mutexThread;
            ViewHierarchyImpl.CHECK_LOG.log(Level.INFO, msg + " for textComponent=" + this.textComponent, new Exception());
        }
    }

    boolean isLocked() {
        PriorityMutex mutex = this.pMutex;
        return mutex != null && mutex.getLockThread() == Thread.currentThread();
    }

    @Override
    protected String getDumpName() {
        return "DV";
    }

    @Override
    public String findIntegrityError() {
        String err = super.findIntegrityError();
        if (err != null) {
            return err;
        }
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        int viewCount = this.getViewCount();
        if (viewCount > 0) {
            ParagraphView firstView = this.getParagraphView(0);
            if (firstView.getStartOffset() != startOffset) {
                return "firstView.getStartOffset()=" + firstView.getStartOffset() + " != startOffset=" + startOffset;
            }
            ParagraphView lastView = this.getParagraphView(viewCount - 1);
            if (lastView.getEndOffset() != endOffset) {
                return "lastView.endOffset=" + lastView.getEndOffset() + " != endOffset=" + endOffset;
            }
            if (endOffset < this.getEndBoundOffset()) {
                return "endOffset=" + endOffset + " < endBoundOffset=" + this.getEndBoundOffset();
            }
        }
        return null;
    }

    @Override
    public String findTreeIntegrityError() {
        final String[] ret = new String[1];
        this.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                ret[0] = DocumentView.super.findTreeIntegrityError();
            }
        });
        return ret[0];
    }

    @Override
    protected StringBuilder appendViewInfo(StringBuilder sb, int indent, String xyInfo, int importantChildIndex) {
        DocumentView.super.appendViewInfo(sb, indent, xyInfo, importantChildIndex);
        sb.append("; Bounds:<");
        sb.append(this.hasExtraStartBound() ? Integer.valueOf(this.startPos.getOffset()) : "DOC-START");
        sb.append(",");
        sb.append(this.hasExtraEndBound() ? Integer.valueOf(this.endPos.getOffset()) : "DOC-END");
        sb.append(">, ");
        this.op.appendInfo(sb);
        if (LOG_SOURCE_TEXT) {
            Document doc = this.getDocument();
            sb.append("\nDoc: ").append(ViewUtils.toString(doc));
        }
        if (this.children != null && importantChildIndex != -1) {
            this.children.appendChildrenInfo(this, sb, indent, importantChildIndex);
        }
        return sb;
    }

    public String toString() {
        final String[] s = new String[1];
        this.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                s[0] = DocumentView.this.toStringUnlocked();
            }
        });
        return s[0];
    }

    public String toStringUnlocked() {
        return this.appendViewInfo(new StringBuilder(200), 0, "", -1).toString();
    }

    public String toStringDetail() {
        final String[] s = new String[1];
        this.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                s[0] = DocumentView.this.toStringDetailUnlocked();
            }
        });
        return s[0];
    }

    public String toStringDetailUnlocked() {
        return this.appendViewInfo(new StringBuilder(200), 0, "", -2).toString();
    }

    static {
        EditorViewFactory.registerFactory(new HighlightsViewFactory.HighlightsFactory());
    }
}

