/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenChildStringPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;
    private int alignment;

    public ScreenChildStringPropertyEditor(String propertyName) {
        this(propertyName, 2);
    }

    public ScreenChildStringPropertyEditor(String propertyName, int alignment) {
        this.alignment = alignment;
        assert (propertyName != null);
        this.propertyName = propertyName;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor property) {
        StringTextField editor = new StringTextField(property);
        editor.setMinimumSize(new Dimension(128, 21));
        PropertyValue value = property.getRelatedComponent().readProperty(this.propertyName);
        String string = MidpTypes.getString(value);
        editor.setText(string != null ? string : "");
        editor.selectAll();
        return editor;
    }

    public Insets getEditorComponentInsets(JComponent editorComponent) {
        return editorComponent.getBorder().getBorderInsets(editorComponent);
    }

    private class StringTextField
    extends JTextField
    implements KeyListener {
        private ScreenPropertyDescriptor property;

        public StringTextField(ScreenPropertyDescriptor property) {
            this.property = property;
            this.addKeyListener(this);
            this.setHorizontalAlignment(ScreenChildStringPropertyEditor.this.alignment);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\n') {
                return;
            }
            final DesignComponent relatedComponent = this.property.getRelatedComponent();
            relatedComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue value = MidpTypes.createStringValue(StringTextField.this.getText());
                    relatedComponent.writeProperty(ScreenChildStringPropertyEditor.this.propertyName, value);
                }
            });
            PopupUtil.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

