/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.eventhandler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD;
import org.netbeans.modules.vmd.midp.components.points.CallPointCD;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.components.points.MobileDeviceCD;
import org.netbeans.modules.vmd.midp.general.AcceptContextResolver;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorElementFactory;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorEventHandlerElement;
import org.netbeans.modules.vmd.midp.propertyeditors.eventhandler.ExitMidletElement;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PropertyEditorEventHandler
extends DesignPropertyEditor {
    private static final String DO_NOTHING = NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"LBL_NOTHING_ACTION");
    private CustomEditor customEditor = null;
    private WeakReference<DesignComponent> component;
    private boolean initialized;

    private PropertyEditorEventHandler() {
    }

    public static final PropertyEditorEventHandler createInstance() {
        return new PropertyEditorEventHandler();
    }

    public void init(DesignComponent component) {
        if (component != null) {
            this.component = new WeakReference<DesignComponent>(component);
        }
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            Collection factories = Lookup.getDefault().lookup(new Lookup.Template(PropertyEditorElementFactory.class)).allInstances();
            ArrayList<PropertyEditorEventHandlerElement> elements = new ArrayList<PropertyEditorEventHandlerElement>(factories.size());
            for (PropertyEditorElementFactory factory : factories) {
                elements.add(factory.createElement());
            }
            this.customEditor = new CustomEditor(elements);
        }
        if (this.initialized) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }

    private void initCustomEditor() {
        if (this.component != null && this.component.get() != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue value = null;
                    Iterator iterator = _component.getComponents().iterator();
                    if (iterator.hasNext()) {
                        DesignComponent eventHandler = (DesignComponent)iterator.next();
                        value = PropertyValue.createComponentReference((DesignComponent)eventHandler);
                    }
                    DesignComponent displayableCategory = MidpDocumentSupport.getCategoryComponent(_component.getDocument(), DisplayablesCategoryCD.TYPEID);
                    DesignComponent pointsCategory = MidpDocumentSupport.getCategoryComponent(_component.getDocument(), PointsCategoryCD.TYPEID);
                    List displayables = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)displayableCategory, (TypeID)DisplayableCD.TYPEID);
                    PropertyEditorEventHandler.this.customEditor.updateModels(displayables, 0, value);
                    List alerts = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)displayableCategory, (TypeID)AlertCD.TYPEID);
                    ArrayList<DesignComponent> displExceptAlerts = new ArrayList<DesignComponent>(displayables.size() - alerts.size());
                    displExceptAlerts.addAll(displayables);
                    displExceptAlerts.removeAll(alerts);
                    PropertyEditorEventHandler.this.customEditor.updateModels(displExceptAlerts, 1, value);
                    List points = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)pointsCategory, (TypeID)CallPointCD.TYPEID);
                    List methods = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)pointsCategory, (TypeID)MethodPointCD.TYPEID);
                    ArrayList<DesignComponent> pointsAndMethods = new ArrayList<DesignComponent>(points.size() + methods.size());
                    pointsAndMethods.addAll(points);
                    pointsAndMethods.addAll(methods);
                    PropertyEditorEventHandler.this.customEditor.updateModels(pointsAndMethods, 2, value);
                    List mobileDevices = DocumentSupport.gatherSubComponentsOfType((DesignComponent)pointsCategory, (TypeID)MobileDeviceCD.TYPEID);
                    PropertyEditorEventHandler.this.customEditor.setExitMidletEnabled(mobileDevices.size() == 1);
                }
            });
        }
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        final String[] string = new String[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = _component.getComponents().iterator();
                    if (!iterator.hasNext()) {
                        string[0] = DO_NOTHING;
                    } else {
                        DesignComponent eventHandler = (DesignComponent)iterator.next();
                        InfoPresenter presenter = (InfoPresenter)eventHandler.getPresenter(InfoPresenter.class);
                        if (presenter != null) {
                            string[0] = presenter.getDisplayName(InfoPresenter.NameType.PRIMARY);
                        } else {
                            throw new IllegalStateException("No infoPresenter for " + eventHandler);
                        }
                    }
                }
            });
        }
        return string[0];
    }

    public boolean executeInsideWriteTransaction() {
        if (this.initialized && this.component != null && this.component.get() != null) {
            this.customEditor.createEventHandler((DesignComponent)this.component.get());
        }
        return false;
    }

    public boolean isDefaultValue() {
        return true;
    }

    public void cleanUp(DesignComponent component) {
        if (this.customEditor != null) {
            this.customEditor.clean(component);
        }
        component = null;
        super.cleanUp(component);
    }

    private class CustomEditor
    extends JPanel
    implements CleanUp {
        private Collection<PropertyEditorEventHandlerElement> elements;
        private JRadioButton doNothingRadioButton;

        public CustomEditor(Collection<PropertyEditorEventHandlerElement> elements) {
            this.elements = elements;
        }

        private void initComponents(Collection<PropertyEditorEventHandlerElement> elements) {
            if (PropertyEditorEventHandler.this.component == null || PropertyEditorEventHandler.this.component.get() == null) {
                return;
            }
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints constraints = new GridBagConstraints();
            boolean wasSelected = false;
            final DesignComponent _component = (DesignComponent)PropertyEditorEventHandler.this.component.get();
            for (PropertyEditorEventHandlerElement element : elements) {
                final Collection<TypeID> types = element.getTypes();
                final boolean[] acceptable = new boolean[]{true};
                _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        for (TypeID typeID : types) {
                            if (AcceptContextResolver.resolveAcceptAllowance(_component, typeID)) continue;
                            acceptable[0] = false;
                            break;
                        }
                    }
                });
                if (!acceptable[0]) continue;
                JRadioButton rb = element.getRadioButton();
                if (element.isInitiallySelected()) {
                    rb.setSelected(true);
                    wasSelected = true;
                }
                buttonGroup.add(rb);
                constraints.insets = new Insets(12, 12, 6, 12);
                constraints.anchor = 18;
                constraints.gridx = 0;
                constraints.gridy = -1;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.fill = 2;
                this.add((Component)rb, constraints);
                JComponent component = element.getCustomEditorComponent();
                if (component == null) continue;
                constraints.insets = new Insets(0, 32, 12, 12);
                constraints.anchor = 18;
                constraints.gridx = 0;
                constraints.gridy = -1;
                constraints.weightx = 1.0;
                constraints.weighty = element.isVerticallyResizable() ? 1.0 : 0.0;
                constraints.fill = 1;
                this.add((Component)component, constraints);
            }
            this.doNothingRadioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.doNothingRadioButton, (String)NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"LBL_NOTHING"));
            this.doNothingRadioButton.setSelected(!wasSelected);
            buttonGroup.add(this.doNothingRadioButton);
            this.doNothingRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"ACSN_NOTHING"));
            this.doNothingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"ACSD_NOTHING"));
            constraints.insets = new Insets(12, 12, 6, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            this.add((Component)this.doNothingRadioButton, constraints);
            JPanel spacer = new JPanel();
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            this.add((Component)spacer, constraints);
        }

        public void updateModels(List<DesignComponent> components, int modelType, PropertyValue value) {
            for (PropertyEditorEventHandlerElement element : this.elements) {
                element.updateModel(components, modelType);
                element.updateState(value);
                this.checkDoNothing(value);
            }
        }

        public void setExitMidletEnabled(boolean enabled) {
            for (PropertyEditorEventHandlerElement element : this.elements) {
                if (!(element instanceof ExitMidletElement)) continue;
                element.setElementEnabled(enabled);
                break;
            }
        }

        private void checkDoNothing(PropertyValue value) {
            if (value == null || value.getComponent() == null) {
                this.doNothingRadioButton.setSelected(true);
            }
        }

        private void resetEventHandler(DesignComponent eventSource) {
            MidpDocumentSupport.updateEventHandlerWithNew(eventSource, null);
        }

        public void createEventHandler(DesignComponent eventSource) {
            if (this.doNothingRadioButton.isSelected()) {
                this.resetEventHandler(eventSource);
            } else {
                for (PropertyEditorEventHandlerElement element : this.elements) {
                    if (eventSource == null) continue;
                    element.createEventHandler(eventSource);
                }
            }
        }

        @Override
        public void addNotify() {
            if (!PropertyEditorEventHandler.this.initialized) {
                this.initComponents(this.elements);
                PropertyEditorEventHandler.this.initCustomEditor();
                PropertyEditorEventHandler.this.initialized = true;
            }
            super.addNotify();
        }

        @Override
        public void clean(DesignComponent component) {
            if (this.elements != null && this.elements.size() > 0) {
                for (PropertyEditorEventHandlerElement element : this.elements) {
                    if (!(element instanceof CleanUp)) continue;
                    ((CleanUp)((Object)element)).clean(component);
                }
                this.elements = null;
            }
            this.doNothingRadioButton = null;
        }
    }
}

