/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.util.List;

public abstract class Bitmask {
    private int bitmask;

    public Bitmask(int bitmask) {
        this.bitmask = bitmask;
    }

    public abstract List<BitmaskItem> getBitmaskItems();

    public int getBitmask() {
        return this.bitmask;
    }

    public boolean isSet(BitmaskItem item) {
        int affectedBits = item.getAffectedBits();
        return (affectedBits & this.bitmask) == affectedBits;
    }

    public int addToBitmask(BitmaskItem item, boolean value) {
        this.bitmask = value ? (this.bitmask |= item.getAffectedBits()) : (this.bitmask &= ~item.getAffectedBits());
        return this.bitmask;
    }

    public int setBitmask(int bitmask) {
        this.bitmask = bitmask;
        return this.bitmask;
    }

    public boolean equals(Bitmask bitmask) {
        if (this == bitmask) {
            return true;
        }
        return this.bitmask == bitmask.bitmask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bitmask) {
            return this.equals((Bitmask)obj);
        }
        return false;
    }

    public BitmaskItem getBitmaskItem(int affectedBits) {
        for (BitmaskItem bitmaskItem : this.getBitmaskItems()) {
            if (bitmaskItem.getAffectedBits() != affectedBits) continue;
            return bitmaskItem;
        }
        return null;
    }

    public BitmaskItem getBitmaskItem(String displayName) {
        for (BitmaskItem bitmaskItem : this.getBitmaskItems()) {
            if (!bitmaskItem.getDisplayName().equals(displayName)) continue;
            return bitmaskItem;
        }
        return null;
    }

    public static final class BitmaskItem {
        private String name;
        private String displayName;
        private int affectedBits;

        public BitmaskItem(String name, int affectedBits) {
            this(affectedBits, null, name);
        }

        public BitmaskItem(int affectedBits, String displayName, String name) {
            if (name == null) {
                throw new NullPointerException("Name parameter cannot be null");
            }
            this.name = name;
            this.displayName = displayName != null ? displayName : this.name;
            this.affectedBits = affectedBits;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public int getAffectedBits() {
            return this.affectedBits;
        }
    }
}

