/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.FacadeGenerator;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.RestFacadeMethod;
import org.netbeans.modules.websvc.rest.codegen.RestGenerationOptions;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class EntityResourcesGenerator
extends AbstractGenerator
implements FacadeGenerator {
    public static final String RESOURCE_FOLDER = "service";
    public static final String CONTROLLER_FOLDER = "controller";
    public static final String RESOURCE_SUFFIX = "Resource";
    protected static final String REST_FACADE_SUFFIX = "RESTFacade";
    private PersistenceHelper.PersistenceUnit persistenceUnit;
    private String targetPackageName;
    private FileObject targetFolder;
    private FileObject resourceFolder;
    private String resourcePackageName;
    private FileObject controllerFolder;
    private String controllerPackageName;
    private EntityResourceBeanModel model;
    private Project project;

    public void initialize(EntityResourceBeanModel entityResourceBeanModel, Project project, FileObject fileObject, String string, String string2, String string3, PersistenceHelper.PersistenceUnit persistenceUnit) {
        this.model = entityResourceBeanModel;
        this.project = project;
        this.persistenceUnit = persistenceUnit;
        this.targetFolder = fileObject;
        this.targetPackageName = string;
        this.resourcePackageName = string2 == null ? string + "." + RESOURCE_FOLDER : string2;
        this.controllerPackageName = string3 == null ? string + "." + CONTROLLER_FOLDER : string3;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle);
        }
        this.createFolders();
        new PersistenceHelper(this.project).configure(this.model.getBuilder().getAllEntityNames(), !RestUtils.hasJTASupport(this.project));
        this.configurePersistence();
        HashSet<String> hashSet = new HashSet<String>();
        for (EntityClassInfo entityClassInfo : this.model.getEntityInfos()) {
            if (hashSet.contains(entityClassInfo.getEntityFqn())) continue;
            hashSet.add(entityClassInfo.getEntityFqn());
            Util.modifyEntity(entityClassInfo.getEntityFqn(), this.project);
        }
        this.preGenerate(new ArrayList<String>(hashSet));
        Util.generateRESTFacades(this.project, hashSet, this.model, this.resourceFolder, this.getResourcePackageName(), this);
        this.finishProgressReporting();
        return new HashSet<FileObject>();
    }

    public Set<FileObject> generate(Project project, Map<String, String> map, FileObject fileObject, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws IOException {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        String string4 = JavaIdentifiers.unqualify((String)string);
        String string5 = string4 + REST_FACADE_SUFFIX;
        this.reportProgress(string5);
        FileObject fileObject2 = fileObject.getFileObject(string5, "java");
        if (fileObject2 != null) {
            if (bl3) {
                fileObject2.delete();
            } else {
                throw new IOException("file alerady exists exception: " + fileObject2);
            }
        }
        FileObject fileObject3 = GenerationUtils.createClass((FileObject)fileObject, (String)(string4 + REST_FACADE_SUFFIX), null);
        hashSet.add(fileObject3);
        if (!this.generateInfrastracture(hashSet, string4, fileObject3)) {
            return hashSet;
        }
        this.generateResourceMethods(fileObject3, string, string2);
        return hashSet;
    }

    protected List<String> getResourceImports(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        linkedList.add(URI.class.getCanonicalName());
        return linkedList;
    }

    protected boolean generateInfrastracture(Set<FileObject> set, String string, FileObject fileObject) throws IOException {
        return true;
    }

    protected void preGenerate(List<String> list) throws IOException {
    }

    protected ModifiersTree addRestMethodAnnotations(GenerationUtils generationUtils, TreeMaker treeMaker, RestGenerationOptions restGenerationOptions, ModifiersTree modifiersTree) {
        String string;
        String string2 = restGenerationOptions.getRestMethod().getMethod();
        ModifiersTree modifiersTree2 = modifiersTree;
        if (string2 != null) {
            modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation(string2));
        }
        if ((string = restGenerationOptions.getRestMethod().getUriPath()) != null) {
            LiteralTree literalTree = treeMaker.Literal((Object)string);
            modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree2, generationUtils.createAnnotation("javax.ws.rs.Path", Collections.singletonList(literalTree)));
        }
        if (restGenerationOptions.getRestMethod().overrides()) {
            modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree2, generationUtils.createAnnotation(Override.class.getCanonicalName()));
        }
        modifiersTree2 = this.addMimeHandlerAnnotation(generationUtils, treeMaker, restGenerationOptions, modifiersTree2, "javax.ws.rs.Produces", restGenerationOptions.getProduces());
        modifiersTree2 = this.addMimeHandlerAnnotation(generationUtils, treeMaker, restGenerationOptions, modifiersTree2, "javax.ws.rs.Consumes", restGenerationOptions.getConsumes());
        return modifiersTree2;
    }

    protected ModifiersTree addResourceAnnotation(String string, ClassTree classTree, GenerationUtils generationUtils, TreeMaker treeMaker) {
        LiteralTree literalTree = treeMaker.Literal((Object)string.toLowerCase());
        ModifiersTree modifiersTree = classTree.getModifiers();
        modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation("javax.ws.rs.Path", Collections.singletonList(literalTree)));
        return modifiersTree;
    }

    protected List<RestGenerationOptions> getRestFacadeMethodOptions(String string, String string2) {
        String string3;
        String string4 = string2;
        if (Character.class.getCanonicalName().equals(string2)) {
            string3 = "id.charAt(0)";
            string4 = String.class.getCanonicalName();
        } else {
            string3 = "id";
        }
        RestFacadeMethod[] restFacadeMethodArray = RestFacadeMethod.values();
        ArrayList<RestGenerationOptions> arrayList = new ArrayList<RestGenerationOptions>(restFacadeMethodArray.length);
        for (RestFacadeMethod restFacadeMethod : restFacadeMethodArray) {
            RestGenerationOptions restGenerationOptions = this.getGenerationOptions(restFacadeMethod, string, string3, string4);
            arrayList.add(restGenerationOptions);
        }
        return arrayList;
    }

    protected void generateRestMethod(TypeElement typeElement, GenerationUtils generationUtils, TreeMaker treeMaker, List<Tree> list, RestGenerationOptions restGenerationOptions) {
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.emptySet());
        ModifiersTree modifiersTree2 = restGenerationOptions.getRestMethod().getMethod() == null ? generationUtils.createModifiers(Modifier.PRIVATE) : generationUtils.createModifiers(Modifier.PUBLIC);
        ModifiersTree modifiersTree3 = this.addRestMethodAnnotations(generationUtils, treeMaker, restGenerationOptions, modifiersTree2);
        List<VariableTree> list2 = this.addRestArguments(typeElement, generationUtils, treeMaker, restGenerationOptions, modifiersTree);
        PrimitiveTypeTree primitiveTypeTree = restGenerationOptions.getReturnType() == null || restGenerationOptions.getReturnType().equals("void") ? treeMaker.PrimitiveType(TypeKind.VOID) : generationUtils.createType(restGenerationOptions.getReturnType(), typeElement);
        list.add(treeMaker.Method(modifiersTree3, (CharSequence)restGenerationOptions.getRestMethod().getMethodName(), (Tree)primitiveTypeTree, Collections.emptyList(), list2, Collections.emptyList(), "{" + restGenerationOptions.getBody() + "}", null));
    }

    protected List<VariableTree> addRestArguments(TypeElement typeElement, GenerationUtils generationUtils, TreeMaker treeMaker, RestGenerationOptions restGenerationOptions, ModifiersTree modifiersTree) {
        int n;
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        String[] stringArray = restGenerationOptions.getParameterNames();
        int n2 = n = stringArray == null ? 0 : restGenerationOptions.getParameterNames().length;
        if (n > 0) {
            String[] stringArray2 = restGenerationOptions.getParameterTypes();
            String[] stringArray3 = restGenerationOptions.getPathParams();
            for (int i = 0; i < n; ++i) {
                Object object;
                ModifiersTree modifiersTree2 = modifiersTree;
                if (stringArray3 != null && stringArray3[i] != null) {
                    object = Collections.singletonList(treeMaker.Literal((Object)stringArray3[i]));
                    modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation("javax.ws.rs.PathParam", (List)object));
                }
                object = generationUtils.createType(stringArray2[i], typeElement);
                VariableTree variableTree = treeMaker.Variable(modifiersTree2, (CharSequence)stringArray[i], (Tree)object, null);
                arrayList.add(variableTree);
            }
        }
        return arrayList;
    }

    protected void createFolders(boolean bl) {
        FileObject fileObject = this.getSourceRootFolder(this.targetFolder, this.targetPackageName);
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            String string = this.toFilePath(this.getResourcePackageName());
            this.resourceFolder = fileObject.getFileObject(string);
            if (this.resourceFolder == null) {
                this.resourceFolder = FileUtil.createFolder((File)new File(file, string));
            }
            if (bl) {
                String string2 = this.toFilePath(this.controllerPackageName);
                this.controllerFolder = fileObject.getFileObject(string2);
                if (this.controllerFolder == null) {
                    this.controllerFolder = FileUtil.createFolder((File)new File(file, string2));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void configurePersistence() {
    }

    protected RestGenerationOptions getGenerationOptions(RestFacadeMethod restFacadeMethod, String string, String string2, String string3) {
        RestGenerationOptions restGenerationOptions = new RestGenerationOptions();
        switch (restFacadeMethod) {
            case CREATE: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.CREATE);
                restGenerationOptions.setReturnType("javax.ws.rs.core.Response");
                restGenerationOptions.setParameterNames(new String[]{"entity"});
                restGenerationOptions.setParameterTypes(new String[]{string});
                restGenerationOptions.setConsumes(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return restGenerationOptions;
            }
            case EDIT: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.EDIT);
                restGenerationOptions.setReturnType("javax.ws.rs.core.Response");
                restGenerationOptions.setParameterNames(new String[]{"entity"});
                restGenerationOptions.setParameterTypes(new String[]{string});
                restGenerationOptions.setConsumes(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return restGenerationOptions;
            }
            case REMOVE: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.REMOVE);
                restGenerationOptions.setReturnType("javax.ws.rs.core.Response");
                restGenerationOptions.setParameterNames(new String[]{"id"});
                restGenerationOptions.setParameterTypes(new String[]{string3});
                restGenerationOptions.setPathParams(new String[]{"id"});
                return restGenerationOptions;
            }
            case FIND: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.FIND);
                restGenerationOptions.setReturnType(string);
                restGenerationOptions.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                restGenerationOptions.setParameterNames(new String[]{"id"});
                restGenerationOptions.setParameterTypes(new String[]{string3});
                restGenerationOptions.setPathParams(new String[]{"id"});
                return restGenerationOptions;
            }
            case FIND_ALL: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.FIND_ALL);
                restGenerationOptions.setReturnType(List.class.getCanonicalName() + "<" + string + ">");
                restGenerationOptions.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                return restGenerationOptions;
            }
            case FIND_RANGE: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.FIND_RANGE);
                restGenerationOptions.setReturnType(List.class.getCanonicalName() + "<" + string + ">");
                restGenerationOptions.setProduces(new String[]{Constants.MimeType.XML.value(), Constants.MimeType.JSON.value()});
                restGenerationOptions.setParameterNames(new String[]{"max", "first"});
                restGenerationOptions.setParameterTypes(new String[]{Integer.class.getCanonicalName(), Integer.class.getCanonicalName()});
                restGenerationOptions.setPathParams(new String[]{"max", "first"});
                return restGenerationOptions;
            }
            case COUNT: {
                restGenerationOptions.setRestMethod(RestFacadeMethod.COUNT);
                restGenerationOptions.setReturnType(String.class.getCanonicalName());
                restGenerationOptions.setProduces(new String[]{Constants.MimeType.TEXT.value()});
                return restGenerationOptions;
            }
        }
        return null;
    }

    protected EntityClassInfo getEntityClassInfo(String string) {
        return this.model.getBuilder().getEntityClassInfo(string);
    }

    protected Project getProject() {
        return this.project;
    }

    protected EntityResourceBeanModel getModel() {
        return this.model;
    }

    protected FileObject getTargetFolder() {
        return this.targetFolder;
    }

    protected FileObject getResourceFolder() {
        return this.resourceFolder;
    }

    protected PersistenceHelper.PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    protected String getResourcePackageName() {
        return this.resourcePackageName;
    }

    protected String getControllerPackageName() {
        return this.controllerPackageName;
    }

    protected FileObject getControllerFolder() {
        return this.controllerFolder;
    }

    protected int getEntitiesCount() {
        return this.getModel().getEntityInfos().size();
    }

    protected String getIdFieldToUriStmt(EntityClassInfo.FieldInfo fieldInfo) {
        String string = this.getGetterName(fieldInfo);
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                if (n++ > 0) {
                    stringBuilder.append(" + \",\" + ");
                }
                stringBuilder.append("entity.");
                stringBuilder.append(string);
                stringBuilder.append("().");
                stringBuilder.append(this.getGetterName(fieldInfo2));
                stringBuilder.append("()");
            }
            return stringBuilder.toString();
        }
        return "entity." + string + "()";
    }

    @Override
    protected int getTotalWorkUnits() {
        return this.getEntitiesCount();
    }

    protected String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    protected void createFolders() {
        this.createFolders(true);
    }

    private void generateResourceMethods(FileObject fileObject, final String string, final String string2) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                ClassTree classTree = (ClassTree)compilationUnitTree.getTypeDecls().get(0);
                TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(TreePath.getPath(compilationUnitTree, (Tree)classTree));
                List<String> list = EntityResourcesGenerator.this.getResourceImports(string);
                JavaSourceHelper.addImports(workingCopy, list.toArray(new String[list.size()]));
                GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ArrayList<Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
                MethodTree methodTree = treeMaker.Constructor(generationUtils.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}");
                arrayList.add(methodTree);
                List<RestGenerationOptions> list2 = EntityResourcesGenerator.this.getRestFacadeMethodOptions(string, string2);
                for (RestGenerationOptions object2 : list2) {
                    EntityResourcesGenerator.this.generateRestMethod(typeElement, generationUtils, treeMaker, arrayList, object2);
                }
                ModifiersTree modifiersTree = EntityResourcesGenerator.this.addResourceAnnotation(string, classTree, generationUtils, treeMaker);
                ArrayList<? extends Tree> arrayList2 = new ArrayList<Tree>(classTree.getImplementsClause());
                ClassTree classTree2 = treeMaker.Class(modifiersTree, (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), arrayList2, arrayList);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        };
        javaSource.runModificationTask((Task)task).commit();
    }

    private ModifiersTree addMimeHandlerAnnotation(GenerationUtils generationUtils, TreeMaker treeMaker, RestGenerationOptions restGenerationOptions, ModifiersTree modifiersTree, String string, String[] stringArray) {
        if (stringArray != null) {
            ExpressionTree expressionTree = null;
            if (stringArray.length == 1) {
                expressionTree = treeMaker.Literal((Object)stringArray[0]);
            } else {
                ArrayList<LiteralTree> arrayList = new ArrayList<LiteralTree>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(treeMaker.Literal((Object)stringArray[i]));
                }
                expressionTree = treeMaker.NewArray(null, Collections.emptyList(), arrayList);
            }
            modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation(string, Collections.singletonList(expressionTree)));
        }
        return modifiersTree;
    }

    private String getGetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "get" + this.capitalizeFirstLetter(fieldInfo.getName());
    }

    private String toFilePath(String string) {
        return string.replace('.', '/');
    }

    private FileObject getSourceRootFolder(FileObject fileObject, String string) {
        String[] stringArray = string.split("\\.");
        FileObject fileObject2 = fileObject;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) {
                return fileObject2;
            }
            if (fileObject2 == null || !stringArray[i].equals(fileObject2.getNameExt())) {
                throw new IllegalArgumentException("Unmatched folder: " + fileObject.getPath() + " and package name: " + string);
            }
            fileObject2 = fileObject2.getParent();
        }
        return fileObject2;
    }
}

