/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.helper.FinishHandler;

public final class ErrorManager {
    private static Thread.UncaughtExceptionHandler exceptionHandler;
    private static FinishHandler finishHandler;
    private static final String ERROR_UNEXPECTED_EXCEPTION_KEY = "EM.ununexpected.exception";
    private static final String ERROR_CRITICAL_KEY = "EM.errortype.critical";
    private static final String ERROR_WARNING_KEY = "EM.errortype.warning";
    private static final String ERROR_ERROR_KEY = "EM.errortype.error";
    private static final String ERROR_MESSAGE_KEY = "EM.errortype.message";
    private static final String ERROR_UNEXPECTED_ERROR_KEY = "EM.unexpected.error";
    private static final String ERROR_EXCEPTION_MESSAGE_KEY = "EM.exception.message";
    private static final String ERROR_LOGFILE_INFO_KEY = "EM.exception.logfile.info";

    public static synchronized void notifyDebug(String message) {
        ErrorManager.notify(4, message);
    }

    public static synchronized void notifyDebug(String message, Throwable e) {
        ErrorManager.notify(4, message, e);
    }

    public static synchronized void notify(String message) {
        ErrorManager.notify(3, message);
    }

    public static synchronized void notify(String message, Throwable e) {
        ErrorManager.notify(3, message, e);
    }

    public static synchronized void notifyWarning(String message) {
        ErrorManager.notify(2, message);
    }

    public static synchronized void notifyWarning(String message, Throwable e) {
        ErrorManager.notify(2, message, e);
    }

    public static synchronized void notifyError(String message) {
        ErrorManager.notify(1, message);
    }

    public static synchronized void notifyError(String message, Throwable e) {
        ErrorManager.notify(1, message, e);
    }

    public static synchronized void notifyCritical(String message) {
        ErrorManager.notify(0, message);
    }

    public static synchronized void notifyCritical(String message, Throwable e) {
        ErrorManager.notify(0, message, e);
    }

    public static synchronized void notify(int level, String message) {
        ErrorManager.notify(level, message, null);
    }

    public static synchronized void notify(int level, Throwable exception) {
        ErrorManager.notify(level, null, exception);
    }

    public static synchronized void notify(int level, String message, Throwable exception) {
        UiUtils.MessageType type;
        assert (message != null || exception != null);
        String dialogText = "";
        if (message != null) {
            LogManager.log(level, message);
            dialogText = message;
        } else {
            dialogText = ResourceUtils.getString(ErrorManager.class, ERROR_UNEXPECTED_ERROR_KEY);
        }
        if (exception != null) {
            LogManager.log(level, exception);
            dialogText = dialogText + ResourceUtils.getString(ErrorManager.class, ERROR_EXCEPTION_MESSAGE_KEY, exception.getClass().getName(), exception.getMessage());
        }
        if (LogManager.getLogFile() != null) {
            dialogText = dialogText + ResourceUtils.getString(ErrorManager.class, ERROR_LOGFILE_INFO_KEY, LogManager.getLogFile().getAbsolutePath());
        }
        String titleKey = null;
        switch (level) {
            case 3: {
                titleKey = ERROR_MESSAGE_KEY;
                type = UiUtils.MessageType.INFORMATION;
                break;
            }
            case 2: {
                titleKey = ERROR_WARNING_KEY;
                type = UiUtils.MessageType.WARNING;
                break;
            }
            case 1: {
                titleKey = ERROR_ERROR_KEY;
                type = UiUtils.MessageType.ERROR;
                break;
            }
            case 0: {
                titleKey = ERROR_CRITICAL_KEY;
                type = UiUtils.MessageType.CRITICAL;
                break;
            }
            default: {
                return;
            }
        }
        String title = ResourceUtils.getString(ErrorManager.class, titleKey);
        if (title == null) {
            title = type.toString();
        }
        UiUtils.showMessageDialog(dialogText, title, type);
        if (type.equals((Object)UiUtils.MessageType.CRITICAL)) {
            finishHandler.criticalExit();
        }
    }

    public static Thread.UncaughtExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    public static void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        ErrorManager.exceptionHandler = exceptionHandler;
    }

    public static FinishHandler getFinishHandler() {
        return finishHandler;
    }

    public static void setFinishHandler(FinishHandler finishHandler) {
        ErrorManager.finishHandler = finishHandler;
    }

    private ErrorManager() {
    }

    public static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public void uncaughtException(Thread thread, Throwable exception) {
            ErrorManager.notifyCritical(ResourceUtils.getString(ErrorManager.class, ErrorManager.ERROR_UNEXPECTED_EXCEPTION_KEY, thread.getName()), exception);
        }
    }
}

