/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.support.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MacroMap {
    private Map<String, Value> storage = new HashMap<String, Value>();

    public MacroMap() {
    }

    public MacroMap(MacroMap parent) {
        this.storage.putAll(parent.storage);
    }

    public void addAll(List<String> list) {
        for (String macro : list) {
            String value;
            String key;
            int i = macro.indexOf(61);
            if (i > 0) {
                key = macro.substring(0, i).trim();
                value = macro.substring(i + 1).trim();
            } else {
                key = macro;
                value = null;
            }
            Value v = this.storage.get(key);
            if (v == null) {
                v = new Value();
                this.storage.put(key, v);
            }
            v.addValue(value);
        }
    }

    public int size() {
        return this.storage.size();
    }

    public void retainAll(List<String> list) {
        HashMap<String, String> keys = new HashMap<String, String>();
        for (String macro : list) {
            String value;
            String key;
            int i = macro.indexOf(61);
            if (i > 0) {
                key = macro.substring(0, i).trim();
                value = macro.substring(i + 1).trim();
            } else {
                key = macro;
                value = null;
            }
            keys.put(key, value);
        }
        for (String s : new ArrayList<String>(this.storage.keySet())) {
            if (!keys.containsKey(s)) {
                this.storage.remove(s);
                continue;
            }
            String v = (String)keys.get(s);
            Value value = this.storage.get(s);
            value.addValue(v);
        }
    }

    public List<String> convertToList() {
        ArrayList<String> external = new ArrayList<String>();
        for (Map.Entry<String, Value> e : this.storage.entrySet()) {
            String key = e.getKey();
            String value = e.getValue().getDominante();
            if (value == null) {
                external.add(key);
                continue;
            }
            external.add(key + "=" + value);
        }
        return external;
    }

    public List<String> removeCommon(List<String> list) {
        ArrayList<String> diff = new ArrayList<String>();
        for (String macro : list) {
            String value;
            String key;
            int i = macro.indexOf(61);
            if (i > 0) {
                key = macro.substring(0, i).trim();
                value = macro.substring(i + 1).trim();
            } else {
                key = macro;
                value = null;
            }
            Value v = this.storage.get(key);
            if (v == null) {
                diff.add(macro);
                continue;
            }
            String dominante = v.getDominante();
            if (value == null && dominante == null || value != null && dominante != null && value.equals(dominante)) continue;
            diff.add(macro);
        }
        return diff;
    }

    private static class Value {
        private List<String> values = new ArrayList<String>();
        private List<Integer> counts = new ArrayList<Integer>();

        private Value() {
        }

        private void addValue(String value) {
            int i = this.values.indexOf(value);
            if (i < 0) {
                this.values.add(value);
                i = this.values.size() - 1;
                this.counts.add(1);
            } else {
                int c = this.counts.get(i);
                this.counts.set(i, c + 1);
            }
        }

        private String getDominante() {
            int res = -1;
            int count = 0;
            for (int i = 0; i < this.counts.size(); ++i) {
                int v = this.counts.get(i);
                if (v <= count) continue;
                count = v;
                res = i;
            }
            return this.values.get(res);
        }
    }
}

