/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.discovery.api.QtInfoProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.CharSequences;

public class UserOptionsProviderImpl
implements UserOptionsProvider {
    private final Map<String, PkgConfigManager.PkgConfig> pkgConfigs = new HashMap<String, PkgConfigManager.PkgConfig>();
    private final Map<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>> commandCache = new WeakHashMap<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>>();

    public List<String> getItemUserIncludePaths(List<String> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>(includes);
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(compilerOptions.getAllOptions((Tool)compiler), makeConfiguration)) {
                for (String path : pc.getIncludePaths()) {
                    res.add(path);
                }
            }
        }
        if (makeConfiguration.isQmakeConfiguration()) {
            res.addAll(QtInfoProvider.getDefault().getQtIncludeDirectories(makeConfiguration));
        }
        return res;
    }

    public List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>(macros);
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(options, makeConfiguration)) {
                res.addAll(pc.getMacros());
            }
            this.convertOptionsToMacros(options, res);
        }
        return res;
    }

    private void convertOptionsToMacros(String options, List<String> res) {
        int i;
        String rest;
        if (options.indexOf("-fopenmp") >= 0) {
            res.add("_OPENMP=200505");
        } else if (options.indexOf("-xopenmp") >= 0 && ((rest = options.substring((i = options.indexOf("-xopenmp")) + 8)).length() == 0 || rest.charAt(0) == ' ' || rest.startsWith("=parallel") || rest.startsWith("=noopt"))) {
            res.add("_OPENMP");
        }
        if (options.indexOf("-xc99") >= 0) {
            res.add("__STDC_VERSION__=199901L");
        }
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            if (compiler.getKind() == PredefinedToolKind.CCompiler) {
                if (options.indexOf("-xc99") >= 0) {
                    return NativeFileItem.LanguageFlavor.C99;
                }
                if (options.indexOf("-std=c89") >= 0) {
                    return NativeFileItem.LanguageFlavor.C89;
                }
                if (options.indexOf("-std=c99") >= 0) {
                    return NativeFileItem.LanguageFlavor.C99;
                }
            } else {
                if (compiler.getKind() == PredefinedToolKind.CCCompiler) {
                    return NativeFileItem.LanguageFlavor.CPP;
                }
                if (compiler.getKind() == PredefinedToolKind.FortranCompiler) {
                    // empty if block
                }
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    private List<PkgConfigManager.PackageConfiguration> getPackages(String s, MakeConfiguration conf) {
        String pkg;
        int j;
        int i;
        ArrayList<PkgConfigManager.PackageConfiguration> res = new ArrayList<PkgConfigManager.PackageConfiguration>();
        while ((i = s.indexOf(96)) >= 0 && (j = (pkg = s.substring(i + 1)).indexOf(96)) > 0) {
            PkgConfigManager.PackageConfiguration config;
            String executable = pkg.substring(0, j);
            s = s.substring(i + executable.length() + 2);
            if (executable.startsWith("pkg-config ")) {
                config = this.getPkgConfigOutput(conf, executable);
                if (config == null) continue;
                res.add(config);
                continue;
            }
            config = this.getCommandOutput(conf, executable);
            if (config == null) continue;
            res.add(config);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkgConfigManager.PkgConfig getPkgConfig(MakeConfiguration conf) {
        String hostKey = conf.getDevelopmentHost().getHostKey();
        PkgConfigManager.PkgConfig pkg = null;
        Map<String, PkgConfigManager.PkgConfig> map = this.pkgConfigs;
        synchronized (map) {
            pkg = this.pkgConfigs.get(hostKey);
            if (pkg == null) {
                pkg = PkgConfigManager.getDefault().getPkgConfig(conf);
                this.pkgConfigs.put(hostKey, pkg);
            }
        }
        return pkg;
    }

    public NativeFileSearch getPackageFileSearch(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return null;
        }
        MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = make.getActiveConfiguration();
        if (conf != null) {
            final PkgConfigManager.PkgConfig pkg = this.getPkgConfig(conf);
            return new NativeFileSearch(){

                public Collection<CharSequence> searchFile(NativeProject project, String fileName) {
                    Collection resolvedPath = pkg.getResolvedPath(fileName);
                    ArrayList<CharSequence> res = new ArrayList<CharSequence>(1);
                    if (resolvedPath != null) {
                        for (PkgConfigManager.ResolvedPath path : resolvedPath) {
                            res.add(CharSequences.create((CharSequence)(path.getIncludePath() + File.separator + fileName)));
                        }
                    }
                    return res;
                }
            };
        }
        return null;
    }

    private PkgConfigManager.PackageConfiguration getPkgConfigOutput(MakeConfiguration conf, String executable) {
        PkgConfigManager.PkgConfig configs;
        PkgConfigManager.PackageConfiguration config;
        String pkg = executable.substring(11).trim();
        StringTokenizer st = new StringTokenizer(pkg);
        boolean readFlags = false;
        String findPkg = null;
        while (st.hasMoreTokens()) {
            String aPkg = st.nextToken();
            if (aPkg.equals("--cflags")) {
                readFlags = true;
                continue;
            }
            if (aPkg.startsWith("-")) {
                readFlags = false;
                continue;
            }
            findPkg = aPkg;
        }
        if (readFlags && findPkg != null && (config = (configs = this.getPkgConfig(conf)).getPkgConfig(findPkg)) != null) {
            return config;
        }
        return null;
    }

    private synchronized PkgConfigManager.PackageConfiguration getCommandOutput(MakeConfiguration conf, String command) {
        ExecutionEnvironment env = conf.getDevelopmentHost().getExecutionEnvironment();
        Map<String, PkgConfigManager.PackageConfiguration> map = this.commandCache.get(env);
        if (map == null) {
            map = new HashMap<String, PkgConfigManager.PackageConfiguration>();
            this.commandCache.put(env, map);
        }
        if (map.containsKey(command)) {
            return map.get(command);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(command, " ");
        String executable = null;
        while (st.hasMoreTokens()) {
            if (executable == null) {
                executable = st.nextToken();
                continue;
            }
            args.add(st.nextToken());
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir(), (ExecutionEnvironment)env, (String)executable, (String[])args.toArray(new String[args.size()]));
        String flags = status.output;
        MyPackageConfiguration config = null;
        if (flags != null) {
            config = new MyPackageConfiguration(executable, flags);
        }
        map.put(command, config);
        return config;
    }

    private static final class MyPackageConfiguration
    implements PkgConfigManager.PackageConfiguration {
        private final String executable;
        private final List<String> macros = new ArrayList<String>();
        private final List<String> paths = new ArrayList<String>();

        private MyPackageConfiguration(String executable, String flags) {
            this.executable = executable;
            StringTokenizer st = new StringTokenizer(flags, " ");
            while (st.hasMoreElements()) {
                String t = st.nextToken();
                if (t.startsWith("-I")) {
                    this.paths.add(t.substring(2));
                    continue;
                }
                if (!t.startsWith("-D")) continue;
                this.macros.add(t.substring(2));
            }
        }

        public String getName() {
            return this.executable;
        }

        public Collection<String> getIncludePaths() {
            return this.paths;
        }

        public Collection<String> getMacros() {
            return this.macros;
        }

        public String getDisplayName() {
            return this.executable;
        }

        public String getLibs() {
            return "";
        }

        public String getVersion() {
            return "";
        }
    }
}

