/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildProjectActionHandlerFactory;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.BuildActionsProviderImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HelperLibraryUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

public class BuildProjectActionHandler
implements ProjectActionHandler {
    private ProjectActionHandler delegate;
    private ProjectActionEvent pae;
    private ExecutionEnvironment execEnv;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers;

    BuildProjectActionHandler() {
    }

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes, Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers) {
        this.pae = pae;
        this.delegate = BuildProjectActionHandlerFactory.createDelegateHandler(pae);
        this.delegate.init(pae, paes, outputHandlers);
        this.execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
        this.outputHandlers = outputHandlers;
    }

    public void addExecutionListener(ExecutionListener l) {
        this.delegate.addExecutionListener(l);
        this.listeners.add(l);
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.delegate.removeExecutionListener(l);
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return this.delegate.canCancel();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void execute(InputOutput io) {
        File execLog = null;
        String remoteExecLog = null;
        try {
            execLog = File.createTempFile("exec", ".log");
            execLog.deleteOnExit();
            if (this.execEnv.isRemote()) {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
                remoteExecLog = hostInfo.getTempDir() + "/" + execLog.getName();
            }
        }
        catch (ConnectionManager.CancellationException ex) {
            execLog = null;
        }
        catch (IOException ex) {
            execLog = null;
        }
        if (execLog != null) {
            Env env = this.pae.getProfile().getEnvironment();
            env.putenv("__CND_TOOLS__", BuildTraceSupport.CND_TOOLS_VALUE);
            if (this.execEnv.isRemote()) {
                env.putenv("__CND_BUILD_LOG__", remoteExecLog);
            } else {
                env.putenv("__CND_BUILD_LOG__", execLog.getAbsolutePath());
            }
            try {
                String merge = env.getenv("LD_PRELOAD");
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv) + ":" + merge : BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv);
                env.putenv("LD_PRELOAD", merge);
                merge = env.getenv("LD_LIBRARY_PATH");
                if (merge == null || merge.isEmpty()) {
                    merge = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getEnvironment().get("LD_LIBRARY_PATH");
                }
                merge = merge != null && !merge.isEmpty() ? BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv) + ":" + merge : BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv);
                env.putenv("LD_LIBRARY_PATH", merge);
            }
            catch (ConnectionManager.CancellationException ex) {
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        final ExecLogWrapper wrapper = new ExecLogWrapper(execLog, this.execEnv);
        if (this.outputHandlers != null) {
            for (BuildActionsProvider.OutputStreamHandler handler : this.outputHandlers) {
                if (!(handler instanceof BuildActionsProviderImpl.ConfigureAction)) continue;
                BuildActionsProviderImpl.ConfigureAction myHandler = (BuildActionsProviderImpl.ConfigureAction)handler;
                myHandler.setExecLog(wrapper);
            }
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                BuildProjectActionHandler.this.delegate.removeExecutionListener((ExecutionListener)this);
                BuildProjectActionHandler.this.reconfigureCodeAssistance(rc, wrapper);
            }
        };
        this.delegate.addExecutionListener(listener);
        this.delegate.execute(io);
    }

    private void reconfigureCodeAssistance(int rc, ExecLogWrapper execLog) {
        DiscoveryProvider provider = null;
        if (execLog.getExecLog() != null) {
            provider = DiscoveryExtension.findProvider("exec-log");
        }
        if (provider == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("exec-log".equals(provider.getID())) {
            map.put("exec-log", execLog.getExecLog());
        } else {
            map.put("build-log", execLog.getBuildLog());
        }
        DiscoveryManagerImpl.projectBuilt(this.pae.getProject(), map, true);
    }

    public static final class ExecLogWrapper {
        private File execLog;
        private String buildLog;
        private final ExecutionEnvironment execEnv;
        private final AtomicBoolean downloadedExecLog = new AtomicBoolean(false);

        public ExecLogWrapper(File execLog, ExecutionEnvironment execEnv) {
            this.execLog = execLog;
            this.execEnv = execEnv;
        }

        private synchronized void downloadExecLog() {
            if (this.execLog != null && !this.downloadedExecLog.get() && this.execEnv.isRemote()) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
                    String remoteExecLog = hostInfo.getTempDir() + "/" + this.execLog.getName();
                    if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)remoteExecLog)) {
                        Future task = CommonTasksSupport.downloadFile((String)remoteExecLog, (ExecutionEnvironment)this.execEnv, (String)this.execLog.getAbsolutePath(), null);
                        task.get();
                    } else {
                        this.execLog = null;
                    }
                }
                catch (Throwable ex) {
                    this.execLog = null;
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.downloadedExecLog.set(true);
            }
        }

        public void setBuildLog(String buildLog) {
            this.buildLog = buildLog;
        }

        public String getBuildLog() {
            return this.buildLog;
        }

        public String getExecLog() {
            this.downloadExecLog();
            if (this.execLog != null) {
                return this.execLog.getAbsolutePath();
            }
            return null;
        }
    }

    private static final class BuildTraceHelper
    extends HelperLibraryUtility {
        private static final BuildTraceHelper INSTANCE = new BuildTraceHelper();

        private BuildTraceHelper() {
            super("org.netbeans.modules.cnd.actions", "bin/${osname}-${platform}${_isa}/libBuildTrace.so");
        }
    }
}

