/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.util.Lookup;

public final class UILookupMergerSupport {
    private UILookupMergerSupport() {
    }

    public static LookupMerger<RecommendedTemplates> createRecommendedTemplatesMerger() {
        return new RecommendedMerger();
    }

    public static LookupMerger<PrivilegedTemplates> createPrivilegedTemplatesMerger() {
        return new PrivilegedMerger();
    }

    public static LookupMerger<ProjectOpenedHook> createProjectOpenHookMerger(ProjectOpenedHook defaultInstance) {
        return new OpenMerger(defaultInstance);
    }

    private static class OpenHookImpl
    extends ProjectOpenedHook {
        private ProjectOpenedHook defaultInstance;
        private Lookup lkp;

        OpenHookImpl(ProjectOpenedHook def, Lookup lkp) {
            this.defaultInstance = def;
            this.lkp = lkp;
        }

        @Override
        protected void projectOpened() {
            if (this.defaultInstance != null) {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(this.defaultInstance);
            }
            for (ProjectOpenedHook poh : this.lkp.lookupAll(ProjectOpenedHook.class)) {
                if (poh == this.defaultInstance || poh instanceof OpenHookImpl) continue;
                ProjectOpenedTrampoline.DEFAULT.projectOpened(poh);
            }
        }

        @Override
        protected void projectClosed() {
            if (this.defaultInstance != null) {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(this.defaultInstance);
            }
            for (ProjectOpenedHook poh : this.lkp.lookupAll(ProjectOpenedHook.class)) {
                if (poh == this.defaultInstance || poh instanceof OpenHookImpl) continue;
                ProjectOpenedTrampoline.DEFAULT.projectClosed(poh);
            }
        }
    }

    private static class RecommendedTemplatesImpl
    implements RecommendedTemplates {
        private Lookup lkp;

        public RecommendedTemplatesImpl(Lookup lkp) {
            this.lkp = lkp;
        }

        @Override
        public String[] getRecommendedTypes() {
            LinkedHashSet<String> templates = new LinkedHashSet<String>();
            for (RecommendedTemplates pt : this.lkp.lookupAll(RecommendedTemplates.class)) {
                String[] temp = pt.getRecommendedTypes();
                if (temp == null) {
                    throw new IllegalStateException(pt.getClass().getName() + " returns null from getRecommendedTemplates() method.");
                }
                templates.addAll(Arrays.asList(temp));
            }
            return templates.toArray(new String[templates.size()]);
        }
    }

    private static class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private Lookup lkp;

        public PrivilegedTemplatesImpl(Lookup lkp) {
            this.lkp = lkp;
        }

        @Override
        public String[] getPrivilegedTemplates() {
            LinkedHashSet<String> templates = new LinkedHashSet<String>();
            for (PrivilegedTemplates pt : this.lkp.lookupAll(PrivilegedTemplates.class)) {
                String[] temp = pt.getPrivilegedTemplates();
                if (temp == null) {
                    throw new IllegalStateException(pt.getClass().getName() + " returns null from getPrivilegedTemplates() method.");
                }
                templates.addAll(Arrays.asList(temp));
            }
            return templates.toArray(new String[templates.size()]);
        }
    }

    private static class OpenMerger
    implements LookupMerger<ProjectOpenedHook> {
        private ProjectOpenedHook defaultInstance;

        OpenMerger(ProjectOpenedHook def) {
            this.defaultInstance = def;
        }

        public Class<ProjectOpenedHook> getMergeableClass() {
            return ProjectOpenedHook.class;
        }

        public ProjectOpenedHook merge(Lookup lookup) {
            return new OpenHookImpl(this.defaultInstance, lookup);
        }
    }

    private static class RecommendedMerger
    implements LookupMerger<RecommendedTemplates> {
        private RecommendedMerger() {
        }

        public Class<RecommendedTemplates> getMergeableClass() {
            return RecommendedTemplates.class;
        }

        public RecommendedTemplates merge(Lookup lookup) {
            return new RecommendedTemplatesImpl(lookup);
        }
    }

    private static class PrivilegedMerger
    implements LookupMerger<PrivilegedTemplates> {
        private PrivilegedMerger() {
        }

        public Class<PrivilegedTemplates> getMergeableClass() {
            return PrivilegedTemplates.class;
        }

        public PrivilegedTemplates merge(Lookup lookup) {
            return new PrivilegedTemplatesImpl(lookup);
        }
    }
}

