/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.freeform;

import java.awt.Dialog;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.freeform.AntTaskSelectPanel;
import org.netbeans.modules.profiler.freeform.FreeFormProjectProfilingSupportProvider;
import org.netbeans.modules.profiler.freeform.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FreeFormProjectsSupport {
    private static final String ERROR_PARSING_BUILDFILE_MSG = NbBundle.getMessage(FreeFormProjectProfilingSupportProvider.class, (String)"FreeFormProjectTypeProfiler_ErrorParsingBuildFileMsg");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(FreeFormProjectProfilingSupportProvider.class, (String)"FreeFormProjectTypeProfiler_OkButtonName");
    private static final String SELECT_PROFILING_TASK_DIALOG_CAPTION = NbBundle.getMessage(FreeFormProjectProfilingSupportProvider.class, (String)"FreeFormProjectTypeProfiler_SelectProfilingTaskDialogCaption");
    private static final String NO_PROFILER_TASK_MSG = NbBundle.getMessage(FreeFormProjectProfilingSupportProvider.class, (String)"FreeFormProjectTypeProfiler_NoProfilerTaskMsg");
    public static final String PROFILE_TARGET_ATTRIBUTE = "profile-target";
    public static final String PROFILE_SINGLE_TARGET_ATTRIBUTE = "profile-file-target";
    public static final String PROFILE_VERSION_ATTRIBUTE = "version";
    public static final String VERSION_NUMBER = "0.4";

    public static boolean saveProfilerConfig(Project project, String profileTarget, String profileSingleTarget) {
        Element profilerFragment = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS("http://www.netbeans.org/ns/profiler/1", "data");
        profilerFragment.setAttribute(PROFILE_VERSION_ATTRIBUTE, VERSION_NUMBER);
        if (profileTarget != null) {
            profilerFragment.setAttribute(PROFILE_TARGET_ATTRIBUTE, profileTarget);
        }
        if (profileSingleTarget != null) {
            profilerFragment.setAttribute(PROFILE_SINGLE_TARGET_ATTRIBUTE, profileSingleTarget);
        }
        ProjectUtils.getAuxiliaryConfiguration((Project)project).putConfigurationFragment(profilerFragment, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException e1) {
            Profiler.getDefault().notifyException(8, (Exception)e1);
            ProfilerLogger.log((Exception)e1);
            return false;
        }
        return true;
    }

    public static String selectProfilingTarget(Project project, FileObject buildScript, int type, String currentTarget) {
        block6: {
            String targetName;
            List l;
            List targets = Util.getAntScriptTargets(buildScript);
            try {
                l = AntScriptUtils.getCallableTargetNames((FileObject)buildScript);
            }
            catch (IOException x) {
                ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_PARSING_BUILDFILE_MSG, ProjectUtils.getInformation((Project)project).getName()));
                return null;
            }
            if (!"".equals(currentTarget) && l.contains(currentTarget)) {
                return currentTarget;
            }
            JButton okButton = new JButton(OK_BUTTON_NAME);
            AntTaskSelectPanel atsp = new AntTaskSelectPanel(l, type, okButton);
            block2: while (true) {
                DialogDescriptor dd = new DialogDescriptor((Object)atsp, SELECT_PROFILING_TASK_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
                if (dd.getValue() != okButton) break block6;
                targetName = atsp.getTargetName();
                Iterator it = targets.iterator();
                while (true) {
                    if (!it.hasNext()) continue block2;
                    TargetLister.Target t = (TargetLister.Target)it.next();
                    if (!t.getName().equals(targetName)) continue;
                    if (FreeFormProjectsSupport.checkTarget(t.getElement())) {
                        return targetName;
                    }
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NO_PROFILER_TASK_MSG, 2, 2)) == NotifyDescriptor.OK_OPTION) break block2;
                }
                break;
            }
            return targetName;
        }
        return null;
    }

    private static boolean checkTarget(Element element) {
        NodeList nl = element.getElementsByTagName("nbprofiledirect");
        return nl.getLength() > 0;
    }
}

