/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.CompositeCPUCCTWalker;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.categorization.api.Categorization;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ForwardCategoryDistributionPanel
extends ProjectAwareStatisticalModule {
    private static final String NO_METHOD_LABEL_TEXT = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_NoMethodLabelText");
    private static final String NO_DATA_LABEL_TEXT = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_NoDataLabelText");
    private static final String METHOD_CATEGORIES_STRING = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_MethodCategoriesString");
    private static final String DESCR_STRING = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_DescrString");
    private CompositeCPUCCTWalker walker;
    private JLabel noData = new JLabel(NO_DATA_LABEL_TEXT);
    private JLabel noMethods = new JLabel(NO_METHOD_LABEL_TEXT);
    private Model model;
    private RuntimeCPUCCTNode lastAppNode;

    public ForwardCategoryDistributionPanel() {
        this.initComponents();
        this.model = new Model();
        this.walker = new CompositeCPUCCTWalker();
        this.walker.add(0, (CPUCCTVisitor)this.model);
    }

    @Override
    public boolean supportsProject(Lookup.Provider project) {
        return Categorization.isAvailable(this.getProject());
    }

    public void setSelectedMethodId(int methodId) {
        int lastSelectedId = this.getSelectedMethodId();
        super.setSelectedMethodId(methodId);
        if (lastSelectedId != methodId) {
            lastSelectedId = methodId;
            this.refresh(this.lastAppNode);
        }
    }

    public synchronized void refresh(RuntimeCPUCCTNode appNode) {
        if (appNode != null) {
            if (this.walker != null) {
                appNode.accept((RuntimeCPUCCTNodeVisitor)this.walker);
            }
            this.lastAppNode = appNode;
        }
    }

    private void initComponents() {
        BoxLayout layout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(layout);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.noMethods.setOpaque(false);
        this.noMethods.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noMethods.getBorder()));
        this.noData.setOpaque(false);
        this.noData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noData.getBorder()));
        this.add(this.noMethods);
        this.setName(METHOD_CATEGORIES_STRING);
        this.setToolTipText(DESCR_STRING);
    }

    private void refreshData() {
        if (this.model == null) {
            return;
        }
        Runnable uiUpdater = null;
        if (this.getSelectedMethodId() == -1) {
            uiUpdater = new Runnable(){

                @Override
                public void run() {
                    ForwardCategoryDistributionPanel.this.removeAll();
                    ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noMethods);
                    ForwardCategoryDistributionPanel.this.revalidate();
                    ForwardCategoryDistributionPanel.this.repaint();
                }
            };
        } else {
            Map<Mark, Long> catTimes = this.model.getDistribution();
            if (catTimes == null || catTimes.isEmpty()) {
                uiUpdater = new Runnable(){

                    @Override
                    public void run() {
                        ForwardCategoryDistributionPanel.this.removeAll();
                        ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noData);
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            } else {
                long parentTime = 0L;
                long shownTime = 0L;
                final ArrayList<MarkTime> shownCats = new ArrayList<MarkTime>();
                for (Map.Entry<Mark, Long> entry : catTimes.entrySet()) {
                    if (!catTimes.keySet().contains(entry.getKey())) continue;
                    long time = entry.getValue();
                    shownTime += time;
                    shownCats.add(new MarkTime(entry.getKey(), time));
                }
                final long fullTime = parentTime > shownTime ? parentTime : shownTime;
                Collections.sort(shownCats, MarkTime.COMPARATOR);
                uiUpdater = new Runnable(){

                    @Override
                    public void run() {
                        final Categorization categorization = new Categorization(ForwardCategoryDistributionPanel.this.getProject());
                        ForwardCategoryDistributionPanel.this.removeAll();
                        for (final MarkTime cat : shownCats) {
                            float ratio = (float)cat.time / (float)fullTime;
                            float percent = 100.0f * ratio;
                            JPanel panel = new JPanel(new BorderLayout());
                            panel.setOpaque(false);
                            Category displayedCat = categorization.getCategoryForMark(cat.mark);
                            StringBuilder labelBuilder = new StringBuilder();
                            if (displayedCat != null) {
                                categorization.getRoot().accept((Visitor)new Visitor<Visitable<Category>, Void, StringBuilder>(){

                                    public Void visit(Visitable<Category> visitable, StringBuilder parameter) {
                                        if (categorization.getAllMarks((Category)visitable.getValue()).contains(cat.mark)) {
                                            if (parameter.length() > 0) {
                                                parameter.append("/");
                                            }
                                            parameter.append(((Category)visitable.getValue()).getLabel());
                                        }
                                        return null;
                                    }
                                }, labelBuilder);
                            } else {
                                labelBuilder.append("Not categorized");
                            }
                            JLabel data = new JLabel(labelBuilder.toString() + " (" + StringUtils.floatPerCentToString((float)percent) + "%)");
                            data.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), data.getBorder()));
                            data.setOpaque(false);
                            panel.add((Component)data, "West");
                            JProgressBar prgbar = new JProgressBar(0, 0, 100);
                            prgbar.setOpaque(false);
                            prgbar.setPreferredSize(new Dimension(120, data.getPreferredSize().height + 2));
                            prgbar.setMaximumSize(prgbar.getPreferredSize());
                            prgbar.setMinimumSize(prgbar.getPreferredSize());
                            prgbar.setForeground(new Color(Color.HSBtoRGB(100.0f, ratio, 0.7f)));
                            prgbar.setString("");
                            prgbar.setStringPainted(true);
                            prgbar.setValue((int)percent);
                            JPanel prgbarContainer = new JPanel(new FlowLayout(0, 2, 3));
                            prgbarContainer.setOpaque(false);
                            prgbarContainer.add(prgbar);
                            panel.add((Component)prgbarContainer, "East");
                            ForwardCategoryDistributionPanel.this.add(panel);
                        }
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            }
        }
        if (EventQueue.isDispatchThread()) {
            uiUpdater.run();
        } else {
            EventQueue.invokeLater(uiUpdater);
        }
    }

    private class Model
    extends CPUCCTVisitorAdapter {
        private Map<Mark, Long> markMap = new HashMap<Mark, Long>();
        private Mark usedMark;
        private Stack<Mark> markStack = new Stack();
        private int inCalls;
        private int lastCalls;
        private int outCalls;
        private long time0;
        private long time1;

        private Model() {
        }

        public Map<Mark, Long> getDistribution() {
            return new HashMap<Mark, Long>(this.markMap);
        }

        public void afterWalk() {
            ForwardCategoryDistributionPanel.this.refreshData();
        }

        public void beforeWalk() {
            this.markStack.clear();
            this.markMap.clear();
            this.usedMark = Mark.DEFAULT;
        }

        public void visit(MarkedCPUCCTNode node) {
            if (this.time0 > 0L) {
                long cleansedTime;
                Long markTime = this.markMap.get(this.usedMark);
                if (markTime == null) {
                    markTime = 0L;
                }
                if ((cleansedTime = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls - this.lastCalls, this.outCalls, false)) > 0L) {
                    this.markMap.put(this.usedMark, markTime + cleansedTime);
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.markStack.push(this.usedMark);
            this.usedMark = node.getMark();
        }

        public void visit(MethodCPUCCTNode node) {
            if (node.getMethodId() != ForwardCategoryDistributionPanel.this.getSelectedMethodId()) {
                return;
            }
            this.time0 += node.getNetTime0();
            this.time1 += node.getNetTime1();
            this.inCalls += node.getNCalls();
            this.outCalls += node.getNCalls();
            this.lastCalls = node.getNCalls();
        }

        public void visitPost(MarkedCPUCCTNode node) {
            if (this.time0 > 0L) {
                long cleansedTime;
                Long markTime = this.markMap.get(this.usedMark);
                if (markTime == null) {
                    markTime = 0L;
                }
                if ((cleansedTime = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls, this.outCalls - this.lastCalls, false)) > 0L) {
                    this.markMap.put(this.usedMark, markTime + cleansedTime);
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.usedMark = this.markStack.pop();
        }
    }

    private static class MarkTime {
        public static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (!(o1 instanceof MarkTime) || !(o2 instanceof MarkTime)) {
                    return 0;
                }
                if (((MarkTime)o1).time < ((MarkTime)o2).time) {
                    return 1;
                }
                if (((MarkTime)o1).time > ((MarkTime)o2).time) {
                    return -1;
                }
                return 0;
            }
        };
        public Mark mark;
        public long time;

        public MarkTime(Mark mark, long time) {
            this.mark = mark;
            this.time = time;
        }
    }
}

