/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api.bridge;

import java.util.Collection;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.modules.profiler.categorization.api.Categorization;
import org.netbeans.modules.profiler.categorization.api.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.spi.SessionListener;
import org.openide.util.Lookup;

public class CategorizationSetup
extends SessionListener.Adapter {
    public void onStartup(ProfilingSettings ps, Lookup.Provider project) {
        this.setupMarks(ps, project);
        this.setupStatistics(ps, project);
    }

    public void onShutdown() {
        StatisticalModuleContainer statModulesContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
        if (statModulesContainer != null) {
            statModulesContainer.removeAllModules();
        }
    }

    private void setupMarks(ProfilingSettings ps, Lookup.Provider project) {
        boolean isMarksEnabled;
        boolean bl = isMarksEnabled = ps.getProfilingType() == 8 || ps.getProfilingType() == 16;
        if (isMarksEnabled &= Categorization.isAvailable(project)) {
            Categorization ctg = new Categorization(project);
            ctg.reset();
            MarkingEngine.getDefault().configure(ctg.getMappings(), Lookup.getDefault().lookupAll(MarkingEngine.StateObserver.class));
        } else {
            MarkingEngine.getDefault().deconfigure();
        }
    }

    private void setupStatistics(ProfilingSettings ps, Lookup.Provider project) {
        Collection pmodules;
        StatisticalModuleContainer statModulesContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
        Collection modules = Lookup.getDefault().lookupAll(StatisticalModule.class);
        if (statModulesContainer != null && modules != null) {
            for (StatisticalModule module : modules) {
                if (module instanceof ProjectAwareStatisticalModule) {
                    if (!((ProjectAwareStatisticalModule)module).supportsProject(project)) continue;
                    statModulesContainer.addModule(module);
                    continue;
                }
                statModulesContainer.addModule(module);
            }
        }
        if ((pmodules = Lookup.getDefault().lookupAll(ProjectAwareStatisticalModule.class)) != null) {
            for (ProjectAwareStatisticalModule module : pmodules) {
                if (!module.supportsProject(project)) continue;
                statModulesContainer.addModule((StatisticalModule)module);
            }
        }
    }
}

