/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.CategoryBuilder;
import org.netbeans.modules.profiler.categorization.api.CategoryContainer;
import org.netbeans.modules.profiler.categorization.spi.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class Categorization
implements Marker {
    private Lookup.Provider project;
    private Map<Category, Set<Mark>> inheritedMarkMap;
    private Map<Mark, Category> reverseMap;
    private CategoryContainer root = null;

    public Categorization(Lookup.Provider project) {
        this.project = project;
        this.inheritedMarkMap = null;
    }

    public synchronized void reset() {
        this.root = null;
        this.inheritedMarkMap = null;
        this.reverseMap = null;
    }

    private synchronized Map<Category, Set<Mark>> getInheritedMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.inheritedMarkMap;
    }

    private synchronized Map<Mark, Category> getReverseMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.reverseMap;
    }

    private void initInternals() {
        this.inheritedMarkMap = new HashMap<Category, Set<Mark>>();
        this.reverseMap = new WeakHashMap<Mark, Category>();
        Stack<Category> path = new Stack<Category>();
        path.add(this.getRoot());
        this.initInternals(path);
    }

    private void initInternals(Stack<Category> path) {
        Category currentCategory = path.peek();
        this.reverseMap.put(currentCategory.getAssignedMark(), currentCategory);
        for (Category category : path) {
            Set<Mark> marks = this.inheritedMarkMap.get(category);
            if (marks == null) {
                marks = new HashSet<Mark>();
                this.inheritedMarkMap.put(category, marks);
            }
            marks.add(currentCategory.getAssignedMark());
        }
        for (Category child : currentCategory.getSubcategories()) {
            path.push(child);
            this.initInternals(path);
            path.pop();
        }
    }

    public Category getRoot() {
        if (this.root == null) {
            this.root = new CategoryContainer("ROOT", NbBundle.getMessage(CategoryBuilder.class, (String)"ROOT_CATEGORY_NAME"), Mark.DEFAULT);
            for (CategoryBuilder builder : this.project.getLookup().lookupAll(CategoryBuilder.class)) {
                this.root.addAll(builder.getRootCategory().getSubcategories());
            }
        }
        return this.root;
    }

    public Category getCategoryForMark(Mark mark) {
        return this.getReverseMap().get(mark);
    }

    public Set<Mark> getAllMarks(Category category) {
        Set<Mark> marks = this.getInheritedMap().get(category);
        return marks != null ? Collections.unmodifiableSet(marks) : Collections.EMPTY_SET;
    }

    public boolean isAvailable() {
        return Categorization.isAvailable(this.project);
    }

    public static boolean isAvailable(Lookup.Provider project) {
        if (project == null) {
            return false;
        }
        return project.getLookup().lookup(CategoryBuilder.class) != null;
    }

    public MarkMapping[] getMappings() {
        CategoryDefinitionProcessor mp = (CategoryDefinitionProcessor)this.project.getLookup().lookup(CategoryDefinitionProcessor.class);
        if (mp != null) {
            this.getRoot().accept((Visitor)new Visitor<Visitable<Category>, Void, CategoryDefinitionProcessor>(){

                public Void visit(Visitable<Category> visitable, CategoryDefinitionProcessor parameter) {
                    ((Category)visitable.getValue()).processDefinitionsWith(parameter);
                    return null;
                }
            }, mp);
            return ((Marker)mp).getMappings();
        }
        return new MarkMapping[0];
    }

    public Mark[] getMarks() {
        return this.getAllMarks(this.getRoot()).toArray(new Mark[0]);
    }
}

