/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.settings.ConvertAsJavaBean;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ConvertorProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(ConvertAsProperties.class.getCanonicalName(), ConvertAsJavaBean.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        String convElem;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        for (Element element : env.getElementsAnnotatedWith(ConvertAsProperties.class)) {
            reg = element.getAnnotation(ConvertAsProperties.class);
            convElem = this.instantiableClassOrMethod(element, true, reg);
            String dtd = reg.dtd();
            String dtdCode = ConvertorProcessor.convertPublicId(dtd);
            this.layer(new Element[]{element}).file("xml/entities" + dtdCode).url("nbres:/org/netbeans/modules/settings/resources/properties-1_0.dtd").stringvalue("hint.originalPublicID", dtd).write();
            this.layer(new Element[]{element}).file("xml/memory/" + convElem.replace('.', '/')).stringvalue("settings.providerPath", "xml/lookups/" + dtdCode + ".instance").write();
            LayerBuilder.File f = this.layer(new Element[]{element}).file("xml/lookups" + dtdCode + ".instance").methodvalue("instanceCreate", "org.netbeans.api.settings.Factory", "create").methodvalue("settings.convertor", "org.netbeans.api.settings.Factory", "properties").stringvalue("settings.instanceClass", convElem).stringvalue("settings.instanceOf", convElem).boolvalue("xmlproperties.preventStoring", !reg.autostore());
            ConvertorProcessor.commaSeparated(f, reg.ignoreChanges()).write();
        }
        for (Element element : env.getElementsAnnotatedWith(ConvertAsJavaBean.class)) {
            reg = element.getAnnotation(ConvertAsJavaBean.class);
            convElem = this.instantiableClassOrMethod(element, false, reg);
            LayerBuilder.File f = this.layer(new Element[]{element}).file("xml/memory/" + convElem.replace('.', '/'));
            f.stringvalue("settings.providerPath", "xml/lookups/NetBeans/DTD_XML_beans_1_0.instance");
            if (reg.subclasses()) {
                f.boolvalue("settings.subclasses", true);
            }
            f.write();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String convertPublicId(String publicID) {
        char[] arr = publicID.toCharArray();
        int numberofslashes = 0;
        int state = 0;
        int write = 0;
        int i = 0;
        while (i < arr.length) {
            block9: {
                int ch = arr[i];
                switch (state) {
                    case 0: {
                        if (ch == 43 || ch == 45 || ch == 73 || ch == 83 || ch == 79) break block9;
                        state = 1;
                    }
                    case 1: {
                        if (ch != 47) break;
                        state = 2;
                        if (++numberofslashes == 3) {
                            return new String(arr, 0, write);
                        }
                        arr[write++] = 47;
                    }
                    {
                        break block9;
                    }
                    case 2: {
                        if (ch == 47) break block9;
                        state = 1;
                    }
                }
                arr[write++] = ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 ? ch : 95;
            }
            ++i;
        }
        return new String(arr, 0, write);
    }

    private static LayerBuilder.File commaSeparated(LayerBuilder.File f, String[] arr) {
        if (arr.length == 0) {
            return f;
        }
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String s : arr) {
            sb.append(sep);
            sb.append(s);
            sep = ",";
        }
        return f.stringvalue("xmlproperties.ignoreChanges", sb.toString());
    }

    private String instantiableClassOrMethod(Element e, boolean checkMethods, Annotation r) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e, this.processingEnv, r);
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor", e, this.processingEnv, r);
                }
                if (checkMethods) {
                    TypeMirror propType = this.processingEnv.getElementUtils().getTypeElement("java.util.Properties").asType();
                    boolean hasRead = false;
                    boolean hasWrite = false;
                    for (ExecutableElement m : ElementFilter.methodsIn(e.getEnclosedElements())) {
                        if (m.getParameters().size() == 1 && m.getSimpleName().contentEquals("readProperties") && ((Object)m.getParameters().get(0).asType()).equals(propType)) {
                            hasRead = true;
                        }
                        if (m.getParameters().size() != 1 || !m.getSimpleName().contentEquals("writeProperties") || !((Object)m.getParameters().get(0).asType()).equals(propType) || m.getReturnType().getKind() != TypeKind.VOID) continue;
                        hasWrite = true;
                    }
                    if (!hasRead) {
                        throw new LayerGenerationException(clazz + " must have proper readProperties method", e, this.processingEnv, r);
                    }
                    if (!hasWrite) {
                        throw new LayerGenerationException(clazz + " must have proper writeProperties method", e, this.processingEnv, r);
                    }
                }
                return clazz;
            }
        }
        throw new LayerGenerationException("Annotated element is not loadable as an instance", e, this.processingEnv, r);
    }
}

