/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public final class NativeProjectProvider {
    private NativeProjectProvider() {
    }

    public static NativeProject createProject(String projectRoot, List<File> files, List<String> sysIncludes, List<String> usrIncludes, List<String> sysMacros, List<String> usrMacros, boolean pathsRelCurFile) {
        NativeProjectImpl project = new NativeProjectImpl(projectRoot, sysIncludes, usrIncludes, sysMacros, usrMacros, pathsRelCurFile);
        project.addFiles(files);
        return project;
    }

    public static void fireAllFilesChanged(NativeProject nativeProject) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).fireAllFilesChanged();
        }
    }

    public static void setUserMacros(NativeProject nativeProject, List<String> usrMacros) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).usrMacros.clear();
            ((NativeProjectImpl)nativeProject).usrMacros.addAll(usrMacros);
        }
    }

    public static NativeFileItem.Language getLanguage(File file, DataObject dobj) {
        CndUtils.assertNotNull((Object)file, (String)"null file");
        FileObject fo = null;
        if (dobj != null) {
            fo = dobj.getPrimaryFile();
        }
        String mimeType = "";
        mimeType = fo != null ? MIMESupport.getSourceFileMIMEType((FileObject)fo) : MIMESupport.getSourceFileMIMEType((File)file);
        return NativeProjectProvider.getLanguage(mimeType);
    }

    public static NativeFileItem.Language getLanguage(FileObject fo, DataObject dobj) {
        CndUtils.assertNotNull((Object)fo, (String)"null file object");
        String mimeType = MIMESupport.getSourceFileMIMEType((FileObject)fo);
        return NativeProjectProvider.getLanguage(mimeType);
    }

    private static NativeFileItem.Language getLanguage(String mimeType) {
        if ("text/x-c++".equals(mimeType)) {
            return NativeFileItem.Language.CPP;
        }
        if ("text/x-c".equals(mimeType)) {
            return NativeFileItem.Language.C;
        }
        if ("text/x-fortran".equals(mimeType)) {
            return NativeFileItem.Language.FORTRAN;
        }
        if ("text/x-h".equals(mimeType)) {
            return NativeFileItem.Language.C_HEADER;
        }
        return NativeFileItem.Language.OTHER;
    }

    public static DataObject getDataObject(FileObject fo) {
        DataObject dobj = null;
        if (fo != null) {
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dobj;
    }

    public static DataObject getDataObject(File file) {
        CndUtils.assertNormalized((File)file);
        return NativeProjectProvider.getDataObject(CndFileUtils.toFileObject((File)file));
    }

    static void registerItemInDataObject(DataObject obj, NativeFileItem item) {
        NativeFileItemSet set;
        if (obj != null && (set = (NativeFileItemSet)obj.getLookup().lookup(NativeFileItemSet.class)) != null) {
            set.add(item);
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(File file, NativeProjectImpl project, NativeFileItem.Language language) {
            this.project = project;
            this.file = CndFileUtils.normalizeFile((File)file);
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return CndFileUtils.toFileObject((File)this.file);
        }

        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        public String getName() {
            return this.file.getName();
        }

        public List<FSPath> getSystemIncludePaths() {
            List<FSPath> result = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(result) : result;
        }

        public List<FSPath> getUserIncludePaths() {
            List<FSPath> result = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(result) : result;
        }

        private List<FSPath> toAbsolute(List<FSPath> orig) {
            File base = this.file.getParentFile();
            ArrayList<FSPath> result = new ArrayList<FSPath>(orig.size());
            for (FSPath path : orig) {
                File pathFile = new File(path.getPath());
                if (pathFile.isAbsolute()) {
                    result.add(path);
                    continue;
                }
                pathFile = new File(base, path.getPath());
                result.add(new FSPath(CndFileUtils.getLocalFileSystem(), pathFile.getAbsolutePath()));
            }
            return result;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }

    public static final class NativeProjectImpl
    implements NativeProject {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        private boolean pathsRelCurFile;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        public NativeProjectImpl(String projectRoot, List<String> sysIncludes, List<String> usrIncludes, List<String> sysMacros, List<String> usrMacros, boolean pathsRelCurFile) {
            this.projectRoot = projectRoot;
            this.pathsRelCurFile = pathsRelCurFile;
            this.sysIncludes = this.createIncludes(sysIncludes);
            this.usrIncludes = this.createIncludes(usrIncludes);
            this.sysMacros = new ArrayList<String>(sysMacros);
            this.usrMacros = new ArrayList<String>(usrMacros);
        }

        private List<String> createIncludes(List<String> src) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(src);
            }
            ArrayList<String> result = new ArrayList<String>(src.size());
            for (String path : src) {
                File file = new File(path);
                result.add(file.getAbsolutePath());
            }
            return result;
        }

        private void addFiles(List<File> files) {
            for (File file : files) {
                this.addFile(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getAbsoluteFile())));
            }
        }

        public Lookup.Provider getProject() {
            return null;
        }

        public FileSystem getFileSystem() {
            return CndFileUtils.getLocalFileSystem();
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return "DummyProject";
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public NativeFileSearch getNativeFileSearch() {
            return new NativeFileSearch(){

                public Collection<CharSequence> searchFile(NativeProject project, String fileName) {
                    return Collections.emptyList();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileChanged(FileObject fo) {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            NativeFileItem item = this.findFileItem(fo);
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.filePropertiesChanged(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileAdded(FileObject fo) {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            NativeFileItem item = this.findFileItem(fo);
            if (item == null) {
                item = this.addFile(fo);
            }
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.fileAdded(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAllFilesChanged() {
            ArrayList<NativeProjectItemsListener> listenersCopy;
            Object object = this.listenersLock;
            synchronized (object) {
                listenersCopy = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            List<NativeFileItem> items = Collections.unmodifiableList(this.files);
            for (NativeProjectItemsListener listener : listenersCopy) {
                listener.filesPropertiesChanged(items);
            }
        }

        public NativeFileItem findFileItem(FileObject fileObject) {
            return this.findFileItem(CndFileUtils.normalizePath((FileObject)fileObject));
        }

        private NativeFileItem findFileItem(String path) {
            for (NativeFileItem item : this.files) {
                if (!item.getAbsolutePath().equalsIgnoreCase(path)) continue;
                return item;
            }
            return null;
        }

        public List<FSPath> getSystemIncludePaths() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.sysIncludes);
        }

        public List<FSPath> getUserIncludePaths() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.usrIncludes);
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        private NativeFileItem addFile(FileObject fo) {
            File file = FileUtil.toFile((FileObject)fo);
            DataObject dobj = NativeProjectProvider.getDataObject(fo);
            NativeFileItem.Language lang = NativeProjectProvider.getLanguage(fo, dobj);
            NativeFileItemImpl item = new NativeFileItemImpl(file, this, lang);
            this.files.add(item);
            return item;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable task) {
            task.run();
        }

        public NativeExitStatus execute(String executable, String[] env, String ... args) {
            return null;
        }

        public String getPlatformName() {
            return null;
        }

        public void fireFilesPropertiesChanged() {
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }
}

