/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticUnresolved;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.generated.CPPParser;
import org.openide.util.Exceptions;

public class Diagnostic {
    private static int STATISTICS_LEVEL = Integer.getInteger("cnd.modelimpl.stat.level", 0);
    private static DiagnosticUnresolved diagnosticUnresolved = null;
    private static final int step = 4;
    private static StringBuilder indentBuffer = new StringBuilder();
    private static FileStatistics curFileHandler = new FileStatistics(null);

    private Diagnostic() {
    }

    public static int getStatisticsLevel() {
        return STATISTICS_LEVEL;
    }

    public static void setStatisticsLevel(int level) {
        STATISTICS_LEVEL = level;
    }

    public static boolean needStatistics() {
        return STATISTICS_LEVEL > 0;
    }

    public static void indent() {
        Diagnostic.setupIndentBuffer(indentBuffer.length() + 4);
    }

    public static void unindent() {
        Diagnostic.setupIndentBuffer(indentBuffer.length() - 4);
    }

    private static void setupIndentBuffer(int len) {
        if (len <= 0) {
            indentBuffer.setLength(0);
        } else {
            indentBuffer.setLength(len);
            for (int i = 0; i < len; ++i) {
                indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public static void trace(PrintStream out, Object arg) {
        if (TraceFlags.DEBUG | Diagnostic.needStatistics()) {
            out.println(indentBuffer.toString() + arg);
        }
    }

    public static void trace(Object arg) {
        Diagnostic.trace(System.err, arg);
    }

    public static void traceStack(String message) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace(message);
            StringWriter wr = new StringWriter();
            new Exception(message).printStackTrace(new PrintWriter(wr));
            BufferedReader br = new BufferedReader(new StringReader(wr.getBuffer().toString()));
            try {
                br.readLine();
                br.readLine();
                String s = br.readLine();
                while (s != null) {
                    Diagnostic.trace(s);
                    s = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void printlnStack(String message, int depth) {
        StringBuilder buf = new StringBuilder(message);
        buf.append('\n');
        StringWriter wr = new StringWriter();
        new Exception(message).printStackTrace(new PrintWriter(wr));
        BufferedReader br = new BufferedReader(new StringReader(wr.getBuffer().toString()));
        try {
            br.readLine();
            br.readLine();
            int i = 0;
            String s = br.readLine();
            while (s != null) {
                if (i == 0) {
                    buf.append("  in thread " + Thread.currentThread().getName());
                    buf.append('\n');
                }
                buf.append(s);
                buf.append('\n');
                if (i <= depth - 1) {
                    ++i;
                    s = br.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        System.out.println(buf.toString());
    }

    public static synchronized void printToFile(String fileName, String format, Object ... args) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName, true);
            PrintStream ps = new PrintStream(fos);
            ps.printf(format, args);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void traceThreads(String message) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace(message);
            Diagnostic.trace("Threads are:");
            int cnt = Thread.activeCount();
            Thread[] threads = new Thread[cnt];
            Thread.enumerate(threads);
            for (int i = 0; i < cnt; ++i) {
                String s = threads[i].getName() + " " + threads[i].getPriority();
                if (threads[i] == Thread.currentThread()) {
                    s = s + " (current)";
                }
                Diagnostic.trace(s);
            }
            Diagnostic.trace("");
        }
    }

    public static void initFileStatistics(String file) {
        curFileHandler.dispose();
        curFileHandler = null;
        curFileHandler = new FileStatistics(file);
    }

    public static void dumpFileStatistics(String dumpFile) throws FileNotFoundException {
        Diagnostic.dumpFileStatistics(dumpFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFileStatistics(String dumpFile, boolean append) throws FileNotFoundException {
        PrintStream dump = new PrintStream(new FileOutputStream(dumpFile, append), true);
        try {
            curFileHandler.dump(dump);
        }
        finally {
            dump.close();
        }
    }

    public static void onUnresolvedError(CharSequence[] nameTokens, CsmFile file, int offset) {
        if (STATISTICS_LEVEL > 0) {
            Diagnostic.getDiagnosticUnresolved().onUnresolved(nameTokens, file, offset);
        }
    }

    public static void dumpUnresolvedStatistics(String dumpFile, boolean append) throws FileNotFoundException {
        Diagnostic.getDiagnosticUnresolved().dumpStatictics(dumpFile, append);
    }

    private static synchronized DiagnosticUnresolved getDiagnosticUnresolved() {
        if (diagnosticUnresolved == null) {
            diagnosticUnresolved = new DiagnosticUnresolved(STATISTICS_LEVEL);
        }
        return diagnosticUnresolved;
    }

    public static void onLexerError(RecognitionException e) {
        curFileHandler.handleLexerError(e);
    }

    public static void onParserError(RecognitionException e) {
        curFileHandler.handleParserError(e);
    }

    public static void onError(Exception e, String source) {
        curFileHandler.handleOtherError(e, source);
    }

    public static void onInclude(String include, String absBaseFilePath, String resolvedIncludePath) {
        curFileHandler.handleInclude(include, absBaseFilePath, resolvedIncludePath, false);
    }

    public static void onRecurseInclude(String resolvedIncludePath, String absBaseFilePath) {
        curFileHandler.handleInclude(null, absBaseFilePath, resolvedIncludePath, true);
    }

    private static class FileStatistics {
        private Map<ExceptionWrapper, ExceptionWrapper> lexerProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<ExceptionWrapper, ExceptionWrapper> parserProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<ExceptionWrapper, ExceptionWrapper> otherProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<String, IncludeInfo> includes = new HashMap<String, IncludeInfo>();
        private ExceptionWrapper lastError = null;
        private ExceptionWrapper firstError = null;
        private String lastErrorMsg = null;
        private String handledFile;

        public FileStatistics(String file) {
            this.handledFile = file;
        }

        public void handleLexerError(RecognitionException e) {
            this.handleError(this.lexerProblems, new LexerExceptionWrapper(e), true);
        }

        public void handleParserError(RecognitionException e) {
            this.handleError(this.parserProblems, new ParserExceptionWrapper(e), true);
        }

        public void handleOtherError(Exception e, String source) {
            this.handleError(this.otherProblems, new ExceptionWrapper(e, source), false);
        }

        public void handleInclude(String include, String absBaseFilePath, String resolvedIncludePath, boolean recursion) {
            String key;
            String string = key = resolvedIncludePath == null ? include : resolvedIncludePath;
            assert (key != null) : "at least 'include' or 'resolvedIncludePath' must be specified";
            IncludeInfo info = this.includes.get(key);
            if (info == null) {
                info = new IncludeInfo(key, resolvedIncludePath == null);
                this.includes.put(key, info);
            }
            info.add(absBaseFilePath, recursion);
        }

        public void dispose() {
            this.handledFile = null;
            this.lastError = null;
            this.firstError = null;
            this.lastErrorMsg = null;
            this.lexerProblems.clear();
            this.parserProblems.clear();
            this.otherProblems.clear();
            this.includes.clear();
        }

        private boolean hasLexerProblems() {
            return this.lexerProblems.size() > 0;
        }

        private boolean hasParserProblems() {
            return this.parserProblems.size() > 0;
        }

        private boolean hasOtherProblems() {
            return this.otherProblems.size() > 0;
        }

        private boolean hasIncludeProblems() {
            for (IncludeInfo elem : this.includes.values()) {
                if (!elem.hasErrors()) continue;
                return true;
            }
            return false;
        }

        public void dump(PrintStream dumpFile) {
            if (this.lexerProblems.isEmpty() && this.parserProblems.isEmpty() && this.includes.isEmpty()) {
                Diagnostic.trace(dumpFile, "*** No errors found in file " + this.handledFile);
            } else {
                Diagnostic.trace(dumpFile, "*** Statistics of file " + this.handledFile);
                if (this.lastError != null) {
                    Diagnostic.trace(dumpFile, "****** First and last lexer/parser errors ******");
                    Diagnostic.indent();
                    Diagnostic.trace(dumpFile, "[FIRST ERROR MSG]: (" + this.firstError.getSourceName() + ")");
                    Diagnostic.trace(dumpFile, this.firstError.e.toString());
                    Diagnostic.trace(dumpFile, "[LAST ERROR MSG]: (" + this.lastError.getSourceName() + ")");
                    Diagnostic.trace(dumpFile, this.lastErrorMsg);
                    if (Diagnostic.getStatisticsLevel() > 1) {
                        Diagnostic.trace(dumpFile, "+++ More details +++ ");
                        if (this.lastError != this.firstError) {
                            Diagnostic.trace(dumpFile, "[FIRST ERROR] " + this.firstError);
                            Diagnostic.trace(dumpFile, "[LAST ERROR] " + this.lastError);
                        } else {
                            Diagnostic.trace(dumpFile, "[ERROR] " + this.lastError);
                        }
                    }
                    Diagnostic.unindent();
                }
                if (this.hasOtherProblems()) {
                    Diagnostic.trace(dumpFile, "****** All unclassified errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(dumpFile, this.otherProblems);
                    Diagnostic.unindent();
                }
                if (this.hasLexerProblems()) {
                    Diagnostic.trace(dumpFile, "****** All Lexer errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(dumpFile, this.lexerProblems);
                    Diagnostic.unindent();
                }
                if (this.hasParserProblems()) {
                    Diagnostic.trace(dumpFile, "****** All Parser errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(dumpFile, this.parserProblems);
                    Diagnostic.unindent();
                }
                if (Diagnostic.getStatisticsLevel() > 1 || this.hasIncludeProblems()) {
                    Diagnostic.trace(dumpFile, "****** Inclusions ******");
                    Diagnostic.indent();
                    this.dumpIncludes(dumpFile, this.includes);
                    Diagnostic.unindent();
                }
                Diagnostic.trace(dumpFile, "*** End of statistics for " + this.handledFile + '\n');
            }
        }

        private void handleError(Map<ExceptionWrapper, ExceptionWrapper> errors, ExceptionWrapper error, boolean updateFirstLastError) {
            assert (error != null);
            assert (error.getException() != null);
            ExceptionWrapper wrap = errors.get(error);
            if (wrap == null) {
                wrap = error;
                errors.put(wrap, wrap);
            }
            wrap.add(error.getException());
            if (updateFirstLastError) {
                this.lastError = wrap;
                this.lastErrorMsg = error.e.toString();
                if (this.firstError == null) {
                    this.firstError = this.lastError;
                }
            }
        }

        private void dumpExceptions(PrintStream dumpFile, Map<ExceptionWrapper, ExceptionWrapper> errors) {
            ArrayList<ExceptionWrapper> values = new ArrayList<ExceptionWrapper>(errors.keySet());
            Collections.sort(values, ExceptionWrapper.COMPARATOR);
            for (ExceptionWrapper elem : values) {
                Diagnostic.trace(dumpFile, elem);
            }
        }

        private void dumpIncludes(PrintStream dumpFile, Map<String, IncludeInfo> includes) {
            ArrayList<IncludeInfo> values = new ArrayList<IncludeInfo>(includes.values());
            Collections.sort(values, IncludeInfo.COMPARATOR);
            for (IncludeInfo elem : values) {
                if (Diagnostic.getStatisticsLevel() == 1 && !elem.hasErrors()) break;
                Diagnostic.trace(dumpFile, elem);
            }
        }

        private static class ParserExceptionWrapper
        extends ExceptionWrapper {
            ParserExceptionWrapper(RecognitionException e) {
                super((Exception)e, "Parser");
            }

            @Override
            protected boolean isStopElement(StackTraceElement curElem) {
                if (!curElem.getClassName().equals(CPPParser.class.getName())) {
                    return true;
                }
                return curElem.getMethodName().equals("translation_unit");
            }
        }

        private static class LexerExceptionWrapper
        extends ExceptionWrapper {
            LexerExceptionWrapper(RecognitionException e) {
                super((Exception)e, "Lexer");
            }

            @Override
            protected boolean isStopElement(StackTraceElement curElem) {
                if (!curElem.getClassName().equals("org.netbeans.modules.cnd.apt.impl.support.generated.APTLexer")) {
                    return true;
                }
                return curElem.getMethodName().equals("nextToken");
            }
        }

        private static class ExceptionWrapper {
            private static final int CKHECKED_STACK_DEPTH = 15;
            private Exception e;
            private Set<String> errorMessages = new HashSet<String>();
            private int counter = 0;
            private String source;
            static final Comparator<ExceptionWrapper> COMPARATOR = new Comparator<ExceptionWrapper>(){

                @Override
                public int compare(ExceptionWrapper w1, ExceptionWrapper w2) {
                    if (w1 == w2) {
                        return 0;
                    }
                    if (w1.counter > w2.counter) {
                        return -1;
                    }
                    if (w1.counter < w2.counter) {
                        return 1;
                    }
                    String msg1 = w1.e.toString();
                    String msg2 = w2.e.toString();
                    return msg1.compareTo(msg2);
                }
            };

            ExceptionWrapper(Exception e, String source) {
                this.e = e;
                this.source = source;
            }

            public Exception getException() {
                return this.e;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof ExceptionWrapper)) {
                    return false;
                }
                ExceptionWrapper check = (ExceptionWrapper)obj;
                if (!check.e.getClass().equals(this.e.getClass())) {
                    return false;
                }
                StackTraceElement[] stack = this.e.getStackTrace();
                StackTraceElement[] checkStack = check.e.getStackTrace();
                if (stack != null) {
                    int length = Math.min(15, Math.min(stack.length, checkStack.length));
                    for (int i = 0; i < length; ++i) {
                        StackTraceElement curElem = stack[i];
                        StackTraceElement checkedElem = checkStack[i];
                        if (this.isStopElement(curElem) || check.isStopElement(checkedElem)) {
                            return true;
                        }
                        if (this.equals(curElem, checkedElem)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            protected String getSourceName() {
                return this.source;
            }

            public String toString() {
                String indent;
                StringBuilder retValue = new StringBuilder();
                retValue.append("===> [").append(this.counter).append("] similar ");
                retValue.append(this.getSourceName()).append(" error(s) with the first :\n");
                retValue.append(indentBuffer.toString()).append(this.e.toString());
                if (Diagnostic.getStatisticsLevel() > 2) {
                    indent = indentBuffer.toString() + indentBuffer.toString() + indentBuffer.toString();
                    StackTraceElement[] stack = this.e.getStackTrace();
                    for (int i = 0; i < stack.length; ++i) {
                        retValue.append("\n").append(indent);
                        retValue.append("at ").append(stack[i]);
                    }
                }
                if (Diagnostic.getStatisticsLevel() > 1 && this.errorMessages.size() > 1) {
                    indent = indentBuffer.toString() + indentBuffer.toString();
                    retValue.append("\n").append(indent);
                    retValue.append("+++ all error messages:");
                    ArrayList<String> values = new ArrayList<String>(this.errorMessages);
                    Collections.sort(values);
                    for (String elem : values) {
                        retValue.append('\n').append(indent).append(elem);
                    }
                }
                return retValue.toString();
            }

            public int hashCode() {
                StackTraceElement[] stack = this.e.getStackTrace();
                int retValue = stack != null && stack.length > 0 ? stack[0].hashCode() : this.e.hashCode();
                return retValue;
            }

            protected boolean isStopElement(StackTraceElement curElem) {
                return false;
            }

            private boolean equals(StackTraceElement elem1, StackTraceElement elem2) {
                assert (elem1 != null);
                assert (elem2 != null);
                return elem1.equals(elem2);
            }

            public void add(Exception e) {
                ++this.counter;
                this.errorMessages.add(e.toString());
            }
        }

        private static class IncludeInfo {
            private String include;
            private boolean failedInclusion;
            private int counter = 0;
            private Map<String, Integer> includedFrom = new HashMap<String, Integer>();
            private Set<String> recursionFrom = new HashSet<String>();
            static final Comparator<IncludeInfo> COMPARATOR = new Comparator<IncludeInfo>(){

                @Override
                public int compare(IncludeInfo i1, IncludeInfo i2) {
                    if (i1 == i2) {
                        return 0;
                    }
                    if (i1.failedInclusion != i2.failedInclusion) {
                        return i1.failedInclusion ? -1 : 1;
                    }
                    if (i1.recursionFrom.size() != i2.recursionFrom.size()) {
                        return i1.recursionFrom.size() > i2.recursionFrom.size() ? -1 : 1;
                    }
                    if (i1.counter != i2.counter) {
                        return i1.counter > i2.counter ? -1 : 1;
                    }
                    return i1.include.compareTo(i2.include);
                }
            };

            IncludeInfo(String include, boolean failedInclusion) {
                this.include = include;
                this.failedInclusion = failedInclusion;
            }

            void add(String absBaseFilePath, boolean recursion) {
                ++this.counter;
                Integer fileCounter = this.includedFrom.containsKey(absBaseFilePath) ? this.includedFrom.get(absBaseFilePath) : Integer.valueOf(0);
                this.includedFrom.put(absBaseFilePath, fileCounter + 1);
                if (recursion) {
                    this.recursionFrom.add(absBaseFilePath);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof IncludeInfo)) {
                    return false;
                }
                IncludeInfo other = (IncludeInfo)obj;
                boolean retValue = this.isFailedInclude() == other.isFailedInclude();
                return retValue &= this.include.equals(other.include);
            }

            public int hashCode() {
                int retValue = this.include.hashCode() + 17 * (this.isFailedInclude() ? 0 : 1);
                return retValue;
            }

            public String toString() {
                StringBuilder retValue = new StringBuilder();
                retValue.append("===> ").append(this.include);
                if (this.isFailedInclude()) {
                    retValue.append(" (FAILED)");
                } else if (this.hasRecursionInclude()) {
                    retValue.append(" (HAS RECURSION)");
                }
                retValue.append(" included ");
                retValue.append(this.counter).append(" time(s)");
                if (Diagnostic.getStatisticsLevel() == 1) {
                    if (this.isFailedInclude() || this.hasRecursionInclude()) {
                        String from;
                        retValue.append("\n").append(indentBuffer.toString()).append(indentBuffer.toString());
                        if (this.hasRecursionInclude()) {
                            assert (this.recursionFrom.size() > 0);
                            assert (this.recursionFrom.iterator().hasNext());
                            from = this.recursionFrom.iterator().next();
                            retValue.append(" [RECURSION] ");
                        } else {
                            assert (this.includedFrom.size() > 0);
                            assert (this.includedFrom.keySet().iterator().hasNext());
                            from = this.includedFrom.keySet().iterator().next();
                            retValue.append(" where [").append(this.includedFrom.get(from)).append("] time(s) ");
                        }
                        retValue.append("from ").append(from);
                    }
                } else {
                    ArrayList<String> files = new ArrayList<String>(this.includedFrom.keySet());
                    Collections.sort(files);
                    for (String from : files) {
                        retValue.append("\n").append(indentBuffer.toString());
                        retValue.append(indentBuffer.toString());
                        if (this.recursionFrom.contains(from)) {
                            retValue.append(" [RECURSION] ");
                        } else {
                            retValue.append(" [").append(this.includedFrom.get(from)).append("] ");
                        }
                        retValue.append("from ").append(from);
                    }
                }
                return retValue.toString();
            }

            public boolean isFailedInclude() {
                return this.failedInclusion;
            }

            public boolean hasRecursionInclude() {
                return !this.recursionFrom.isEmpty();
            }

            public boolean hasErrors() {
                return this.isFailedInclude() || this.hasRecursionInclude();
            }
        }
    }

    public static class StopWatch {
        private long time = 0L;
        private long lastStart;
        private boolean running;

        public StopWatch() {
            this(true);
        }

        public StopWatch(boolean start) {
            if (start) {
                this.start();
            }
        }

        public void start() {
            this.running = true;
            this.lastStart = System.currentTimeMillis();
        }

        public long stop() {
            this.running = false;
            this.time += System.currentTimeMillis() - this.lastStart;
            return this.time;
        }

        public long stopAndReport(String text) {
            long out = this.stop();
            this.report(text);
            return out;
        }

        public long report(String text) {
            System.err.println(' ' + text + ' ' + this.time + " ms");
            return this.time;
        }

        public boolean isRunning() {
            return this.running;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class ProjectStat {
        private static final int SLOW_FILE_NUMBER = Math.max(1, Integer.getInteger("cnd.modelimpl.slow.file.number", 5));
        private final ConcurrentMap<CsmUID<CsmProject>, SlowFilesCollection> projectStats = new ConcurrentHashMap<CsmUID<CsmProject>, SlowFilesCollection>();

        public void addParseFileStatistics(ProjectBase project, FileImpl file, long parseTime) {
            if (project != null && !project.isArtificial()) {
                SlowFilesCollection old;
                CsmUID<CsmProject> uID = project.getUID();
                SlowFilesCollection data = (SlowFilesCollection)this.projectStats.get(uID);
                if (data == null && uID != null && (old = this.projectStats.putIfAbsent(uID, data = new SlowFilesCollection())) != null) {
                    data = old;
                }
                if (data != null) {
                    data.put(file, parseTime);
                }
            }
        }

        public void traceProjectData(ProjectBase project) {
            if (project != null && !project.isArtificial()) {
                SlowFilesCollection data = (SlowFilesCollection)this.projectStats.get(project.getUID());
                if (data != null) {
                    System.err.printf("Slowest Files for %s are:\n%s", project.getName(), data.asString());
                    System.err.println();
                    System.err.flush();
                } else {
                    System.err.printf("No Slowest Files info for " + project.getName(), new Object[0]);
                    System.err.println();
                    System.err.flush();
                }
            }
        }

        public void clear() {
            this.projectStats.clear();
        }

        private static final class SlowFilesCollection {
            private final LinkedList<Entry> times = new LinkedList();

            private SlowFilesCollection() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void put(FileImpl file, long parseTime) {
                SlowFilesCollection slowFilesCollection = this;
                synchronized (slowFilesCollection) {
                    boolean add;
                    ListIterator<Entry> iterator = this.times.listIterator(this.times.size());
                    boolean bl = add = !iterator.hasPrevious();
                    while (iterator.hasPrevious()) {
                        Entry elem = iterator.previous();
                        if (elem.time < parseTime) {
                            add = true;
                            continue;
                        }
                        if (!add) continue;
                        iterator.add(new Entry(parseTime, file.getAbsolutePath()));
                        break;
                    }
                    if (add) {
                        this.times.addFirst(new Entry(parseTime, file.getBuffer().getUrl()));
                    }
                    if (this.times.size() > SLOW_FILE_NUMBER) {
                        this.times.removeLast();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String asString() {
                StringBuilder out = new StringBuilder();
                SlowFilesCollection slowFilesCollection = this;
                synchronized (slowFilesCollection) {
                    for (Entry entry : this.times) {
                        out.append(entry).append('\n');
                    }
                }
                return out.toString();
            }

            private static final class Entry {
                final long time;
                final CharSequence file;

                public Entry(long time, CharSequence file) {
                    this.time = time;
                    this.file = file;
                }

                public String toString() {
                    return " file=" + this.file + " " + this.time + " ms";
                }
            }
        }
    }
}

