/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ClassifierContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CreateFilesWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainerProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FakeRegistrationWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModel;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeProjectListenerImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseFinishNotificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.Terminator;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileInfoQueryImpl;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTRestorePreprocStateWalker;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public abstract class ProjectBase
implements CsmProject,
Persistent,
SelfPersistent,
CsmIdentifiable,
CndFileSystemProvider.CndFileSystemProblemListener {
    private static final boolean TRACE_FILE = TraceFlags.TRACE_FILE_NAME != null;
    private int preventMultiplyDiagnosticExceptionsGlobalNamespace = 0;
    private CsmUID<CsmProject> uid = null;
    private final Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> fakeASTs = new WeakHashMap();
    private volatile int hash = 0;
    private volatile Status status;
    private Cancellable initializationTask;
    private final Object initializationTaskLock = new InitializationTaskLock();
    private final Object waitParseLock = new WaitParseLock();
    private final Object classifierReplaceLock = new ClassifierReplaceLock();
    private ModelImpl model;
    private Unresolved unresolved;
    private CharSequence name;
    private CsmUID<CsmNamespace> globalNamespaceUID;
    private NamespaceImpl FAKE_GLOBAL_NAMESPACE;
    private volatile Object platformProject;
    private final FileSystem fileSystem;
    private boolean hasFileSystemProblems;
    private final Object fileSystemProblemsLock = new Object();
    private final AtomicBoolean disposing = new AtomicBoolean(false);
    private final ReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private final CharSequence uniqueName;
    private final Map<CharSequence, CsmUID<CsmNamespace>> namespaces;
    private final Key classifierStorageKey;
    private final APTSystemStorage sysAPTData;
    private final APTIncludePathStorage userPathStorage;
    private final Object namespaceLock = new NamespaceLock();
    private final Key declarationsSorageKey;
    private final Key fileContainerKey;
    private final Object fileContainerLock = new FileContainerLock();
    private final Key graphStorageKey;
    private NativeProjectListenerImpl projectListener;
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private static final boolean REMEMBER_RESTORED = TraceFlags.CLEAN_MACROS_AFTER_PARSE && (DebugUtils.getBoolean((String)"cnd.remember.restored", (boolean)false) || TRACE_PP_STATE_OUT);
    public static final int GATHERING_MACROS = 0;
    public static final int GATHERING_TOKENS = 1;
    private static volatile List<String> testRestoredFiles = null;
    private final WeakContainer<DeclarationContainerProject> weakDeclarationContainer;
    private final WeakContainer<FileContainer> weakFileContainer;
    private final WeakContainer<GraphContainer> weakGraphContainer;
    private final WeakContainer<ClassifierContainer> weakClassifierContainer;

    protected ProjectBase(ModelImpl model, FileSystem fs, Object platformProject, String name) {
        this.namespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.uniqueName = ProjectBase.getUniqueName(fs, platformProject);
        RepositoryUtils.openUnit(ProjectBase.createProjectKey(fs, platformProject));
        this.setStatus(Status.Initial);
        this.name = ProjectNameCache.getManager().getString((CharSequence)name);
        this.fileSystem = fs;
        this.init(model, platformProject);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.declarationsSorageKey = new ProjectDeclarationContainerKey(this.getUniqueName());
        this.weakDeclarationContainer = new WeakContainer(this, this.declarationsSorageKey);
        this.classifierStorageKey = new ClassifierContainerKey(this.getUniqueName());
        this.weakClassifierContainer = new WeakContainer(this, this.classifierStorageKey);
        this.fileContainerKey = new FileContainerKey(this.getUniqueName());
        this.weakFileContainer = new WeakContainer(this, this.fileContainerKey);
        this.graphStorageKey = new GraphContainerKey(this.getUniqueName());
        this.weakGraphContainer = new WeakContainer(this, this.graphStorageKey);
        this.initFields();
    }

    final void initFields() {
        NamespaceImpl ns = NamespaceImpl.create(this, false);
        assert (ns != null);
        this.globalNamespaceUID = UIDCsmConverter.namespaceToUID(ns);
        DeclarationContainerProject declarationContainer = new DeclarationContainerProject(this);
        CndUtils.assertTrue((boolean)this.declarationsSorageKey.equals(declarationContainer.getKey()));
        this.weakDeclarationContainer.clear();
        ClassifierContainer classifierContainer = new ClassifierContainer(this);
        CndUtils.assertTrue((boolean)this.classifierStorageKey.equals(classifierContainer.getKey()));
        this.weakClassifierContainer.clear();
        FileContainer fileContainer = new FileContainer(this);
        CndUtils.assertTrue((boolean)this.fileContainerKey.equals(fileContainer.getKey()));
        this.weakFileContainer.clear();
        GraphContainer graphContainer = new GraphContainer(this);
        CndUtils.assertTrue((boolean)this.graphStorageKey.equals(graphContainer.getKey()));
        this.weakGraphContainer.clear();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
    }

    private void init(ModelImpl model, Object platformProject) {
        this.model = model;
        this.platformProject = platformProject;
        RepositoryUtils.hang(this);
        if (TraceFlags.CLOSE_AFTER_PARSE) {
            Terminator.create(this);
        }
    }

    private boolean checkConsistency() {
        long time;
        long l = time = TraceFlags.TIMING ? System.currentTimeMillis() : 0L;
        if (this.getFileContainer() == FileContainer.empty()) {
            return false;
        }
        if (this.getDeclarationsSorage() == DeclarationContainerProject.empty()) {
            return false;
        }
        if (this.getGraph() == GraphContainer.empty()) {
            return false;
        }
        if (this.getGlobalNamespace() == this.FAKE_GLOBAL_NAMESPACE) {
            return false;
        }
        if (TraceFlags.TIMING) {
            System.err.printf("Consistency check took %d ms\n", System.currentTimeMillis() - time);
        }
        return true;
    }

    private void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    protected static void cleanRepository(FileSystem fs, Object platformProject, boolean articicial) {
        Key key = ProjectBase.createProjectKey(fs, platformProject);
        RepositoryUtils.closeUnit(key, null, true);
    }

    private static Key createProjectKey(FileSystem fs, Object platfProj) {
        return KeyUtilities.createProjectKey(ProjectBase.getUniqueName(fs, platfProj));
    }

    protected static ProjectBase readInstance(ModelImpl model, FileSystem fs, Object platformProject, String name) {
        long time = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("Project %s: instantiating...\n", name);
            time = System.currentTimeMillis();
        }
        assert (TraceFlags.PERSISTENT_REPOSITORY);
        Key key = ProjectBase.createProjectKey(fs, platformProject);
        RepositoryUtils.openUnit(key);
        Persistent o = RepositoryUtils.get(key);
        if (o != null) {
            assert (o instanceof ProjectBase);
            ProjectBase impl = (ProjectBase)o;
            CharSequence aName = ProjectNameCache.getManager().getString((CharSequence)name);
            if (!impl.name.equals(aName)) {
                impl.setName(aName);
            }
            impl.init(model, platformProject);
            if (TraceFlags.TIMING) {
                time = System.currentTimeMillis() - time;
                System.err.printf("Project %s: loaded. %d ms\n", name, time);
            }
            UIDManager.instance().clearProjectCache(key);
            if (impl.checkConsistency()) {
                return impl;
            }
        }
        return null;
    }

    public final CsmNamespace getGlobalNamespace() {
        return this._getGlobalNamespace();
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final void setName(CharSequence name) {
        this.name = name;
    }

    public final CharSequence getUniqueName() {
        return this.uniqueName;
    }

    public static CharSequence getUniqueName(NativeProject platformProject) {
        return ProjectBase.getUniqueName(platformProject.getFileSystem(), platformProject);
    }

    public String getDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return ((Object)this.name).toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public String getHtmlDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return ((Object)this.name).toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectHtmlDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public static CharSequence getUniqueName(FileSystem fs, Object platformProject) {
        String result;
        String postfix;
        Parameters.notNull((CharSequence)"FileSystem", (Object)fs);
        String string = postfix = CndFileUtils.isLocalFileSystem((FileSystem)fs) ? "" : fs.getDisplayName();
        if (platformProject instanceof NativeProject) {
            result = ((NativeProject)platformProject).getProjectRoot() + 'N' + postfix;
        } else if (platformProject instanceof CharSequence) {
            result = ((Object)((CharSequence)platformProject)).toString() + 'L' + postfix;
        } else {
            if (platformProject == null) {
                throw new IllegalArgumentException("Incorrect platform project: null");
            }
            throw new IllegalArgumentException("Incorrect platform project class: " + platformProject.getClass());
        }
        return ProjectNameCache.getManager().getString((CharSequence)result);
    }

    public final Object getPlatformProject() {
        return this.platformProject;
    }

    protected final void setPlatformProject(Object platformProject) {
        CndUtils.assertTrue((this.platformProject == null ? 1 : 0) != 0);
        CndUtils.assertNotNull((Object)platformProject, (CharSequence)"Passing null project for ", (Object)this);
        this.platformProject = platformProject;
        CndUtils.assertTrue((boolean)this.uniqueName.equals(ProjectBase.getUniqueName(this.fileSystem, platformProject)));
    }

    public final CsmNamespace findNamespace(CharSequence qualifiedName, boolean findInLibraries) {
        CsmNamespace result;
        block1: {
            CsmProject lib;
            result = this.findNamespace(qualifiedName);
            if (result != null || !findInLibraries) break block1;
            Iterator it = this.getLibraries().iterator();
            while (it.hasNext() && (result = (lib = (CsmProject)it.next()).findNamespace(qualifiedName)) == null) {
            }
        }
        return result;
    }

    public final CsmNamespace findNamespace(CharSequence qualifiedName) {
        NamespaceImpl nsp = this._getNamespace(qualifiedName);
        return nsp;
    }

    private static String getNestedNamespaceQualifiedName(CharSequence name, NamespaceImpl parent, boolean createForEmptyNames) {
        StringBuilder sb = new StringBuilder(name);
        if (parent != null) {
            if (name.length() == 0 && createForEmptyNames) {
                sb.append(parent.getNameForUnnamedElement());
            }
            if (!parent.isGlobal()) {
                sb.insert(0, "::");
                sb.insert(0, parent.getQualifiedName());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NamespaceImpl findNamespaceCreateIfNeeded(NamespaceImpl parent, CharSequence name) {
        Object object = this.namespaceLock;
        synchronized (object) {
            String qualifiedName = ProjectBase.getNestedNamespaceQualifiedName(name, parent, true);
            NamespaceImpl nsp = this._getNamespace(qualifiedName);
            if (nsp == null) {
                nsp = NamespaceImpl.create(this, parent, ((Object)name).toString(), qualifiedName);
            }
            return nsp;
        }
    }

    public final void registerNamespace(NamespaceImpl namespace) {
        this._registerNamespace(namespace);
    }

    public final void unregisterNamesace(NamespaceImpl namespace) {
        this._unregisterNamespace(namespace);
    }

    public final CsmClassifier findClassifier(CharSequence qualifiedName, boolean findInLibraries) {
        CsmClassifier result;
        block1: {
            CsmProject lib;
            result = this.findClassifier(qualifiedName);
            if (result != null || !findInLibraries) break block1;
            Iterator it = this.getLibraries().iterator();
            while (it.hasNext() && (result = (lib = (CsmProject)it.next()).findClassifier(qualifiedName)) == null) {
            }
        }
        return result;
    }

    public final CsmClassifier findClassifier(CharSequence qualifiedName) {
        CsmClassifier result = this.getClassifierSorage().getClassifier(qualifiedName);
        return result;
    }

    public final Collection<CsmClassifier> findClassifiers(CharSequence qualifiedName) {
        CsmClassifier result = this.getClassifierSorage().getClassifier(qualifiedName);
        ArrayList<CsmClassifier> out = new ArrayList<CsmClassifier>();
        if (result != null) {
            if (CsmKindUtilities.isBuiltIn((CsmObject)result)) {
                return Collections.singletonList(result);
            }
            CharSequence[] allClassifiersUniqueNames = Utils.getAllClassifiersUniqueNames(result.getUniqueName());
            ArrayList<CsmClassifier> fwds = new ArrayList<CsmClassifier>(1);
            for (CharSequence curUniqueName : allClassifiersUniqueNames) {
                Collection<CsmOffsetableDeclaration> decls;
                Collection<CsmOffsetableDeclaration> classifiers = decls = this.findDeclarations(curUniqueName);
                for (CsmClassifier csmClassifier : classifiers) {
                    if (ForwardClass.isForwardClass((CsmDeclaration)csmClassifier)) {
                        fwds.add(csmClassifier);
                        continue;
                    }
                    out.add(csmClassifier);
                }
            }
            out.addAll(fwds);
        }
        return out;
    }

    public final Collection<CsmInheritance> findInheritances(CharSequence name) {
        return this.getClassifierSorage().getInheritances(name);
    }

    public final CsmDeclaration findDeclaration(CharSequence uniqueName) {
        return this.getDeclarationsSorage().getDeclaration(uniqueName);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence uniqueName) {
        return this.getDeclarationsSorage().findDeclarations(uniqueName);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarationsByPrefix(String uniquNamePrefix) {
        char maxChar = '\u00ff';
        return this.getDeclarationsSorage().getDeclarationsRange((CharSequence)uniquNamePrefix, uniquNamePrefix + maxChar);
    }

    public final Collection<CsmFriend> findFriendDeclarations(CsmOffsetableDeclaration decl) {
        return this.getDeclarationsSorage().findFriends(decl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerDeclaration(CsmOffsetableDeclaration decl) {
        if (!Utils.canRegisterDeclaration((CsmDeclaration)decl)) {
            if (TraceFlags.TRACE_REGISTRATION) {
                ProjectBase.traceRegistration("not registered decl " + decl + " UID " + UIDs.get((Object)decl));
            }
            return false;
        }
        if (CsmKindUtilities.isClass((CsmObject)decl) || CsmKindUtilities.isEnum((CsmObject)decl)) {
            ClassEnumBase cls = (ClassEnumBase)decl;
            CharSequence qname = cls.getQualifiedName();
            Object object = this.classifierReplaceLock;
            synchronized (object) {
                CsmClassifier old = this.getClassifierSorage().getClassifier(qname);
                if (old != null) {
                    if (cls.shouldBeReplaced(old)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            ProjectBase.traceRegistration("not registered decl " + decl + " UID " + UIDs.get((Object)decl));
                        }
                        return false;
                    }
                    if (old instanceof ClassEnumBase && ((ClassEnumBase)old).shouldBeReplaced((CsmClassifier)cls)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            System.err.println("disposing old decl " + old + " UID " + UIDs.get((Object)decl));
                        }
                        ((ClassEnumBase)old).dispose();
                    }
                }
                this.getDeclarationsSorage().putDeclaration(decl);
                this.getClassifierSorage().putClassifier((CsmClassifier)decl);
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)decl)) {
            this.getDeclarationsSorage().putDeclaration(decl);
            this.getClassifierSorage().putClassifier((CsmClassifier)decl);
        } else {
            this.getDeclarationsSorage().putDeclaration(decl);
        }
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("registered " + decl + " UID " + UIDs.get((Object)decl));
        }
        return true;
    }

    public final void unregisterDeclaration(CsmOffsetableDeclaration decl) {
        if (TraceFlags.TRACE_REGISTRATION) {
            ProjectBase.traceRegistration("unregistered " + decl + " UID " + UIDs.get((Object)decl));
        }
        if (decl instanceof CsmClassifier) {
            this.getClassifierSorage().removeClassifier((CsmDeclaration)decl);
        }
        this.getDeclarationsSorage().removeDeclaration(decl);
    }

    private static void traceRegistration(String text) {
        assert (TraceFlags.TRACE_REGISTRATION) : "TraceFlags.TRACE_REGISTRATION should be checked *before* call !";
        System.err.printf("registration: %s\n", text);
    }

    public final void waitParse() {
        boolean insideParser = ParserThreadManager.instance().isParserThread();
        if (insideParser) {
            new Throwable("project.waitParse should NEVER be called in parser thread !!!").printStackTrace(System.err);
        }
        if (insideParser) {
            return;
        }
        this.ensureFilesCreated();
        this.ensureChangedFilesEnqueued();
        this.model.waitModelTasks();
        this.waitParseImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitParseImpl() {
        Object object = this.waitParseLock;
        synchronized (object) {
            while (ParserQueue.instance().hasPendingProjectRelatedWork(this, null)) {
                try {
                    this.waitParseLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void ensureChangedFilesEnqueued() {
    }

    protected boolean hasChangedFiles(CsmFile skipFile) {
        return false;
    }

    protected boolean hasEditedFiles() {
        return false;
    }

    protected final synchronized void registerProjectListeners() {
        if (this.platformProject instanceof NativeProject) {
            if (this.projectListener == null) {
                this.projectListener = new NativeProjectListenerImpl(this.getModel(), (NativeProject)this.platformProject, this);
            }
            NativeProject nativeProject = (NativeProject)this.platformProject;
            nativeProject.addProjectItemsListener((NativeProjectItemsListener)this.projectListener);
            for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                CndFileSystemProvider.addFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
            }
        }
    }

    private Set<FileSystem> getIncludesFileSystems(NativeProject nativeProject) {
        HashSet<FileSystem> fileSystems = new HashSet<FileSystem>();
        for (FSPath fsPath : nativeProject.getSystemIncludePaths()) {
            fileSystems.add(fsPath.getFileSystem());
        }
        return fileSystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void problemOccurred(FSPath fsPath) {
        Object object = this.fileSystemProblemsLock;
        synchronized (object) {
            this.hasFileSystemProblems = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovered(FileSystem fileSystem) {
        boolean prev;
        Object object = this.fileSystemProblemsLock;
        synchronized (object) {
            prev = this.hasFileSystemProblems;
            this.hasFileSystemProblems = false;
        }
        if (prev) {
            ModelImpl.instance().scheduleReparse(Collections.singleton(this));
        }
    }

    public final synchronized void enableProjectListeners(boolean enable) {
        if (this.projectListener != null) {
            this.projectListener.enableListening(enable);
        }
    }

    protected final synchronized void unregisterProjectListeners() {
        if (this.projectListener != null && this.platformProject instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)this.platformProject;
            nativeProject.removeProjectItemsListener((NativeProjectItemsListener)this.projectListener);
            for (FileSystem fs : this.getIncludesFileSystems(nativeProject)) {
                CndFileSystemProvider.removeFileSystemProblemListener((CndFileSystemProvider.CndFileSystemProblemListener)this, (FileSystem)fs);
            }
        }
    }

    final void scheduleReparse() {
        this.ensureFilesCreated();
        DeepReparsingUtils.reparseOnEdit(this.getAllFileImpls(), this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFilesCreated() {
        if (this.status == Status.Ready) {
            return;
        }
        boolean notify = false;
        ProjectBase projectBase = this;
        synchronized (projectBase) {
            if (this.status == Status.Initial || this.status == Status.Restored) {
                try {
                    this.setStatus(this.status == Status.Initial ? Status.AddingFiles : Status.Validating);
                    long time = 0L;
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        System.err.println("suspend queue");
                        ParserQueue.instance().suspend();
                        if (TraceFlags.TIMING) {
                            time = System.currentTimeMillis();
                        }
                    }
                    ParserQueue.instance().onStartAddingProjectFiles(this);
                    this.registerProjectListeners();
                    NativeProject nativeProject = ModelSupport.getNativeProject(this.platformProject);
                    if (nativeProject != null) {
                        try {
                            ParserQueue.instance().suspend();
                            this.createProjectFilesIfNeed(nativeProject);
                        }
                        finally {
                            ParserQueue.instance().resume();
                        }
                    }
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        if (TraceFlags.TIMING) {
                            time = System.currentTimeMillis() - time;
                            System.err.println("getting files from project system + put in queue took " + time + "ms");
                        }
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before resuming queue");
                        this.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                        ParserQueue.instance().resume();
                    }
                    notify = true;
                }
                finally {
                    this.setStatus(Status.Ready);
                }
            }
        }
        if (notify) {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    private void sleep(int millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createProjectFilesIfNeed(NativeProject nativeProject) {
        block31: {
            block32: {
                if (TraceFlags.TIMING) {
                    System.err.printf("\n\nGetting files from project system for %s...\n", new Object[]{this.getName()});
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                time = System.currentTimeMillis();
                removedFiles = Collections.synchronizedSet(new HashSet<E>());
                projectItemListener = new NativeProjectItemsListener(){

                    public void fileAdded(NativeFileItem fileItem) {
                    }

                    public void filesAdded(List<NativeFileItem> fileItems) {
                    }

                    public void fileRemoved(NativeFileItem fileItem) {
                        removedFiles.add(fileItem);
                    }

                    public void filesRemoved(List<NativeFileItem> fileItems) {
                        removedFiles.addAll(fileItems);
                    }

                    public void fileRenamed(String oldPath, NativeFileItem newFileIetm) {
                    }

                    public void filePropertiesChanged(NativeFileItem fileItem) {
                    }

                    public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
                    }

                    public void filesPropertiesChanged() {
                    }

                    public void projectDeleted(NativeProject nativeProject) {
                    }
                };
                nativeProject.addProjectItemsListener(projectItemListener);
                sources = new ArrayList<NativeFileItem>();
                headers = new ArrayList<NativeFileItem>();
                excluded = new ArrayList<NativeFileItem>();
                block14: for (NativeFileItem item : nativeProject.getAllFiles()) {
                    if (!item.isExcluded()) {
                        switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[item.getLanguage().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                sources.add(item);
                                continue block14;
                            }
                            case 4: {
                                headers.add(item);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[item.getLanguage().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            excluded.add(item);
                            break;
                        }
                    }
                }
                if (TraceFlags.TIMING) {
                    time = System.currentTimeMillis() - time;
                    System.err.printf("Getting files from project system took  %d ms for %s\n", new Object[]{time, this.getName()});
                    System.err.printf("FILES COUNT for %s:\nSource files:\t%d\nHeader files:\t%d\nTotal files:\t%d\n", new Object[]{this.getName(), sources.size(), headers.size(), sources.size() + headers.size()});
                    time = System.currentTimeMillis();
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec after getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (TraceFlags.DUMP_PROJECT_ON_OPEN) {
                    ModelSupport.dumpNativeProject(nativeProject);
                }
                this.disposeLock.readLock().lock();
                if (TraceFlags.TIMING) {
                    time = System.currentTimeMillis() - time;
                    System.err.printf("Waited on disposeLock: %d ms for %s\n", new Object[]{time, this.getName()});
                    time = System.currentTimeMillis();
                }
                if (!this.isDisposing()) break block31;
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", new Object[]{this.getName()});
                }
                this.disposeLock.readLock().unlock();
                if (!TraceFlags.TIMING) break block32;
                time = System.currentTimeMillis() - time;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{time, this.getName()});
            }
            return;
        }
        try {
            validator = null;
            if (this.status == Status.Validating) {
                validator = new ProjectSettingsValidator(this);
                validator.restoreSettings();
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                validator = null;
                this.reopenUnit();
            }
            this.getProjectRoots().fixFolder(nativeProject.getProjectRoot());
            for (String root : nativeProject.getSourceRoots()) {
                this.getProjectRoots().fixFolder(root);
            }
            this.getProjectRoots().addSources(sources);
            this.getProjectRoots().addSources(headers);
            this.getProjectRoots().addSources(excluded);
            for (NativeFileItem nativeFileItem : excluded) {
                file = this.getFile(nativeFileItem.getAbsolutePath(), true);
                if (file == null) continue;
                this.removeFile(nativeFileItem.getAbsolutePath());
            }
            worker = new CreateFilesWorker(this);
            worker.createProjectFilesIfNeed(sources, true, removedFiles, validator);
            if (this.status != Status.Validating || RepositoryUtils.getRepositoryErrorCount(this) == 0) {
                worker.createProjectFilesIfNeed(headers, false, removedFiles, validator);
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                validator = null;
                this.reopenUnit();
                worker.createProjectFilesIfNeed(sources, true, removedFiles, validator);
                worker.createProjectFilesIfNeed(headers, false, removedFiles, validator);
            }
            this.disposeLock.readLock().unlock();
            ** if (!TraceFlags.TIMING) goto lbl-1000
        }
        catch (Throwable var13_14) {
            this.disposeLock.readLock().unlock();
            if (TraceFlags.TIMING) {
                time = System.currentTimeMillis() - time;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{time, this.getName()});
            }
            throw var13_14;
        }
lbl-1000:
        // 1 sources

        {
            time = System.currentTimeMillis() - time;
            System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{time, this.getName()});
        }
lbl-1000:
        // 2 sources

        {
        }
        nativeProject.removeProjectItemsListener(projectItemListener);
    }

    private void reopenUnit() {
        this.setStatus(Status.Initial);
        ParserQueue.instance().clean(this);
        RepositoryUtils.closeUnit(this.getUniqueName(), null, true);
        RepositoryUtils.openUnit(this);
        RepositoryUtils.hang(this);
        this.initFields();
    }

    protected final void createIfNeed(NativeFileItem nativeFile, boolean isSourceFile) {
        FileAndHandler fileAndHandler = this.preCreateIfNeed(nativeFile, isSourceFile);
        if (fileAndHandler == null) {
            return;
        }
        ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
    }

    private FileAndHandler preCreateIfNeed(NativeFileItem nativeFile, boolean isSourceFile) {
        assert (nativeFile != null && nativeFile.getFileObject() != null);
        if (!Utils.acceptNativeItem(nativeFile)) {
            return null;
        }
        CsmFile.FileType fileType = isSourceFile ? Utils.getFileType(nativeFile) : CsmFile.FileType.HEADER_FILE;
        FileAndHandler fileAndHandler = this.createOrFindFileImpl(ModelSupport.createFileBuffer(nativeFile.getFileObject()), nativeFile, fileType);
        if (fileAndHandler.preprocHandler == null) {
            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFile);
        }
        return fileAndHandler;
    }

    final void createIfNeed(NativeFileItem nativeFile, boolean isSourceFile, FileModel lwm, ProjectSettingsValidator validator, List<FileImpl> reparseOnEdit, List<NativeFileItem> reparseOnPropertyChanged) {
        FileAndHandler fileAndHandler = this.preCreateIfNeed(nativeFile, isSourceFile);
        if (fileAndHandler == null) {
            return;
        }
        if (validator != null) {
            if (fileAndHandler.fileImpl.validate()) {
                if (fileAndHandler.fileImpl.isParsed()) {
                    if (validator.arePropertiesChanged(nativeFile)) {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s properties are changed \n", nativeFile.getAbsolutePath());
                        }
                        reparseOnPropertyChanged.add(nativeFile);
                    }
                } else if (validator.arePropertiesChanged(nativeFile)) {
                    if (fileAndHandler.fileImpl.getState() == FileImpl.State.INITIAL) {
                        fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFile);
                        ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                    } else {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s properties are changed \n", nativeFile.getAbsolutePath());
                        }
                        reparseOnPropertyChanged.add(nativeFile);
                    }
                } else {
                    ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                }
            } else {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("Validation: file %s is changed\n", nativeFile.getAbsolutePath());
                }
                if (validator.arePropertiesChanged(nativeFile)) {
                    reparseOnPropertyChanged.add(nativeFile);
                } else {
                    reparseOnEdit.add(fileAndHandler.fileImpl);
                }
            }
        } else if (lwm == null || !lwm.fill(fileAndHandler.fileImpl)) {
            ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAddedToModel() {
        boolean isRestored;
        boolean bl = isRestored = this.status == Status.Restored;
        if (this.status == Status.Initial || this.status == Status.Restored) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProjectBase.this.onAddedToModelImpl(isRestored);
                    Object object = ProjectBase.this.initializationTaskLock;
                    synchronized (object) {
                        ProjectBase.this.initializationTask = null;
                    }
                }
            };
            String text = this.status == Status.Initial ? "Filling parser queue for " : "Validating files for ";
            Object object = this.initializationTaskLock;
            synchronized (object) {
                this.initializationTask = ModelImpl.instance().enqueueModelTask(r, text + this.getName());
            }
        }
    }

    protected final Status getStatus() {
        return this.status;
    }

    boolean isValidating() {
        return this.status == Status.Validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddedToModelImpl(boolean isRestored) {
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception("Restored: " + isRestored + " disposing: " + this.isDisposing()).printStackTrace(System.err);
        }
        if (this.isDisposing()) {
            return;
        }
        try {
            this.disposeLock.readLock().lock();
            if (this.isDisposing()) {
                return;
            }
            this.ensureFilesCreated();
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (isRestored) {
            ProgressSupport.instance().fireProjectLoaded(this);
        }
        try {
            this.disposeLock.readLock().lock();
            if (isRestored && !this.isDisposing()) {
                try {
                    this.waitParseImpl();
                    this.checkForRemoved();
                }
                catch (Exception e) {
                    DiagnosticExceptoins.register(e);
                }
            }
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    private void checkForRemoved() {
        NativeProject nativeProject = this.platformProject instanceof NativeProject ? (NativeProject)this.platformProject : null;
        HashSet<String> projectFiles = null;
        if (nativeProject != null) {
            projectFiles = new HashSet<String>();
            for (NativeFileItem item : nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: 
                    case C_HEADER: {
                        projectFiles.add(item.getAbsolutePath());
                        break;
                    }
                }
            }
        }
        HashSet<FileImpl> candidates = new HashSet<FileImpl>();
        HashSet<FileImpl> removedPhysically = new HashSet<FileImpl>();
        for (FileImpl file : this.getAllFileImpls()) {
            FileObject fo = file.getFileObject();
            if (fo == null || !fo.isValid()) {
                removedPhysically.add(file);
                continue;
            }
            if (projectFiles == null || projectFiles.contains(((Object)file.getAbsolutePath()).toString())) continue;
            candidates.add(file);
        }
        ArrayList<FileImpl> removedFiles = new ArrayList<FileImpl>(removedPhysically);
        if (TraceFlags.TRACE_VALIDATION) {
            for (FileImpl file : removedPhysically) {
                System.err.printf("Validation: removing (physically deleted) %s\n", file.getAbsolutePath());
            }
        }
        for (FileImpl file : candidates) {
            boolean remove = true;
            Set<CsmFile> parents = this.getGraphStorage().getParentFiles(file);
            for (CsmFile parent : parents) {
                if (candidates.contains((FileImpl)parent)) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            if (TraceFlags.TRACE_VALIDATION) {
                System.err.printf("Validation: removing (removed from project) %s\n", file.getAbsolutePath());
            }
            removedFiles.add(file);
        }
        this.onFileImplRemoved(removedFiles);
    }

    protected final APTPreprocHandler createEmptyPreprocHandler(CharSequence absPath) {
        StartEntry startEntry = new StartEntry(this.getFileSystem(), ((Object)FileContainer.getFileKey(absPath, true)).toString(), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
    }

    protected final APTPreprocHandler createPreprocHandler(NativeFileItem nativeFile) {
        assert (nativeFile != null);
        APTMacroMap macroMap = this.getMacroMap(nativeFile);
        APTIncludeHandler inclHandler = this.getIncludeHandler(nativeFile);
        APTPreprocHandler preprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)macroMap, (APTIncludeHandler)inclHandler, (boolean)this.isSourceFile(nativeFile));
        return preprocHandler;
    }

    private APTIncludeHandler getIncludeHandler(NativeFileItem nativeFile) {
        if (!this.isSourceFile(nativeFile)) {
            nativeFile = DefaultFileItem.toDefault(nativeFile);
        }
        List origUserIncludePaths = nativeFile.getUserIncludePaths();
        if (TraceFlags.DUMP_NATIVE_FILE_ITEM_USER_INCLUDE_PATHS) {
            System.err.println("Item " + nativeFile.getAbsolutePath());
            for (FSPath path : origUserIncludePaths) {
                System.err.println("\tPath " + path.getPath());
            }
        }
        List origSysIncludePaths = nativeFile.getSystemIncludePaths();
        List userIncludePaths = this.userPathStorage.get((CharSequence)origUserIncludePaths.toString(), origUserIncludePaths);
        List sysIncludePaths = this.sysAPTData.getIncludes((CharSequence)origSysIncludePaths.toString(), origSysIncludePaths);
        String entryKey = ((Object)FileContainer.getFileKey(nativeFile.getAbsolutePath(), true)).toString();
        if (CndUtils.isDebugMode()) {
            FileSystem curPrjFS = this.getFileSystem();
            FileSystem nativeProjectFS = nativeFile.getNativeProject().getFileSystem();
            CndUtils.assertTrue((boolean)nativeProjectFS.equals(curPrjFS), (String)("File systems differ: incoming=" + nativeProjectFS + ";cur=" + curPrjFS));
        }
        StartEntry startEntry = new StartEntry(this.getFileSystem(), entryKey, RepositoryUtils.UIDtoKey(this.getUID()));
        APTFileSearch searcher = null;
        Object aPlatformProject = this.getPlatformProject();
        if (aPlatformProject != null) {
            searcher = APTFileSearch.get((Key)KeyUtilities.createProjectKey(ProjectBase.getUniqueName(this.fileSystem, aPlatformProject)));
        }
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)sysIncludePaths, (List)userIncludePaths, searcher);
    }

    private APTMacroMap getMacroMap(NativeFileItem nativeFile) {
        if (!this.isSourceFile(nativeFile)) {
            nativeFile = DefaultFileItem.toDefault(nativeFile);
        }
        List userMacros = nativeFile.getUserMacroDefinitions();
        List sysMacros = nativeFile.getSystemMacroDefinitions();
        APTMacroMap map = APTHandlersSupport.createMacroMap((APTMacroMap)this.getSysMacroMap(sysMacros), (List)userMacros);
        return map;
    }

    protected final boolean isSourceFile(NativeFileItem nativeFile) {
        CsmFile.FileType type = Utils.getFileType(nativeFile);
        return FileImpl.isSourceFileType(type);
    }

    private APTMacroMap getSysMacroMap(List<String> sysMacros) {
        APTMacroMap map = this.sysAPTData.getMacroMap(sysMacros.toString(), sysMacros);
        return map;
    }

    final APTPreprocHandler getPreprocHandler(CharSequence absPath, PreprocessorStatePair statePair) {
        assert (statePair != null);
        return this.createPreprocHandlerFromState(absPath, statePair.state);
    }

    final APTPreprocHandler createPreprocHandlerFromState(CharSequence absPath, APTPreprocHandler.State state) {
        APTPreprocHandler preprocHandler = this.createEmptyPreprocHandler(absPath);
        if (state != null) {
            if (state.isCleaned()) {
                return this.restorePreprocHandler(absPath, preprocHandler, state);
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("copying state for " + absPath);
            }
            preprocHandler.setState(state);
            return preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.printf("null state for %s, returning default one", absPath);
        }
        return preprocHandler;
    }

    final Collection<PreprocessorStatePair> getPreprocessorStatePairs(CharSequence absPath) {
        return this.getFileContainer().getStatePairs(absPath);
    }

    public final Collection<APTPreprocHandler> getPreprocHandlers(CharSequence absPath) {
        Collection<APTPreprocHandler.State> states = this.getFileContainer().getPreprocStates(absPath);
        ArrayList<APTPreprocHandler> result = new ArrayList<APTPreprocHandler>(states.size());
        for (APTPreprocHandler.State state : states) {
            APTPreprocHandler preprocHandler = this.createEmptyPreprocHandler(absPath);
            if (state != null) {
                if (state.isCleaned()) {
                    preprocHandler = this.restorePreprocHandler(absPath, preprocHandler, state);
                } else {
                    if (TRACE_PP_STATE_OUT) {
                        System.err.println("copying state for " + absPath);
                    }
                    preprocHandler.setState(state);
                }
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.printf("null state for %s, returning default one", absPath);
            }
            result.add(preprocHandler);
        }
        return result;
    }

    public final Collection<APTPreprocHandler.State> getPreprocStates(FileImpl fileImpl) {
        FileContainer fc = this.getFileContainer();
        return fc.getPreprocStates(fileImpl.getAbsolutePath());
    }

    public final CsmFile testAPTParseFile(NativeFileItem item) {
        APTPreprocHandler preprocHandler = this.createPreprocHandler(item);
        return this.findFile(item.getAbsolutePath(), false, Utils.getFileType(item), preprocHandler, true, preprocHandler.getState(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final APTPreprocHandler.State setChangedFileState(NativeFileItem nativeFile) {
        APTPreprocHandler.State state = this.createPreprocHandler(nativeFile).getState();
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry entry = fileContainer.getEntry(nativeFile.getAbsolutePath());
        Object object = entry.getLock();
        synchronized (object) {
            entry.invalidateStates();
            entry.setState(state, FilePreprocessorConditionState.PARSING);
        }
        fileContainer.put();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidatePreprocState(CharSequence absPath) {
        Object stateLock;
        FileContainer fileContainer = this.getFileContainer();
        Object object = stateLock = fileContainer.getLock(absPath);
        synchronized (object) {
            fileContainer.invalidatePreprocState(absPath);
        }
        fileContainer.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markAsParsingPreprocStates(CharSequence absPath) {
        Object stateLock;
        FileContainer fileContainer = this.getFileContainer();
        Object object = stateLock = fileContainer.getLock(absPath);
        synchronized (object) {
            fileContainer.markAsParsingPreprocStates(absPath);
        }
    }

    public final void debugInvalidateFiles() {
        this.getFileContainer().debugClearState();
        for (ProjectBase lib : this.getLibraries()) {
            lib.debugInvalidateFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileImpl onFileIncluded(ProjectBase base, CharSequence file, APTPreprocHandler preprocHandler, PostIncludeData postIncludeState, int mode, boolean triggerParsingActivity) throws IOException {
        if (!ProjectBase.$assertionsDisabled && preprocHandler == null) {
            throw new AssertionError((Object)("null preprocHandler for " + file));
        }
        csmFile = null;
        if (this.isDisposing()) {
            return null;
        }
        modelState = ModelImpl.instance().getState();
        if (modelState == CsmModelState.CLOSING) return null;
        if (modelState == CsmModelState.OFF) {
            return null;
        }
        csmFile = this.findFile(file, true, CsmFile.FileType.HEADER_FILE, preprocHandler, false, null, null);
        if (this.isDisposing()) {
            return csmFile;
        }
        newState = preprocHandler.getState();
        cachedOut = null;
        aptCacheEntry = null;
        pcState = null;
        foundInCache = false;
        if (postIncludeState != null && postIncludeState.hasDeadBlocks()) {
            if (!ProjectBase.$assertionsDisabled && !postIncludeState.hasPostIncludeMacroState()) {
                throw new AssertionError((Object)("how could it be? " + file));
            }
            pcState = FilePreprocessorConditionState.Builder.build(file, postIncludeState.getDeadBlocks());
            preprocHandler.getMacroMap().setState(postIncludeState.getPostIncludeMacroState());
            foundInCache = true;
        }
        v0 = isFileCacheApplicable = mode == 1 && APTHandlersSupport.getIncludeStackDepth((APTPreprocHandler.State)newState) != 0;
        if (!foundInCache && isFileCacheApplicable && (cachedOut = csmFile.getCachedVisitedState(newState)) != null) {
            preprocHandler.getMacroMap().setState(APTHandlersSupport.extractMacroMapState((APTPreprocHandler.State)cachedOut.state));
            pcState = cachedOut.pcState;
            foundInCache = true;
        }
        if (!foundInCache) {
            aptLight = this.getAPTLight(csmFile);
            if (aptLight == null) {
                Utils.LOG.log(Level.INFO, "Can not find or build APT for file {0}", file);
                return csmFile;
            }
            pcBuilder = new FilePreprocessorConditionState.Builder(csmFile.getAbsolutePath());
            aptCacheEntry = csmFile.getAPTCacheEntry(preprocHandler, Boolean.TRUE);
            walker = new APTParseFileWalker(base, aptLight, csmFile, preprocHandler, triggerParsingActivity, (APTParseFileWalker.EvalCallback)pcBuilder, aptCacheEntry);
            walker.visit();
            pcState = pcBuilder.build();
        }
        if (postIncludeState != null && !postIncludeState.hasDeadBlocks()) {
            postIncludeState.setDeadBlocks(FilePreprocessorConditionState.Builder.getDeadBlocks(pcState));
        }
        if (cachedOut == null && isFileCacheApplicable) {
            csmFile.cacheVisitedState(newState, preprocHandler, pcState);
        }
        updateFileContainer = false;
        if (this.isDisposing()) {
            pcBuilder = csmFile;
            if (updateFileContainer == false) return pcBuilder;
        }
        ** GOTO lbl-1000
        this.getFileContainer().put();
        return pcBuilder;
lbl-1000:
        // 1 sources

        {
            if (triggerParsingActivity == false) return csmFile;
            entry = this.getFileContainer().getEntry(csmFile.getAbsolutePath());
            if (entry != null) ** GOTO lbl-1000
            this.entryNotFoundMessage(file);
            var17_18 = csmFile;
            if (updateFileContainer == false) return var17_18;
        }
        this.getFileContainer().put();
        return var17_18;
lbl-1000:
        // 1 sources

        {
            var17_18 = entry.getLock();
            synchronized (var17_18) {
                statesToKeep = new ArrayList<PreprocessorStatePair>(4);
                newStateFound = new AtomicBoolean();
                entryStatePairs = entry.getStatePairs();
                comparisonResult = this.fillStatesToKeepBasedOnPPState(newState, entryStatePairs, statesToKeep, newStateFound);
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file)) {
                    ProjectBase.traceIncludeStates("comparison 2 " + (Object)comparisonResult, csmFile, newState, pcState, newStateFound.get(), null, statesToKeep);
                }
                if (comparisonResult != ComparisonResult.WORSE) ** break block43
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file)) {
                    ProjectBase.traceIncludeStates("worse 2", csmFile, newState, pcState, false, null, statesToKeep);
                }
                var22_23 = csmFile;
            }
            if (updateFileContainer == false) return var22_23;
        }
        this.getFileContainer().put();
        return var22_23;
        {
            if (comparisonResult == ComparisonResult.SAME && newStateFound.get()) {
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file)) {
                    ProjectBase.traceIncludeStates("state is already here ", csmFile, newState, pcState, false, null, statesToKeep);
                }
                var22_24 = csmFile;
                // MONITOREXIT @DISABLED, blocks:[9, 25] lbl82 : MonitorExitStatement: MONITOREXIT : var17_18
                if (updateFileContainer == false) return var22_24;
                this.getFileContainer().put();
                return var22_24;
            }
            if (!ProjectBase.$assertionsDisabled && comparisonResult == ComparisonResult.WORSE) {
                throw new AssertionError();
            }
            statesToParse = new ArrayList<APTPreprocHandler.State>(4);
            statesToParse.add(newState);
            if (comparisonResult == ComparisonResult.BETTER) {
                clean = true;
                CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 2");
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file)) {
                    ProjectBase.traceIncludeStates("best state", csmFile, newState, pcState, clean, statesToParse, statesToKeep);
                }
            } else {
                clean = false;
                comparisonResult = this.fillStatesToKeepBasedOnPCState(pcState, new ArrayList<PreprocessorStatePair>(statesToKeep), statesToKeep);
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file)) {
                    ProjectBase.traceIncludeStates("pc state comparison " + (Object)comparisonResult, csmFile, newState, pcState, clean, statesToParse, statesToKeep);
                }
                switch (3.$SwitchMap$org$netbeans$modules$cnd$modelimpl$csm$core$ProjectBase$ComparisonResult[comparisonResult.ordinal()]) {
                    case 1: {
                        CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 3");
                        clean = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        var24_27 = csmFile;
                        // MONITOREXIT @DISABLED, blocks:[40, 9, 10, 13] lbl111 : MonitorExitStatement: MONITOREXIT : var17_18
                        if (updateFileContainer == false) return var24_27;
                        this.getFileContainer().put();
                        return var24_27;
                    }
                    default: {
                        if (!ProjectBase.$assertionsDisabled) {
                            throw new AssertionError((Object)("unexpected comparison result: " + (Object)comparisonResult));
                        }
                        var24_28 = csmFile;
                        // MONITOREXIT @DISABLED, blocks:[40, 9, 10, 14] lbl119 : MonitorExitStatement: MONITOREXIT : var17_18
                        if (updateFileContainer == false) return var24_28;
                        this.getFileContainer().put();
                        return var24_28;
                    }
                }
            }
            ** try [egrp 7[TRYBLOCK] [12 : 1025->1234)] { 
lbl123:
            // 1 sources

            if (this.isDisposing() != false) return csmFile;
            if (base.isDisposing() != false) return csmFile;
            if (clean) {
                for (PreprocessorStatePair pair : statesToKeep) {
                    if (pair.pcState == FilePreprocessorConditionState.PARSING) continue;
                    statesToParse.add(pair.state);
                }
            }
            csmFile.setAPTCacheEntry(preprocHandler, aptCacheEntry, clean);
            entry.setStates(statesToKeep, new PreprocessorStatePair(newState, pcState));
            ParserQueue.instance().add(csmFile, statesToParse, ParserQueue.Position.HEAD, clean, clean != false ? ParserQueue.FileAction.MARK_REPARSE : ParserQueue.FileAction.MARK_MORE_PARSE);
            csmFile.setAPTCacheEntry(preprocHandler, aptCacheEntry, clean);
            if (ProjectBase.TRACE_FILE && FileImpl.traceFile(file) && (TraceFlags.TRACE_PC_STATE || TraceFlags.TRACE_PC_STATE_COMPARISION)) {
                ProjectBase.traceIncludeStates("scheduling", csmFile, newState, pcState, clean, statesToParse, statesToKeep);
            }
            updateFileContainer = true;
            return csmFile;
lbl140:
            // 1 sources

            finally {
                if (updateFileContainer) {
                    this.getFileContainer().put();
                }
            }
        }
    }

    private void entryNotFoundMessage(CharSequence file) {
        if (Utils.LOG.isLoggable(Level.INFO)) {
            Status st;
            StringBuilder buf = new StringBuilder("File container does not have file ");
            buf.append("[").append(file).append("]");
            if (this.getFileContainer() == FileContainer.empty()) {
                buf.append(" because file container is EMPTY.");
            } else {
                buf.append(".");
            }
            if (this.isDisposing()) {
                buf.append("\n\tIt is very strange but project is disposing.");
            }
            if (!this.isValid()) {
                buf.append("\n\tIt is very strange but project is invalid.");
            }
            if ((st = this.getStatus()) != null) {
                buf.append("\n\tProject ").append(this.toString()).append(" has status ").append((Object)st).append(".");
            }
            Utils.LOG.info(buf.toString());
        }
    }

    private static void traceIncludeStates(CharSequence title, FileImpl file, APTPreprocHandler.State newState, FilePreprocessorConditionState pcState, boolean clean, Collection<APTPreprocHandler.State> statesToParse, Collection<PreprocessorStatePair> statesToKeep) {
        StringBuilder sb = new StringBuilder();
        for (PreprocessorStatePair pair : statesToKeep) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(pair.pcState);
        }
        APTPreprocHandler preprocHandler = file.getProjectImpl(true).createEmptyPreprocHandler(file.getAbsolutePath());
        preprocHandler.setState(newState);
        System.err.printf("%s %s (1) %s\n\tfrom %s \n\t%s %s \n\t%s keeping [%s]\n", title, clean ? "reparse" : "  parse", file.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)newState).getStartFile(), TraceUtils.getPreprocStateString(preprocHandler.getState()), TraceUtils.getMacroString(preprocHandler, TraceFlags.logMacros), pcState, sb);
        if (statesToParse != null) {
            for (APTPreprocHandler.State state : statesToParse) {
                if (newState.equals(state)) continue;
                FilePreprocessorConditionState currPcState = null;
                for (PreprocessorStatePair pair : statesToKeep) {
                    if (!newState.equals(pair.state)) continue;
                    currPcState = pair.pcState;
                    break;
                }
                System.err.printf("%s %s (2) %s \n\tfrom %s\n\t valid %b context %b %s\n", title, "  parse", file.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state).getStartFile(), state.isValid(), state.isCompileContext(), currPcState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setParsedPCState(FileImpl csmFile, APTPreprocHandler.State ppState, FilePreprocessorConditionState pcState) {
        boolean entryFound;
        FileContainer.FileEntry entry = this.getFileContainer().getEntry(csmFile.getAbsolutePath());
        if (entry == null) {
            this.entryNotFoundMessage(csmFile.getAbsolutePath());
            return false;
        }
        Object object = entry.getLock();
        synchronized (object) {
            ArrayList<PreprocessorStatePair> statesToKeep = new ArrayList<PreprocessorStatePair>(4);
            Collection<PreprocessorStatePair> entryStatePairs = entry.getStatePairs();
            if (TraceFlags.TRACE_182342_BUG) {
                System.err.printf("setParsedPCState: original states for file: %s \n with new state: %s\n and pcState: %s\n", csmFile, ppState, pcState);
                if (entryStatePairs.isEmpty()) {
                    System.err.println("NO ORIGINAL STATES");
                } else {
                    int i = 0;
                    for (PreprocessorStatePair preprocessorStatePair : entryStatePairs) {
                        System.err.printf("setParsedPCState: State %d from original %s\n", i++, preprocessorStatePair);
                    }
                }
            }
            ArrayList<PreprocessorStatePair> copy = new ArrayList<PreprocessorStatePair>();
            entryFound = false;
            for (PreprocessorStatePair pair : entryStatePairs) {
                assert (pair != null) : "can not be null element in " + entryStatePairs;
                assert (pair.state != null) : "state can not be null in pair " + pair + " for file " + csmFile;
                if (pair.pcState == FilePreprocessorConditionState.PARSING && APTHandlersSupport.equalsIgnoreInvalid((APTPreprocHandler.State)pair.state, (APTPreprocHandler.State)ppState)) {
                    assert (!entryFound);
                    entryFound = true;
                    continue;
                }
                copy.add(pair);
            }
            if (TraceFlags.TRACE_182342_BUG) {
                System.err.printf("setParsedPCState: %s found PARSING entry for file: %s \n", entryFound ? "" : "NOT", csmFile);
                if (copy.isEmpty()) {
                    System.err.println("NO KEPT STATES");
                } else {
                    int i = 0;
                    for (PreprocessorStatePair preprocessorStatePair : copy) {
                        System.err.printf("setParsedPCState: State %d from copy %s\n", i++, preprocessorStatePair);
                    }
                }
            }
            if (entryFound) {
                ComparisonResult comparisonResult = this.fillStatesToKeepBasedOnPCState(pcState, copy, statesToKeep);
                switch (comparisonResult) {
                    case BETTER: {
                        CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty 3");
                        entry.setStates(statesToKeep, new PreprocessorStatePair(ppState, pcState));
                        break;
                    }
                    case SAME: {
                        assert (!statesToKeep.isEmpty());
                        entry.setStates(statesToKeep, new PreprocessorStatePair(ppState, pcState));
                        break;
                    }
                    case WORSE: {
                        assert (!copy.isEmpty());
                        entry.setStates(copy, null);
                        break;
                    }
                    default: {
                        assert (false) : "unexpected comparison result: " + (Object)((Object)comparisonResult);
                        break;
                    }
                }
            }
        }
        if (entryFound) {
            FileContainer fileContainer = this.getFileContainer();
            fileContainer.put();
        }
        return entryFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnWaitParseLock() {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
    }

    public Iterator<CsmUID<CsmFile>> getFilteredFileUIDs(CsmSelect.NameAcceptor nameFilter) {
        FileContainer fileContainer = this.getFileContainer();
        Collection<CsmUID<CsmFile>> filesUID = fileContainer.getFilesUID();
        ArrayList<CsmUID<CsmFile>> out = new ArrayList<CsmUID<CsmFile>>(filesUID.size());
        for (CsmUID<CsmFile> fileUID : filesUID) {
            CharSequence fileName = FileInfoQueryImpl.getFileName(fileUID);
            if (!nameFilter.accept(fileName)) continue;
            out.add(fileUID);
        }
        return out.iterator();
    }

    protected abstract SourceRootContainer getProjectRoots();

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private ComparisonResult fillStatesToKeepBasedOnPPState(APTPreprocHandler.State newState, Collection<PreprocessorStatePair> oldStates, Collection<PreprocessorStatePair> statesToKeep, AtomicBoolean newStateFound) {
        if (newState == null || !newState.isValid()) {
            return ComparisonResult.WORSE;
        }
        statesToKeep.clear();
        newStateFound.set(false);
        ComparisonResult result = ComparisonResult.SAME;
        for (PreprocessorStatePair pair : oldStates) {
            if (newState.equals(pair.state)) {
                assert (!newStateFound.get());
                newStateFound.set(true);
                continue;
            }
            boolean keep = false;
            if (pair.state != null && pair.state.isValid()) {
                if (pair.state.isCompileContext()) {
                    keep = true;
                    if (!newState.isCompileContext()) {
                        return ComparisonResult.WORSE;
                    }
                } else {
                    boolean bl = keep = !newState.isCompileContext();
                }
            }
            if (keep) {
                if (!pair.state.isCleaned()) {
                    pair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)pair.state), pair.pcState);
                }
                statesToKeep.add(pair);
                result = ComparisonResult.SAME;
                continue;
            }
            CndUtils.assertTrueInConsole((statesToKeep.isEmpty() || !newState.isCompileContext() ? 1 : 0) != 0, (String)"states to keep must be empty for new compile context entry");
            result = statesToKeep.isEmpty() ? ComparisonResult.BETTER : ComparisonResult.SAME;
        }
        if (result == ComparisonResult.BETTER) {
            CndUtils.assertTrueInConsole((boolean)statesToKeep.isEmpty(), (String)"states to keep must be empty ");
        }
        return result;
    }

    private ComparisonResult fillStatesToKeepBasedOnPCState(FilePreprocessorConditionState pcState, List<PreprocessorStatePair> oldStates, List<PreprocessorStatePair> statesToKeep) {
        boolean isSuperset = true;
        statesToKeep.clear();
        int size = oldStates.size();
        for (int i = 0; i < size; ++i) {
            PreprocessorStatePair old = oldStates.get(i);
            if (old.pcState == FilePreprocessorConditionState.PARSING) {
                isSuperset = false;
                if (!old.state.isCleaned()) {
                    old = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)old.state), old.pcState);
                }
                statesToKeep.add(old);
                continue;
            }
            if (old.pcState.isBetterOrEqual(pcState)) {
                return ComparisonResult.WORSE;
            }
            if (pcState.isBetterOrEqual(old.pcState)) continue;
            isSuperset = false;
            if (!old.state.isCleaned()) {
                old = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)old.state), old.pcState);
            }
            statesToKeep.add(old);
        }
        if (isSuperset) {
            assert (statesToKeep.isEmpty()) : "should be empty, but it is: " + Arrays.toString(statesToKeep.toArray());
            return ComparisonResult.BETTER;
        }
        return ComparisonResult.SAME;
    }

    public ProjectBase findFileProject(CharSequence absPath, boolean waitFilesCreated) {
        if (waitFilesCreated) {
            this.ensureFilesCreated();
        }
        if (this.getFileUID(absPath, false) != null) {
            return this;
        }
        for (CsmProject prj : this.getLibraries()) {
            if (waitFilesCreated) {
                ((ProjectBase)prj).ensureFilesCreated();
            }
            if (((ProjectBase)prj).getFileUID(absPath, false) == null) continue;
            return (ProjectBase)prj;
        }
        return null;
    }

    public ProjectBase findFileProject(FSPath fsPath, boolean waitFilesCreated) {
        if (this.getFileSystem() == fsPath.getFileSystem()) {
            if (waitFilesCreated) {
                this.ensureFilesCreated();
            }
            if (this.getFileUID(fsPath.getPath(), false) != null) {
                return this;
            }
        }
        for (CsmProject prj : this.getLibraries()) {
            if (((ProjectBase)prj).getFileSystem() != fsPath.getFileSystem()) continue;
            if (waitFilesCreated) {
                ((ProjectBase)prj).ensureFilesCreated();
            }
            if (((ProjectBase)prj).getFileUID(fsPath.getPath(), false) == null) continue;
            return (ProjectBase)prj;
        }
        return null;
    }

    public final boolean isMySource(String includePath) {
        return this.getProjectRoots().isMySource(includePath);
    }

    public abstract void onFileAdded(NativeFileItem var1);

    public abstract void onFileAdded(List<NativeFileItem> var1);

    public abstract void onFileImplRemoved(Collection<FileImpl> var1);

    public abstract void onFileRemoved(List<NativeFileItem> var1);

    public abstract void onFilePropertyChanged(NativeFileItem var1);

    public abstract void onFilePropertyChanged(List<NativeFileItem> var1);

    protected abstract ParserQueue.Position getIncludedFileParserQueuePosition();

    public abstract NativeFileItem getNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void putNativeFileItem(CsmUID<CsmFile> var1, NativeFileItem var2);

    protected abstract NativeFileItem removeNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void clearNativeFileContainer();

    public final void onFileRemoved(CharSequence absPath) {
        this.onFileImplRemoved(Collections.singletonList(this.getFile(absPath, false)));
    }

    public final void onFileExternalCreate(FileObject file) {
        CndFileUtils.clearFileExistenceCache();
        DeepReparsingUtils.reparseOnAdded(file, this);
    }

    public final void onFileExternalChange(FileImpl file) {
        DeepReparsingUtils.reparseOnChangedFile(file, this);
    }

    public final CsmFile findFile(Object absolutePathOrNativeFileItem, boolean createIfPossible, boolean snapShot) {
        CsmFile res = null;
        if (absolutePathOrNativeFileItem instanceof FSPath) {
            FSPath fsPath = (FSPath)absolutePathOrNativeFileItem;
            if (this.getFileSystem() != fsPath.getFileSystem()) {
                return null;
            }
            absolutePathOrNativeFileItem = fsPath.getPath();
        }
        if (absolutePathOrNativeFileItem instanceof CharSequence) {
            res = this.findFileByPath((CharSequence)absolutePathOrNativeFileItem, createIfPossible);
        } else if (absolutePathOrNativeFileItem instanceof NativeFileItem) {
            res = this.findFileByItem((NativeFileItem)absolutePathOrNativeFileItem, createIfPossible);
        }
        if (snapShot && res instanceof FileImpl) {
            res = ((FileImpl)res).getSnapshot();
        }
        return res;
    }

    final int getFileContainerSize() {
        return this.getFileContainer().getSize();
    }

    private CsmFile findFileByPath(CharSequence absolutePath, boolean createIfPossible) {
        absolutePath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)((Object)absolutePath).toString());
        APTPreprocHandler preprocHandler = null;
        if (this.getFileContainer().getEntry(absolutePath) == null) {
            NativeProject prj;
            if (!createIfPossible) {
                return null;
            }
            NativeFileItem nativeFile = null;
            if (this.getPlatformProject() instanceof NativeProject && (prj = (NativeProject)this.getPlatformProject()) != null) {
                FileObject fo = CndFileUtils.toFileObject((FileSystem)prj.getFileSystem(), (CharSequence)((Object)absolutePath).toString());
                if (fo != null) {
                    nativeFile = prj.findFileItem(fo);
                }
                if (nativeFile == null) {
                    return null;
                }
                if (!Utils.acceptNativeItem(nativeFile)) {
                    return null;
                }
                preprocHandler = this.createPreprocHandler(nativeFile);
            }
            if (preprocHandler != null) {
                return this.findFile(absolutePath, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, preprocHandler.getState(), nativeFile);
            }
        }
        return this.findFile(absolutePath, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, null, null);
    }

    private CsmFile findFileByItem(NativeFileItem nativeFile, boolean createIfPossible) {
        String file = nativeFile.getAbsolutePath();
        APTPreprocHandler preprocHandler = null;
        if (this.getFileContainer().getEntry(file) == null) {
            NativeProject prj;
            if (!createIfPossible || !Utils.acceptNativeItem(nativeFile)) {
                return null;
            }
            if (this.getPlatformProject() instanceof NativeProject && (prj = nativeFile.getNativeProject()) != null && nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
                preprocHandler = this.createPreprocHandler(nativeFile);
            }
            if (preprocHandler != null) {
                return this.findFile(file, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, preprocHandler.getState(), nativeFile);
            }
        }
        return this.findFile(file, false, CsmFile.FileType.UNDEFINED_FILE, preprocHandler, true, null, null);
    }

    protected final FileImpl findFile(CharSequence absPath, boolean treatSymlinkAsSeparateFile, CsmFile.FileType fileType, APTPreprocHandler preprocHandler, boolean scheduleParseIfNeed, APTPreprocHandler.State initial, NativeFileItem nativeFileItem) {
        FileImpl impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
        if (impl == null) {
            CndUtils.assertTrueInConsole((preprocHandler != null ? 1 : 0) != 0, (String)"null preprocHandler");
            if (preprocHandler == null) {
                Collection<APTPreprocHandler.State> preprocStates = this.getFileContainer().getPreprocStates(absPath);
                APTPreprocHandler.State state = preprocStates.isEmpty() ? null : preprocStates.iterator().next();
                preprocHandler = this.createPreprocHandlerFromState(absPath, state);
            }
            impl = this.findFileImpl(absPath, treatSymlinkAsSeparateFile, fileType, preprocHandler, scheduleParseIfNeed, initial, nativeFileItem);
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl findFileImpl(CharSequence absPath, boolean treatSymlinkAsSeparateFile, CsmFile.FileType fileType, APTPreprocHandler preprocHandler, boolean scheduleParseIfNeed, APTPreprocHandler.State initial, NativeFileItem nativeFileItem) {
        FileImpl impl = null;
        boolean create = false;
        Object object = this.fileContainerLock;
        synchronized (object) {
            impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
            if (impl == null) {
                create = true;
            }
        }
        if (create) {
            assert (preprocHandler != null) : "null preprocHandler for " + absPath;
            FileObject fo = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)absPath);
            CndUtils.assertTrueInConsole((fo != null ? 1 : 0) != 0, (String)"file object not found ", (Object)absPath);
            FileBuffer fileBuffer = ModelSupport.createFileBuffer(fo);
            Object object2 = this.fileContainerLock;
            synchronized (object2) {
                impl = this.getFile(absPath, treatSymlinkAsSeparateFile);
                if (impl == null) {
                    impl = new FileImpl(fileBuffer, this, fileType, nativeFileItem);
                    if (nativeFileItem != null) {
                        this.putNativeFileItem(impl.getUID(), nativeFileItem);
                    }
                    this.putFile(impl, initial);
                    if (scheduleParseIfNeed) {
                        APTPreprocHandler.State ppState = preprocHandler.getState();
                        ParserQueue.instance().add(impl, ppState, ParserQueue.Position.TAIL);
                    }
                }
            }
        }
        if (fileType == CsmFile.FileType.SOURCE_FILE && !impl.isSourceFile()) {
            impl.setSourceFile();
        } else if (fileType == CsmFile.FileType.HEADER_FILE && !impl.isHeaderFile()) {
            impl.setHeaderFile();
        }
        return impl;
    }

    protected final FileImpl createOrFindFileImpl(FileBuffer buf, NativeFileItem nativeFile) {
        return this.createOrFindFileImpl(buf, nativeFile, Utils.getFileType(nativeFile)).fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAndHandler createOrFindFileImpl(FileBuffer buf, NativeFileItem nativeFile, CsmFile.FileType fileType) {
        APTPreprocHandler preprocHandler = null;
        CharSequence absPath = buf.getAbsolutePath();
        FileImpl impl = this.getFile(absPath, true);
        CsmUID<CsmFile> aUid = null;
        if (impl == null) {
            preprocHandler = this.createPreprocHandler(nativeFile);
            Object object = this.fileContainerLock;
            synchronized (object) {
                impl = this.getFile(absPath, true);
                if (impl == null) {
                    assert (preprocHandler != null);
                    impl = new FileImpl(buf, this, fileType, nativeFile);
                    this.putFile(impl, preprocHandler.getState());
                } else {
                    aUid = impl.getUID();
                }
            }
        } else {
            aUid = impl.getUID();
        }
        if (aUid != null) {
            this.putNativeFileItem(aUid, nativeFile);
        }
        return new FileAndHandler(impl, preprocHandler);
    }

    public final FileImpl getFile(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        return this.getFileContainer().getFile(absPath, treatSymlinkAsSeparateFile);
    }

    public final CsmUID<CsmFile> getFileUID(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        return this.getFileContainer().getFileUID(absPath, treatSymlinkAsSeparateFile);
    }

    protected final void removeFile(CharSequence file) {
        this.getFileContainer().removeFile(file);
    }

    protected final void putFile(FileImpl impl, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putFile(impl, state);
    }

    protected Collection<Key> getLibrariesKeys() {
        ArrayList<Key> res = new ArrayList<Key>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject nativeProject : ((NativeProject)this.platformProject).getDependences()) {
                Key key = ProjectBase.createProjectKey(nativeProject.getFileSystem(), nativeProject);
                if (key == null) continue;
                res.add(key);
            }
        }
        if (!this.isArtificial()) {
            for (CsmUID csmUID : LibraryManager.getInstance().getLirariesKeys(this.getUID())) {
                res.add(RepositoryUtils.UIDtoKey(csmUID));
            }
        }
        return res;
    }

    public List<CsmProject> getLibraries() {
        int i;
        int size;
        ArrayList<CsmProject> res = new ArrayList<CsmProject>();
        if (this.platformProject instanceof NativeProject) {
            List dependences = ((NativeProject)this.platformProject).getDependences();
            size = dependences.size();
            for (i = 0; i < size; ++i) {
                NativeProject nativeLib = (NativeProject)dependences.get(i);
                CsmProject prj = this.model.findProject(nativeLib);
                if (prj == null) continue;
                res.add(prj);
            }
        }
        if (!this.isArtificial()) {
            List<LibProjectImpl> libraries = LibraryManager.getInstance().getLibraries((ProjectImpl)this);
            size = libraries.size();
            for (i = 0; i < size; ++i) {
                res.add(libraries.get(i));
            }
        }
        return res;
    }

    public final List<ProjectBase> getDependentProjects() {
        ArrayList<ProjectBase> res = new ArrayList<ProjectBase>();
        for (CsmProject prj : this.model.projects()) {
            if (!(prj instanceof ProjectBase) || !prj.getLibraries().contains(this)) continue;
            res.add((ProjectBase)prj);
        }
        return res;
    }

    public final CsmClass getDummyForUnresolved(CharSequence[] nameTokens, CsmFile file, int offset) {
        if (Diagnostic.needStatistics()) {
            Diagnostic.onUnresolvedError(nameTokens, file, offset);
        }
        return this.getUnresolved().getDummyForUnresolved(nameTokens);
    }

    public final CsmClass getDummyForUnresolved(CharSequence name) {
        return this.getUnresolved().getDummyForUnresolved(name);
    }

    public final CsmNamespace getUnresolvedNamespace() {
        return this.getUnresolved().getUnresolvedNamespace();
    }

    public final CsmFile getUnresolvedFile() {
        return this.getUnresolved().getUnresolvedFile();
    }

    private synchronized Unresolved getUnresolved() {
        if (this.unresolved == null) {
            this.unresolved = new Unresolved(this);
        }
        return this.unresolved;
    }

    public final boolean isValid() {
        return this.platformProject != null && !this.isDisposing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisposed() {
        this.disposing.set(true);
        Object object = this.initializationTaskLock;
        synchronized (object) {
            if (this.initializationTask != null) {
                this.initializationTask.cancel();
                this.initializationTask = null;
            }
        }
        this.unregisterProjectListeners();
        ParserQueue.instance().removeAll(this);
    }

    public final boolean isDisposing() {
        return this.disposing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(boolean cleanPersistent) {
        long time = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("\n\nProject %s: disposing...\n", this.name);
            time = System.currentTimeMillis();
        }
        this.setDisposed();
        try {
            this.disposeLock.writeLock().lock();
            ProjectSettingsValidator validator = new ProjectSettingsValidator(this);
            validator.storeSettings();
            this.getUnresolved().dispose();
            RepositoryUtils.closeUnit(this.getUID(), this.getRequiredUnits(), cleanPersistent);
            this.platformProject = null;
            this.unresolved = null;
            this.uid = null;
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
        if (TraceFlags.TIMING) {
            time = System.currentTimeMillis() - time;
            System.err.printf("Project %s: disposing took %d ms\n", this.name, time);
        }
    }

    protected final Set<CharSequence> getRequiredUnits() {
        HashSet<CharSequence> requiredUnits = new HashSet<CharSequence>();
        for (Key dependent : this.getLibrariesKeys()) {
            requiredUnits.add(dependent.getUnit());
        }
        return requiredUnits;
    }

    private NamespaceImpl _getGlobalNamespace() {
        NamespaceImpl ns = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.globalNamespaceUID);
        if (ns == null && this.preventMultiplyDiagnosticExceptionsGlobalNamespace < 5) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get global namespace by key " + this.globalNamespaceUID));
            ++this.preventMultiplyDiagnosticExceptionsGlobalNamespace;
        }
        return ns != null ? ns : this.FAKE_GLOBAL_NAMESPACE;
    }

    private NamespaceImpl _getNamespace(CharSequence key) {
        key = CharSequences.create((CharSequence)key);
        CsmUID<CsmNamespace> nsUID = this.namespaces.get(key);
        NamespaceImpl ns = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(nsUID);
        return ns;
    }

    private void _registerNamespace(NamespaceImpl ns) {
        assert (ns != null);
        CharSequence key = ns.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)key));
        CsmUID<NamespaceImpl> nsUID = RepositoryUtils.put(ns);
        assert (nsUID != null);
        this.namespaces.put(key, nsUID);
    }

    private void _unregisterNamespace(NamespaceImpl ns) {
        assert (ns != null);
        assert (!ns.isGlobal());
        CharSequence key = ns.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)key));
        CsmUID<CsmNamespace> nsUID = this.namespaces.remove(key);
        assert (nsUID != null);
        RepositoryUtils.remove(nsUID, ns);
    }

    protected final ModelImpl getModel() {
        return this.model;
    }

    public void onFileEditStart(FileBuffer buf, NativeFileItem nativeFile) {
    }

    public void onFileEditEnd(FileBuffer buf, NativeFileItem nativeFile, boolean undo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmProject> getUID() {
        CsmUID<CsmProject> out = this.uid;
        if (out == null) {
            ProjectBase projectBase = this;
            synchronized (projectBase) {
                if (this.uid == null) {
                    this.uid = out = UIDUtilities.createProjectUID(this);
                }
            }
        }
        return this.uid;
    }

    public boolean isStable(CsmFile skipFile) {
        if (this.status == Status.Ready && !this.isDisposing()) {
            return !ParserQueue.instance().hasPendingProjectRelatedWork(this, (FileImpl)skipFile);
        }
        return false;
    }

    public final void onParseFinish() {
        this.onParseFinishImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onParseFinishImpl(boolean libsAlreadyParsed) {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
        try {
            this.disposeLock.readLock().lock();
            if (!this.isDisposing() && !this.hasEditedFiles()) {
                new FakeRegistrationWorker(this, this.disposing).fixFakeRegistration(libsAlreadyParsed);
            }
        }
        catch (Exception e) {
            DiagnosticExceptoins.register(e);
        }
        finally {
            this.disposeLock.readLock().unlock();
            ProjectComponent.setStable(this.declarationsSorageKey);
            ProjectComponent.setStable(this.fileContainerKey);
            ProjectComponent.setStable(this.graphStorageKey);
            ProjectComponent.setStable(this.classifierStorageKey);
            ProjectBase.checkStates(this, libsAlreadyParsed);
            if (!libsAlreadyParsed) {
                ParseFinishNotificator.onParseFinish(this);
            }
        }
        if (TraceFlags.PARSE_STATISTICS) {
            ParseStatistics.getInstance().printResults(this);
            ParseStatistics.getInstance().clear(this);
        }
    }

    private static void checkStates(ProjectBase prj, boolean libsAlreadyParsed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trackFakeFunctionAST(CsmUID<CsmFile> fileUID, CsmUID<FunctionImplEx<?>> funUID, AST funAST) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, AST> fileASTs = this.fakeASTs.get(fileUID);
            if (fileASTs == null) {
                fileASTs = new HashMap();
                if (funAST != null) {
                    this.fakeASTs.put(fileUID, fileASTs);
                }
            }
            if (funAST == null) {
                fileASTs.remove(funUID);
            } else {
                fileASTs.put(funUID, funAST);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST(CsmUID<CsmFile> fileUID) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            this.fakeASTs.remove(fileUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST() {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            this.fakeASTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AST getFakeFunctionAST(CsmUID<CsmFile> fileUID, CsmUID<FunctionImplEx<?>> fakeUid) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, AST> fileASTs = this.fakeASTs.get(fileUID);
            return fileASTs == null ? null : fileASTs.get(fakeUid);
        }
    }

    final void onLibParseFinish() {
        this.onParseFinishImpl(true);
    }

    public final Collection<CsmFile> getAllFiles() {
        return this.getFileContainer().getFiles();
    }

    public final Collection<CsmUID<CsmFile>> getAllFilesUID() {
        return this.getFileContainer().getFilesUID();
    }

    public final Collection<FileImpl> getAllFileImpls() {
        return this.getFileContainer().getFileImpls();
    }

    public final Collection<CsmFile> getSourceFiles() {
        ArrayList uids = new ArrayList();
        for (FileImpl file : this.getAllFileImpls()) {
            if (!file.isSourceFile()) continue;
            uids.add(file.getUID());
        }
        return new LazyCsmCollection(uids, TraceFlags.SAFE_UID_ACCESS);
    }

    public final Collection<CsmFile> getHeaderFiles() {
        ArrayList uids = new ArrayList();
        for (FileImpl file : this.getAllFileImpls()) {
            if (file.isSourceFile()) continue;
            uids.add(file.getUID());
        }
        return new LazyCsmCollection(uids, TraceFlags.SAFE_UID_ACCESS);
    }

    public final long getMemoryUsageEstimation() {
        return this.getFileContainer().getSize();
    }

    public final String toString() {
        return ((Object)this.getName()).toString() + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = super.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    private StartEntryInfo getStartEntryInfo(APTPreprocHandler preprocHandler, APTPreprocHandler.State state) {
        NativeFileItem nativeFile;
        FileImpl csmFile;
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase startProject = Utils.getStartProject(startEntry);
        FileImpl fileImpl = csmFile = startProject == null ? null : startProject.getFile(startEntry.getStartFile(), false);
        if (csmFile != null && (nativeFile = csmFile.getNativeFileItem()) != null && nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
            preprocHandler = startProject.createPreprocHandler(nativeFile);
        }
        return new StartEntryInfo(preprocHandler, startProject, csmFile);
    }

    private APTPreprocHandler restorePreprocHandler(CharSequence interestedFile, APTPreprocHandler preprocHandler, APTPreprocHandler.State state) {
        assert (state != null);
        assert (state.isCleaned());
        LinkedList reverseInclStack = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
        assert (reverseInclStack != null);
        if (reverseInclStack.isEmpty()) {
            if (TRACE_PP_STATE_OUT) {
                System.err.println("stack is empty; return default for " + interestedFile);
            }
            return this.getStartEntryInfo(preprocHandler, state).preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.println("restoring for " + interestedFile);
        }
        return this.restorePreprocHandlerFromIncludeStack(reverseInclStack, interestedFile, preprocHandler, state);
    }

    protected final APTPreprocHandler restorePreprocHandlerFromIncludeStack(LinkedList<APTIncludeHandler.IncludeInfo> reverseInclStack, CharSequence interestedFile, APTPreprocHandler preprocHandler, APTPreprocHandler.State state) {
        assert (!reverseInclStack.isEmpty()) : "state of stack is " + reverseInclStack;
        LinkedList<APTIncludeHandler.IncludeInfo> inclStack = Utils.reverse(reverseInclStack);
        StartEntryInfo sei = this.getStartEntryInfo(preprocHandler, state);
        FileImpl csmFile = sei.csmFile;
        ProjectBase startProject = sei.startProject;
        preprocHandler = sei.preprocHandler;
        APTFile aptLight = null;
        try {
            aptLight = csmFile == null ? null : this.getAPTLight(csmFile);
        }
        catch (IOException ex) {
            System.err.println("can't restore preprocessor state for " + interestedFile + "\nreason: " + ex.getMessage());
            DiagnosticExceptoins.register(ex);
        }
        boolean ppStateRestored = false;
        if (aptLight != null) {
            long time = REMEMBER_RESTORED ? System.currentTimeMillis() : 0L;
            int stackSize = inclStack.size();
            APTFileCacheEntry cacheEntry = csmFile.getAPTCacheEntry(preprocHandler, Boolean.FALSE);
            APTRestorePreprocStateWalker walker = new APTRestorePreprocStateWalker(startProject, aptLight, csmFile, preprocHandler, inclStack, ((Object)FileContainer.getFileKey(interestedFile, false)).toString(), cacheEntry);
            walker.visit();
            if (preprocHandler.isValid()) {
                if (REMEMBER_RESTORED) {
                    if (testRestoredFiles == null) {
                        testRestoredFiles = new ArrayList<String>();
                    }
                    FileImpl interestedFileImpl = this.getFile(interestedFile, false);
                    assert (interestedFileImpl != null);
                    String msg = interestedFile + " [" + (interestedFileImpl.isHeaderFile() ? "H" : (interestedFileImpl.isSourceFile() ? "S" : "U")) + "]";
                    time = System.currentTimeMillis() - time;
                    msg = msg + " within " + time + "ms" + " stack " + stackSize + " elems";
                    System.err.println("#" + testRestoredFiles.size() + " restored: " + msg);
                    testRestoredFiles.add(msg);
                }
                if (TRACE_PP_STATE_OUT) {
                    System.err.println("after restoring " + preprocHandler);
                }
                ppStateRestored = true;
            }
        }
        if (!ppStateRestored) {
            if (startProject == null) {
                startProject = this;
            }
            preprocHandler = startProject.createDefaultPreprocHandler(interestedFile);
        }
        return preprocHandler;
    }

    private NativeProject findNativeProjectHolder(Set<ProjectBase> visited) {
        NativeProject nativeProject;
        block1: {
            visited.add(this);
            nativeProject = ModelSupport.getNativeProject(this.getPlatformProject());
            if (nativeProject != null) break block1;
            List<ProjectBase> deps = this.getDependentProjects();
            for (ProjectBase dependentPrj : deps) {
                if (!visited.contains(dependentPrj) && (nativeProject = dependentPrj.findNativeProjectHolder(visited)) != null) break;
            }
        }
        return nativeProject;
    }

    private APTPreprocHandler createDefaultPreprocHandler(CharSequence interestedFile) {
        NativeProject nativeProject = this.findNativeProjectHolder(new HashSet<ProjectBase>(10));
        APTPreprocHandler out = null;
        if (nativeProject != null) {
            DefaultFileItem item = new DefaultFileItem(nativeProject, ((Object)interestedFile).toString());
            out = this.createPreprocHandler(item);
        } else {
            out = this.createEmptyPreprocHandler(interestedFile);
        }
        assert (out != null) : "failed creating default ppState for " + interestedFile;
        return out;
    }

    public final APTFile getAPTLight(CsmFile csmFile) throws IOException {
        APTFile aptLight = null;
        aptLight = APTDriver.findAPTLight((APTFileBuffer)((FileImpl)csmFile).getBuffer());
        return aptLight;
    }

    public final GraphContainer getGraph() {
        return this.getGraphStorage();
    }

    public static List<String> testGetRestoredFiles() {
        return testRestoredFiles;
    }

    public void write(RepositoryDataOutput aStream) throws IOException {
        assert (aStream != null);
        PersistentUtils.writeFileSystem(this.fileSystem, aStream);
        UIDObjectFactory aFactory = UIDObjectFactory.getDefaultFactory();
        assert (aFactory != null);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, aStream);
        aFactory.writeUID(this.globalNamespaceUID, aStream);
        aFactory.writeStringToUIDMap(this.namespaces, aStream, false);
        ProjectComponent.writeKey(this.fileContainerKey, aStream);
        ProjectComponent.writeKey(this.declarationsSorageKey, aStream);
        ProjectComponent.writeKey(this.graphStorageKey, aStream);
        ProjectComponent.writeKey(this.classifierStorageKey, aStream);
        PersistentUtils.writeUTF(this.uniqueName, aStream);
        aStream.writeBoolean(this.hasFileSystemProblems);
    }

    protected ProjectBase(RepositoryDataInput aStream) throws IOException {
        this.fileSystem = PersistentUtils.readFileSystem(aStream);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.setStatus(Status.Restored);
        assert (aStream != null);
        UIDObjectFactory aFactory = UIDObjectFactory.getDefaultFactory();
        assert (aFactory != null) : "default UID factory can not be bull";
        this.name = PersistentUtils.readUTF(aStream, ProjectNameCache.getManager());
        assert (this.name != null) : "project name can not be null";
        this.globalNamespaceUID = aFactory.readUID(aStream);
        assert (this.globalNamespaceUID != null) : "globalNamespaceUID can not be null";
        int collSize = aStream.readInt();
        this.namespaces = collSize <= 0 ? new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(0) : new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(collSize);
        aFactory.readStringToUIDMap(this.namespaces, aStream, QualifiedNameCache.getManager(), collSize);
        this.fileContainerKey = ProjectComponent.readKey(aStream);
        assert (this.fileContainerKey != null) : "fileContainerKey can not be null";
        this.weakFileContainer = new WeakContainer(this, this.fileContainerKey);
        this.declarationsSorageKey = ProjectComponent.readKey(aStream);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.weakDeclarationContainer = new WeakContainer(this, this.declarationsSorageKey);
        this.graphStorageKey = ProjectComponent.readKey(aStream);
        assert (this.graphStorageKey != null) : "graphStorageKey can not be null";
        this.weakGraphContainer = new WeakContainer(this, this.graphStorageKey);
        this.classifierStorageKey = ProjectComponent.readKey(aStream);
        assert (this.classifierStorageKey != null) : "classifierStorageKey can not be null";
        this.weakClassifierContainer = new WeakContainer(this, this.classifierStorageKey);
        this.uniqueName = PersistentUtils.readUTF(aStream, ProjectNameCache.getManager());
        assert (this.uniqueName != null) : "uniqueName can not be null";
        this.model = (ModelImpl)CsmModelAccessor.getModel();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
        this.hasFileSystemProblems = aStream.readBoolean();
    }

    DeclarationContainerProject getDeclarationsSorage() {
        DeclarationContainerProject dc = this.weakDeclarationContainer.getContainer();
        return dc != null ? dc : DeclarationContainerProject.empty();
    }

    FileContainer getFileContainer() {
        FileContainer fc = this.weakFileContainer.getContainer();
        return fc != null ? fc : FileContainer.empty();
    }

    public void traceFileContainer(PrintWriter err) {
        FileContainer container = this.getFileContainer();
        Set<Map.Entry<CharSequence, FileContainer.FileEntry>> entrySet = container.getFileStorage().entrySet();
        err.printf("FileContainer (%d) for project %s\n", entrySet.size(), this.toString());
        for (Map.Entry<CharSequence, FileContainer.FileEntry> entry : entrySet) {
            err.println("\tEntry " + entry.getKey());
            if (entry.getValue().getStatePairs().isEmpty()) {
                err.println("\t\tState EMPTY");
                continue;
            }
            block1: for (PreprocessorStatePair pair : entry.getValue().getStatePairs()) {
                err.println("\t\tState");
                String text = pair.toString();
                StringTokenizer st = new StringTokenizer(text, "\n");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if ("Snapshot".equals(s)) {
                        err.println("\t\t\t" + s + "{...}");
                        continue block1;
                    }
                    err.println("\t\t\t" + s);
                }
            }
        }
    }

    public final GraphContainer getGraphStorage() {
        GraphContainer gc = this.weakGraphContainer.getContainer();
        return gc != null ? gc : GraphContainer.empty();
    }

    final ClassifierContainer getClassifierSorage() {
        ClassifierContainer cc = this.weakClassifierContainer.getContainer();
        return cc != null ? cc : ClassifierContainer.empty();
    }

    public void traceProjectContainers(PrintStream printStream) {
        ProjectBase.dumpProjectContainers(this.getClassifierSorage(), printStream);
        ProjectBase.dumpProjectContainers(this.getDeclarationsSorage(), printStream);
    }

    private static void dumpProjectContainers(ClassifierContainer container, PrintStream printStream) {
        printStream.println("\n========== Dumping Dump Project Classifiers");
        for (Map.Entry<CharSequence, CsmClassifier> entry : container.getClassifiers().entrySet()) {
            printStream.print("\t" + ((Object)entry.getKey()).toString() + " ");
            if (entry.getValue() == null) {
                printStream.println("null");
                continue;
            }
            printStream.println(entry.getValue().getUniqueName());
        }
        printStream.println("\n========== Dumping Dump Project Typedefs");
        for (Map.Entry<CharSequence, CsmClassifier> entry : container.getTypedefs().entrySet()) {
            printStream.print("\t" + ((Object)entry.getKey()).toString() + " ");
            if (entry.getValue() == null) {
                printStream.println("null");
                continue;
            }
            printStream.println(entry.getValue().getUniqueName());
        }
    }

    private static void dumpProjectContainers(DeclarationContainerProject container, PrintStream printStream) {
        TreeMap<CharSequence, Object> set;
        printStream.println("\n========== Dumping Project declarations");
        for (Map.Entry<CharSequence, Object> entry : container.testDeclarations().entrySet()) {
            printStream.println("\t" + ((Object)entry.getKey()).toString());
            set = new TreeMap<CharSequence, Object>();
            Object o = entry.getValue();
            if (o instanceof CsmUID[]) {
                CsmUID[] csmUIDArray;
                for (CsmUID uidt : csmUIDArray = (CsmUID[])o) {
                    set.put(((CsmOffsetableDeclaration)uidt.getObject()).getContainingFile().getAbsolutePath(), uidt.getObject());
                }
            } else if (o instanceof CsmUID) {
                CsmUID csmUID = (CsmUID)o;
                set.put(((CsmOffsetableDeclaration)csmUID.getObject()).getContainingFile().getAbsolutePath(), csmUID.getObject());
            }
            for (Map.Entry entry2 : set.entrySet()) {
                printStream.println("\t\t" + entry2.getValue() + " from " + entry2.getKey());
            }
        }
        printStream.println("\n========== Dumping Project friends");
        for (Map.Entry<CharSequence, Object> entry : container.testFriends().entrySet()) {
            printStream.println("\t" + ((Object)entry.getKey()).toString());
            set = new TreeMap();
            for (CsmUID csmUID : (Set)entry.getValue()) {
                CsmFriend csmFriend = (CsmFriend)csmUID.getObject();
                set.put(csmFriend.getQualifiedName(), csmFriend);
            }
            for (Map.Entry entry3 : set.entrySet()) {
                printStream.println("\t\t" + entry3.getKey() + " " + entry3.getValue());
            }
        }
    }

    public static final class WeakContainer<T> {
        private WeakReference<T> weakContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
        private int preventMultiplyDiagnosticExceptionsSorage = 0;
        private final ProjectBase project;
        private final Key sorageKey;

        public WeakContainer(ProjectBase project, Key sorageKey) {
            this.project = project;
            this.sorageKey = sorageKey;
        }

        synchronized void clear() {
            if (TraceFlags.USE_WEAK_MEMORY_CACHE) {
                this.weakContainer.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getContainer() {
            Object container = this.getFromRef();
            if (container != null) {
                return container;
            }
            WeakContainer weakContainer = this;
            synchronized (weakContainer) {
                container = this.getFromRef();
                if (container != null) {
                    return container;
                }
                container = RepositoryUtils.get(this.sorageKey);
                if (container == null && this.project.isValid() && this.preventMultiplyDiagnosticExceptionsSorage < 3) {
                    DiagnosticExceptoins.register(new IllegalStateException("Failed to get container sorage by key " + this.sorageKey));
                    ++this.preventMultiplyDiagnosticExceptionsSorage;
                }
                if (TraceFlags.USE_WEAK_MEMORY_CACHE && container != null && this.weakContainer != null) {
                    this.weakContainer = new WeakReference<T>(container);
                }
                return container;
            }
        }

        private T getFromRef() {
            WeakReference<T> weak = null;
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.project.isValid() && (weak = this.weakContainer) != null) {
                return weak.get();
            }
            return null;
        }
    }

    private static final class FileContainerLock {
        private FileContainerLock() {
        }
    }

    private static final class NamespaceLock {
        private NamespaceLock() {
        }
    }

    private static final class ClassifierReplaceLock {
        private ClassifierReplaceLock() {
        }
    }

    private static final class WaitParseLock {
        private WaitParseLock() {
        }
    }

    private static final class InitializationTaskLock {
        private InitializationTaskLock() {
        }
    }

    protected static enum Status {
        Initial,
        Restored,
        AddingFiles,
        Validating,
        Ready;

    }

    private static final class DefaultFileItem
    implements NativeFileItem {
        private final NativeProject project;
        private final String normalizedAbsPath;

        public DefaultFileItem(NativeProject project, String absolutePath) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"absolutePath", (Object)absolutePath);
            this.project = project;
            this.normalizedAbsPath = CndFileUtils.normalizeAbsolutePath((FileSystem)project.getFileSystem(), (String)absolutePath);
        }

        public DefaultFileItem(NativeFileItem nativeFile) {
            Parameters.notNull((CharSequence)"nativeFile", (Object)nativeFile);
            this.project = nativeFile.getNativeProject();
            this.normalizedAbsPath = nativeFile.getAbsolutePath();
            CndUtils.assertNormalized((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
            Parameters.notNull((CharSequence)"nativeFile.getAbsolutePath()", (Object)this.normalizedAbsPath);
        }

        public static NativeFileItem toDefault(NativeFileItem nativeFile) {
            if (!(nativeFile instanceof DefaultFileItem)) {
                nativeFile = new DefaultFileItem(nativeFile);
            }
            return nativeFile;
        }

        public List<String> getUserMacroDefinitions() {
            if (this.project != null) {
                return this.project.getUserMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getUserIncludePaths() {
            if (this.project != null) {
                return this.project.getUserIncludePaths();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemMacroDefinitions() {
            if (this.project != null) {
                return this.project.getSystemMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getSystemIncludePaths() {
            if (this.project != null) {
                return this.project.getSystemIncludePaths();
            }
            return Collections.emptyList();
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return CndFileUtils.toFileObject((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
        }

        public String getAbsolutePath() {
            return this.normalizedAbsPath;
        }

        public String getName() {
            return CndPathUtilitities.getBaseName((String)this.normalizedAbsPath);
        }

        public NativeFileItem.Language getLanguage() {
            return NativeFileItem.Language.C_HEADER;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.normalizedAbsPath + ' ' + this.project.getFileSystem().getDisplayName();
        }
    }

    private static class StartEntryInfo {
        private final APTPreprocHandler preprocHandler;
        private final ProjectBase startProject;
        private final FileImpl csmFile;

        public StartEntryInfo(APTPreprocHandler preprocHandler, ProjectBase startProject, FileImpl csmFile) {
            this.preprocHandler = preprocHandler;
            this.startProject = startProject;
            this.csmFile = csmFile;
        }
    }

    private static class FileAndHandler {
        private final FileImpl fileImpl;
        private APTPreprocHandler preprocHandler;

        public FileAndHandler(FileImpl fileImpl, APTPreprocHandler preprocHandler) {
            this.fileImpl = fileImpl;
            this.preprocHandler = preprocHandler;
        }
    }

    private static enum ComparisonResult {
        BETTER,
        SAME,
        WORSE;

    }
}

