/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Line2Offset;
import org.openide.filesystems.FileSystem;

public final class FileBufferSnapshot
implements APTFileBuffer {
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private final char[] buffer;
    private final long timeStamp;
    private Reference<Line2Offset> lines;
    private final APTFileBuffer.BufferType bufType;

    public FileBufferSnapshot(FileSystem fileSystem, CharSequence absPath, APTFileBuffer.BufferType bufType, char[] buffer, int[] linesCache, long timeStamp) {
        this.absPath = absPath;
        this.fileSystem = fileSystem;
        this.buffer = buffer;
        this.timeStamp = timeStamp;
        this.lines = linesCache != null ? new WeakReference<Line2Offset>(new Line2Offset(buffer, linesCache)) : new WeakReference<Object>(null);
        this.bufType = bufType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public APTFileBuffer.BufferType getType() {
        return this.bufType;
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public char[] getCharBuffer() throws IOException {
        return this.buffer;
    }

    public int[] getLineColumnByOffset(int offset) throws IOException {
        return this.getLine2Offset().getLineColumnByOffset(offset);
    }

    public int getOffsetByLineColumn(int line, int column) throws IOException {
        return this.getLine2Offset().getOffsetByLineColumn(line, column);
    }

    private Line2Offset getLine2Offset() throws IOException {
        Line2Offset lines2Offset = null;
        Reference<Line2Offset> aLines = this.lines;
        if (aLines != null) {
            lines2Offset = aLines.get();
        }
        if (lines2Offset == null) {
            lines2Offset = new Line2Offset(this.getText());
            this.lines = new WeakReference<Line2Offset>(lines2Offset);
        }
        return lines2Offset;
    }

    public String getText(int start, int end) {
        return new String(this.buffer, start, end - start);
    }

    public String getText() {
        return new String(this.buffer);
    }
}

