/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.CharSequences;

public final class SystemMacroImpl
implements CsmMacro,
CsmIdentifiable {
    private final CharSequence macroName;
    private final CharSequence macroBody;
    private final CsmMacro.Kind macroKind;
    private final List<CharSequence> params;
    private final CsmFile containingFile;
    private final CsmUID<CsmMacro> uid;

    private SystemMacroImpl(CharSequence macroName, String macroBody, List<CharSequence> macroParams, CsmFile containingFile, CsmMacro.Kind macroKind) {
        this.macroName = NameCache.getManager().getString(macroName);
        this.macroBody = TextCache.getManager().getString((CharSequence)macroBody);
        this.macroKind = macroKind;
        this.params = macroParams != null ? Collections.unmodifiableList(macroParams) : null;
        assert (containingFile instanceof Unresolved.UnresolvedFile);
        this.containingFile = containingFile;
        this.uid = UIDProviderIml.createSelfUID(this);
    }

    public static SystemMacroImpl create(CharSequence macroName, String macroBody, List<CharSequence> macroParams, CsmFile containingFile, CsmMacro.Kind macroKind) {
        return new SystemMacroImpl(macroName, macroBody, macroParams, containingFile, macroKind);
    }

    public List<CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.macroBody;
    }

    public CsmMacro.Kind getKind() {
        return this.macroKind;
    }

    public CharSequence getName() {
        return this.macroName;
    }

    public CsmFile getContainingFile() {
        return this.containingFile;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return 0;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CharSequence getText() {
        return "#define " + this.macroName + " " + this.macroBody;
    }

    public boolean equals(Object obj) {
        boolean retValue;
        if (obj == null || !(obj instanceof SystemMacroImpl)) {
            retValue = false;
        } else {
            SystemMacroImpl other = (SystemMacroImpl)obj;
            retValue = CharSequences.comparator().compare(this.getName(), other.getName()) == 0;
        }
        return retValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.macroName != null ? this.macroName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append("#define '");
        retValue.append(this.getName());
        if (this.getParameters() != null) {
            retValue.append("[");
            Iterator<CharSequence> it = this.getParameters().iterator();
            while (it.hasNext()) {
                CharSequence param = it.next();
                retValue.append(param);
                if (!it.hasNext()) continue;
                retValue.append(", ");
            }
            retValue.append("]");
        }
        if (this.getBody().length() > 0) {
            retValue.append("'='");
            retValue.append(this.getBody());
        }
        retValue.append("' [").append(this.macroKind == CsmMacro.Kind.USER_SPECIFIED ? "user defined" : "system").append("]");
        return retValue.toString();
    }

    public CsmParameterList<CsmMacroParameter> getParameterList() {
        return null;
    }

    @Override
    public CsmUID<?> getUID() {
        return this.uid;
    }
}

