/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class ParameterListImpl<T, K extends CsmNamedElement>
extends OffsetableIdentifiableBase<T>
implements CsmParameterList<K> {
    private final Collection<?> parameters;

    protected ParameterListImpl(CsmFile file, int start, int end, Collection<?> parameters) {
        super(file, start, end);
        this.parameters = parameters == null || parameters.isEmpty() ? null : parameters;
    }

    public final Collection<K> getParameters() {
        return this._getParameters();
    }

    public final boolean isEmpty() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public final int getNrParameters() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    @Override
    public void dispose() {
        super.dispose();
        RepositoryUtils.remove(this._getUIDs());
    }

    private Collection<K> _getParameters() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        Object first = this.parameters.iterator().next();
        Collection<Object> out = first instanceof CsmUID ? UIDCsmConverter.UIDsToCsmObjects(this.parameters) : new ArrayList(this.parameters);
        return out;
    }

    private Collection<CsmUID<K>> _getUIDs() {
        if (this.parameters == null) {
            return null;
        }
        Object first = this.parameters.iterator().next();
        Collection<?> out = null;
        if (first instanceof CsmUID) {
            out = this.parameters;
        }
        return out;
    }

    @Override
    public String toString() {
        return "ParamList " + super.toString();
    }

    @Override
    protected CsmUID<CsmParameterList<K>> createUID() {
        return UIDUtilities.createParamListUID(this);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this._getUIDs(), output, false);
    }

    public ParameterListImpl(RepositoryDataInput input) throws IOException {
        super(input);
        int collSize = input.readInt();
        this.parameters = collSize <= 0 ? null : UIDObjectFactory.getDefaultFactory().readUIDCollection(new ArrayList(collSize), input, collSize);
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTMacro macro) {
        return ParameterListImpl.create(file, macro.getName(), macro.getParams());
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTDefine define) {
        return ParameterListImpl.create(file, define.getName(), define.getParams());
    }

    private static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile file, APTToken name, Collection<APTToken> params) {
        return null;
    }
}

