/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ConstructorDefinitionImpl
extends FunctionDefinitionImpl<CsmFunctionDefinition>
implements CsmInitializerListContainer {
    private List<CsmExpression> initializers;

    protected ConstructorDefinitionImpl(CharSequence name, CharSequence rawName, CsmScope scope, boolean _static, boolean _const, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, scope, _static, _const, file, startOffset, endOffset, global);
    }

    public static ConstructorDefinitionImpl create(AST ast, CsmFile file, boolean global) throws AstRendererException {
        CsmScope scope = null;
        int startOffset = ConstructorDefinitionImpl.getStartOffset(ast);
        int endOffset = ConstructorDefinitionImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            DiagnosticExceptoins.register(new AstRendererException((FileImpl)file, startOffset, "Empty function name."));
            return null;
        }
        CharSequence rawName = ConstructorDefinitionImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        scope = AstRenderer.FunctionRenderer.getScope(scope, file, _static, true);
        ConstructorDefinitionImpl res = new ConstructorDefinitionImpl(name, rawName, scope, _static, _const, file, startOffset, endOffset, global);
        ConstructorDefinitionImpl.temporaryRepositoryRegistration(global, res);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = ConstructorDefinitionImpl.createTemplateDescriptor(ast, file, (CsmScope)res, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        res.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        res.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, (CsmScope)res, file));
        res.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, (CsmScope)res, file, global), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        CharSequence[] classOrNspNames = CastUtils.isCast(ast) ? ConstructorDefinitionImpl.getClassOrNspNames(ast) : res.initClassOrNspNames(ast);
        res.setClassOrNspNames(classOrNspNames);
        CsmCompoundStatement body = AstRenderer.findCompoundStatement(ast, file, res);
        if (body == null) {
            throw new AstRendererException((FileImpl)file, startOffset, "Null body in method definition.");
        }
        res.setCompoundStatement(body);
        res.initializers = AstRenderer.renderConstructorInitializersList(ast, (CsmScope)res, res.getContainingFile());
        ConstructorDefinitionImpl.postObjectCreateRegistration(global, res);
        nameHolder.addReference(file, res);
        return res;
    }

    @Override
    public CsmType getReturnType() {
        return NoType.instance();
    }

    public Collection<CsmExpression> getInitializerList() {
        if (this.initializers != null) {
            return this.initializers;
        }
        return Collections.emptyList();
    }

    public ConstructorDefinitionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.initializers = PersistentUtils.readExpressions(new ArrayList(), input);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.initializers, output);
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> c = super.getScopeElements();
        c.addAll(this.getInitializerList());
        return c;
    }
}

