/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImplSpecialization;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FieldImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FriendClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypedefImpl;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class ClassImpl
extends ClassEnumBase<CsmClass>
implements CsmClass,
CsmTemplate,
SelectImpl.FilterableMembers,
DeclarationsContainer {
    private final CsmDeclaration.Kind kind;
    private final List<CsmUID<CsmMember>> members;
    private final List<CsmUID<CsmFriend>> friends;
    private final ArrayList<CsmUID<CsmInheritance>> inheritances;
    private TemplateDescriptor templateDescriptor = null;
    private int leftBracketPos;
    private static final int CLASS_KIND = 1;
    private static final int UNION_KIND = 2;
    private static final int STRUCT_KIND = 3;

    protected ClassImpl(NameHolder name, AST ast, CsmFile file) {
        this(name, ast, file, ClassImpl.getStartOffset(ast), ClassImpl.getEndOffset(ast));
    }

    protected ClassImpl(NameHolder name, AST ast, CsmFile file, int start, int end) {
        super(name, file, start, end);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = this.findKind(ast);
    }

    private ClassImpl(CsmFile file, CsmScope scope, String name, CsmDeclaration.Kind kind, int startOffset, int endOffset) {
        super(name, name, file, startOffset, endOffset);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = kind;
        this.initScope(scope);
    }

    public static ClassImpl create(CsmFile file, CsmScope scope, String name, CsmDeclaration.Kind kind, int startOffset, int endOffset, boolean register) {
        ClassImpl classImpl = new ClassImpl(file, scope, name, kind, startOffset, endOffset);
        ClassImpl.temporaryRepositoryRegistration(register, classImpl);
        if (register) {
            classImpl.register(classImpl.getScope(), false);
        }
        return classImpl;
    }

    protected void init(CsmScope scope, AST ast, boolean register) {
        this.initScope(scope);
        ClassImpl.temporaryRepositoryRegistration(register, this);
        this.initClassDefinition(scope);
        this.render(ast, !register);
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    private void initClassDefinition(CsmScope scope) {
        ClassMemberForwardDeclaration fd = this.findClassDefinition(scope);
        if (fd != null && CsmKindUtilities.isClass((CsmObject)this)) {
            fd.setCsmClass(this);
            CsmClass containingClass = fd.getContainingClass();
            if (containingClass != null) {
                this.initScope((CsmScope)containingClass);
            }
        }
    }

    protected final void render(AST ast, boolean localClass) {
        new ClassAstRenderer(this.getContainingFile(), CsmVisibility.PRIVATE, localClass).render(ast);
        this.leftBracketPos = this.initLeftBracketPos(ast);
    }

    public final void fixFakeRender(CsmFile file, CsmVisibility visibility, AST ast, boolean localClass) {
        new ClassAstRenderer(file, visibility, localClass).render(ast);
    }

    protected static ClassImpl findExistingClassImplInContainer(DeclarationsContainer container, AST ast) {
        ClassImpl out = null;
        if (container != null) {
            int end;
            CharSequence name = CharSequences.create((CharSequence)AstUtil.findId(ast, 17, true));
            name = name == null ? CharSequences.empty() : name;
            int start = ClassImpl.getStartOffset(ast);
            CsmOffsetableDeclaration existing = container.findExistingDeclaration(start, end = ClassImpl.getEndOffset(ast), name);
            if (existing instanceof ClassImpl) {
                out = (ClassImpl)existing;
            }
        }
        return out;
    }

    public static ClassImpl create(AST ast, CsmScope scope, CsmFile file, boolean register, DeclarationsContainer container) {
        ClassImpl impl = ClassImpl.findExistingClassImplInContainer(container, ast);
        if (impl != null && !ClassImpl.class.equals(impl.getClass())) {
            impl = null;
        }
        NameHolder nameHolder = null;
        if (impl == null) {
            nameHolder = NameHolder.createClassName(ast);
            impl = new ClassImpl(nameHolder, ast, file);
        }
        impl.init(scope, ast, register);
        if (nameHolder != null) {
            nameHolder.addReference(file, impl);
        }
        return impl;
    }

    protected void setTemplateDescriptor(TemplateDescriptor td) {
        this.templateDescriptor = td;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return this.kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmMember> getMembers() {
        Collection<CsmMember> out;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarations(this.members);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter filter) {
        ArrayList uids = new ArrayList();
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            uids.addAll(this.members);
        }
        return UIDCsmConverter.UIDsToDeclarations(uids, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> getFriends() {
        Collection<CsmFriend> out;
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarations(this.friends);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getBaseClasses() {
        Collection<CsmInheritance> out;
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            out = UIDCsmConverter.UIDsToInheritances(this.inheritances);
        }
        return out;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, int end, CharSequence name) {
        CsmUID out = null;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.members, start, end, name);
        }
        if (out == null) {
            list = this.friends;
            synchronized (list) {
                out = UIDUtilities.findExistingUIDInList(this.friends, start, end, name);
            }
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMember(CsmMember member, boolean global) {
        if (global) {
            RepositoryUtils.put(member);
        }
        CsmUID<CsmMember> uid = UIDCsmConverter.declarationToUID(member);
        assert (uid != null);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInheritance(CsmInheritance inheritance, boolean global) {
        if (global) {
            RepositoryUtils.put(inheritance);
        }
        CsmUID<CsmInheritance> uid = UIDCsmConverter.inheritanceToUID(inheritance);
        assert (uid != null);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFriend(CsmFriend friend, boolean global) {
        if (global) {
            RepositoryUtils.put(friend);
        }
        CsmUID<CsmFriend> uid = UIDCsmConverter.declarationToUID(friend);
        assert (uid != null);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.friends);
        }
    }

    private int initLeftBracketPos(AST node) {
        AST lcurly = AstUtil.findChildOfType(node, 16);
        return lcurly instanceof CsmAST ? ((CsmAST)lcurly).getOffset() : this.getStartOffset();
    }

    public int getLeftBracketOffset() {
        return this.leftBracketPos;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getMembers();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearMembers();
        this._clearFriends();
        this._clearInheritances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMembers() {
        Collection<CsmMember> members2dispose = this.getMembers();
        Utils.disposeAll(members2dispose);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            RepositoryUtils.remove(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInheritances() {
        Collection<CsmInheritance> inheritances2dispose = this.getBaseClasses();
        Utils.disposeAll(inheritances2dispose);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            RepositoryUtils.remove(this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearFriends() {
        Collection<CsmFriend> friends2dispose = this.getFriends();
        Utils.disposeAll(friends2dispose);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            RepositoryUtils.remove(this.friends);
        }
    }

    private CsmDeclaration.Kind findKind(AST ast) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 157: {
                    return CsmDeclaration.Kind.CLASS;
                }
                case 159: {
                    return CsmDeclaration.Kind.UNION;
                }
                case 158: {
                    return CsmDeclaration.Kind.STRUCT;
                }
            }
        }
        return CsmDeclaration.Kind.CLASS;
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.kind != null);
        ClassImpl.writeKind(this.kind, output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
        output.writeInt(this.leftBracketPos);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUIDCollection(this.members, output, true);
        factory.writeUIDCollection(this.friends, output, true);
        factory.writeUIDCollection(this.inheritances, output, true);
    }

    public ClassImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.kind = ClassImpl.readKind(input);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
        this.leftBracketPos = input.readInt();
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        int collSize = input.readInt();
        this.members = collSize <= 0 ? new ArrayList<CsmUID<CsmMember>>(0) : new ArrayList<CsmUID<CsmMember>>(collSize);
        factory.readUIDCollection(this.members, input, collSize);
        collSize = input.readInt();
        this.friends = collSize <= 0 ? new ArrayList<CsmUID<CsmFriend>>(0) : new ArrayList<CsmUID<CsmFriend>>(collSize);
        factory.readUIDCollection(this.friends, input, collSize);
        collSize = input.readInt();
        this.inheritances = collSize <= 0 ? new ArrayList(0) : new ArrayList(collSize);
        factory.readUIDCollection(this.inheritances, input, collSize);
    }

    private static void writeKind(CsmDeclaration.Kind kind, RepositoryDataOutput output) throws IOException {
        int kindHandler;
        if (kind == CsmDeclaration.Kind.CLASS) {
            kindHandler = 1;
        } else if (kind == CsmDeclaration.Kind.UNION) {
            kindHandler = 2;
        } else {
            assert (kind == CsmDeclaration.Kind.STRUCT);
            kindHandler = 3;
        }
        output.writeByte(kindHandler);
    }

    private static CsmDeclaration.Kind readKind(RepositoryDataInput input) throws IOException {
        CsmDeclaration.Kind kind;
        byte kindHandler = input.readByte();
        switch (kindHandler) {
            case 1: {
                kind = CsmDeclaration.Kind.CLASS;
                break;
            }
            case 2: {
                kind = CsmDeclaration.Kind.UNION;
                break;
            }
            case 3: {
                kind = CsmDeclaration.Kind.STRUCT;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal handler " + kindHandler);
            }
        }
        return kind;
    }

    public static final class ClassMemberForwardDeclaration
    extends ClassForwardDeclarationImpl
    implements CsmMember,
    CsmClassifier {
        private final CsmVisibility visibility;
        private CsmUID<CsmClass> classDefinition;
        private final CsmUID<CsmClass> containerUID;
        private CsmClass containerRef;

        private ClassMemberForwardDeclaration(CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            super(ast, containingClass.getContainingFile(), register);
            this.visibility = curentVisibility;
            this.containerUID = UIDCsmConverter.declarationToUID(containingClass);
        }

        public static ClassMemberForwardDeclaration create(CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            ClassMemberForwardDeclaration res = new ClassMemberForwardDeclaration(containingClass, ast, curentVisibility, register);
            ClassMemberForwardDeclaration.postObjectCreateRegistration(register, res);
            return res;
        }

        @Override
        protected final boolean registerInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                return ((ProjectBase)project).registerDeclaration(this);
            }
            return false;
        }

        private void unregisterInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                ((ProjectBase)project).unregisterDeclaration(this);
                this.cleanUID();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.onDispose();
            CsmScope scope = this.getScope();
            if (scope instanceof MutableDeclarationsContainer) {
                ((MutableDeclarationsContainer)scope).removeDeclaration(this);
            }
            this.unregisterInProject();
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        private synchronized void onDispose() {
            if (this.containerRef == null) {
                this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
        }

        public synchronized CsmClass getContainingClass() {
            CsmClass out = this.containerRef;
            if (out == null) {
                out = this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
            return out;
        }

        @Override
        public CsmScope getScope() {
            return this.getContainingClass();
        }

        @Override
        public CsmClass getCsmClass() {
            CsmClass cls = UIDCsmConverter.UIDtoClass(this.classDefinition);
            if (cls != null && cls.isValid() && !ForwardClass.isForwardClass((CsmDeclaration)cls)) {
                return cls;
            }
            cls = super.getCsmClass();
            this.setCsmClass(cls);
            return cls;
        }

        @Override
        protected CsmClass createForwardClassIfNeed(AST ast, CsmScope scope, boolean registerInProject) {
            CsmClass cls = super.createForwardClassIfNeed(ast, scope, registerInProject);
            this.classDefinition = UIDCsmConverter.declarationToUID(cls);
            if (cls != null) {
                RepositoryUtils.put(this);
            }
            return cls;
        }

        public void setCsmClass(CsmClass cls) {
            this.classDefinition = UIDCsmConverter.declarationToUID(cls);
        }

        @Override
        public CharSequence getQualifiedName() {
            CsmClass cls = this.getContainingClass();
            if (cls == null) {
                cls = this.getContainingClass();
            }
            return CharSequences.create((CharSequence)(cls.getQualifiedName() + "::" + this.getName()));
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
            assert (this.containerUID != null);
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, output);
            UIDObjectFactory.getDefaultFactory().writeUID(this.classDefinition, output);
        }

        public ClassMemberForwardDeclaration(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
            this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(input);
            assert (this.containerUID != null);
            this.classDefinition = UIDObjectFactory.getDefaultFactory().readUID(input);
        }
    }

    public static final class MemberTypedef
    extends TypedefImpl
    implements CsmMember {
        private final CsmVisibility visibility;

        private MemberTypedef(CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility) {
            super(ast, containingClass.getContainingFile(), (CsmObject)containingClass, type, name);
            this.visibility = curentVisibility;
        }

        public static MemberTypedef create(CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility, boolean global) {
            MemberTypedef memberTypedef = new MemberTypedef(containingClass, ast, type, name, curentVisibility);
            if (!global) {
                Utils.setSelfUID(memberTypedef);
            }
            return memberTypedef;
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public CsmClass getContainingClass() {
            return (CsmClass)this.getScope();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
        }

        public MemberTypedef(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
        }
    }

    private class ClassAstRenderer
    extends AstRenderer {
        private final boolean renderingLocalContext;
        private CsmVisibility curentVisibility;

        public ClassAstRenderer(CsmFile containingFile, CsmVisibility curentVisibility, boolean renderingLocalContext) {
            super((FileImpl)containingFile);
            this.renderingLocalContext = renderingLocalContext;
            this.curentVisibility = curentVisibility;
        }

        @Override
        protected boolean isRenderingLocalContext() {
            return this.renderingLocalContext;
        }

        protected VariableImpl<CsmField> createVariable(AST offsetAst, CsmFile file, CsmType type, NameHolder name, boolean _static, boolean _extern, MutableDeclarationsContainer container1, MutableDeclarationsContainer container2, CsmScope scope) {
            type = TemplateUtils.checkTemplateType(type, (CsmScope)ClassImpl.this);
            FieldImpl field = FieldImpl.create(offsetAst, file, type, name, ClassImpl.this, this.curentVisibility, _static, _extern, !this.isRenderingLocalContext());
            ClassImpl.this.addMember((CsmMember)field, !this.isRenderingLocalContext());
            return field;
        }

        @Override
        public void render(AST ast) {
            block43: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
                switch (token.getType()) {
                    case 115: {
                        List<CsmTemplateParameter> params = TemplateUtils.getTemplateParameters(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        String classSpecializationSuffix = TemplateUtils.getClassSpecializationSuffix(token, null);
                        String name = "<" + classSpecializationSuffix + ">";
                        this.setTemplateDescriptor(params, name, !classSpecializationSuffix.isEmpty());
                        continue block43;
                    }
                    case 547: {
                        ClassImpl.this.addInheritance(InheritanceImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 157: {
                        continue block43;
                    }
                    case 159: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 158: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 163: {
                        this.curentVisibility = CsmVisibility.PUBLIC;
                        continue block43;
                    }
                    case 165: {
                        this.curentVisibility = CsmVisibility.PRIVATE;
                        continue block43;
                    }
                    case 164: {
                        this.curentVisibility = CsmVisibility.PROTECTED;
                        continue block43;
                    }
                    case 464: 
                    case 484: {
                        ClassImpl innerClass = TemplateUtils.isPartialClassSpecialization(token) ? ClassImplSpecialization.create(token, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext(), ClassImpl.this) : ClassImpl.create(token, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext(), ClassImpl.this);
                        innerClass.setVisibility(this.curentVisibility);
                        ClassImpl.this.addMember(innerClass, !this.isRenderingLocalContext());
                        AstRenderer.Pair typedefs = this.renderTypedef(token, innerClass, ClassImpl.this);
                        if (!typedefs.getTypesefs().isEmpty()) {
                            for (CsmTypedef typedef : typedefs.getTypesefs()) {
                                if (!this.isRenderingLocalContext()) {
                                    ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration((CsmOffsetableDeclaration)typedef);
                                }
                                ClassImpl.this.addMember((MemberTypedef)typedef, !this.isRenderingLocalContext());
                                if (typedefs.getEnclosingClassifier() == null) continue;
                                typedefs.getEnclosingClassifier().addEnclosingTypedef(typedef);
                            }
                            if (typedefs.getEnclosingClassifier() != null && !ForwardClass.isForwardClass(typedefs.getEnclosingClassifier())) {
                                ClassImpl.this.addMember(typedefs.getEnclosingClassifier(), !this.isRenderingLocalContext());
                            }
                        }
                        this.renderVariableInClassifier(token, innerClass, null, null);
                        continue block43;
                    }
                    case 465: {
                        EnumImpl innerEnum = EnumImpl.create(token, (CsmScope)ClassImpl.this, this.getContainingFile(), !this.isRenderingLocalContext());
                        innerEnum.setVisibility(this.curentVisibility);
                        ClassImpl.this.addMember(innerEnum, !this.isRenderingLocalContext());
                        this.renderVariableInClassifier(token, innerEnum, null, null);
                        continue block43;
                    }
                    case 490: 
                    case 491: {
                        try {
                            ClassImpl.this.addMember((CsmMember)ConstructorDDImpl.createConstructor(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 467: 
                    case 468: {
                        try {
                            ClassImpl.this.addMember((CsmMember)ConstructorImpl.createConstructor(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 487: 
                    case 488: {
                        try {
                            ClassImpl.this.addMember((CsmMember)DestructorDDImpl.createDestructor(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 489: {
                        try {
                            ClassImpl.this.addMember((CsmMember)DestructorImpl.createDestructor(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 499: {
                        ClassMemberForwardDeclaration fd;
                        AST child = token.getFirstChild();
                        if (this.hasFriendPrefix(child)) {
                            try {
                                ClassImpl.this.addFriend(this.renderFriendClass(token), !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException e) {
                                DiagnosticExceptoins.register(e);
                            }
                            continue block43;
                        }
                        if (this.renderVariable(token, null, null, false)) continue block43;
                        AstRenderer.Pair typedefs = this.renderTypedef(token, (FileImpl)this.getContainingFile(), (CsmScope)ClassImpl.this, null);
                        if (!typedefs.getTypesefs().isEmpty()) {
                            for (CsmTypedef typedef : typedefs.getTypesefs()) {
                                if (!this.isRenderingLocalContext()) {
                                    ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration((CsmOffsetableDeclaration)typedef);
                                }
                                ClassImpl.this.addMember((MemberTypedef)typedef, !this.isRenderingLocalContext());
                                if (typedefs.getEnclosingClassifier() == null) continue;
                                typedefs.getEnclosingClassifier().addEnclosingTypedef(typedef);
                            }
                            if (typedefs.getEnclosingClassifier() == null || ForwardClass.isForwardClass(typedefs.getEnclosingClassifier())) continue block43;
                            ClassImpl.this.addMember(typedefs.getEnclosingClassifier(), !this.isRenderingLocalContext());
                            continue block43;
                        }
                        if (this.renderBitField(token) || (fd = this.renderClassForwardDeclaration(token)) == null) continue block43;
                        ClassImpl.this.addMember(fd, !this.isRenderingLocalContext());
                        fd.init(token, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 507: {
                        UsingDeclarationImpl using = UsingDeclarationImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                        ClassImpl.this.addMember(using, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 497: {
                        AST child = token.getFirstChild();
                        if (this.hasFriendPrefix(child)) {
                            try {
                                ClassImpl.this.addFriend(this.renderFriendClass(token), !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException e) {
                                DiagnosticExceptoins.register(e);
                            }
                            continue block43;
                        }
                        ClassMemberForwardDeclaration fd = this.renderClassForwardDeclaration(token);
                        if (fd == null) continue block43;
                        ClassImpl.this.addMember(fd, !this.isRenderingLocalContext());
                        fd.init(token, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 469: 
                    case 471: 
                    case 473: 
                    case 492: 
                    case 493: {
                        FunctionImpl friend;
                        FunctionImpl func;
                        FunctionImpl impl;
                        CsmScope scope;
                        AST child = token.getFirstChild();
                        if (child == null) continue block43;
                        if (this.hasFriendPrefix(child)) {
                            try {
                                scope = this.getFriendScope();
                                if (this.isMemberDefinition(token)) {
                                    func = impl = FriendFunctionImplEx.create(token, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    friend = impl;
                                } else {
                                    friend = impl = FriendFunctionImpl.create(token, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    func = impl;
                                    if (scope instanceof NamespaceImpl) {
                                        ((NamespaceImpl)scope).addDeclaration(func);
                                    } else {
                                        ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(func);
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)friend, !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException e) {
                                DiagnosticExceptoins.register(e);
                            }
                            continue block43;
                        }
                        try {
                            ClassImpl.this.addMember((CsmMember)MethodImpl.create(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 470: 
                    case 472: 
                    case 474: 
                    case 494: 
                    case 495: {
                        FunctionImpl friend;
                        FunctionImpl func;
                        FunctionImpl impl;
                        CsmScope scope;
                        AST child = token.getFirstChild();
                        if (this.hasFriendPrefix(child)) {
                            try {
                                scope = this.getFriendScope();
                                if (this.isMemberDefinition(token)) {
                                    func = impl = FriendFunctionDefinitionImpl.create(token, ClassImpl.this, null, !this.isRenderingLocalContext());
                                    friend = impl;
                                } else {
                                    friend = impl = FriendFunctionDDImpl.create(token, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    func = impl;
                                    if (scope instanceof NamespaceImpl) {
                                        ((NamespaceImpl)scope).addDeclaration(func);
                                    } else {
                                        ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(func);
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)friend, !this.isRenderingLocalContext());
                            }
                            catch (AstRendererException e) {
                                DiagnosticExceptoins.register(e);
                            }
                            continue block43;
                        }
                        try {
                            ClassImpl.this.addMember((CsmMember)MethodDDImpl.create(token, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                        }
                        catch (AstRendererException e) {
                            DiagnosticExceptoins.register(e);
                        }
                        continue block43;
                    }
                    case 500: {
                        UsingDeclarationImpl using = UsingDeclarationImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                        ClassImpl.this.addMember(using, !this.isRenderingLocalContext());
                        continue block43;
                    }
                    case 17: {
                        continue block43;
                    }
                }
            }
            this.checkInnerIncludes(ClassImpl.this, ClassImpl.this.getMembers());
        }

        private CsmScope getFriendScope() {
            CsmScope newScope;
            CsmScope scope = ClassImpl.this.getScope();
            while (CsmKindUtilities.isClass((CsmObject)scope) && (newScope = ((CsmClass)scope).getScope()) != null) {
                scope = newScope;
            }
            return scope;
        }

        private void setTemplateDescriptor(List<CsmTemplateParameter> params, String name, boolean specialization) {
            ClassImpl.this.templateDescriptor = new TemplateDescriptor(params, name, specialization, !this.isRenderingLocalContext());
        }

        private boolean hasFriendPrefix(AST child) {
            AST nextSibling;
            if (child == null) {
                return false;
            }
            if (child.getType() == 126) {
                return true;
            }
            return child.getType() == 115 && (nextSibling = child.getNextSibling()) != null && nextSibling.getType() == 126;
        }

        private CsmFriend renderFriendClass(AST ast) throws AstRendererException {
            AST firstChild = ast.getFirstChild();
            AST child = firstChild;
            if (child.getType() == 126) {
                child = child.getNextSibling();
            }
            if (child != null && child.getType() == 115) {
                child = child.getNextSibling();
            }
            CsmClassForwardDeclaration cfd = null;
            AST qid = null;
            if (child != null && (child.getType() == 158 || child.getType() == 157)) {
                AST templStart;
                qid = AstUtil.findChildOfType(ast, 510);
                CharSequence[] nameParts = AstRenderer.getNameTokens(qid);
                if (nameParts != null && nameParts.length == 1 && (templStart = TemplateUtils.getTemplateStart(ast.getFirstChild())) == null) {
                    CsmScope scope = ClassImpl.this.getScope();
                    while (!CsmKindUtilities.isNamespace((Object)scope) && CsmKindUtilities.isScopeElement((CsmObject)scope)) {
                        scope = ((CsmScopeElement)scope).getScope();
                    }
                    if (!CsmKindUtilities.isNamespace((Object)scope)) {
                        scope = this.getContainingFile().getProject().getGlobalNamespace();
                    }
                    cfd = super.createForwardClassDeclaration(ast, null, (FileImpl)this.getContainingFile(), scope);
                    RepositoryUtils.put(cfd);
                    ((NamespaceImpl)scope).addDeclaration((CsmOffsetableDeclaration)cfd);
                }
            } else {
                qid = child != null && child.getType() == 477 ? child : AstUtil.findChildOfType(ast, 510);
            }
            return FriendClassImpl.create(firstChild, qid, cfd, (FileImpl)this.getContainingFile(), ClassImpl.this, !this.isRenderingLocalContext());
        }

        private ClassMemberForwardDeclaration renderClassForwardDeclaration(AST token) {
            AST typeAST = token.getFirstChild();
            if (typeAST == null) {
                return null;
            }
            if (typeAST.getType() == 115) {
                typeAST = typeAST.getNextSibling();
            }
            if (typeAST == null || typeAST.getType() != 158 && typeAST.getType() != 157) {
                return null;
            }
            AST idAST = typeAST.getNextSibling();
            if (idAST == null || idAST.getType() != 510) {
                return null;
            }
            return ClassMemberForwardDeclaration.create(ClassImpl.this, token, this.curentVisibility, !this.isRenderingLocalContext());
        }

        private boolean renderBitField(AST token) {
            AST typeAST = token.getFirstChild();
            if (typeAST == null) {
                return false;
            }
            if ((typeAST = ClassAstRenderer.getFirstSiblingSkipQualifiers(typeAST)) == null) {
                return false;
            }
            if (typeAST.getType() != 476) {
                if (typeAST.getType() == 117) {
                    typeAST = typeAST.getNextSibling();
                }
                if (typeAST == null || typeAST.getType() != 477) {
                    return false;
                }
            }
            TypeImpl type = TypeFactory.createType(typeAST, this.getContainingFile(), null, 0);
            if ((typeAST = ClassAstRenderer.getFirstSiblingSkipQualifiers(typeAST.getNextSibling())) == null) {
                return false;
            }
            boolean bitFieldAdded = this.renderBitFieldImpl(token, typeAST, type, null);
            return bitFieldAdded;
        }

        @Override
        protected boolean renderBitFieldImpl(AST startOffsetAST, AST idAST, CsmType type, ClassEnumBase<?> classifier) {
            boolean cont = true;
            boolean added = false;
            AST start = startOffsetAST;
            AST prev = idAST;
            while (cont) {
                AST expAST;
                AST colonAST;
                boolean unnamed = false;
                if (idAST == null) break;
                if (idAST.getType() == 90) {
                    colonAST = idAST.getNextSibling();
                } else {
                    if (idAST.getType() != 7) break;
                    colonAST = idAST;
                    unnamed = true;
                }
                if (colonAST == null || colonAST.getType() != 7 || (expAST = colonAST.getNextSibling()) == null || expAST.getType() != 535) break;
                prev = expAST.getNextSibling();
                if (prev != null && prev.getType() == 8) {
                    start = idAST;
                } else {
                    cont = false;
                    if (added) {
                        start = idAST;
                    }
                }
                if (!unnamed) {
                    NameHolder nameHolder = NameHolder.createSimpleName(idAST);
                    FieldImpl field = FieldImpl.create(start, this.getContainingFile(), type, nameHolder, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext());
                    ClassImpl.this.addMember((CsmMember)field, !this.isRenderingLocalContext());
                    if (classifier != null) {
                        classifier.addEnclosingVariable(field);
                    }
                }
                added = true;
                if (!cont) continue;
                idAST = prev.getNextSibling();
            }
            return added;
        }

        @Override
        protected CsmTypedef createTypedef(AST ast, FileImpl file, CsmObject container, CsmType type, CharSequence name) {
            type = TemplateUtils.checkTemplateType(type, (CsmScope)ClassImpl.this);
            return MemberTypedef.create(ClassImpl.this, ast, type, name, this.curentVisibility, !this.isRenderingLocalContext());
        }

        @Override
        protected CsmClassForwardDeclaration createForwardClassDeclaration(AST ast, MutableDeclarationsContainer container, FileImpl file, CsmScope scope) {
            ClassMemberForwardDeclaration fd = ClassMemberForwardDeclaration.create(ClassImpl.this, ast, this.curentVisibility, !this.isRenderingLocalContext());
            ClassImpl.this.addMember(fd, !this.isRenderingLocalContext());
            fd.init(ast, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
            return fd;
        }
    }
}

