/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.j2ee.LoadGenPanel;
import org.netbeans.modules.profiler.j2ee.ServletUriPanel;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public final class J2EEProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private static final String PROFILING_NOT_SUPPORTED_MSG = NbBundle.getMessage(J2EEProjectProfilingSupportProvider.class, (String)"J2EEProjectTypeProfiler_ProfilingNotSupportedMsg");
    private static final String SKIP_BUTTON_NAME = NbBundle.getMessage(J2EEProjectProfilingSupportProvider.class, (String)"J2EEProjectTypeProfiler_SkipButtonName");
    private static final String NO_SERVER_FOUND_MSG = NbBundle.getMessage(J2EEProjectProfilingSupportProvider.class, (String)"J2EEProjectTypeProfiler_NoServerFoundMsg");
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2ee");
    private static int lastAgentID = -1;
    private static int lastAgentPort = 5140;

    public J2EEProjectProfilingSupportProvider(Project project) {
        super(project);
    }

    public static int getLastAgentID() {
        return lastAgentID;
    }

    public static int getLastAgentPort() {
        return lastAgentPort;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider serverInstanceModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (serverInstanceModuleProvider == null) {
            return null;
        }
        return serverInstanceModuleProvider.getServerInstanceID();
    }

    public org.netbeans.modules.profiler.api.JavaPlatform getProjectJavaPlatform() {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(this.getProject());
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectProfilingSupportProvider.getServerJavaPlatform(serverInstanceID);
    }

    private static org.netbeans.modules.profiler.api.JavaPlatform getServerJavaPlatform(String serverInstanceID) {
        J2eePlatform j2eePlatform = J2EEProjectProfilingSupportProvider.getJ2eePlatform(serverInstanceID);
        if (j2eePlatform == null) {
            return null;
        }
        JavaPlatform jp = j2eePlatform.getJavaPlatform();
        if (jp == null) {
            return null;
        }
        return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)((String)jp.getProperties().get("platform.ant.name")));
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        if (!this.isProfilingSupported()) {
            return false;
        }
        J2eePlatform j2eePlatform = J2EEProjectProfilingSupportProvider.getJ2eePlatform(this.getProject());
        if (j2eePlatform == null) {
            ProfilerDialogs.displayError((String)NO_SERVER_FOUND_MSG);
            return false;
        }
        if (!j2eePlatform.supportsProfiling()) {
            ProfilerDialogs.displayWarning((String)PROFILING_NOT_SUPPORTED_MSG);
            return false;
        }
        if (profiledClassFile == null) {
            return true;
        }
        return this.isFileObjectSupported(profiledClassFile);
    }

    public boolean isFileObjectSupported(FileObject file) {
        Project project = this.getProject();
        return WebProjectUtils.isJSP(file) && WebProjectUtils.isWebDocumentSource(file, project) || WebProjectUtils.isHttpServlet(file) && WebProjectUtils.isWebJavaSource(file, project) && WebProjectUtils.isMappedServlet(file, project, true) || super.isFileObjectSupported(file);
    }

    public void configurePropertiesForProfiling(Properties props, FileObject profiledClassFile) {
        String loadGenPath;
        Project project = this.getProject();
        J2EEProjectProfilingSupportProvider.initAntPlatform(project, props);
        props.setProperty("profiler.j2ee.serverForceRestart", "true");
        props.setProperty("profiler.j2ee.serverStartupTimeout", "300000");
        props.setProperty("profiler.j2ee.agentID", "-Dnbprofiler.agentid=" + new Integer(J2EEProjectProfilingSupportProvider.generateAgentID()).toString());
        String jvmArgs = props.getProperty("profiler.info.jvmargs");
        if (jvmArgs != null && jvmArgs.trim().length() > 0) {
            props.setProperty("profiler.info.jvmargs.extra", jvmArgs);
        }
        org.netbeans.modules.profiler.api.JavaPlatform javaPlatform = J2EEProjectProfilingSupportProvider.getJavaPlatformFromAntName(project, props);
        props.setProperty("profiler.info.javaPlatform", javaPlatform.getPlatformId());
        String javaVersion = javaPlatform.getPlatformJDKVersion();
        String localPlatform = IntegrationUtils.getLocalPlatform((int)javaPlatform.getPlatformArchitecture());
        if (javaVersion.equals("jdk15")) {
            props.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_50, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        } else {
            props.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_60, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        }
        J2EEProjectProfilingSupportProvider.generateAgentPort();
        String string = loadGenPath = LoadGenPanel.hasInstance() ? LoadGenPanel.instance().getSelectedScript() : null;
        if (loadGenPath != null) {
            props.setProperty("profiler.loadgen.path", loadGenPath);
        }
        if (profiledClassFile == null) {
            return;
        }
        if (WebProjectUtils.isJSP(profiledClassFile)) {
            props.put("client.urlPart", WebProjectUtils.getJSPFileContext(project, profiledClassFile, false));
        } else if (WebProjectUtils.isHttpServlet(profiledClassFile)) {
            String servletAddress = null;
            Collection<Document> ddos = WebProjectUtils.getDeploymentDescriptorDocuments(project, true);
            for (Document dd : ddos) {
                String mapping = WebProjectUtils.getServletMapping(profiledClassFile, dd);
                if (mapping == null || mapping.length() <= 0) continue;
                servletAddress = mapping;
                break;
            }
            if (servletAddress != null) {
                ServletUriPanel uriPanel = new ServletUriPanel(servletAddress);
                DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(J2EEProjectProfilingSupportProvider.class, (String)"TTL_setServletExecutionUri"), true, new Object[]{DialogDescriptor.OK_OPTION, new JButton(SKIP_BUTTON_NAME){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width + 16, super.getPreferredSize().height);
                    }
                }}, DialogDescriptor.OK_OPTION, 0, null, null);
                Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (res.equals(NotifyDescriptor.YES_OPTION)) {
                    servletAddress = uriPanel.getServletUri();
                }
                props.put("client.urlPart", servletAddress);
            }
        }
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)profiledClassFile);
        if (src != null) {
            String profiledClass = src.getTopLevelClass().getVMName();
            props.setProperty("profile.class", profiledClass);
            String clazz = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)profiledClassFile), (FileObject)profiledClassFile);
            props.setProperty("javac.includes", clazz);
        }
    }

    public static int generateAgentID() {
        int newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        while (newAgentID == lastAgentID) {
            newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        }
        lastAgentID = newAgentID;
        return J2EEProjectProfilingSupportProvider.getLastAgentID();
    }

    public static org.netbeans.modules.profiler.api.JavaPlatform generateAgentJavaPlatform(String serverInstanceID) {
        org.netbeans.modules.profiler.api.JavaPlatform platform = org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)ProfilerIDESettings.getInstance().getJavaPlatformForProfiling());
        org.netbeans.modules.profiler.api.JavaPlatform projectPlatform = J2EEProjectProfilingSupportProvider.getServerJavaPlatform(serverInstanceID);
        if (platform == null && (platform = projectPlatform) == null && (platform = JavaPlatformSelector.getDefault().selectPlatformToUse()) == null) {
            return null;
        }
        return platform;
    }

    public static int generateAgentPort() {
        lastAgentPort = ProfilerIDESettings.getInstance().getPortNo();
        return J2EEProjectProfilingSupportProvider.getLastAgentPort();
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        Project project = this.getProject();
        PropertyEvaluator pp = this.getProjectProperties(project);
        ss.setMainClass("");
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("build.classes.dir");
        ss.setMainClassPath(runCP != null ? MiscUtils.getAbsoluteFilePath((String)runCP, (String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath()) : "");
        ss.setJVMArgs("");
        ss.setWorkingDir("");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate() {
        return true;
    }

    public void unintegrateProfiler() {
        ProjectUtilities.unintegrateProfiler((Project)this.getProject());
    }

    private static J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(project);
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectProfilingSupportProvider.getJ2eePlatform(serverInstanceID);
    }

    private static J2eePlatform getJ2eePlatform(String serverInstanceID) {
        return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
    }

    private static org.netbeans.modules.profiler.api.JavaPlatform getJavaPlatformFromAntName(Project project, Properties props) {
        String javaPlatformAntName = props.getProperty("profiler.info.javaPlatform");
        if (javaPlatformAntName.equals("default_platform")) {
            return org.netbeans.modules.profiler.api.JavaPlatform.getDefaultPlatform();
        }
        return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)javaPlatformAntName);
    }

    private static int generateAgentNumber() {
        return (int)(Math.random() * 2.147483648E9);
    }

    private static void initAntPlatform(Project project, Properties props) {
        String javaPlatformAntName = props.getProperty("profiler.info.javaPlatform");
        if (javaPlatformAntName == null) {
            String platformId;
            Object platform = null;
            J2eePlatform j2eepf = J2EEProjectProfilingSupportProvider.getJ2eePlatform(project);
            if (j2eepf == null) {
                platformId = org.netbeans.modules.profiler.api.JavaPlatform.getDefaultPlatform().getPlatformId();
            } else {
                Map jpprops = j2eepf.getJavaPlatform().getProperties();
                platformId = (String)jpprops.get("platform.ant.name");
            }
            props.setProperty("profiler.info.javaPlatform", platformId);
        }
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is;
                if (privatePropsFile != null) {
                    try {
                        is = privatePropsFile.getInputStream();
                        try {
                            privateProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (projectPropsFile != null) {
                    try {
                        is = projectPropsFile.getInputStream();
                        try {
                            projectProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (userPropsFile != null) {
                    try {
                        is = new BufferedInputStream(new FileInputStream(userPropsFile));
                        try {
                            userPropsProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    private void addJspMarker(MethodMarker marker, Mark mark, Project project) {
        ClientUtils.SourceCodeSelection[] jspmethods = WebProjectUtils.getJSPRootMethods(project, true);
        if (jspmethods != null) {
            for (int i = 0; i < jspmethods.length; ++i) {
                marker.addMethodMark(jspmethods[i].getClassName(), jspmethods[i].getMethodName(), jspmethods[i].getMethodSignature(), mark);
            }
        }
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static class JSPNameFormatter
    implements MethodNameFormatter {
        private JSPNameFormatter() {
        }

        public Formattable formatMethodName(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
            return new Formattable(){

                public String toFormatted() {
                    String name = WebProjectUtils.getJSPPath(sourceCodeSelection);
                    return name;
                }
            };
        }

        public Formattable formatMethodName(final String className, final String methodName, final String signature) {
            return new Formattable(){

                public String toFormatted() {
                    ClientUtils.SourceCodeSelection tmpSelection = new ClientUtils.SourceCodeSelection(className, methodName, signature);
                    String name = WebProjectUtils.getJSPPath(tmpSelection);
                    return name;
                }
            };
        }
    }
}

