/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import com.sun.source.tree.Scope;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.profiler.api.EditorContext;
import org.netbeans.modules.profiler.spi.EditorSupportProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectEditorSupportImpl
extends EditorSupportProvider {
    private <T> T performOnAWT(final Callable<T> action) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            return action.call();
        }
        final Object[] rslt = new Object[]{null};
        final Exception[] exc = new Exception[1];
        final CountDownLatch latch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rslt[0] = action.call();
                }
                catch (Exception ex) {
                    exc[0] = ex;
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        return (T)rslt[0];
    }

    public boolean currentlyInJavaEditor() {
        TopComponent top1 = WindowManager.getDefault().getRegistry().getActivated();
        if (top1 == null) {
            return false;
        }
        JTextComponent editor = EditorRegistry.lastFocusedComponent();
        if (editor == null) {
            return false;
        }
        Document document = editor.getDocument();
        if (document == null) {
            return false;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        TopComponent top2 = NbEditorUtilities.getOuterTopComponent((JTextComponent)editor);
        if (top2 == null) {
            return false;
        }
        return top1 == top2;
    }

    public EditorContext getMostActiveJavaEditorContext() {
        for (JTextComponent component : EditorRegistry.componentList()) {
            Document document = component.getDocument();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) continue;
            return new EditorContext(component, document, fileObject);
        }
        return null;
    }

    public FileObject getCurrentFile() {
        try {
            return this.performOnAWT(new Callable<FileObject>(){

                @Override
                public FileObject call() throws Exception {
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    if (tc != null) {
                        return (FileObject)tc.getLookup().lookup(FileObject.class);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public int getCurrentOffset() {
        try {
            return this.performOnAWT(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    JTextComponent mostActiveEditor = EditorRegistry.lastFocusedComponent();
                    if (mostActiveEditor != null && mostActiveEditor.getCaret() != null) {
                        return mostActiveEditor.getCaretPosition();
                    }
                    return -1;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return -1;
        }
    }

    public int getLineForOffset(FileObject file, final int offset) {
        try {
            if (offset == -1) {
                return -1;
            }
            DataObject dobj = DataObject.find((FileObject)file);
            if (dobj == null) {
                return -1;
            }
            final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return -1;
            }
            return this.performOnAWT(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    StyledDocument doc = ProjectEditorSupportImpl.getDocument(ec);
                    if (doc == null) {
                        return -1;
                    }
                    return NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return -1;
        }
    }

    public int getOffsetForLine(FileObject file, final int line) {
        try {
            if (line == -1) {
                return -1;
            }
            DataObject dobj = DataObject.find((FileObject)file);
            if (dobj == null) {
                return -1;
            }
            final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return -1;
            }
            return this.performOnAWT(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    StyledDocument doc = ProjectEditorSupportImpl.getDocument(ec);
                    if (doc == null) {
                        return -1;
                    }
                    return NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return -1;
        }
    }

    public boolean isOffsetValid(final FileObject file, final int offset) {
        try {
            return this.performOnAWT(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (file == null) {
                        return false;
                    }
                    return ProjectEditorSupportImpl.validateOffset(file, offset) != -1;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
    }

    public Lookup.Provider getCurrentProject() {
        try {
            return this.performOnAWT(new Callable<Lookup.Provider>(){

                @Override
                public Lookup.Provider call() throws Exception {
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    if (tc != null) {
                        return (Lookup.Provider)tc.getLookup().lookup(Project.class);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public int[] getSelectionOffsets() {
        try {
            return this.performOnAWT(new Callable<int[]>(){

                @Override
                public int[] call() throws Exception {
                    EditorCookie ec;
                    int[] indexes = new int[]{-1, -1};
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    if (tc != null && (ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class)) != null) {
                        for (JEditorPane pane : ec.getOpenedPanes()) {
                            int selStart = pane.getSelectionStart();
                            if (selStart <= -1) continue;
                            indexes[0] = selStart;
                            indexes[1] = pane.getSelectionEnd();
                            break;
                        }
                    }
                    return indexes;
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return new int[]{-1, -1};
        }
    }

    private static int validateOffset(FileObject editorDoc, final int toValidate) {
        final int[] validated = new int[]{-1};
        JavaSource js = JavaSource.forFileObject((FileObject)editorDoc);
        if (js != null) {
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        validated[0] = -1;
                        Scope sc = controller.getTreeUtilities().scopeFor(toValidate);
                        if (sc.getEnclosingClass() != null) {
                            validated[0] = toValidate;
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return validated[0];
    }

    private static StyledDocument getDocument(EditorCookie ec) throws IOException {
        StyledDocument doc = null;
        try {
            doc = ec.openDocument();
        }
        catch (UserQuestionException uqe) {
            Object value = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)uqe.getLocalizedMessage(), NbBundle.getMessage(ProjectEditorSupportImpl.class, (String)"TXT_Question"), 0));
            if (value != NotifyDescriptor.YES_OPTION) {
                return null;
            }
            uqe.confirmed();
            doc = ec.openDocument();
        }
        return doc;
    }
}

