/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.ClassMarker;
import org.netbeans.lib.profiler.marker.CompositeMarker;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.marker.PackageMarker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.categorization.api.definitions.CustomCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.PackageCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.SingleTypeCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.SubtypeCategoryDefinition;
import org.netbeans.modules.profiler.categorization.spi.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.openide.util.Lookup;

public final class MarkerProcessor
extends CategoryDefinitionProcessor
implements Marker {
    private static final Logger LOGGER = Logger.getLogger(MarkerProcessor.class.getName());
    private MethodMarker mMarker = new MethodMarker();
    private ClassMarker cMarker = new ClassMarker();
    private PackageMarker pMarker = new PackageMarker();
    private CompositeMarker cmMarker = new CompositeMarker();
    private JavaSource associatedParser;
    private Project pp;

    public MarkerProcessor(Project prj) {
        this.associatedParser = ElementUtilitiesEx.getSources(prj);
        this.pp = prj;
    }

    public void process(SubtypeCategoryDefinition def) {
        if (def.getExcludes() == null && def.getIncludes() == null) {
            this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getAssignedMark());
        } else {
            if (def.getExcludes() != null) {
                this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getExcludes(), false, def.getAssignedMark());
            }
            if (def.getIncludes() != null) {
                this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getIncludes(), true, def.getAssignedMark());
            }
        }
    }

    public void process(SingleTypeCategoryDefinition def) {
        if (def.getExcludes() == null && def.getIncludes() == null) {
            this.cMarker.addClassMark(def.getTypeName(), def.getAssignedMark());
        } else {
            if (def.getExcludes() != null) {
                this.addTypeMarker(this.mMarker, def.getTypeName(), def.getExcludes(), false, def.getAssignedMark());
            }
            if (def.getIncludes() != null) {
                this.addTypeMarker(this.mMarker, def.getTypeName(), def.getIncludes(), true, def.getAssignedMark());
            }
        }
    }

    public void process(CustomCategoryDefinition def) {
        this.cmMarker.addMarker(def.getCustomMarker());
    }

    public void process(PackageCategoryDefinition def) {
        this.pMarker.addPackageMark(def.getPackageName(), def.getAssignedMark(), def.isRecursive());
    }

    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> mappings = new ArrayList<MarkMapping>();
        mappings.addAll(Arrays.asList(this.mMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.cMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.pMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.cmMarker.getMappings()));
        return mappings.toArray(new MarkMapping[mappings.size()]);
    }

    public Mark[] getMarks() {
        HashSet<Mark> marks = new HashSet<Mark>();
        marks.addAll(Arrays.asList(this.mMarker.getMarks()));
        marks.addAll(Arrays.asList(this.cMarker.getMarks()));
        marks.addAll(Arrays.asList(this.pMarker.getMarks()));
        marks.addAll(Arrays.asList(this.cmMarker.getMarks()));
        return marks.toArray(new Mark[marks.size()]);
    }

    private void addInterfaceMarker(MethodMarker marker, String interfaceName, Mark mark) {
        this.addInterfaceMarker(marker, interfaceName, null, false, mark);
    }

    private void addInterfaceMarker(MethodMarker marker, String interfaceName, String[] methodNameRestriction, boolean inclusive, Mark mark) {
        Set<String> restrictorSet = methodNameRestriction != null ? new HashSet<String>(Arrays.asList(methodNameRestriction)) : Collections.EMPTY_SET;
        SourceClassInfo ci = ProfilerTypeUtils.resolveClass((String)interfaceName, (Lookup.Provider)this.pp);
        if (ci == null) {
            LOGGER.log(Level.FINE, "Couldn''t resolve type: {0}", interfaceName);
            return;
        }
        Set<SourceMethodInfo> applicableMethods = this.addTypeMarker(marker, ci, restrictorSet, inclusive, mark);
        for (SourceClassInfo sci : ci.getSubclasses()) {
            for (SourceMethodInfo smi : applicableMethods) {
                marker.addMethodMark(sci.getQualifiedName(), smi.getName(), smi.getSignature(), mark);
            }
        }
    }

    private void addTypeMarker(final MethodMarker marker, final String type, String[] methodNameRestriction, final boolean inclusive, final Mark mark) {
        Set<String> restrictorSet;
        Set<String> set = restrictorSet = methodNameRestriction != null ? new HashSet<String>(Arrays.asList(methodNameRestriction)) : Collections.EMPTY_SET;
        if (this.associatedParser != null) {
            try {
                this.associatedParser.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        ElementHandle<TypeElement> eh = ElementUtilitiesEx.resolveClassByName(type, cc.getClasspathInfo(), false);
                        if (eh != null) {
                            JavacClassInfo ci = new JavacClassInfo(eh, cc);
                            if (ci == null) {
                                LOGGER.log(Level.FINE, "Couldn''t resolve type: {0}", type);
                                return;
                            }
                            MarkerProcessor.this.addTypeMarker(marker, ci, restrictorSet, inclusive, mark);
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private Set<SourceMethodInfo> addTypeMarker(MethodMarker marker, SourceClassInfo classType, Set<String> restrictors, boolean inclusive, Mark mark) {
        HashSet<SourceMethodInfo> applicableMethods = new HashSet<SourceMethodInfo>();
        for (SourceMethodInfo mi : classType.getMethods(true)) {
            if (Modifier.isPrivate(mi.getModifiers()) || (!inclusive || !restrictors.contains(mi.getName())) && (inclusive || restrictors.contains(mi.getName()))) continue;
            if (!Modifier.isFinal(mi.getModifiers())) {
                applicableMethods.add(mi);
            }
            if (Modifier.isAbstract(mi.getModifiers())) continue;
            marker.addMethodMark(mi.getClassName(), mi.getName(), mi.getSignature(), mark);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "added type marker for {0}", classType.getQualifiedName());
        }
        return applicableMethods;
    }
}

