/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacClassInfo;
import org.openide.filesystems.FileObject;

public class JavacPackageInfo
extends SourcePackageInfo {
    private static final Logger LOGGER = Logger.getLogger(JavacPackageInfo.class.getName());
    private ClasspathInfo cpInfo;
    private Set<ClassIndex.SearchScope> sScope;

    public JavacPackageInfo(ClasspathInfo cpInfo, String simpleName, String fqn, SourcePackageInfo.Scope scope) {
        super(simpleName, fqn, scope);
        this.cpInfo = cpInfo;
        this.sScope = new HashSet<ClassIndex.SearchScope>();
        switch (scope) {
            case SOURCE: {
                this.sScope.add(ClassIndex.SearchScope.SOURCE);
                break;
            }
            case DEPENDENCIES: {
                this.sScope.add(ClassIndex.SearchScope.DEPENDENCIES);
            }
        }
    }

    public Collection<SourceClassInfo> getClasses() {
        final ArrayList<SourceClassInfo> clzs = new ArrayList<SourceClassInfo>();
        JavaSource source = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.PARSED);
                    PackageElement pelem = cc.getElements().getPackageElement(JavacPackageInfo.this.getSimpleName());
                    if (pelem != null) {
                        for (TypeElement type : ElementFilter.typesIn(pelem.getEnclosedElements())) {
                            if (type.getKind() != ElementKind.CLASS && type.getKind() != ElementKind.ENUM) continue;
                            clzs.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)type), cc));
                        }
                    } else {
                        LOGGER.log(Level.FINEST, "Package name {0} resulted into a NULL element", JavacPackageInfo.this.getBinaryName());
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            LOGGER.severe(ex.getLocalizedMessage());
        }
        return clzs;
    }

    public Collection<SourcePackageInfo> getSubpackages() {
        ClassIndex index = this.cpInfo.getClassIndex();
        ArrayList<SourcePackageInfo> pkgs = new ArrayList<SourcePackageInfo>();
        for (String pkgName : index.getPackageNames(this.getBinaryName() + ".", true, this.sScope)) {
            pkgs.add(new JavacPackageInfo(this.cpInfo, pkgName, pkgName, this.getScope()));
        }
        return pkgs;
    }
}

