/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.javac.JavacMethodInfo;
import org.openide.filesystems.FileObject;

public class JavacClassInfo
extends SourceClassInfo {
    private ElementHandle<TypeElement> handle;
    private FileObject src;
    private ClasspathInfo cpInfo;
    private JavaSource source;

    private JavacClassInfo(ElementHandle<TypeElement> eh) {
        super(JavacClassInfo.getSimpleName(eh.getBinaryName()), eh.getBinaryName(), eh.getBinaryName().replace('.', '/'));
        this.handle = eh;
    }

    public JavacClassInfo(ElementHandle<TypeElement> eh, ClasspathInfo cpInfo) {
        this(eh);
        this.cpInfo = cpInfo;
    }

    public JavacClassInfo(ElementHandle<TypeElement> eh, CompilationController cc) {
        this(eh);
        this.cpInfo = cc.getClasspathInfo();
        this.source = cc.getJavaSource();
    }

    public Set<SourceMethodInfo> getMethods(final boolean all) {
        final Set[] rslt = new Set[1];
        if (this.handle != null) {
            try {
                this.getSource(false).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED) == JavaSource.Phase.ELEMENTS_RESOLVED) {
                            rslt[0] = JavacClassInfo.this.getMethods(cc, all);
                        }
                    }
                }, true);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rslt[0] != null ? rslt[0] : Collections.EMPTY_SET;
    }

    public Set<SourceClassInfo> getSubclasses() {
        final Set[] rslt = new Set[]{Collections.EMPTY_SET};
        if (this.handle != null) {
            try {
                this.getSource(true).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        rslt[0] = JavacClassInfo.this.getSubclasses(cc);
                    }
                }, true);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rslt[0] != null ? rslt[0] : Collections.EMPTY_SET;
    }

    public synchronized FileObject getFile() {
        if (this.src == null) {
            this.src = SourceUtils.getFile(this.handle, (ClasspathInfo)this.cpInfo);
            if (this.src == null) {
                String resName = this.handle.getBinaryName().replace('.', '/').concat(".class");
                this.src = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).findResource(resName);
                if (this.src == null) {
                    this.src = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).findResource(resName);
                    if (this.src == null) {
                        this.src = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(resName);
                    }
                }
            }
        }
        return this.src;
    }

    public Set<SourceMethodInfo> getConstructors() {
        final HashSet<SourceMethodInfo> infos = new HashSet<SourceMethodInfo>();
        if (this.handle != null) {
            try {
                this.getSource(false).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED) == JavaSource.Phase.ELEMENTS_RESOLVED) {
                            TypeElement type = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc);
                            for (ExecutableElement method : ElementFilter.constructorsIn(type.getEnclosedElements())) {
                                infos.add(new JavacMethodInfo(method, cc));
                            }
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return infos;
    }

    public Set<SourceClassInfo> getInnerClases() {
        final HashSet<SourceClassInfo> innerClasses = new HashSet<SourceClassInfo>();
        if (this.handle != null) {
            try {
                this.getSource(false).runUserActionTask((Task)new Task<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController cc) throws Exception {
                        if (cc.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                            return;
                        }
                        TypeElement type = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc);
                        List<TypeElement> elements = ElementFilter.typesIn(type.getEnclosedElements());
                        for (TypeElement element : elements) {
                            innerClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)element), cc));
                        }
                        JavacClassInfo.this.addAnonymousInnerClasses(cc, innerClasses);
                    }
                }, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return innerClasses;
    }

    public Set<SourceClassInfo> getInterfaces() {
        final HashSet<SourceClassInfo> ifcs = new HashSet<SourceClassInfo>();
        if (this.handle != null) {
            try {
                this.getSource(true).runUserActionTask((Task)new Task<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement te = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc);
                        Types t = cc.getTypes();
                        for (TypeMirror typeMirror : te.getInterfaces()) {
                            TypeElement ife = (TypeElement)t.asElement(typeMirror);
                            ifcs.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)ife), cc));
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ifcs;
    }

    public SourceClassInfo getSuperType() {
        final SourceClassInfo[] rslt = new SourceClassInfo[1];
        if (this.handle != null) {
            try {
                this.getSource(false).runUserActionTask((Task)new Task<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController cc) throws Exception {
                        TypeElement te;
                        TypeMirror superTm;
                        if (cc.toPhase(JavaSource.Phase.RESOLVED) == JavaSource.Phase.RESOLVED && (superTm = (te = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc)).getSuperclass()) != null) {
                            TypeElement superType = (TypeElement)cc.getTypes().asElement(superTm);
                            rslt[0] = new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)superType), cc);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rslt[0];
    }

    final Set<SourceMethodInfo> getMethods(CompilationController cc, boolean all) {
        HashSet<SourceMethodInfo> mis = new HashSet<SourceMethodInfo>();
        TypeElement te = (TypeElement)this.handle.resolve((CompilationInfo)cc);
        if (te != null) {
            HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>(ElementFilter.methodsIn(te.getEnclosedElements()));
            for (ExecutableElement method : ElementFilter.methodsIn(cc.getElements().getAllMembers(te))) {
                String parent = ElementUtilities.getBinaryName((TypeElement)((TypeElement)method.getEnclosingElement()));
                if (!parent.equals(this.getQualifiedName()) && (!all || JavacClassInfo.containsAny(method.getModifiers(), EnumSet.of(Modifier.PRIVATE, Modifier.FINAL)) || parent.equals(Object.class.getName()))) continue;
                methods.add(method);
            }
            for (ExecutableElement method : methods) {
                mis.add(new JavacMethodInfo(method, cc));
            }
        }
        return mis;
    }

    final Set<SourceClassInfo> getSubclasses(CompilationController cc) {
        HashSet<SourceClassInfo> subs = new HashSet<SourceClassInfo>();
        TypeElement te = (TypeElement)this.handle.resolve((CompilationInfo)cc);
        if (te != null) {
            for (ElementHandle<TypeElement> eh : JavacClassInfo.findImplementors(cc.getClasspathInfo(), this.handle)) {
                subs.add(new JavacClassInfo(eh, cc));
            }
        }
        return subs;
    }

    final Set<SourceClassInfo> getSuperclasses(CompilationController cc) {
        HashSet<SourceClassInfo> sups = new HashSet<SourceClassInfo>();
        TypeElement te = (TypeElement)this.handle.resolve((CompilationInfo)cc);
        if (te != null) {
            this.collectSuperclass(cc, te, sups);
        }
        return sups;
    }

    private void collectSuperclass(CompilationController cc, TypeElement te, Set<SourceClassInfo> superClasses) {
        TypeElement sType = (TypeElement)cc.getTypes().asElement(te.getSuperclass());
        if (sType != null) {
            superClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)sType), cc));
            this.collectSuperclass(cc, sType, superClasses);
        }
    }

    private static String getSimpleName(String qualName) {
        String name = qualName;
        int lastDot = name.lastIndexOf(".");
        if (lastDot > -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    private static Set<ElementHandle<TypeElement>> findImplementors(ClasspathInfo cpInfo, ElementHandle<TypeElement> baseType) {
        HashSet tmpImplementors;
        EnumSet<ClassIndex.SearchKind> kind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
        EnumSet<ClassIndex.SearchScope> scope = EnumSet.allOf(ClassIndex.SearchScope.class);
        HashSet<ElementHandle<TypeElement>> allImplementors = new HashSet<ElementHandle<TypeElement>>();
        HashSet implementors = cpInfo.getClassIndex().getElements(baseType, kind, scope);
        do {
            tmpImplementors = new HashSet();
            allImplementors.addAll(implementors);
            for (ElementHandle element : implementors) {
                tmpImplementors.addAll(cpInfo.getClassIndex().getElements(element, kind, scope));
            }
        } while (!(implementors = tmpImplementors).isEmpty());
        return allImplementors;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JavacClassInfo other = (JavacClassInfo)((Object)obj);
        if (!(this.handle == other.handle || this.handle != null && this.handle.equals(other.handle))) {
            return false;
        }
        if (this.src != null && this.src != other.src && !this.src.equals(other.src)) {
            return false;
        }
        return this.cpInfo == null || this.cpInfo == other.cpInfo || this.cpInfo.equals((Object)other.cpInfo);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.handle != null ? this.handle.hashCode() : 0);
        hash = 89 * hash + (this.src != null ? this.src.hashCode() : 0);
        hash = 89 * hash + (this.cpInfo != null ? this.cpInfo.hashCode() : 0);
        return hash;
    }

    private void addAnonymousInnerClasses(final CompilationController cc, final Set<SourceClassInfo> innerClasses) throws IOException {
        final int parentClassNameLength = this.getQualifiedName().length();
        cc.toPhase(JavaSource.Phase.RESOLVED);
        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void v) {
                TypeElement innerClassElement;
                String className;
                Element classElement = cc.getTrees().getElement(this.getCurrentPath());
                if (classElement != null && classElement.getKind() == ElementKind.CLASS && JavacClassInfo.this.isAnonymous(className = (className = ElementUtilities.getBinaryName((TypeElement)(innerClassElement = (TypeElement)classElement))).length() <= parentClassNameLength ? "" : className.substring(parentClassNameLength))) {
                    innerClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)innerClassElement), cc));
                }
                super.visitClass(node, v);
                return null;
            }
        };
        scanner.scan(cc.getCompilationUnit(), null);
    }

    private static <T> boolean containsAny(Set<T> superSet, Set<T> subSet) {
        HashSet<T> set = new HashSet<T>(superSet);
        return set.removeAll(subSet);
    }

    private synchronized JavaSource getSource(boolean allowSourceLess) {
        JavaSource jSrc = this.source;
        if (jSrc == null || !allowSourceLess && jSrc.getFileObjects().isEmpty()) {
            FileObject f = this.getFile();
            if (f.getExt().toLowerCase().equals("java")) {
                jSrc = this.cpInfo != null ? JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.getFile()}) : JavaSource.forFileObject((FileObject)this.getFile());
            } else if (this.cpInfo != null) {
                jSrc = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            }
            this.source = jSrc;
        }
        return this.source;
    }
}

