/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.utils.OutputParameter;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectSensitiveAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    protected volatile boolean actionEnabled = false;
    private final Lookup lookup;
    private final Object initLock = new Object();
    private final Object refreshRequestLock = new Object();
    private final ProfilerProjectActionPerformer performer;
    private final String namePattern;
    private final Lookup.Result[] results;
    private final Class[] watch;
    private volatile boolean isCalculated = false;
    private int refreshRequested = 0;

    ProjectSensitiveAction(ProfilerProjectActionPerformer performer, String name, String namePattern, Icon icon, Lookup lookup) {
        super(name);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
        if (lookup == null) {
            lookup = Utilities.actionsGlobalContext();
        }
        this.lookup = lookup;
        this.watch = new Class[]{Project.class, DataObject.class};
        this.results = new Lookup.Result[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            Lookup.Result result = lookup.lookup(new Lookup.Template(this.watch[i]));
            result.addLookupListener((LookupListener)this);
            this.results[i] = result;
        }
        this.performer = performer;
        this.namePattern = namePattern;
        this.init();
    }

    @Override
    public final boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.actionPerformed(this.lookup);
    }

    public static ProjectSensitiveAction projectSensitiveAction(ProfilerProjectActionPerformer performer, String name, String namePattern, Icon icon) {
        return new ProjectSensitiveAction(performer, name, namePattern, icon, null);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ProjectSensitiveAction(this.getPerformer(), this.getName(), this.getNamePattern(), (Icon)this.getValue("SmallIcon"), actionContext);
    }

    public final void resultChanged(LookupEvent e) {
        this.isCalculated = false;
    }

    protected final void setDisplayName(String name) {
        this.putValue("Name", name);
    }

    protected final String getName() {
        return (String)this.getValue("Name");
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    protected final ProfilerProjectActionPerformer getPerformer() {
        return this.performer;
    }

    protected void actionPerformed(final Lookup context) {
        final Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length == 1 && this.performer != null) {
            new NBSwingWorker(false){
                private boolean isEnabled;
                private final OutputParameter<Boolean> isCancelled;
                private final OutputParameter<ProgressDisplayer> progress;
                {
                    super(x0);
                    this.isEnabled = false;
                    this.isCancelled = new OutputParameter((Object)Boolean.FALSE);
                    this.progress = new OutputParameter(null);
                }

                protected void doInBackground() {
                    this.isEnabled = ProjectSensitiveAction.this.performer.enable(projects[0], context, false);
                }

                protected void done() {
                    if (this.progress.isSet()) {
                        ((ProgressDisplayer)this.progress.getValue()).close();
                    }
                    if (this.isEnabled && !((Boolean)this.isCancelled.getValue()).booleanValue()) {
                        ProjectSensitiveAction.this.performer.perform(projects[0], context);
                    } else if (!((Boolean)this.isCancelled.getValue()).booleanValue()) {
                        ProfilerDialogs.displayInfo((String)NbBundle.getMessage(ProjectSensitiveAction.class, (String)"AntActions_LazyEnablementFailure"));
                    }
                }

                protected void nonResponding() {
                    this.progress.setValue((Object)ProgressDisplayer.showProgress((String)ResourceBundle.getBundle("org/netbeans/modules/profiler/actions/Bundle").getString("AntActions_LazyEnablementProgressMessage"), (ProgressDisplayer.ProgressController)new ProgressDisplayer.ProgressController(){

                        public boolean cancel() {
                            if (progress.isSet()) {
                                ((ProgressDisplayer)progress.getValue()).close();
                            }
                            progress.setValue(null);
                            isCancelled.setValue((Object)true);
                            return true;
                        }
                    }));
                }
            }.execute();
        }
    }

    protected void doRefresh(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        this.setDisplayName(ActionsUtil.formatProjectSensitiveName(this.getNamePattern(), projects));
        if (projects != null && projects.length == 1) {
            this.setEnabled(this.getPerformer().enable(projects[0], context, true));
        } else {
            this.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.isCalculated) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.isCalculated) {
                return;
            }
            this.refresh(this.lookup);
            this.isCalculated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(final Lookup context) {
        Object object = this.refreshRequestLock;
        synchronized (object) {
            if (this.refreshRequested++ > 0) {
                return;
            }
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int oldReqCount = -1;
                    int currentReqCount = -1;
                    Object object = ProjectSensitiveAction.this.refreshRequestLock;
                    synchronized (object) {
                        oldReqCount = ProjectSensitiveAction.this.refreshRequested;
                    }
                    ProjectSensitiveAction.this.doRefresh(ProjectSensitiveAction.this.lookup);
                    object = ProjectSensitiveAction.this.refreshRequestLock;
                    synchronized (object) {
                        currentReqCount = ProjectSensitiveAction.this.refreshRequested;
                        ProjectSensitiveAction.this.refreshRequested = 0;
                    }
                    if (oldReqCount != currentReqCount) {
                        ProjectSensitiveAction.this.refresh(context);
                    }
                }
            });
        }
    }

    public static final class ActionsUtil {
        public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
            HashSet<FileObject> result = new HashSet<FileObject>();
            Collection dataObjects = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
            for (DataObject dObj : dataObjects) {
                FileObject fObj = dObj.getPrimaryFile();
                Project p = FileOwnerQuery.getOwner((FileObject)fObj);
                if (p == null || !p.equals(project)) continue;
                result.add(fObj);
            }
            FileObject[] fos = new FileObject[result.size()];
            result.toArray(fos);
            return fos;
        }

        public static Project[] getProjectsFromLookup(Lookup lookup, String command) {
            HashSet<Project> result = new HashSet<Project>();
            Collection projects = lookup.lookup(new Lookup.Template(Project.class)).allInstances();
            for (Project p : projects) {
                result.add(p);
            }
            Collection dataObjects = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
            for (DataObject dObj : dataObjects) {
                FileObject fObj = dObj.getPrimaryFile();
                Project p = FileOwnerQuery.getOwner((FileObject)fObj);
                if (p == null) continue;
                result.add(p);
            }
            Project[] projectsArray = new Project[result.size()];
            result.toArray(projectsArray);
            if (command != null) {
                for (int i = 0; i < projectsArray.length; ++i) {
                    if (ActionsUtil.commandSupported(projectsArray[i], command, lookup)) continue;
                    return new Project[0];
                }
            }
            return projectsArray;
        }

        public static boolean commandSupported(Project project, String command, Lookup context) {
            List<String> commands;
            ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            return ap != null && (commands = Arrays.asList(ap.getSupportedActions())).contains(command) && (context == null || ap.isActionEnabled(command, context));
        }

        public static String formatName(String namePattern, int numberOfObjects, String firstObjectName) {
            return MessageFormat.format(namePattern, numberOfObjects, firstObjectName == null ? "" : firstObjectName);
        }

        public static String formatProjectSensitiveName(String namePattern, Project[] projects) {
            if (projects == null || projects.length == 0) {
                return ActionsUtil.formatName(namePattern, 0, null);
            }
            return ActionsUtil.formatName(namePattern, projects.length, ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
        }
    }

    public static interface ProfilerProjectActionPerformer {
        public boolean enable(Project var1, Lookup var2, boolean var3);

        public void perform(Project var1, Lookup var2);
    }
}

