/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class ListEditorPanel<E>
extends JPanel {
    private JList targetList = null;
    private List<E> listData = new ArrayList();
    private boolean allowedToRemoveAll = true;
    protected JButton[] extraButtons;
    private boolean isChanged = false;
    private JButton addButton;
    private JPanel controlsPanel;
    private JButton copyButton;
    private JPanel dataPanel;
    private JButton defaultButton;
    private JButton downButton;
    private JLabel listLabel;
    private JButton removeButton;
    private JButton renameButton;
    private JScrollPane scrollPane;
    private JButton upButton;

    public ListEditorPanel(Collection<E> objects) {
        this(objects, null);
    }

    public ListEditorPanel(Collection<E> objects, JButton[] extraButtons) {
        this.initComponents();
        this.extraButtons = extraButtons;
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.listLabel.setText(this.getListLabelText());
        this.listLabel.setDisplayedMnemonic(this.getListLabelMnemonic());
        this.addButton.setText(this.getAddButtonText());
        this.addButton.setMnemonic(this.getAddButtonMnemonics());
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getAddButtonAD());
        this.copyButton.setText(this.getCopyButtonText());
        this.copyButton.setMnemonic(this.getCopyButtonMnemonics());
        this.copyButton.getAccessibleContext().setAccessibleDescription(this.getCopyButtonAD());
        this.renameButton.setText(this.getRenameButtonText());
        this.renameButton.setMnemonic(this.getRenameButtonMnemonics());
        this.renameButton.getAccessibleContext().setAccessibleDescription(this.getRenameButtonAD());
        this.removeButton.setText(this.getRemoveButtonText());
        this.removeButton.setMnemonic(this.getRemoveButtonMnemonics());
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getRemoveButtonAD());
        this.upButton.setText(this.getUpButtonText());
        this.upButton.setMnemonic(this.getUpButtonMnemonics());
        this.upButton.getAccessibleContext().setAccessibleDescription(this.getUpButtonAD());
        this.downButton.setText(this.getDownButtonText());
        this.downButton.setMnemonic(this.getDownButtonMnemonics());
        this.downButton.getAccessibleContext().setAccessibleDescription(this.getDownButtonAD());
        this.defaultButton.setText(this.getDefaultButtonText());
        this.defaultButton.setMnemonic(this.getDefaultButtonMnemonics());
        this.defaultButton.getAccessibleContext().setAccessibleDescription(this.getDefaultButtonAD());
        if (objects != null) {
            for (E o : objects) {
                this.listData.add(o);
            }
        }
        this.targetList = new JList();
        this.targetList.setVisibleRowCount(6);
        this.targetList.setModel(new MyModel(this.listData));
        this.targetList.addListSelectionListener(new TargetSelectionListener());
        this.targetList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object[] ob = ListEditorPanel.this.targetList.getSelectedValues();
                if (ob.length != 1) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    me.consume();
                    ListEditorPanel.this.editObjectAction();
                }
            }
        });
        this.targetList.getSelectionModel().setSelectionMode(0);
        this.scrollPane.setViewportView(this.getViewComponent());
        this.listLabel.setLabelFor(this.targetList);
        this.initAccessibility();
        if (this.targetList.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.targetList.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
        if (extraButtons != null) {
            int index = 1;
            for (int i = 0; i < extraButtons.length; ++i) {
                this.addExtraButton(extraButtons[i], index++);
            }
        }
        this.checkSelection();
    }

    public final void addExtraButton(JButton button, int index) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add(button, gridBagConstraints, index);
    }

    public void setAllowedToRemoveAll(boolean b) {
        this.allowedToRemoveAll = b;
        this.checkSelection();
    }

    public boolean getAllowedToRemoveAll() {
        return this.allowedToRemoveAll;
    }

    public JLabel getListLabel() {
        return this.listLabel;
    }

    protected final void setCustomCellRenderer(ListCellRenderer renderer) {
        this.targetList.setCellRenderer(renderer);
    }

    protected String getListLabelText() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_LBL");
    }

    protected char getListLabelMnemonic() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_MNEMONIC").toCharArray()[0];
    }

    protected String getAddButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_LBL");
    }

    protected char getAddButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getAddButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_AD");
    }

    protected String getCopyButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_LBL");
    }

    protected char getCopyButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getCopyButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_AD");
    }

    protected String getRenameButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_LBL");
    }

    protected char getRenameButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getRenameButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_AD");
    }

    protected String getRemoveButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL");
    }

    protected char getRemoveButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getRemoveButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_AD");
    }

    protected String getUpButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_LBL");
    }

    protected char getUpButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getUpButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_AD");
    }

    protected String getDownButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_LBL");
    }

    protected char getDownButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getDownButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_AD");
    }

    protected String getDefaultButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_LBL");
    }

    protected char getDefaultButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_MNEMONIC").toCharArray()[0];
    }

    protected String getDefaultButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_AD");
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JButton getEditButton() {
        return this.renameButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    @Override
    public void setEnabled(boolean b) {
        this.listLabel.setEnabled(b);
        this.targetList.setEnabled(b);
        this.addButton.setEnabled(b);
        this.copyButton.setEnabled(b);
        this.renameButton.setEnabled(b);
        this.removeButton.setEnabled(b);
        this.upButton.setEnabled(b);
        this.downButton.setEnabled(b);
        this.defaultButton.setEnabled(b);
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_EDITOR"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_EDITOR"));
        context = this.targetList.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlsPanel = new JPanel();
        this.addButton = new JButton();
        this.copyButton = new JButton();
        this.renameButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.defaultButton = new JButton();
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.dataPanel.setRequestFocusEnabled(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_LIST_MNEMONIC").charAt(0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle");
        this.listLabel.setText(bundle.getString("TARGET_EDITOR_LIST_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.dataPanel.add((Component)this.listLabel, gridBagConstraints);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dataPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.controlsPanel.setOpaque(false);
        this.controlsPanel.setRequestFocusEnabled(false);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").charAt(0));
        this.addButton.setText(bundle.getString("TARGET_EDITOR_ADD_BUTTON_LBL"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.addButton, gridBagConstraints);
        this.copyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").charAt(0));
        this.copyButton.setText(bundle.getString("TARGET_EDITOR_COPY_BUTTON_LBL"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.controlsPanel.add((Component)this.copyButton, gridBagConstraints);
        this.renameButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").charAt(0));
        this.renameButton.setText(bundle.getString("TARGET_EDITOR_RENAME_BUTTON_LBL"));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").charAt(0));
        this.removeButton.setText(bundle.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.controlsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(bundle.getString("TARGET_EDITOR_UP_BUTTON_LBL"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(bundle.getString("TARGET_EDITOR_DOWN_BUTTON_LBL"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.controlsPanel.add((Component)this.downButton, gridBagConstraints);
        this.defaultButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/utils/ui/Bundle").getString("TARGET_EDITOR_DEFAULT_BUTTON_MNEMONIC").charAt(0));
        this.defaultButton.setText(bundle.getString("TARGET_EDITOR_DEFAULT_BUTTON_LBL"));
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.defaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.controlsPanel.add((Component)this.defaultButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.dataPanel.add((Component)this.controlsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    public void defaultAction(E o) {
    }

    private synchronized void defaultObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        this.defaultAction(this.listData.get(selectedIndex));
        this.isChanged = true;
        this.setData(this.listData);
        this.setSelectedIndex(selectedIndex);
        this.defaultButton.requestFocus();
        this.checkSelection();
        this.defaultButton.requestFocus();
    }

    private void defaultButtonActionPerformed(ActionEvent evt) {
        this.defaultObjectAction();
    }

    public void editAction(E o, int i) {
    }

    private synchronized void editObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        this.editAction(this.listData.get(selectedIndex), selectedIndex);
        this.isChanged = true;
        this.setData(this.listData);
        this.setSelectedIndex(selectedIndex);
        this.renameButton.requestFocus();
        this.checkSelection();
        this.renameButton.requestFocus();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        this.editObjectAction();
    }

    public E copyAction(E o) {
        return null;
    }

    private synchronized void copyObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        E newObject = this.copyAction(this.listData.get(selectedIndex));
        if (newObject == null) {
            return;
        }
        this.isChanged = true;
        int addAtIndex = this.listData.size();
        this.listData.add(addAtIndex, newObject);
        this.setData(this.listData);
        this.setSelectedIndex(addAtIndex);
        this.copyButton.requestFocus();
        this.checkSelection();
        this.copyButton.requestFocus();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.copyObjectAction();
    }

    public void downAction(int from) {
    }

    private synchronized void downAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size() - 1) {
            return;
        }
        this.downAction(selectedIndex);
        this.isChanged = true;
        E tmp = this.listData.get(selectedIndex);
        this.listData.remove(selectedIndex);
        this.listData.add(++selectedIndex, tmp);
        this.setData(this.listData);
        if (selectedIndex >= 0) {
            this.ensureIndexIsVisible(selectedIndex);
            this.checkSelection(selectedIndex);
            this.setSelectedIndex(selectedIndex);
        } else {
            this.checkSelection();
        }
        if (this.downButton.isEnabled()) {
            this.downButton.requestFocus();
        } else {
            this.upButton.requestFocus();
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.downAction();
    }

    public void upAction(int from) {
    }

    private synchronized void upAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex <= 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        this.upAction(selectedIndex);
        this.isChanged = true;
        E tmp = this.listData.get(selectedIndex);
        this.listData.remove(selectedIndex);
        this.listData.add(--selectedIndex, tmp);
        this.setData(this.listData);
        if (selectedIndex >= 0) {
            this.ensureIndexIsVisible(selectedIndex);
            this.checkSelection(selectedIndex);
            this.setSelectedIndex(selectedIndex);
        } else {
            this.checkSelection();
        }
        if (this.upButton.isEnabled()) {
            this.upButton.requestFocus();
        } else {
            this.downButton.requestFocus();
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.upAction();
    }

    public void removeAction(E o, int i) {
    }

    private synchronized void removeObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        this.removeAction(this.listData.get(selectedIndex), selectedIndex);
        this.isChanged = true;
        this.listData.remove(selectedIndex);
        this.setData(this.listData);
        int n = selectedIndex = selectedIndex >= this.listData.size() ? selectedIndex - 1 : selectedIndex;
        if (selectedIndex >= 0) {
            this.ensureIndexIsVisible(selectedIndex);
            this.checkSelection(selectedIndex);
            this.setSelectedIndex(selectedIndex);
        } else {
            this.checkSelection();
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeObjectAction();
    }

    public E addAction() {
        return null;
    }

    private void addObjectAction() {
        this.addObjectAction(this.addAction());
    }

    public void addObjectAction(E newObject) {
        if (newObject == null) {
            return;
        }
        ArrayList<E> listToAdd = new ArrayList<E>();
        listToAdd.add(newObject);
        this.addObjectsAction(listToAdd);
    }

    protected final synchronized void addObjectsAction(List<E> listToAdd) {
        if (listToAdd == null || listToAdd.isEmpty()) {
            return;
        }
        this.isChanged = true;
        int addAtIndex = this.listData.size();
        ArrayList<E> newListData = new ArrayList<E>();
        newListData.addAll(this.listData);
        newListData.addAll(listToAdd);
        this.listData = newListData;
        this.setData(this.listData);
        this.setSelectedIndex(addAtIndex);
        this.ensureIndexIsVisible(addAtIndex);
        this.checkSelection();
        this.addButton.requestFocus();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addObjectAction();
    }

    public JPanel getDataPanel() {
        return this.dataPanel;
    }

    protected void checkSelection() {
        this.checkSelection(this.getSelectedIndex());
    }

    protected final synchronized void checkSelection(int i) {
        if (i >= 0 && this.listData.size() > 0) {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(true);
            this.renameButton.setEnabled(true);
            if (this.allowedToRemoveAll) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(this.listData.size() > 1);
            }
            this.upButton.setEnabled(i != 0);
            this.downButton.setEnabled(i < this.listData.size() - 1);
            this.defaultButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.defaultButton.setEnabled(false);
        }
    }

    public final synchronized List<E> getListData() {
        return new ArrayList<E>(this.listData);
    }

    protected final synchronized int getListDataSize() {
        return this.listData.size();
    }

    protected final synchronized E getElementAt(int i) {
        return this.listData.get(i);
    }

    protected synchronized void replaceElement(E oldElement, E newElement, int index) {
        Object[] arr = this.listData.toArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != oldElement) continue;
            this.listData.remove(i);
            this.listData.add(i, newElement);
            break;
        }
    }

    public synchronized int getSelectedIndex() {
        int index = this.targetList.getSelectedIndex();
        if (index >= 0 && index < this.listData.size()) {
            return index;
        }
        return 0;
    }

    protected void setSelectedIndex(int i) {
        this.targetList.setSelectedIndex(i);
    }

    protected void setData(List<E> data) {
        this.targetList.setModel(new MyModel(data));
    }

    protected void ensureIndexIsVisible(int selectedIndex) {
        this.targetList.ensureIndexIsVisible(selectedIndex);
    }

    protected Component getViewComponent() {
        return this.targetList;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ListEditorPanel.class, (String)key);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDataValid() {
        return true;
    }

    private static final class MyModel<E>
    extends AbstractListModel {
        private final List<E> listData;

        private MyModel(List<E> listData) {
            this.listData = listData;
        }

        @Override
        public int getSize() {
            return this.listData.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.listData.get(i);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListEditorPanel.this.checkSelection();
        }
    }
}

