/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class JSFConfigEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private static final RequestProcessor requestProcessor = new RequestProcessor(JSFConfigEditorSupport.class);
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JSFConfigDataObject obj = (JSFConfigDataObject)JSFConfigEditorSupport.this.getDataObject();
            JSFConfigEditorSupport.this.restartTimer();
            obj.parsingDocument();
            if (obj.isDocumentValid()) {
                JSFConfigEditorSupport.this.saveDocument();
            } else {
                DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
                d.setVisible(true);
                if (dialog.getValue() == DialogDescriptor.OK_OPTION) {
                    JSFConfigEditorSupport.this.saveDocument();
                }
            }
        }
    };
    private JSFConfigDataObject dataObject;
    private RequestProcessor.Task parsingDocumentTask;
    private TopComponent mvtc;
    private static final int AUTO_PARSING_DELAY = 2000;
    private int click = 0;

    public JSFConfigEditorSupport(JSFConfigDataObject dobj) {
        super((DataObject)dobj, null, (CloneableEditorSupport.Env)new XmlEnv(dobj));
        this.dataObject = dobj;
        this.setMIMEType("text/x-jsf+xml");
        this.initialize();
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-jsf+xml", (Serializable)this.getDataObject());
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        super.initializeCloneableEditor(editor);
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent tc = super.createCloneableTopComponent();
        this.mvtc = tc;
        this.updateDisplayName();
        return tc;
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    protected void setMVTC(TopComponent mvtc) {
        this.mvtc = mvtc;
        this.updateDisplayName();
    }

    public void updateDisplayName() {
        final TopComponent tc = this.mvtc;
        if (tc == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String displayName = JSFConfigEditorSupport.this.messageHtmlName();
                if (!displayName.equals(tc.getDisplayName())) {
                    tc.setHtmlDisplayName(displayName);
                }
                tc.setToolTipText(JSFConfigEditorSupport.this.dataObject.getPrimaryFile().getPath());
            }
        });
    }

    private void initialize() {
        final DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.change(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.change(e);
            }

            private void change(DocumentEvent e) {
                if (!JSFConfigEditorSupport.this.dataObject.isNodeDirty()) {
                    JSFConfigEditorSupport.this.restartTimer();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StyledDocument doc = JSFConfigEditorSupport.this.getDocument();
                if ("document".equals(evt.getPropertyName()) && JSFConfigEditorSupport.this.isDocumentLoaded() && doc != null) {
                    doc.addDocumentListener(docListener);
                }
            }
        });
    }

    public void saveDocument() throws IOException {
        final StyledDocument doc = this.getDocument();
        String defaultEncoding = "UTF-8";
        String enc = EncodingUtil.detectEncoding((Document)doc);
        boolean changeEncodingToDefault = false;
        if (enc == null) {
            enc = defaultEncoding;
        }
        if (!this.isSupportedEncoding(enc)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc, defaultEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            changeEncodingToDefault = true;
        }
        if (!changeEncodingToDefault) {
            try {
                CharsetEncoder coder = Charset.forName(enc).newEncoder();
                if (!coder.canEncode(doc.getText(0, doc.getLength()))) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc}), 0, 2);
                    nd.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int MAX_PROLOG = 1000;
                int maxPrologLen = Math.min(1000, doc.getLength());
                final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                int prologLen = 0;
                if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                    for (int i = 3; i < maxPrologLen; ++i) {
                        if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                        prologLen = i + 1;
                        break;
                    }
                }
                final int passPrologLen = prologLen;
                Runnable edit = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                doc.remove(0, passPrologLen + 1);
                                doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                            }
                            catch (BadLocationException e) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                e.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    public void restartTimer() {
        if (this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel()) {
            this.dataObject.setDocumentDirty(true);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    JSFConfigEditorSupport.this.dataObject.parsingDocument();
                }
            };
            this.parsingDocumentTask = this.parsingDocumentTask != null ? requestProcessor.post(r, 2000) : requestProcessor.post(r, 100);
        }
    }

    protected boolean notifyModified() {
        boolean notif = super.notifyModified();
        if (!notif) {
            return false;
        }
        this.updateDisplayName();
        this.addSaveCookie();
        return true;
    }

    protected void notifyClosed() {
        this.mvtc = null;
        super.notifyClosed();
        final JSFConfigModel configModel = ConfigurationUtils.getConfigModel(this.dataObject.getPrimaryFile(), true);
        requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                try {
                    if (configModel != null) {
                        configModel.sync();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Sync Config Model took: " + (System.currentTimeMillis() - time) + " ms");
            }
        });
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.updateDisplayName();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        if (this.dataObject.getCookie(SaveCookie.class) == null) {
            this.dataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            this.dataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        JSFConfigDataObject obj = (JSFConfigDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    public void open() {
        super.open();
        this.restartTimer();
        this.updateDisplayName();
    }

    public void edit() {
        this.open();
        JSFConfigEditorSupport.runInAwtDispatchThread(new Runnable(){

            @Override
            public void run() {
                MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)JSFConfigEditorSupport.this.mvtc);
                if (handler != null) {
                    handler.requestVisible(handler.getPerspectives()[handler.getPerspectives().length - 1]);
                    JSFConfigEditorSupport.this.mvtc.requestActive();
                }
            }
        });
    }

    private static void runInAwtDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(JSFConfigDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JSFConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (JSFConfigEditorSupport)this.getDataObject().getCookie(JSFConfigEditorSupport.class);
        }
    }
}

