/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lib.api.CssTokenIdCategory;
import org.netbeans.modules.css.lib.nblexer.CssLanguageHierarchy;

public enum CssTokenId implements TokenId
{
    EOF(-1, CssTokenIdCategory.OTHERS),
    ERROR(0, CssTokenIdCategory.ERRORS),
    AND(18, CssTokenIdCategory.KEYWORDS),
    NOT(17, CssTokenIdCategory.KEYWORDS),
    ONLY(16, CssTokenIdCategory.KEYWORDS),
    RESOLUTION(65, CssTokenIdCategory.NUMBERS),
    WS(4, CssTokenIdCategory.WHITESPACES),
    CHARSET_SYM(9, CssTokenIdCategory.KEYWORDS),
    STRING(7, CssTokenIdCategory.STRINGS),
    SEMI(10, CssTokenIdCategory.SEPARATORS),
    IMPORT_SYM(11, CssTokenIdCategory.KEYWORDS),
    URI(8, CssTokenIdCategory.URIS),
    COMMA(15, CssTokenIdCategory.SEPARATORS),
    MEDIA_SYM(12, CssTokenIdCategory.KEYWORDS),
    LBRACE(13, CssTokenIdCategory.BRACES),
    RBRACE(14, CssTokenIdCategory.BRACES),
    IDENT(6, CssTokenIdCategory.IDENTIFIERS),
    PAGE_SYM(20, CssTokenIdCategory.KEYWORDS),
    COLON(38, CssTokenIdCategory.SEPARATORS),
    DCOLON(49, CssTokenIdCategory.SEPARATORS),
    SOLIDUS(39, CssTokenIdCategory.OTHERS),
    PLUS(40, CssTokenIdCategory.OPERATORS),
    GREATER(41, CssTokenIdCategory.OPERATORS),
    TILDE(42, CssTokenIdCategory.OPERATORS),
    MINUS(43, CssTokenIdCategory.OPERATORS),
    STAR(44, CssTokenIdCategory.OPERATORS),
    HASH(46, CssTokenIdCategory.HASHES),
    DOT(47, CssTokenIdCategory.OPERATORS),
    LBRACKET(48, CssTokenIdCategory.BRACES),
    OPEQ(50, CssTokenIdCategory.OTHERS),
    INCLUDES(51, CssTokenIdCategory.OPERATORS),
    DASHMATCH(52, CssTokenIdCategory.OPERATORS),
    RBRACKET(53, CssTokenIdCategory.BRACES),
    LPAREN(54, CssTokenIdCategory.BRACES),
    RPAREN(55, CssTokenIdCategory.BRACES),
    IMPORTANT_SYM(56, CssTokenIdCategory.KEYWORDS),
    NUMBER(57, CssTokenIdCategory.NUMBERS),
    PERCENTAGE(58, CssTokenIdCategory.NUMBERS),
    LENGTH(59, CssTokenIdCategory.NUMBERS),
    EMS(60, CssTokenIdCategory.NUMBERS),
    EXS(61, CssTokenIdCategory.NUMBERS),
    ANGLE(62, CssTokenIdCategory.NUMBERS),
    TIME(63, CssTokenIdCategory.NUMBERS),
    FREQ(64, CssTokenIdCategory.NUMBERS),
    HEXCHAR(66, CssTokenIdCategory.NUMBERS),
    NONASCII(67, CssTokenIdCategory.OTHERS),
    UNICODE(68, CssTokenIdCategory.OTHERS),
    ESCAPE(69, CssTokenIdCategory.OTHERS),
    NMSTART(70, CssTokenIdCategory.OTHERS),
    NMCHAR(71, CssTokenIdCategory.OTHERS),
    NAME(72, CssTokenIdCategory.OTHERS),
    URL(73, CssTokenIdCategory.URIS),
    A(74, CssTokenIdCategory.OTHERS),
    B(75, CssTokenIdCategory.OTHERS),
    C(76, CssTokenIdCategory.OTHERS),
    D(77, CssTokenIdCategory.OTHERS),
    E(78, CssTokenIdCategory.OTHERS),
    F(79, CssTokenIdCategory.OTHERS),
    G(80, CssTokenIdCategory.OTHERS),
    H(81, CssTokenIdCategory.OTHERS),
    I(82, CssTokenIdCategory.OTHERS),
    J(83, CssTokenIdCategory.OTHERS),
    K(84, CssTokenIdCategory.OTHERS),
    L(85, CssTokenIdCategory.OTHERS),
    M(86, CssTokenIdCategory.OTHERS),
    N(87, CssTokenIdCategory.OTHERS),
    O(88, CssTokenIdCategory.OTHERS),
    P(89, CssTokenIdCategory.OTHERS),
    Q(90, CssTokenIdCategory.OTHERS),
    R(91, CssTokenIdCategory.OTHERS),
    S(92, CssTokenIdCategory.OTHERS),
    T(93, CssTokenIdCategory.OTHERS),
    U(94, CssTokenIdCategory.OTHERS),
    V(95, CssTokenIdCategory.OTHERS),
    W(96, CssTokenIdCategory.OTHERS),
    X(97, CssTokenIdCategory.OTHERS),
    Y(98, CssTokenIdCategory.OTHERS),
    Z(99, CssTokenIdCategory.OTHERS),
    COMMENT(100, CssTokenIdCategory.COMMENTS),
    CDO(101, CssTokenIdCategory.OTHERS),
    CDC(102, CssTokenIdCategory.OTHERS),
    INVALID(103, CssTokenIdCategory.OTHERS),
    DIMENSION(104, CssTokenIdCategory.NUMBERS),
    NL(105, CssTokenIdCategory.OTHERS),
    PIPE(45, CssTokenIdCategory.OPERATORS),
    GEN(19, CssTokenIdCategory.OTHERS),
    NAMESPACE_SYM(5, CssTokenIdCategory.KEYWORDS),
    TOPLEFTCORNER_SYM(22, CssTokenIdCategory.KEYWORDS),
    TOPLEFT_SYM(23, CssTokenIdCategory.KEYWORDS),
    TOPCENTER_SYM(24, CssTokenIdCategory.KEYWORDS),
    TOPRIGHT_SYM(25, CssTokenIdCategory.KEYWORDS),
    TOPRIGHTCORNER_SYM(26, CssTokenIdCategory.KEYWORDS),
    BOTTOMLEFTCORNER_SYM(27, CssTokenIdCategory.KEYWORDS),
    BOTTOMLEFT_SYM(28, CssTokenIdCategory.KEYWORDS),
    BOTTOMCENTER_SYM(29, CssTokenIdCategory.KEYWORDS),
    BOTTOMRIGHT_SYM(30, CssTokenIdCategory.KEYWORDS),
    BOTTOMRIGHTCORNER_SYM(31, CssTokenIdCategory.KEYWORDS),
    LEFTTOP_SYM(32, CssTokenIdCategory.KEYWORDS),
    LEFTMIDDLE_SYM(33, CssTokenIdCategory.KEYWORDS),
    LEFTBOTTOM_SYM(34, CssTokenIdCategory.KEYWORDS),
    RIGHTTOP_SYM(35, CssTokenIdCategory.KEYWORDS),
    RIGHTMIDDLE_SYM(36, CssTokenIdCategory.KEYWORDS),
    RIGHTBOTTOM_SYM(37, CssTokenIdCategory.KEYWORDS),
    COUNTER_STYLE_SYM(21, CssTokenIdCategory.KEYWORDS);

    private static final Map<Integer, CssTokenId> codesMap;
    private final CssTokenIdCategory primaryCategory;
    private final int code;
    private static final Language<CssTokenId> language;

    public static CssTokenId forTokenTypeCode(int tokenTypeCode) {
        return codesMap.get(tokenTypeCode);
    }

    private CssTokenId(int code, CssTokenIdCategory primaryCategory) {
        this.primaryCategory = primaryCategory;
        this.code = code;
    }

    public static Language<CssTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory.name().toLowerCase();
    }

    public CssTokenIdCategory getTokenCategory() {
        return this.primaryCategory;
    }

    static {
        codesMap = new HashMap<Integer, CssTokenId>();
        for (CssTokenId id : CssTokenId.values()) {
            codesMap.put(id.code, id);
        }
        language = new CssLanguageHierarchy().language();
    }
}

