/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.netbeans.modules.css.lib.AbstractParseTreeNode;
import org.netbeans.modules.css.lib.CommonTokenUtil;
import org.netbeans.modules.css.lib.ErrorNode;
import org.netbeans.modules.css.lib.RootNode;
import org.netbeans.modules.css.lib.RuleNode;
import org.netbeans.modules.css.lib.TokenNode;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.ProblemDescription;

public class NbParseTreeBuilder
extends BlankDebugEventListener {
    private String[] IGNORED_RULES = new String[]{"syncToFollow", "syncTo_IDENT_RBRACE"};
    Stack<RuleNode> callStack = new Stack();
    List<CommonToken> hiddenTokens = new ArrayList<CommonToken>();
    private int backtracking = 0;
    private CommonToken lastConsumedToken;
    private CharSequence source;
    static boolean debug_tokens = false;
    private Stack<ErrorNode> errorNodes = new Stack();
    private boolean resync;
    private CommonToken unexpectedToken;

    public NbParseTreeBuilder(CharSequence source) {
        this.source = source;
        this.callStack.push(new RootNode(source));
    }

    public AbstractParseTreeNode getTree() {
        return (AbstractParseTreeNode)this.callStack.elementAt(0);
    }

    @Override
    public void enterDecision(int d, boolean couldBacktrack) {
        ++this.backtracking;
    }

    @Override
    public void exitDecision(int i) {
        --this.backtracking;
    }

    private boolean isIgnoredRule(String ruleName) {
        return Arrays.binarySearch(this.IGNORED_RULES, ruleName) >= 0;
    }

    @Override
    public void enterRule(String filename, String ruleName) {
        if (this.backtracking > 0) {
            return;
        }
        if (this.isIgnoredRule(ruleName)) {
            return;
        }
        AbstractParseTreeNode parentRuleNode = this.callStack.peek();
        RuleNode ruleNode = new RuleNode(NodeType.valueOf(ruleName), this.source);
        this.addNodeChild(parentRuleNode, ruleNode);
        this.callStack.push(ruleNode);
    }

    @Override
    public void exitRule(String filename, String ruleName) {
        if (this.backtracking > 0) {
            return;
        }
        if (this.isIgnoredRule(ruleName)) {
            return;
        }
        RuleNode ruleNode = this.callStack.pop();
        if (ruleNode.getChildCount() == 0) {
            RuleNode parent = (RuleNode)ruleNode.getParent();
            if (parent != null) {
                parent.deleteChild(ruleNode);
            }
        } else if (this.lastConsumedToken != null) {
            ruleNode.setLastToken(this.lastConsumedToken);
        }
    }

    @Override
    public void beginResync() {
        super.beginResync();
        this.resync = true;
    }

    @Override
    public void endResync() {
        super.endResync();
        this.resync = false;
    }

    @Override
    public void consumeToken(Token token) {
        if (this.backtracking > 0 || this.resync) {
            return;
        }
        if (debug_tokens) {
            CommonToken ct = (CommonToken)token;
            int[] ctr = CommonTokenUtil.getCommonTokenOffsetRange(ct);
            System.out.println(token + "(" + ctr[0] + "-" + ctr[1] + ")");
        }
        if (token.getType() == -1) {
            return;
        }
        if (token.getType() == 0) {
            return;
        }
        this.lastConsumedToken = (CommonToken)token;
        RuleNode ruleNode = this.callStack.peek();
        TokenNode elementNode = new TokenNode((CommonToken)token);
        elementNode.hiddenTokens = this.hiddenTokens;
        this.hiddenTokens.clear();
        ruleNode.addChild(elementNode);
        this.updateFirstTokens(ruleNode, this.lastConsumedToken);
    }

    private void updateFirstTokens(RuleNode ruleNode, CommonToken token) {
        while (ruleNode.from() == -1) {
            ruleNode.setFirstToken(token);
            if ((ruleNode = (RuleNode)ruleNode.getParent()) != null) continue;
            break;
        }
    }

    @Override
    public void consumeHiddenToken(Token token) {
        if (this.backtracking > 0 || this.resync) {
            return;
        }
        if (debug_tokens) {
            CommonToken ct = (CommonToken)token;
            int[] ctr = CommonTokenUtil.getCommonTokenOffsetRange(ct);
            System.out.println(token + "(" + ctr[0] + "-" + ctr[1] + ")");
        }
        this.hiddenTokens.add((CommonToken)token);
    }

    @Override
    public void recognitionException(RecognitionException e) {
        if (this.backtracking > 0) {
            return;
        }
        RuleNode ruleNode = this.callStack.peek();
        assert (e.token != null);
        this.unexpectedToken = (CommonToken)e.token;
        int unexpectedTokenCode = e.getUnexpectedType();
        CssTokenId unexpectedTokenId = CssTokenId.forTokenTypeCode(unexpectedTokenCode);
        assert (unexpectedTokenId != null) : "No CssTokenId for " + this.unexpectedToken;
        int from = this.lastConsumedToken != null ? CommonTokenUtil.getCommonTokenOffsetRange(this.lastConsumedToken)[1] : 0;
        int to = CommonTokenUtil.getCommonTokenOffsetRange(this.unexpectedToken)[0];
        if (unexpectedTokenId == CssTokenId.ERROR) {
            ++to;
        }
        String message = unexpectedTokenId == CssTokenId.EOF ? String.format("Premature end of file", new Object[0]) : String.format("Unexpected token '%s' found at %s:%s (offset range %s-%s).", unexpectedTokenId.name(), e.line, e.charPositionInLine, from, to);
        ProblemDescription problemDescription = new ProblemDescription(from, to, message, ProblemDescription.Keys.PARSING.name(), ProblemDescription.Type.ERROR);
        ErrorNode errorNode = new ErrorNode(from, to, problemDescription, this.source);
        this.addNodeChild(ruleNode, errorNode);
        if (unexpectedTokenId == CssTokenId.ERROR) {
            TokenNode tokenNode = new TokenNode(this.unexpectedToken);
            this.addNodeChild(errorNode, tokenNode);
        }
        this.lastConsumedToken = new CommonToken(0);
        this.lastConsumedToken.setStartIndex(from);
        this.lastConsumedToken.setStopIndex(to - 1);
        this.errorNodes.push(errorNode);
    }

    @Override
    public void terminate() {
        super.terminate();
        Iterator i$ = this.errorNodes.iterator();
        while (i$.hasNext()) {
            ErrorNode en;
            for (RuleNode n = en = (ErrorNode)i$.next(); n != null; n = (RuleNode)n.parent()) {
                if (((RuleNode)n).from() != -1 && ((RuleNode)n).to() != -1) continue;
                ((RuleNode)n).from = en.from();
                ((RuleNode)n).to = en.to();
            }
        }
    }

    public Collection<ProblemDescription> getProblems() {
        ArrayList<ProblemDescription> problems = new ArrayList<ProblemDescription>();
        for (ErrorNode errorNode : this.errorNodes) {
            problems.add(errorNode.getProblemDescription());
        }
        return problems;
    }

    void consumeSkippedTokens(List<Token> tokens) {
        int i;
        boolean ignoreFirstToken;
        if (tokens.isEmpty()) {
            return;
        }
        CommonToken first = (CommonToken)tokens.get(0);
        CommonToken last = (CommonToken)tokens.get(tokens.size() - 1);
        boolean bl = ignoreFirstToken = this.unexpectedToken == first;
        if (ignoreFirstToken && tokens.size() == 1) {
            return;
        }
        if (ignoreFirstToken) {
            first = (CommonToken)tokens.get(1);
        }
        ErrorNode errorNode = this.errorNodes.peek();
        errorNode.setFirstToken(first);
        errorNode.setLastToken(last);
        errorNode.from = CommonTokenUtil.getCommonTokenOffsetRange(first)[0];
        errorNode.to = CommonTokenUtil.getCommonTokenOffsetRange(last)[1];
        int n = i = ignoreFirstToken ? 1 : 0;
        while (i < tokens.size()) {
            CommonToken token = (CommonToken)tokens.get(i);
            TokenNode tokenNode = new TokenNode(token);
            this.addNodeChild(errorNode, tokenNode);
            ++i;
        }
        this.lastConsumedToken = new CommonToken(0);
        this.lastConsumedToken.setStartIndex(first.getStartIndex());
        this.lastConsumedToken.setStopIndex(last.getStopIndex());
    }

    private void addNodeChild(AbstractParseTreeNode parent, AbstractParseTreeNode child) {
        parent.addChild(child);
        child.setParent(parent);
    }
}

