/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.spring.api.beans.SpringAnnotations;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.beans.model.impl.Refreshable;

public class SpringBeanImpl
extends PersistentObject
implements SpringBean,
Refreshable {
    private String id;
    private List<String> names = new LinkedList<String>();
    private String className;
    private String parent;
    private String factoryBean;
    private String factoryMethod;
    private Set<SpringBeanProperty> properties;
    private Location location;

    protected SpringBeanImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public String getFactoryBean() {
        return this.factoryBean;
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public Set<SpringBeanProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean refresh(TypeElement type) {
        Map types = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type));
        AnnotationMirror annotationMirror = SpringBeanImpl.getAnnotationMirror(types);
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectString("value", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        this.className = type.getQualifiedName().toString();
        this.names.clear();
        if (parseResult.get("value", String.class) == null) {
            this.names.add(SpringBeanImpl.getConvertedClassName(this.className));
        } else {
            this.names.add((String)parseResult.get("value", String.class));
        }
        return true;
    }

    private static AnnotationMirror getAnnotationMirror(Map<String, ? extends AnnotationMirror> types) {
        Iterator<String> it = SpringAnnotations.SPRING_COMPONENTS.iterator();
        while (it.hasNext()) {
            AnnotationMirror annotationMirror = types.get(it.next());
            if (annotationMirror == null) continue;
            return annotationMirror;
        }
        return null;
    }

    private static String getConvertedClassName(String className) {
        String result = className.substring(className.lastIndexOf(".") + 1);
        if (result.length() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(Character.toLowerCase(result.charAt(0)));
            builder.append(result.substring(1));
            result = builder.toString();
        }
        return result;
    }
}

