/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;

public class SpringBinaryIndexer
extends BinaryIndexer {
    public static final Logger LOGGER = Logger.getLogger(SpringBinaryIndexer.class.getSimpleName());
    static final String INDEXER_NAME = "SpringBinary";
    static final int INDEX_VERSION = 1;
    private static final String XSD_SUFFIX = ".xsd";
    static final String LIBRARY_MARK_KEY = "xsdSpringSchema";
    static final String NAMESPACE_MARK_KEY = "namespace";
    private String version;

    protected void index(Context context) {
        LOGGER.log(Level.FINE, "indexing " + context.getRoot());
        FileObject root = context.getRoot();
        if (root == null) {
            return;
        }
        if (root.getFileObject("org/springframework") == null) {
            return;
        }
        this.version = this.findVersion(root);
        if (this.version != null) {
            this.processXsds(context);
        }
    }

    private void processXsds(Context context) {
        FileObject root = context.getRoot();
        for (FileObject fileObject : this.findSpringLibraryDescriptors(root, XSD_SUFFIX)) {
            try {
                ModelSource source = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
                SchemaModel model = SchemaModelFactory.getDefault().getModel(source);
                Schema schema = model.getSchema();
                String targetNamespace = schema.getTargetNamespace();
                if (targetNamespace == null) continue;
                IndexingSupport sup = IndexingSupport.getInstance((Context)context);
                IndexDocument doc = sup.createDocument(fileObject);
                doc.addPair(NAMESPACE_MARK_KEY, targetNamespace, true, true);
                doc.addPair(LIBRARY_MARK_KEY, Boolean.TRUE.toString(), true, true);
                sup.addDocument(doc);
                LOGGER.log(Level.INFO, "The file " + fileObject + " indexed as a XSD (namespace=" + targetNamespace + ")");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private Collection<FileObject> findSpringLibraryDescriptors(FileObject classpathRoot, String suffix) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        if (classpathRoot.getFileObject("org/springframework") == null) {
            return files;
        }
        Enumeration fos = classpathRoot.getChildren(true);
        while (fos.hasMoreElements()) {
            FileObject file = (FileObject)fos.nextElement();
            String fileName = file.getNameExt().toLowerCase();
            if (fileName == null || !fileName.endsWith(suffix) || !this.version.startsWith(this.findXsdVersion(file))) continue;
            files.add(file);
        }
        return files;
    }

    private String findXsdVersion(FileObject file) {
        String v = file.getName();
        v = v.substring(v.lastIndexOf("-") + 1);
        return v;
    }

    private String findVersion(FileObject classpathRoot) {
        ClassPath cp = ClassPath.getClassPath((FileObject)classpathRoot, (String)"classpath/compile");
        if (cp == null) {
            return null;
        }
        String classRelativePath = "org.springframework.core.SpringVersion".replace('.', '/') + ".class";
        try {
            FileObject resource = cp.findResource(classRelativePath);
            if (resource == null) {
                return null;
            }
            FileObject ownerRoot = cp.findOwnerRoot(resource);
            if (ownerRoot != null && ownerRoot.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)ownerRoot.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public static class Factory
    extends BinaryIndexerFactory {
        public BinaryIndexer createIndexer() {
            return new SpringBinaryIndexer();
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public String getIndexerName() {
            return SpringBinaryIndexer.INDEXER_NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

