/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;

public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> result = Lookup.getDefault().lookupResult(FileSystem.class);
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookupBefore;
    private boolean needToAddClasspathLayers;

    ModuleLayeredFileSystem(FileSystem writableLayer, boolean userDir, FileSystem[] otherLayers, boolean mgr) throws IOException {
        this(writableLayer, userDir, otherLayers, LayerCacheManager.manager(mgr));
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, boolean addLookup, FileSystem[] otherLayers, LayerCacheManager mgr) throws IOException {
        this(writableLayer, addLookup, otherLayers, mgr, mgr.loadCache());
    }

    private ModuleLayeredFileSystem(FileSystem writableLayer, boolean addLookup, FileSystem[] otherLayers, LayerCacheManager mgr, FileSystem cacheLayer) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(writableLayer, addLookup, otherLayers, cacheLayer == null ? mgr.createEmptyFileSystem() : cacheLayer, addLookup));
        this.manager = mgr;
        this.writableLayer = writableLayer;
        this.otherLayers = otherLayers;
        this.cacheLayer = cacheLayer;
        this.addLookupBefore = addLookup;
        this.needToAddClasspathLayers = addLookup;
        this.setPropagateMasks(true);
        this.urls = null;
        result.addLookupListener((LookupListener)this);
        result.allItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem[] appendLayers(FileSystem fs1, boolean addLookupBefore, FileSystem[] fs2s, FileSystem fs3, boolean addClasspathLayers) {
        ArrayList<Object> l = new ArrayList<Object>(fs2s.length + 2);
        l.add(fs1);
        if (addLookupBefore) {
            for (FileSystem f : result.allInstances()) {
                if (Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                l.add(f);
            }
        }
        l.addAll(Arrays.asList(fs2s));
        l.add(fs3);
        if (addClasspathLayers) {
            ArrayList<URL> layerUrls = new ArrayList<URL>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                for (URL manifest : NbCollections.iterable(loader.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream is = manifest.openStream();
                    try {
                        Manifest mani = new Manifest(is);
                        String layerLoc = mani.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (layerLoc == null) continue;
                        URL layer = loader.getResource(layerLoc);
                        if (layer != null) {
                            layerUrls.add(layer);
                            continue;
                        }
                        err.log(Level.WARNING, "No such layer: {0}", layerLoc);
                    }
                    finally {
                        is.close();
                    }
                }
                for (URL generatedLayer : NbCollections.iterable(loader.getResources("META-INF/generated-layer.xml"))) {
                    layerUrls.add(generatedLayer);
                }
                XMLFileSystem xmlfs = new XMLFileSystem();
                xmlfs.setXmlUrls(layerUrls.toArray(new URL[layerUrls.size()]));
                l.add(xmlfs);
                err.log(Level.FINE, "Loading classpath layers: {0}", layerUrls);
            }
            catch (Exception x) {
                err.log(Level.WARNING, "Setting layer URLs: " + layerUrls, x);
            }
        }
        if (!addLookupBefore) {
            for (FileSystem f : result.allInstances()) {
                if (!Boolean.TRUE.equals(f.getRoot().getAttribute("fallback"))) continue;
                l.add(f);
            }
        }
        return l.toArray(new FileSystem[l.size()]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem sfs;
        try {
            sfs = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new AssertionError((Object)ex);
        }
        ModuleLayeredFileSystem home = sfs.getInstallationLayer();
        if (home != null) {
            return home;
        }
        return sfs.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem sfs;
        try {
            sfs = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new AssertionError((Object)ex);
        }
        return sfs.getUserLayer();
    }

    public void setURLs(List<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        if (err.isLoggable(Level.FINE)) {
            err.log(Level.FINE, "setURLs: {0}", urls);
        }
        if (this.urls != null && ((Object)urls).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        if (this.urls != null || this.cacheLayer == null) {
            if (this.cacheLayer == null) {
                this.cacheLayer = this.manager.createEmptyFileSystem();
            }
            this.cacheLayer = this.manager.store(this.cacheLayer, urls);
            err.log(Level.FINEST, "changing delegates");
            this.needToAddClasspathLayers = false;
            this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, false));
            err.log(Level.FINEST, "delegates changed");
        }
        this.urls = urls;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>(urls);
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        this.setURLs(arr);
    }

    public void removeURLs(Collection<URL> urls) throws Exception {
        if (urls.contains(null)) {
            throw new NullPointerException("urls=" + urls);
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        if (this.urls != null) {
            arr.addAll(this.urls);
        }
        arr.removeAll(urls);
        this.setURLs(arr);
    }

    public void resultChanged(LookupEvent ev) {
        this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, this.needToAddClasspathLayers));
    }
}

