/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    private Logger logger = Logger.getLogger(NbEvents.class.getName());
    private int moduleCount;
    private int counter;

    NbEvents() {
    }

    protected void logged(String message, Object[] args) {
        if (message == "perfTick") {
            StartLog.logProgress((String)args[0]);
        } else if (message == "perfStart") {
            StartLog.logStart((String)args[0]);
        } else if (message == "perfEnd") {
            StartLog.logEnd((String)args[0]);
        } else if (message == "startCreateBootModule") {
            Splash.getInstance().increment(1);
        } else if (message == "startLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_load_boot_modules"));
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (message == "startLoad") {
            StartLog.logStart("NbInstaller.load");
        } else if (message == "finishLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_load_boot_modules"));
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (message == "finishLoad") {
            StartLog.logEnd("NbInstaller.load");
        } else if (message == "startAutoRestore") {
            Set modules = (Set)args[0];
            if (!modules.isEmpty()) {
                NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_auto_restore"));
            }
        } else if (message == "finishAutoRestore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_auto_restore"));
        } else if (message == "startEnableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_enable_modules"));
        } else if (message == "finishEnableModules") {
            List modules = NbCollections.checkedListByCopy((List)((List)args[0]), Module.class, (boolean)true);
            if (!modules.isEmpty()) {
                this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_enable_modules"));
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_enable_modules"));
            StartLog.logEnd("ModuleManager.enable");
        } else if (message == "startDisableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_disable_modules"));
        } else if (message == "finishDisableModules") {
            List modules = NbCollections.checkedListByCopy((List)((List)args[0]), Module.class, (boolean)true);
            if (!modules.isEmpty()) {
                this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_disable_modules"));
                this.dumpModulesList(modules);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_disable_modules"));
        } else if (message == "startDeployTestModule") {
            String msg = MessageFormat.format(NbBundle.getMessage(NbEvents.class, (String)"TEXT_start_deploy_test_module"), (File)args[0]);
            NbEvents.setStatusText(msg);
        } else if (message == "finishDeployTestModule") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_deploy_test_module"));
        } else if (message == "failedInstallNew") {
            Set modules = NbCollections.checkedSetByCopy((Set)((Set)args[0]), Module.class, (boolean)true);
            StringBuilder buf = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, false);
            buf.append('\n');
            this.logger.log(Level.INFO, buf.toString());
            buf = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, true);
            String msg = buf.toString();
            this.notify(msg, true);
            NbEvents.setStatusText("");
        } else if (message == "failedInstallNewUnexpected") {
            Module m = (Module)args[0];
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.add(m);
            modules.addAll(NbCollections.checkedSetByCopy((Set)((Set)args[1]), Module.class, (boolean)true));
            StringBuilder buf = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)m.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(buf, modules, false);
            buf.append('\n');
            this.logger.log(Level.INFO, buf.toString());
            this.notify(NbProblemDisplayer.messageForProblem(m, m.getProblems().iterator().next(), true), true);
            NbEvents.setStatusText("");
        } else if (message == "startRead") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_read"));
            StartLog.logStart("ModuleList.readInitial");
        } else if (message == "modulesFileScanned") {
            this.moduleCount = (Integer)args[0];
            Splash.getInstance().addToMaxSteps(Math.max(this.moduleCount + this.moduleCount / 2 - 100, 0));
        } else if (message == "modulesFileProcessed") {
            Splash.getInstance().increment(1);
            if (StartLog.willLog()) {
                StartLog.logProgress("module " + args[0] + " processed");
            }
        } else if (message == "finishRead") {
            if (this.moduleCount < 100) {
                Splash.getInstance().increment(this.moduleCount - 100);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_read"));
            StartLog.logEnd("ModuleList.readInitial");
        } else if (message == "restore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_restore"));
            if (++this.counter < this.moduleCount / 2) {
                Splash.getInstance().increment(1);
            }
        } else if (message == "install") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_install", (Object)((Module)args[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_install", (Object)((Module)args[0]).getDisplayName()));
        } else if (message == "update") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_update", (Object)((Module)args[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_update", (Object)((Module)args[0]).getDisplayName()));
        } else if (message == "uninstall") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_uninstall", (Object)((Module)args[0]).getDisplayName()));
        } else if (message == "loadSection") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_section"));
            if (++this.counter < this.moduleCount / 4) {
                Splash.getInstance().increment(1);
            }
        } else if (message == "loadLayers") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_layers"));
        } else if (message == "wrongClassLoader") {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(Level.WARNING)) {
                Class clazz = (Class)args[1];
                StringBuilder b = new StringBuilder();
                b.append("The module " + ((Module)args[0]).getDisplayName() + " loaded the class " + clazz.getName() + "\n");
                b.append("from the wrong classloader. The expected classloader was " + args[2] + "\n");
                b.append("whereas it was actually loaded from " + clazz.getClassLoader() + "\n");
                b.append("Usually this means that some classes were in the startup classpath.\n");
                b.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.warning(b.toString());
            }
        } else if (message == "extensionMultiplyLoaded") {
            this.logger.log(Level.WARNING, "The extension " + (File)args[0] + " may be multiply loaded by modules: " + (Set)args[1] + "; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path");
        } else if (message == "missingJarFile") {
            File jar = (File)args[0];
            Level level = Boolean.FALSE.equals(args[1]) ? Level.FINE : Level.INFO;
            this.logger.log(level, NbBundle.getMessage(NbEvents.class, (String)"TEXT_missing_jar_file", (Object)jar.getAbsolutePath()));
        } else if (message == "cantDeleteEnabledAutoload") {
            Module m = (Module)args[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_cant_delete_enabled_autoload", (Object)m.getDisplayName()));
        } else if (message == "miscPropMismatch") {
            Module m = (Module)args[0];
            String prop = (String)args[1];
            Object onDisk = args[2];
            Object inMem = args[3];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_misc_prop_mismatch", (Object[])new Object[]{m.getDisplayName(), prop, onDisk, inMem}));
        } else if (message == "patch") {
            File f = (File)args[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_patch", (Object)f.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection<Module> modules) {
        if (modules.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder buf = new StringBuilder(modules.size() * 100 + 1);
        String lineSep = System.getProperty("line.separator");
        for (Module m : modules) {
            String bv;
            String iv;
            buf.append('\t');
            buf.append(m.getCodeName());
            buf.append(" [");
            SpecificationVersion sv = m.getSpecificationVersion();
            if (sv != null) {
                buf.append(sv);
            }
            if ((iv = m.getImplementationVersion()) != null) {
                buf.append(' ');
                buf.append(iv);
            }
            if ((bv = m.getBuildVersion()) != null && !bv.equals(iv)) {
                buf.append(' ');
                buf.append(bv);
            }
            buf.append(']');
            buf.append(lineSep);
        }
        this.logger.log(Level.INFO, buf.toString());
    }

    private void notify(String text, boolean warn) {
        if (GraphicsEnvironment.isHeadless() || Boolean.getBoolean("netbeans.full.hack")) {
            this.logger.log(Level.WARNING, text + "\n");
        } else {
            new Notifier(text, warn);
        }
    }

    private static void setStatusText(String msg) {
        Main.setStatusText(msg);
    }

    private static final class Notifier
    implements Runnable {
        private static boolean showDialog = true;
        private boolean warn;
        private String text;
        private static RequestProcessor RP = new RequestProcessor("Notify About Module System");

        public Notifier(String text, boolean type) {
            this.warn = type;
            this.text = text;
            if (showDialog) {
                showDialog = false;
                RP.post((Runnable)this, 0, 1).waitFinished();
            }
        }

        @Override
        public void run() {
            int ret;
            JComponent sp;
            int type = this.warn ? 2 : 1;
            String msg = NbBundle.getMessage(Notifier.class, (String)(this.warn ? "MSG_warning" : "MSG_info"));
            Splash out = Splash.getInstance();
            Component c = out.getComponent() == null ? null : out.getComponent();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, ex);
            }
            JTextPane tp = new JTextPane();
            tp.setContentType("text/html");
            this.text = this.text.replace("\n", "<br>");
            tp.setEditable(false);
            tp.setOpaque(false);
            tp.setEnabled(true);
            tp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hlevt) {
                    if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType()) {
                        assert (hlevt.getURL() != null);
                        try {
                            Desktop.getDesktop().browse(hlevt.getURL().toURI());
                        }
                        catch (Exception ex) {
                            Logger.getLogger(NbBundle.class.getName()).log(Level.INFO, null, ex);
                        }
                    }
                }
            });
            tp.setText(this.text);
            if (tp.getPreferredSize().width > 600 || tp.getPreferredSize().height > 400) {
                tp.setPreferredSize(new Dimension(600, 400));
                sp = new JScrollPane(tp);
            } else {
                sp = tp;
            }
            final JOptionPane op = new JOptionPane(sp, type, 0, null);
            JButton continueButton = new JButton(NbBundle.getMessage(Notifier.class, (String)"MSG_continue"));
            continueButton.setDisplayedMnemonicIndex(0);
            continueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    op.setValue(0);
                }
            });
            JButton exitButton = new JButton(NbBundle.getMessage(Notifier.class, (String)"MSG_exit"));
            exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    op.setValue(1);
                }
            });
            Object[] options = new JButton[]{continueButton, exitButton};
            op.setOptions(options);
            op.setInitialValue(options[1]);
            JDialog d = op.createDialog(c, msg);
            d.setResizable(true);
            d.setVisible(true);
            Object res = op.getValue();
            if (res instanceof Integer && ((ret = ((Integer)res).intValue()) == 1 || ret == -1)) {
                TopLogging.exit(1);
            }
        }
    }
}

