/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenSourceLevelImpl
implements SourceLevelQueryImplementation {
    private final NbMavenProjectImpl project;
    private static Logger LOG = Logger.getLogger(MavenSourceLevelImpl.class.getName());

    public MavenSourceLevelImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    public String getSourceLevel(FileObject javaFile) {
        assert (javaFile != null);
        if (javaFile == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return null;
        }
        URI uri = file.toURI();
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        for (URI testuri : this.project.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        for (URI testuri : this.project.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        String sourceLevel = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "source", goal);
        if (sourceLevel != null) {
            return sourceLevel;
        }
        String version = PluginPropertyUtils.getPluginVersion(((NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class)).getOriginalMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
        if (version != null && new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("2.3")) >= 0) {
            return "1.5";
        }
        return "1.3";
    }
}

