/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.customizer.MainClassChooser;
import org.netbeans.modules.maven.customizer.PropertySplitter;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RunJarPanel
extends JPanel {
    private boolean isCurrentRun = true;
    private boolean isCurrentDebug = true;
    private boolean isCurrentProfile = true;
    private static final String RUN_PARAMS = "exec.args";
    private static final String RUN_WORKDIR = "exec.workingdir";
    private static final String DEFAULT_DEBUG_PARAMS = "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=${jpda.address}";
    private static final String DEFAULT_PROFILE_PARAMS = "${profiler.args}";
    private static final String DEFAULT_PROFILER_EXEC = "${profiler.java}";
    private static final String RUN_EXEC = "exec.executable";
    private static final String PROFILE_CMD = "profile";
    private ModelHandle handle;
    private NbMavenProjectImpl project;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private String oldMainClass;
    private String oldParams;
    private String oldVMParams;
    private String oldWorkDir;
    private String oldAllParams;
    private DocumentListener docListener;
    private ActionListener comboListener;
    private JButton btnMainClass;
    private JButton btnWorkDir;
    private JComboBox comConfiguration;
    private JLabel lblArguments;
    private JLabel lblConfiguration;
    private JLabel lblHint;
    private JLabel lblMainClass;
    private JLabel lblVMOptions;
    private JLabel lblWorkDir;
    private JTextField txtArguments;
    private JTextField txtMainClass;
    private JTextField txtVMOptions;
    private JTextField txtWorkDir;

    public RunJarPanel(ModelHandle handle, NbMavenProjectImpl project) {
        SourceGroup sourceGroup;
        int i;
        this.initComponents();
        this.handle = handle;
        this.project = project;
        this.comConfiguration.setEditable(false);
        this.comConfiguration.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (com instanceof JLabel && value == RunJarPanel.this.handle.getActiveConfiguration()) {
                    com.setFont(com.getFont().deriveFont(1));
                }
                return com;
            }
        });
        this.setupConfigurations();
        this.initValues();
        this.lblMainClass.setFont(this.lblMainClass.getFont().deriveFont(1));
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        Sources srcs = ProjectUtils.getSources((Project)project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (i = 0; i < grps.length; ++i) {
            sourceGroup = grps[i];
            if (!"1SourceRoot".equals(sourceGroup.getName())) continue;
            roots.add(sourceGroup.getRootFolder());
        }
        grps = srcs.getSourceGroups("GeneratedSources");
        for (i = 0; i < grps.length; ++i) {
            sourceGroup = grps[i];
            roots.add(sourceGroup.getRootFolder());
        }
        this.btnMainClass.addActionListener(new MainClassListener(roots.toArray(new FileObject[roots.size()]), this.txtMainClass));
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                RunJarPanel.this.applyChanges();
            }
        };
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunJarPanel.this.removeListeners();
                RunJarPanel.this.initValues();
                RunJarPanel.this.addListeners();
            }
        };
    }

    private void addListeners() {
        this.comConfiguration.addActionListener(this.comboListener);
        this.txtMainClass.getDocument().addDocumentListener(this.docListener);
        this.txtArguments.getDocument().addDocumentListener(this.docListener);
        this.txtVMOptions.getDocument().addDocumentListener(this.docListener);
        this.txtWorkDir.getDocument().addDocumentListener(this.docListener);
    }

    private void removeListeners() {
        this.comConfiguration.removeActionListener(this.comboListener);
        this.txtMainClass.getDocument().removeDocumentListener(this.docListener);
        this.txtArguments.getDocument().removeDocumentListener(this.docListener);
        this.txtVMOptions.getDocument().removeDocumentListener(this.docListener);
        this.txtWorkDir.getDocument().removeDocumentListener(this.docListener);
    }

    private void initValues() {
        this.run = null;
        this.debug = null;
        this.profile = null;
        ActionToGoalMapping mapp = this.handle.getActionMappings((ModelHandle.Configuration)this.comConfiguration.getSelectedItem());
        List<NetbeansActionMapping> lst = mapp.getActions();
        for (NetbeansActionMapping m : lst) {
            if ("run".equals(m.getActionName())) {
                this.run = m;
            }
            if ("debug".equals(m.getActionName())) {
                this.debug = m;
            }
            if (!PROFILE_CMD.equals(m.getActionName())) continue;
            this.profile = m;
        }
        if (this.run == null) {
            this.run = ModelHandle.getDefaultMapping("run", this.project);
        }
        if (this.debug == null) {
            this.debug = ModelHandle.getDefaultMapping("debug", this.project);
        }
        if (this.profile == null) {
            this.profile = ModelHandle.getDefaultMapping(PROFILE_CMD, this.project);
        }
        this.isCurrentRun = this.checkNewMapping(this.run);
        this.isCurrentDebug = this.checkNewMapping(this.debug);
        this.isCurrentProfile = this.checkNewMapping(this.profile);
        if (this.isCurrentDebug || this.isCurrentRun || this.isCurrentProfile) {
            String params;
            this.oldWorkDir = this.run.getProperties().getProperty(RUN_WORKDIR);
            if (this.oldWorkDir == null) {
                this.oldWorkDir = this.debug.getProperties().getProperty(RUN_WORKDIR);
            }
            if (this.oldWorkDir == null && this.profile != null) {
                this.oldWorkDir = this.profile.getProperties().getProperty(RUN_WORKDIR);
            }
            if ((params = this.run.getProperties().getProperty(RUN_PARAMS)) == null) {
                params = this.debug.getProperties().getProperty(RUN_PARAMS);
            }
            if (params == null && this.profile != null) {
                params = this.profile.getProperties().getProperty(RUN_PARAMS);
            }
            if (params != null) {
                this.oldAllParams = params;
                this.oldVMParams = RunJarPanel.splitJVMParams(params);
                if (this.oldVMParams != null && this.oldVMParams.contains("-classpath %classpath")) {
                    this.oldVMParams = this.oldVMParams.replace("-classpath %classpath", "");
                }
                this.oldMainClass = RunJarPanel.splitMainClass(params);
                if (this.oldMainClass != null && this.oldMainClass.equals("${packageClassName}")) {
                    this.oldMainClass = "";
                }
                this.oldParams = RunJarPanel.splitParams(params);
            } else {
                this.oldAllParams = "";
            }
        }
        if (this.oldMainClass == null) {
            this.oldMainClass = "";
        }
        this.txtMainClass.setText(this.oldMainClass);
        if (this.oldParams == null) {
            this.oldParams = "";
        }
        this.txtArguments.setText(this.oldParams);
        if (this.oldVMParams == null) {
            this.oldVMParams = "";
        }
        this.txtVMOptions.setText(this.oldVMParams);
        if (this.oldWorkDir == null) {
            this.oldWorkDir = "";
        }
        this.txtWorkDir.setText(this.oldWorkDir);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setupConfigurations();
        this.initValues();
        this.addListeners();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void initComponents() {
        this.lblMainClass = new JLabel();
        this.txtMainClass = new JTextField();
        this.btnMainClass = new JButton();
        this.lblArguments = new JLabel();
        this.txtArguments = new JTextField();
        this.lblWorkDir = new JLabel();
        this.txtWorkDir = new JTextField();
        this.btnWorkDir = new JButton();
        this.lblVMOptions = new JLabel();
        this.txtVMOptions = new JTextField();
        this.lblHint = new JLabel();
        this.lblConfiguration = new JLabel();
        this.comConfiguration = new JComboBox();
        this.lblMainClass.setLabelFor(this.txtMainClass);
        Mnemonics.setLocalizedText((JLabel)this.lblMainClass, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_MainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMainClass, (String)NbBundle.getMessage(RunJarPanel.class, (String)"BTN_Browse_Main"));
        this.lblArguments.setLabelFor(this.txtArguments);
        Mnemonics.setLocalizedText((JLabel)this.lblArguments, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_Arguments"));
        this.lblWorkDir.setLabelFor(this.txtWorkDir);
        Mnemonics.setLocalizedText((JLabel)this.lblWorkDir, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_WorkDir"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnWorkDir, (String)NbBundle.getMessage(RunJarPanel.class, (String)"BTN_Browse_WorkingDir"));
        this.btnWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunJarPanel.this.btnWorkDirActionPerformed(evt);
            }
        });
        this.lblVMOptions.setLabelFor(this.txtVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.lblVMOptions, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_VMOptions"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(RunJarPanel.class, (String)"LBL_VMHint"));
        this.lblConfiguration.setLabelFor(this.comConfiguration);
        Mnemonics.setLocalizedText((JLabel)this.lblConfiguration, (String)NbBundle.getMessage(RunJarPanel.class, (String)"RunJarPanel.lblConfiguration.text"));
        this.comConfiguration.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblWorkDir).addComponent(this.lblVMOptions).addComponent(this.lblArguments).addComponent(this.lblConfiguration).addComponent(this.lblMainClass)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtVMOptions, -1, 225, Short.MAX_VALUE).addComponent(this.txtWorkDir, -1, 225, Short.MAX_VALUE).addComponent(this.txtArguments, -1, 225, Short.MAX_VALUE).addComponent(this.txtMainClass, -1, 225, Short.MAX_VALUE).addComponent(this.comConfiguration, 0, 225, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnWorkDir).addComponent(this.btnMainClass))).addGroup(layout.createSequentialGroup().addGap(128, 128, 128).addComponent(this.lblHint).addContainerGap(246, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConfiguration).addComponent(this.comConfiguration, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMainClass).addComponent(this.btnMainClass).addComponent(this.txtMainClass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblArguments).addComponent(this.txtArguments, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblWorkDir).addComponent(this.txtWorkDir, -2, -1, -2).addComponent(this.btnWorkDir)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVMOptions).addComponent(this.txtVMOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint).addContainerGap(139, Short.MAX_VALUE)));
        this.txtMainClass.getAccessibleContext().setAccessibleDescription("Main class");
        this.btnMainClass.getAccessibleContext().setAccessibleDescription("Browse main class");
        this.txtArguments.getAccessibleContext().setAccessibleDescription("Arguments");
        this.txtWorkDir.getAccessibleContext().setAccessibleDescription("Working directory");
        this.btnWorkDir.getAccessibleContext().setAccessibleDescription("Browse working directory");
        this.txtVMOptions.getAccessibleContext().setAccessibleDescription("VM options");
        this.comConfiguration.getAccessibleContext().setAccessibleDescription("Configuration");
    }

    private void btnWorkDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.txtWorkDir.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(RunJarPanel.class, (String)"TIT_SelectWorkingDirectory"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.txtWorkDir.setText(file.getAbsolutePath());
        }
    }

    void applyChanges() {
        String newMainClass = this.txtMainClass.getText().trim();
        String newParams = this.txtArguments.getText().trim();
        String newVMParams = this.txtVMOptions.getText().trim();
        String newWorkDir = this.txtWorkDir.getText().trim();
        ActionToGoalMapping a2gm = this.handle.getActionMappings((ModelHandle.Configuration)this.comConfiguration.getSelectedItem());
        if (this.isCurrentRun || this.isCurrentDebug || this.isCurrentProfile) {
            boolean changed;
            String newAllParams = newVMParams + " -classpath %classpath ";
            newAllParams = newMainClass.trim().length() > 0 ? newAllParams + newMainClass + " " : newAllParams + "${packageClassName} ";
            newAllParams = newAllParams + newParams;
            newAllParams = newAllParams.trim();
            if (this.isCurrentRun) {
                changed = false;
                if (!this.oldAllParams.equals(newAllParams)) {
                    this.run.getProperties().setProperty(RUN_PARAMS, newAllParams);
                    changed = true;
                }
                if (!this.oldWorkDir.equals(newWorkDir)) {
                    this.run.getProperties().setProperty(RUN_WORKDIR, newWorkDir);
                    changed = true;
                }
                if (changed) {
                    ModelHandle.setUserActionMapping(this.run, a2gm);
                    this.handle.markAsModified(a2gm);
                }
            }
            if (this.isCurrentDebug) {
                changed = false;
                if (!this.oldAllParams.equals(newAllParams)) {
                    this.debug.getProperties().setProperty(RUN_PARAMS, "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=${jpda.address} " + newAllParams);
                    changed = true;
                }
                if (!this.oldWorkDir.equals(newWorkDir)) {
                    this.debug.getProperties().setProperty(RUN_WORKDIR, newWorkDir);
                    changed = true;
                }
                if (changed) {
                    ModelHandle.setUserActionMapping(this.debug, a2gm);
                    this.handle.markAsModified(a2gm);
                }
            }
            if (this.isCurrentProfile) {
                changed = false;
                if (!this.oldAllParams.equals(newAllParams)) {
                    this.profile.getProperties().setProperty(RUN_PARAMS, "${profiler.args} " + newAllParams);
                    changed = true;
                }
                if (!this.oldWorkDir.equals(newWorkDir)) {
                    this.profile.getProperties().setProperty(RUN_WORKDIR, newWorkDir);
                    changed = true;
                }
                this.profile.getProperties().setProperty(RUN_EXEC, DEFAULT_PROFILER_EXEC);
                if (changed) {
                    ModelHandle.setUserActionMapping(this.profile, a2gm);
                    this.handle.markAsModified(a2gm);
                }
            }
        }
    }

    private boolean checkNewMapping(NetbeansActionMapping map) {
        if (map == null || map.getGoals() == null) {
            return false;
        }
        for (String goal : map.getGoals()) {
            if (!goal.matches("org\\.codehaus\\.mojo\\:exec-maven-plugin\\:(.)+\\:exec") && goal.indexOf("exec:exec") <= -1) continue;
            return true;
        }
        return false;
    }

    public static String[] splitAll(String argline) {
        String jvm = RunJarPanel.splitJVMParams(argline);
        String mainClazz = RunJarPanel.splitMainClass(argline);
        String args = RunJarPanel.splitParams(argline);
        if (jvm != null && jvm.contains("-classpath %classpath")) {
            jvm = jvm.replace("-classpath %classpath", "");
        }
        if (mainClazz != null && mainClazz.equals("${packageClassName}")) {
            mainClazz = "";
        }
        return new String[]{jvm != null ? jvm : "", mainClazz != null ? mainClazz : "", args != null ? args : ""};
    }

    static String splitJVMParams(String line) {
        PropertySplitter ps = new PropertySplitter(line);
        ps.setSeparator(' ');
        String s = ps.nextPair();
        String jvms = "";
        while (s != null) {
            if (s.startsWith("-") || s.startsWith("\"-") || s.contains("%classpath")) {
                jvms = jvms + " " + s;
            } else if (s.equals("${packageClassName}") || s.matches("[\\w]+[\\.]{0,1}[\\w\\.]*")) break;
            s = ps.nextPair();
        }
        return jvms.trim();
    }

    static String splitMainClass(String line) {
        PropertySplitter ps = new PropertySplitter(line);
        ps.setSeparator(' ');
        String s = ps.nextPair();
        while (s != null) {
            if (s.startsWith("-") || s.contains("%classpath")) {
                s = ps.nextPair();
                continue;
            }
            if (s.equals("${packageClassName}") || s.matches("[\\w]+[\\.]{0,1}[\\w\\.]*")) {
                return s;
            }
            Logger.getLogger(RunJarPanel.class.getName()).fine("failed splitting main class from=" + line);
            s = ps.nextPair();
        }
        return "";
    }

    static String splitParams(String line) {
        String main = RunJarPanel.splitMainClass(line);
        int i = line.indexOf(main);
        if (i > -1) {
            return line.substring(i + main.length()).trim();
        }
        return "";
    }

    private void setupConfigurations() {
        this.lblConfiguration.setVisible(true);
        this.comConfiguration.setVisible(true);
        DefaultComboBoxModel<ModelHandle.Configuration> comModel = new DefaultComboBoxModel<ModelHandle.Configuration>();
        for (ModelHandle.Configuration conf : this.handle.getConfigurations()) {
            comModel.addElement(conf);
        }
        this.comConfiguration.setModel(comModel);
        this.comConfiguration.setSelectedItem(this.handle.getActiveConfiguration());
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private FileObject[] sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(FileObject[] sourceRoots, JTextField mainClassTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = mainClassTextField;
            this.okButton = new JButton(NbBundle.getMessage(RunJarPanel.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunJarPanel.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final MainClassChooser panel = new MainClassChooser(this.sourceRoots);
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(RunJarPanel.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.mainClassTextField.setText(panel.getSelectedMainClass());
            }
            dlg.dispose();
        }
    }
}

