/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openide.util.NbBundle;

public abstract class TextComponentUpdater
implements DocumentListener,
AncestorListener {
    private JTextComponent component;
    private JLabel label;
    private boolean inherited = false;

    public TextComponentUpdater(JTextComponent comp, JLabel label) {
        this.component = comp;
        this.component.addAncestorListener(this);
        this.label = label;
    }

    public abstract String getValue();

    public abstract String getDefaultValue();

    public abstract void setValue(String var1);

    private void setModelValue() {
        if (this.inherited) {
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.component.setToolTipText(null);
        }
        this.setValue(this.component.getText().trim().length() == 0 ? null : this.component.getText());
        if (this.component.getText().trim().length() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextComponentUpdater.this.component.getDocument().removeDocumentListener(TextComponentUpdater.this);
                    TextComponentUpdater.this.setTextFieldValue(TextComponentUpdater.this.getValue(), TextComponentUpdater.this.getDefaultValue(), TextComponentUpdater.this.component);
                    TextComponentUpdater.this.component.getDocument().addDocumentListener(TextComponentUpdater.this);
                }
            });
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setModelValue();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setModelValue();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setModelValue();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setTextFieldValue(this.getValue(), this.getDefaultValue(), this.component);
        this.component.getDocument().addDocumentListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.component.getDocument().removeDocumentListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private void setTextFieldValue(String value, String projectValue, JTextComponent field) {
        if (value != null) {
            field.setText(value);
            this.component.setToolTipText(null);
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        } else if (projectValue != null) {
            field.setText(projectValue);
            field.setSelectionEnd(projectValue.length());
            field.setSelectionStart(0);
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.component.setToolTipText(NbBundle.getMessage(TextComponentUpdater.class, (String)"MSG_Value_Inherited"));
            this.inherited = true;
        } else {
            field.setText("");
            this.component.setToolTipText(null);
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
    }
}

