/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.maven.Bundle;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class M2AuxilaryConfigImpl
implements AuxiliaryConfiguration {
    public static final String BROKEN_NBCONFIG = "BROKENNBCONFIG";
    private static final String AUX_CONFIG = "AuxilaryConfiguration";
    public static final String CONFIG_FILE_NAME = "nb-configuration.xml";
    private static final Logger LOG = Logger.getLogger(M2AuxilaryConfigImpl.class.getName());
    private static final int SAVING_DELAY = 100;
    private final NbMavenProjectImpl project;
    private RequestProcessor.Task savingTask;
    private Document scheduledDocument;
    private Date timeStamp = new Date(0L);
    private Document cachedDoc;
    private final Object configIOLock = new Object();
    private static final DocumentBuilder db;

    public M2AuxilaryConfigImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        this.savingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                try {
                    M2AuxilaryConfigImpl.this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            Document doc;
                            Object object = M2AuxilaryConfigImpl.this;
                            synchronized (object) {
                                doc = M2AuxilaryConfigImpl.this.scheduledDocument;
                                if (doc == null) {
                                    return;
                                }
                                M2AuxilaryConfigImpl.this.scheduledDocument = null;
                            }
                            object = M2AuxilaryConfigImpl.this.configIOLock;
                            synchronized (object) {
                                FileObject config = M2AuxilaryConfigImpl.this.project.getProjectDirectory().getFileObject(M2AuxilaryConfigImpl.CONFIG_FILE_NAME);
                                if (doc.getDocumentElement().getElementsByTagName("*").getLength() > 0) {
                                    OutputStream out = config == null ? M2AuxilaryConfigImpl.this.project.getProjectDirectory().createAndOpen(M2AuxilaryConfigImpl.CONFIG_FILE_NAME) : config.getOutputStream();
                                    try {
                                        XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
                                    }
                                    finally {
                                        out.close();
                                    }
                                } else if (config != null) {
                                    config.delete();
                                }
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadConfig(FileObject config) throws IOException, SAXException {
        Object object = this.configIOLock;
        synchronized (object) {
            return XMLUtil.parse((InputSource)new InputSource(config.getURL().toString()), (boolean)false, (boolean)true, null, null);
        }
    }

    public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
        Element e = this.doGetConfigurationFragment(elementName, namespace, shared);
        return e != null ? M2AuxilaryConfigImpl.cloneSafely(e) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element el) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document dummy = db.newDocument();
            return (Element)dummy.importNode(el, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Element doGetConfigurationFragment(String elementName, String namespace, boolean shared) {
        if (shared) {
            if (this.scheduledDocument != null) {
                Element el = XMLUtil.findElement((Element)this.scheduledDocument.getDocumentElement(), (String)elementName, (String)namespace);
                if (el != null) {
                    el = (Element)el.cloneNode(true);
                }
                return el;
            }
            FileObject config = this.project.getProjectDirectory().getFileObject(CONFIG_FILE_NAME);
            if (config != null) {
                if (config.lastModified().after(this.timeStamp)) {
                    try {
                        Document doc;
                        this.cachedDoc = doc = this.loadConfig(config);
                        Element element = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
                        return element;
                    }
                    catch (SAXException ex) {
                        ProblemReporterImpl impl = this.project.getProblemReporter();
                        if (!impl.hasReportWithId(BROKEN_NBCONFIG)) {
                            ProblemReport rep = new ProblemReport(5, Bundle.TXT_Problem_Broken_Config(), Bundle.DESC_Problem_Broken_Config(ex.getMessage()), new OpenConfigAction(config));
                            rep.setId(BROKEN_NBCONFIG);
                            impl.addReport(rep);
                        }
                        LOG.log(Level.INFO, ex.getMessage(), ex);
                        this.cachedDoc = null;
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.cachedDoc = null;
                    }
                    finally {
                        this.timeStamp = config.lastModified();
                    }
                    return null;
                }
                if (this.cachedDoc != null) {
                    return XMLUtil.findElement((Element)this.cachedDoc.getDocumentElement(), (String)elementName, (String)namespace);
                }
            } else {
                this.cachedDoc = null;
            }
            return null;
        }
        String str = (String)this.project.getProjectDirectory().getAttribute(AUX_CONFIG);
        if (str != null) {
            try {
                Document doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
                return XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
            }
            catch (SAXException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public synchronized void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
        Document doc = null;
        if (shared) {
            if (this.scheduledDocument != null) {
                doc = this.scheduledDocument;
            } else {
                FileObject config = this.project.getProjectDirectory().getFileObject(CONFIG_FILE_NAME);
                if (config != null) {
                    try {
                        doc = this.loadConfig(config);
                    }
                    catch (SAXException ex) {
                        LOG.log(Level.INFO, "Cannot parse file " + config.getPath(), ex);
                        if (config.getSize() == 0L) {
                            doc = this.createNewSharedDocument();
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "IO Error with " + config.getPath(), ex);
                    }
                } else {
                    doc = this.createNewSharedDocument();
                }
            }
        } else {
            String str = (String)this.project.getProjectDirectory().getAttribute(AUX_CONFIG);
            if (str != null) {
                try {
                    doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
                }
                catch (SAXException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (doc == null) {
                String element = "project-private";
                doc = XMLUtil.createDocument((String)element, null, null, null);
            }
        }
        if (doc != null) {
            Element el = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)fragment.getNodeName(), (String)fragment.getNamespaceURI());
            if (el != null) {
                doc.getDocumentElement().removeChild(el);
            }
            doc.getDocumentElement().appendChild(doc.importNode(fragment, true));
            if (shared) {
                if (this.scheduledDocument == null) {
                    this.scheduledDocument = doc;
                }
                this.savingTask.schedule(100);
            } else {
                try {
                    ByteArrayOutputStream wr = new ByteArrayOutputStream();
                    XMLUtil.write((Document)doc, (OutputStream)wr, (String)"UTF-8");
                    this.project.getProjectDirectory().setAttribute(AUX_CONFIG, (Object)wr.toString("UTF-8"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
        Document doc = null;
        FileObject config = this.project.getProjectDirectory().getFileObject(CONFIG_FILE_NAME);
        if (shared) {
            if (this.scheduledDocument != null) {
                doc = this.scheduledDocument;
            } else {
                if (config == null) return false;
                try {
                    try {
                        doc = this.loadConfig(config);
                    }
                    catch (SAXException ex) {
                        LOG.log(Level.INFO, "Cannot parse file " + config.getPath(), ex);
                        if (config.getSize() != 0L) return true;
                        config.delete();
                        return true;
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "IO Error with " + config.getPath(), ex);
                }
            }
        } else {
            String str = (String)this.project.getProjectDirectory().getAttribute(AUX_CONFIG);
            if (str == null) return false;
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(new StringReader(str)), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (doc == null) return true;
        Element el = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)elementName, (String)namespace);
        if (el != null) {
            doc.getDocumentElement().removeChild(el);
        }
        if (shared) {
            if (this.scheduledDocument == null) {
                this.scheduledDocument = doc;
            }
            this.savingTask.schedule(100);
            return true;
        }
        try {
            ByteArrayOutputStream wr = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)wr, (String)"UTF-8");
            this.project.getProjectDirectory().setAttribute(AUX_CONFIG, (Object)wr.toString("UTF-8"));
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    private Document createNewSharedDocument() throws DOMException {
        String element = "project-shared-configuration";
        Document doc = XMLUtil.createDocument((String)element, null, null, null);
        doc.getDocumentElement().appendChild(doc.createComment("\nThis file contains additional configuration written by modules in the NetBeans IDE.\nThe configuration is intended to be shared among all the users of project and\ntherefore it is assumed to be part of version control checkout.\nWithout this configuration present, some functionality in the IDE may be limited or fail altogether.\n"));
        return doc;
    }

    static {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class OpenConfigAction
    extends AbstractAction {
        private FileObject fo;

        OpenConfigAction(FileObject file) {
            this.putValue("Name", Bundle.TXT_OPEN_FILE());
            this.fo = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)this.fo);
                    EditCookie edit = (EditCookie)dobj.getCookie(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

