/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public final class IDEUtils {
    private static final String CREATE_NEW_CONFIGURATION_HINT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_CreateNewConfigurationHint");
    private static final String SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationLabelText");
    private static final String SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationDialogCaption");
    private static final String INVALID_TARGET_JVM_EXEFILE_ERROR = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidTargetJVMExeFileError");
    private static final String ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ErrorConvertingProfilingSettingsMessage");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ListAccessName");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_OkButtonText");

    public static String getAntProfilerStartArgument15(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk17");
    }

    public static ProfilingSettings selectSettings(int type, ProfilingSettings[] availableSettings, ProfilingSettings settingsToSelect) {
        int selectedIndex;
        Object[] settings = new Object[availableSettings.length + 1];
        for (int i = 0; i < availableSettings.length; ++i) {
            settings[i] = availableSettings[i];
        }
        settings[availableSettings.length] = CREATE_NEW_CONFIGURATION_HINT;
        JLabel label = new JLabel(SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT);
        final JButton okButton = new JButton(OK_BUTTON_TEXT);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(450, 250));
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.setLayout(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        final JList<Object> list = new JList<Object>(settings);
        label.setLabelFor(list);
        list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(list.getSelectedIndex() != -1);
            }
        });
        if (settingsToSelect != null) {
            list.setSelectedValue(settingsToSelect, true);
        } else {
            list.setSelectedIndex(0);
        }
        panel.add((Component)new JScrollPane(list), "Center");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton && (selectedIndex = list.getSelectedIndex()) != -1) {
            if (selectedIndex < settings.length - 1) {
                ProfilingSettings selectedSettings = (ProfilingSettings)settings[selectedIndex];
                selectedSettings.setProfilingType(type);
                return selectedSettings;
            }
            ProfilingSettings newSettings = ProfilingSettingsManager.createNewSettings((int)type, (ProfilingSettings[])availableSettings);
            if (newSettings == null) {
                return null;
            }
            newSettings.setProfilingType(type);
            return newSettings;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int port, int architecture, String jdkVersion) {
        String ld = Profiler.getDefault().getLibsDir();
        return "-agentpath:" + Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)jdkVersion, (int)architecture) + "=" + ld + "," + port + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }
}

