/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.ui.panels.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.ui.panels.RootMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProjectSelectRootMethodsPanel
extends JPanel {
    private static ProjectSelectRootMethodsPanel instance = null;
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_OkButtonText");
    private static final String NO_SELECTION_PROVIDES = NbBundle.getMessage(ProjectSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_NoSelectionProviders");
    protected static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private HTMLTextArea hintArea;
    private JButton okButton;
    private JCheckBox advancedShowAllProjectsCheckBox;
    private JComboBox treeBuilderList;
    private Lookup.Provider currentProject;
    private RequestProcessor rp = new RequestProcessor("SRM-UI Processor", 1);
    private RootSelectorTree advancedLogicalPackageTree;
    private volatile boolean changingBuilderList = false;
    private boolean globalMode;
    private static final String HELP_CTX_KEY = "ProjectSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectRootMethodsPanel.HelpCtx");

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static synchronized ProjectSelectRootMethodsPanel getDefault() {
        if (instance == null) {
            instance = new ProjectSelectRootMethodsPanel();
        }
        return instance;
    }

    private ProjectSelectRootMethodsPanel() {
        this.initComponents(this);
    }

    public static boolean canBeShown(Lookup ctx) {
        return RootSelectorTree.canBeShown((Lookup)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getRootMethods(Lookup.Provider project, final ClientUtils.SourceCodeSelection[] currentSelection) {
        this.currentProject = project;
        this.advancedLogicalPackageTree.reset();
        this.setGlobalMode(project == null);
        this.advancedShowAllProjectsCheckBox.setSelected(project == null);
        this.advancedShowAllProjectsCheckBox.setEnabled(ProjectUtilities.getOpenedProjects().length > 1);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectSelectRootMethodsPanel.this.refreshBuilderList();
            }
        };
        try {
            this.advancedLogicalPackageTree.addPropertyChangeListener("SELECTION_TREE_VIEW_LIST", pcl);
            this.updateSelector(new Runnable(){

                @Override
                public void run() {
                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(ProjectSelectRootMethodsPanel.this.getContext());
                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setSelection(currentSelection);
                }
            });
            if (this.advancedLogicalPackageTree.getBuilderTypes().isEmpty()) {
                ProfilerDialogs.displayWarning((String)NO_SELECTION_PROVIDES);
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = null;
                return sourceCodeSelectionArray;
            }
            DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_Title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
            Object[] additionalOptions = this.getAdditionalOptions();
            if (additionalOptions != null && additionalOptions.length > 0) {
                dd.setAdditionalOptions(additionalOptions);
            }
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.pack();
            d.setVisible(true);
            this.currentProject = null;
            if (dd.getValue().equals(this.okButton)) {
                ClientUtils.SourceCodeSelection[] selection;
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = selection = this.advancedLogicalPackageTree.getSelection();
                return sourceCodeSelectionArray;
            }
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = null;
            return sourceCodeSelectionArray;
        }
        finally {
            this.advancedLogicalPackageTree.removePropertyChangeListener("SELECTION_TREE_VIEW_LIST", pcl);
        }
    }

    protected void initComponents(Container container) {
        this.okButton = new JButton(OK_BUTTON_TEXT);
        ProgressDisplayer pd = new ProgressDisplayer(){
            ProfilerProgressDisplayer pd = null;

            public synchronized void showProgress(String message) {
                this.pd = ProfilerProgressDisplayer.showProgress(message);
            }

            public synchronized void showProgress(String message, ProgressDisplayer.ProgressController controller) {
                this.pd = ProfilerProgressDisplayer.showProgress(message, (Cancellable)controller);
            }

            public synchronized void showProgress(String caption, String message, ProgressDisplayer.ProgressController controller) {
                this.pd = ProfilerProgressDisplayer.showProgress(caption, message, (Cancellable)controller);
            }

            public synchronized boolean isOpened() {
                return this.pd != null;
            }

            public synchronized void close() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
            }
        };
        this.advancedLogicalPackageTree = new RootSelectorTree(pd, RootSelectorTree.DEFAULT_FILTER);
        this.advancedShowAllProjectsCheckBox = new JCheckBox();
        this.advancedShowAllProjectsCheckBox.setVisible(true);
        this.treeBuilderList = new JComboBox();
        this.treeBuilderList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(final ItemEvent e) {
                if (ProjectSelectRootMethodsPanel.this.changingBuilderList) {
                    return;
                }
                if (e.getStateChange() == 1) {
                    ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                        @Override
                        public void run() {
                            ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)e.getItem());
                        }
                    });
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.advancedLogicalPackageTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane advancedLogicalPackageTreeScrollPane = new JScrollPane((Component)this.advancedLogicalPackageTree);
        advancedLogicalPackageTreeScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)advancedLogicalPackageTreeScrollPane, gridBagConstraints);
        this.advancedShowAllProjectsCheckBox.setText(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ShowAllProjectsLabel"));
        this.advancedShowAllProjectsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSelectRootMethodsPanel.this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        ProjectSelectRootMethodsPanel.this.refreshBuilderList();
                        ProjectSelectRootMethodsPanel.this.updateSelectorProjects();
                    }
                });
            }
        });
        JPanel comboPanel = new JPanel(new FlowLayout());
        comboPanel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_SelectViewLabel")));
        comboPanel.add(this.treeBuilderList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        container.add((Component)comboPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        container.add((Component)this.advancedShowAllProjectsCheckBox, gridBagConstraints);
        String hintString = this.getHintString();
        if (hintString != null && hintString.length() > 0) {
            Color panelBackground = UIManager.getColor("Panel.background");
            Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
            this.hintArea.setText(hintString);
            this.hintArea.setEnabled(false);
            this.hintArea.setDisabledTextColor(Color.darkGray);
            this.hintArea.setBackground(hintBackground);
            this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            container.add((Component)this.hintArea, gridBagConstraints);
        }
    }

    private Object[] getAdditionalOptions() {
        return new Object[]{new JButton(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_AdvancedButtonText")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        final ClientUtils.SourceCodeSelection[] methods = RootMethodsPanel.getSelectedRootMethods(ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.getSelection(), ProjectSelectRootMethodsPanel.this.currentProject);
                        if (methods != null) {
                            ProjectSelectRootMethodsPanel.this.updateSelector(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(ProjectSelectRootMethodsPanel.this.getContext());
                                    ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setSelection(methods);
                                }
                            });
                        }
                    }
                });
            }
        }};
    }

    private void setGlobalMode(boolean value) {
        this.globalMode = value;
    }

    private String getHintString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBuilderList() {
        List builderTypes = this.advancedLogicalPackageTree.getBuilderTypes();
        if (builderTypes == null || builderTypes.isEmpty()) {
            return;
        }
        try {
            this.changingBuilderList = true;
            this.treeBuilderList.setModel(new DefaultComboBoxModel<SelectionTreeBuilder.Type>(builderTypes.toArray(new SelectionTreeBuilder.Type[builderTypes.size()])));
            this.treeBuilderList.setSelectedIndex(0);
            this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)this.treeBuilderList.getItemAt(0));
        }
        finally {
            this.changingBuilderList = false;
        }
    }

    private Lookup.Provider[] relevantProjects() {
        Lookup.Provider[] providerArray;
        if (this.advancedShowAllProjectsCheckBox.isSelected()) {
            providerArray = ProjectUtilities.getOpenedProjects();
        } else {
            Lookup.Provider[] providerArray2 = new Lookup.Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = this.currentProject;
        }
        return providerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable updater) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ParsingProjectStructureMessage"));
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ph.setInitialDelay(500);
                ph.start();
            }
        });
        boolean showAllEnabled = this.advancedShowAllProjectsCheckBox.isEnabled();
        try {
            this.treeBuilderList.setEnabled(false);
            this.advancedLogicalPackageTree.setEnabled(false);
            this.advancedShowAllProjectsCheckBox.setEnabled(false);
            this.okButton.setEnabled(false);
            updater.run();
        }
        finally {
            ph.finish();
            this.okButton.setEnabled(true);
            this.advancedShowAllProjectsCheckBox.setEnabled(showAllEnabled);
            this.advancedLogicalPackageTree.setEnabled(true);
            this.treeBuilderList.setEnabled(true);
        }
    }

    private void updateSelectorProjects() {
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                ProjectSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(ProjectSelectRootMethodsPanel.this.getContext());
            }
        });
    }

    private Lookup getContext() {
        ArrayList builders = new ArrayList();
        for (Lookup.Provider p : this.relevantProjects()) {
            builders.addAll(SelectionTreeBuilderFactory.buildersFor((Lookup.Provider)p));
        }
        return Lookups.fixed((Object[])builders.toArray(new SelectionTreeBuilder[builders.size()]));
    }
}

