/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.NbBundle;

public final class StopAction
extends AbstractAction
implements ProfilingStateListener {
    private static final String MSG_DO_YOU_WANT_TO_TERMINATE_MSG = NbBundle.getMessage(StopAction.class, (String)"StopAction_DoYouWantToTerminateMsg");
    private boolean taskPosted = false;
    private int mode = -1;

    public StopAction() {
        this.updateDisplayName();
        this.updateEnabledState();
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.taskPosted) {
            return;
        }
        Runnable task = null;
        if (this.mode == 0) {
            Boolean ret = ProfilerDialogs.displayCancellableConfirmationDNSA((String)MSG_DO_YOU_WANT_TO_TERMINATE_MSG, null, null, (String)StopAction.class.getName(), (boolean)false);
            if (Boolean.TRUE.equals(ret)) {
                task = new Runnable(){

                    @Override
                    public void run() {
                        Profiler.getDefault().stopApp();
                        StopAction.this.taskPosted = false;
                    }
                };
            } else if (Boolean.FALSE.equals(ret)) {
                task = new Runnable(){

                    @Override
                    public void run() {
                        Profiler.getDefault().detachFromApp();
                        StopAction.this.taskPosted = false;
                    }
                };
            }
        } else {
            task = new Runnable(){

                @Override
                public void run() {
                    Profiler.getDefault().stopApp();
                    StopAction.this.taskPosted = false;
                }
            };
        }
        if (task != null) {
            this.taskPosted = true;
            this.updateEnabledState();
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)task);
        }
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        if (this.mode != Profiler.getDefault().getProfilingMode()) {
            this.updateDisplayName();
        }
        this.updateEnabledState();
    }

    public void threadsMonitoringChanged() {
    }

    private void updateDisplayName() {
        this.mode = Profiler.getDefault().getProfilingMode();
        if (this.mode == 1) {
            this.putValue("Name", NbBundle.getMessage(StopAction.class, (String)"LBL_StopAction"));
            this.putValue("ShortDescription", NbBundle.getMessage(StopAction.class, (String)"HINT_StopAction"));
            this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Stop"));
            this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Stop"));
        } else {
            this.putValue("Name", NbBundle.getMessage(StopAction.class, (String)"LBL_DetachAction"));
            this.putValue("ShortDescription", NbBundle.getMessage(StopAction.class, (String)"HINT_DetachAction"));
            this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Detach"));
            this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Detach"));
        }
    }

    private void updateEnabledState() {
        boolean shouldBeEnabled = !this.taskPosted && (Profiler.getDefault().getProfilingState() == 8 || Profiler.getDefault().getProfilingState() == 4 || Profiler.getDefault().getProfilingState() == 2);
        this.setEnabled(shouldBeEnabled);
    }
}

