/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.NbBundle;

public final class ResetResultsAction
extends AbstractAction {
    public ResetResultsAction() {
        this.putValue("Name", NbBundle.getMessage(ResetResultsAction.class, (String)"LBL_ResetResultsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(ResetResultsAction.class, (String)"HINT_ResetResultsAction"));
        this.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.ResetResults"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.ResetResults"));
        this.updateEnabledState();
        ResultsManager.getDefault().addResultsListener(new ResultsListener(){

            @Override
            public void resultsAvailable() {
                ResetResultsAction.this.updateEnabledState();
            }

            @Override
            public void resultsReset() {
                ResetResultsAction.this.updateEnabledState();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.getDefault().reset();
                try {
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.targetJVMIsAlive()) {
                        runner.resetTimers();
                    } else {
                        runner.getProfilerClient().resetClientData();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        });
    }

    private void updateEnabledState() {
        this.setEnabled(ResultsManager.getDefault().resultsAvailable());
    }
}

